{*
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<style type="text/css">
    .track-button {
        display: inline; 
        padding: 0px 10px;
    }
</style>

<div class="panel" ng-app="newParcelApp" ng-controller="mainController">
    <div class="panel-heading">
        <i class="icon-send"></i> {l s='Globkurier - historia zamówień' mod='globkurier2'}
    </div>
    <table class="table">
        <thead>
            <tr>
                <th>{l s='Date' mod='globkurier2'}</th>
                <th>{l s='Parcel No' mod='globkurier2'}</th>
                <th>{l s='Receiver' mod='globkurier2'}</th>
                <th>{l s='Carrier' mod='globkurier2'}</th>
                <th>{l s='Content' mod='globkurier2'}</th>
                <th>{l s='Weight' mod='globkurier2'}</th>
                <th>{l s='Payment' mod='globkurier2'}</th>
                <th>Etykieta</th>
                <th>#</th>
            </tr>
        </thead>
        <tbody>
            {foreach from=$orders item=order}
            <tr>
                <td>{$order->crateDate|escape:'htmlall':'UTF-8'}</td>
                <td>{$order->gkId|escape:'htmlall':'UTF-8'}</td>
                <td>{$order->receiver|escape:'htmlall':'UTF-8'}</td>
                <td>{$order->carrier|escape:'htmlall':'UTF-8'}</td>
                <td>{$order->content|escape:'htmlall':'UTF-8'}</td>
                <td>{$order->weight|escape:'htmlall':'UTF-8'}kg</td>
                <td>{$order->paymentName|escape:'htmlall':'UTF-8'}</td>
                <td>
                    {if $order->hash}
                        <a href="{$urlModule}?hash={$order->hash|escape:'url':'UTF-8'}" class="" target="_blank" title="Pobierz list przewozowy">
                            <i class="material-icons">note</i>
                        </a>
                    {else}
                        --
                    {/if}
                </td>
                <td>


                  {if $order->orderId}
                    <a href="{$orderDetailsUrl|escape:'javascript':'UTF-8'}&id_order={$order->orderId|escape:'htmlall':'UTF-8'}" title="Zobacz zamówienie">
                      <i class="icon-credit-card"></i>
                    </a>
                  {/if}
{*                    {if $order->hash}*}
{*                  <a href="https://api.globkurier.pl/v1/order/labels?orderHashes[0]={$order->hash|escape:'url':'UTF-8'}" class="" target="_blank" title="Pobierz list przewozowy">*}
{*                    <i class="icon-file-text"></i>*}
{*                  </a>*}
{*                  {/if}*}
                  <form class="track-button" id="track{$order->gkId|escape:'htmlall':'UTF-8'}" action="https://www.globkurier.pl/zlokalizuj_przesylke.html" target="_blank" method="post">
                    <input type="hidden" name="nr" value="{$order->gkId|escape:'htmlall':'UTF-8'}">
                    <a href onclick="$('#track{$order->gkId|escape:'htmlall':'UTF-8'}').submit(); return false;" title="Śledź przesyłkę">
                      <i class="icon-search"></i>
                    </a>
                  </form>
                </td>
            </tr>
            {/foreach}
        </tbody>
    </table>
</div>

{* w nowym api inaczej pobiera sie etykiete
<div class="modal fade waybill-modal" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">

      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">{l s='Waybill' mod='globkurier2'}</h4>
      </div>

      <div class="modal-body loading" style="text-align: center;">
        <h2>{l s='Generating waybill...' mod='globkurier2'}</h2><br/>
        <i class="icon-cog icon-spin" style="font-size: 50px!important; color:#72C279;"></i>
      </div>

      <div class="modal-body error" style="text-align: center;">
      </div>
      
      <div class="modal-body waybill" style="text-align: center;">
        <h2>{l s='Download waybill' mod='globkurier2'}</h2><br/>
        <a href class="waybill-link" target="_blank" title="{l s='Download waybill' mod='globkurier2'}">
          <i class="icon-file-text" style="font-size: 50px!important; color:#72C279;"></i>
        </a>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
  var moduleApiUrl = '{$moduleApiUrl|escape:'javascript':'UTF-8'}';

  $(function(){
    $('.get-shipping-doc').on('click', function(element) {
      var gkNum = $(this).data('gknumber');
      var url = moduleApiUrl + '&ajax=1&action=getWaybill&gknumber='+gkNum;

      $('.waybill-modal .loading').show();
      $('.waybill-modal .error').hide();
      $('.waybill-modal .waybill').hide();
      $('.waybill-modal').modal('show');

      $.getJSON(url, function(r) {
        $('.waybill-modal .loading').hide();

        if (!r.success) {
          $('.waybill-modal .error').show().html('<p>'+r.error+'</p>');
          return ;
        }

        $('a.waybill-link').attr('href', r.url);
        $('.waybill-modal .waybill').show();

      });
      return false;
    });
  });
</script>
*}
