<?php
/**
 * Globkurier2 Prestashop module
 *
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 *  @author    Wiktor Koźmiński
 *  @copyright 2017-2017 Silver Rose Wiktor Koźmiński
 *  @license   LICENSE.txt
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * This upgrade add new column 'hash' to gk_orders table
 * @return boolean
 */
function upgrade_module_2_5_0()
{
    $query = "SHOW COLUMNS FROM `"._DB_PREFIX_."gk_orders`";
    $res = Db::getInstance()->executeS($query);

    if (!$res) {
        // if there is no response, than propably the table does not exist at all
        include(dirname(__FILE__).'/../sql/install.php');
        return true;
    }

    $fields = array();
    foreach ($res as $r) {
        $fields[] = isset($r['Field']) ? $r['Field'] : null;
    }

    if (!in_array('hash', $fields)) {
        $query = "ALTER TABLE `"._DB_PREFIX_."gk_orders` ADD COLUMN `hash` varchar(255)";
        Db::getInstance()->execute($query);
    }

    return true;
}
