<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

namespace Globkurier2\Order;

use \Globkurier2\Order\OrderModel;

class OrderManager
{
    
    public function __construct()
    {
        # code...
    }

    /**
     * Pobiera wszystkie rekordy zamówień
     * @return array zwaraca tablicę obiektów typu order model
     */
    public function getAll()
    {
        $orders = array();
        $sql = "SELECT * FROM "._DB_PREFIX_."gk_orders ORDER BY crate_date DESC LIMIT 50";
        $results = \Db::getInstance()->executeS($sql);
        foreach ($results as $row) {
            $orders[] = $this->getByGkId($row['gk_id']);
        }
        return $orders;
    }

    /**
     * Zwraca obiekt typu order po id zamówienia
     * @param  integer $orderId id zamówienia
     * @return array         tablica obiektów typu zamówinie z wszystkimi jego wartościami
     */
    public function getByOrderId($orderId)
    {
        $orders = array();
        $sql = "SELECT * FROM "._DB_PREFIX_."gk_orders WHERE order_id = ".(int)$orderId;
        $results = \Db::getInstance()->executeS($sql);
        foreach ($results as $row) {
            $orders[] = $this->getByGkId($row['gk_id']);
        }

        return $orders;
    }

     /**
     * Zwraca obiekt typu order po id globkuriera (id wysyłki)
     * @param  string $gkId id globkuriera (id wysyłki)
     * @return OrderModel   obiekt typu zamówinie z wszystkimi jego wartościami
     */
    public function getByGkId($gkId)
    {
        $order = new OrderModel();
        $sql = "SELECT * FROM "._DB_PREFIX_."gk_orders WHERE gk_id = '".pSQL($gkId)."'";
        $row = \Db::getInstance()->getRow($sql);

        if (!$row) {
            throw new \Exception("Error, don't find order with this Id.");
        }

        $this->assignMySqlDataToOrder($row, $order);

        return $order;
    }

    /**
     * Tworzy nowe zamówienie i wkłada je do bazy danych
     * @param   $orderToCreate obiekt typu zamówienie który ma zostać utowrzony
     * @return boolean true w przy pomyślnego utworzenia
     */
    public function create(OrderModel $orderToCreate)
    {
        if (!$orderToCreate->crateDate) {
            $orderToCreate->crateDate = date('Y-m-d H:i:s');
        }
        
        $sql = "INSERT INTO "._DB_PREFIX_."gk_orders ".
               "(gk_id, hash, order_id, crate_date, receiver, content, weight, carrier, comments, cod, payment) ".
               "VALUES (
        '".pSQL($orderToCreate->gkId)."',
        '".pSQL($orderToCreate->hash)."',
        '".(int)$orderToCreate->orderId."',
        '".pSQL($orderToCreate->crateDate)."',
        '".pSQL($orderToCreate->receiver)."',
        '".pSQL($orderToCreate->content)."',
        '".(int)$orderToCreate->weight."',
        '".pSQL($orderToCreate->carrier)."',
        '".pSQL($orderToCreate->comments)."',
        '".(float)$orderToCreate->cod."',
        '".pSQL($orderToCreate->payment)."')";

        $results = \Db::getInstance()->execute($sql);

        if (!$results) {
            return false;
        }
    
        return true;
    }

    private function assignMySqlDataToOrder($mysqlData, $order)
    {
        $order->gkId = $mysqlData['gk_id'];
        $order->hash = $mysqlData['hash'];
        $order->orderId = $mysqlData['order_id'];
        $order->crateDate = $mysqlData['crate_date'];
        $order->receiver = $mysqlData['receiver'];
        $order->content = $mysqlData['content'];
        $order->weight = $mysqlData['weight'];
        $order->carrier = $mysqlData['carrier'];
        $order->comments = $mysqlData['comments'];
        $order->cod = $mysqlData['cod'];
        $order->payment = $mysqlData['payment'];
        $order->paymentName = $this->translatePaymentName($mysqlData['payment']);
    }

    private function translatePaymentName($paymentCode)
    {
        if ($paymentCode == 'T' || (int)$paymentCode == 1) {
            return 'Przelew';
        } elseif ($paymentCode == 'O' || (int)$paymentCode == 2) {
            return 'Online';
        } elseif ($paymentCode == 'P' || (int)$paymentCode == 3) {
            return 'Prepaid';
        } elseif ($paymentCode == 'D') {
            return 'Odroczona';
        } elseif ($paymentCode == 'COD') {
            return 'Na koszt odbiorcy';
        } else {
            return 'Inny';
        }
    }
}
