<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

namespace Globkurier2\Common;

class Logger
{
    public static function error($content)
    {
        return self::log('error', $content);
    }

    public static function xmlRequest($content)
    {
        return self::log('xml_request', $content);
    }

    public static function serverResponse($content)
    {
        return self::log('server_response', $content);
    }

    public static function log($logType, $c)
    {
        $content = $c;
        $sql = "INSERT INTO "._DB_PREFIX_."gk_log (data, type, content) VALUES (
        '".date("Y-m-d H:i:s")."',
        '".pSQL($logType)."',
        '".pSQL($content)."'
        )";

        $results = \Db::getInstance()->execute($sql);
        if (!$results) {
            return false;
        }
        return true;
    }

    public static function getLogs()
    {
        $logs = array();
        $sql = "SELECT * FROM "._DB_PREFIX_."gk_log";
        $logs = \Db::getInstance()->executeS($sql);

        foreach ($logs as $k => $log) {
            if (isset($log['content']) && $log['content']) {
                $logs[$k] = $log['content'];
            }
        }
        
        return $logs;
    }
}
