<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once 'src/globkurier.loader.php';

class Globkurier2 extends Module
{
    protected $config_form = false;
    protected $link;

    public function __construct()
    {
        $this->name = 'globkurier2';
        $this->tab = 'shipping_logistics';
        $this->version = '2.6.2';
        $this->author = 'GlobKurier.pl';
        $this->need_instance = 0;
        $this->bootstrap = true;
        $this->module_key = '1912a4c728f185a7b00a59deb593eb22';

        parent::__construct();

        $this->displayName = $this->l('Globkurier integration');
        $this->description = $this->l('Module Globkurier to ship parcels');

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->link = new Link();
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        Configuration::updateValue('GLOBKURIER2_LIVE_MODE', false);

        include(dirname(__FILE__).'/sql/install.php');

        \Globkurier2\Common\ModuleTabs::install();

        $carrierHookName = 'displayCarrierList';
        if (version_compare(_PS_VERSION_, '1.7.0', '>=') === true) {
            $carrierHookName = 'displayAfterCarrier';
        }

        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('displayBackOfficeHeader') &&
            $this->registerHook($carrierHookName) &&
            $this->registerHook('displayAdminOrder') &&
            $this->registerHook('updateCarrier');
    }

    public function uninstall()
    {
        Configuration::deleteByName('GLOBKURIER2_LIVE_MODE');
        \Globkurier2\Common\ModuleTabs::uninstall();
        // include(dirname(__FILE__).'/sql/uninstall.php');
        \Globkurier2\Common\Config::purge();
        return parent::uninstall();
    }

    /**
     * Load the configuration form
     */
    public function getContent()
    {
        $config = new Globkurier2\Common\Config();
        if (Tools::getValue('action') == 'updateConfig' && $this->validateConfigFields()) {
            $config->update();
        }

        $this->context->smarty->assign(array(
            'config' => $config,
            'submited' => Tools::getValue('action') == 'updateConfig' ? true : false,
            'newParcelPageLink' => $this->link->getAdminLink('AdminGlobkurierPlaceOrder'),
            'getCachePointsLink'
                => $this->link->getAdminLink('AdminGlobkurierPlaceOrder').'&ajax=1&action=getAllPickupPoints',
            'baseurl' => $this->_path,
        ));

        $api = new Globkurier2\Common\GlobkurierApi($config->login, $config->password, $config->apiKey);
        if (!$api->isUserAuthorized()) {
            if (version_compare(_PS_VERSION_, '1.6.0', '>=') === true) {
                return $this->display(__FILE__, 'views/templates/admin/login_page_v16.tpl');
            } else {
                return $this->display(__FILE__, 'views/templates/admin/login_page_v15.tpl');
            }
        }
        
        $carriers = Carrier::getCarriers($this->context->language->id);
        $countries = $api->getCountries();
        $this->context->smarty->assign(array(
            'countries' => $countries,
            'carriers' => $carriers,
        ));

        $this->context->controller->addJS($this->_path . '/views/js/angular.min.js');
        $this->context->controller->addJS($this->_path . '/views/js/configApp.261.js');

        if (version_compare(_PS_VERSION_, '1.6.0', '>=') === true) {
            return $this->display(__FILE__, 'views/templates/admin/config_page_v16.tpl');
        } else {
            return $this->display(__FILE__, 'views/templates/admin/config_page_v15.tpl');
        }
    }

    private function validateConfigFields()
    {
        $valid = true;

        $ruchCarrier = (int) Tools::getValue('config_paczkaRuchCarrier');
        $inpostCarrier = (int) Tools::getValue('config_inPostCarrier');

        if ($inpostCarrier != 0 && $inpostCarrier == $ruchCarrier) {
            $this->context->controller->errors[] = $this->l('You cant use same carrier for two services');
            $valid = false;
        }

        return $valid;
    }

    public function hookDisplayAdminOrder($params)
    {
        
        $orderM = new Globkurier2\Order\OrderManager();
        $gkOrder = $orderM->getByOrderId($params['id_order']);
        $newParcelPageLink = $this->link->getAdminLink('AdminGlobkurierPlaceOrder');
        $newParcelPageLink .= '&order_id='.$params['id_order'];

        $this->context->smarty->assign(array(
            'orders' => $gkOrder,
            'moduleApiUrl' => $this->link->getAdminLink('AdminGlobkurierHistory'),
            'newParcelPageLink' => $newParcelPageLink
        ));

        if (version_compare(_PS_VERSION_, '1.7.0', '>=') === true) {
            return $this->display(__FILE__, 'views/templates/hooks/admin_order.tpl');
        } elseif (version_compare(_PS_VERSION_, '1.6.0', '>=') === true) {
            return $this->display(__FILE__, 'views/templates/hooks/order_details_page_v16.tpl');
        } else {
            return $this->display(__FILE__, 'views/templates/hooks/order_details_v15.tpl');
        }
    }

    /**
     * Wyświetla i ładuje skrypty związane z wyborem paczkomatów
     * @param  array $params
     * @return string
     */
    public function hookDisplayCarrierList($params)
    {
        $config = new Globkurier2\Common\Config();

        if (!$config->inPostEnabled && !$config->inPostCODEnabled && !$config->paczkaRuchEnabled) {
            return ;
        }
        
        // if (version_compare(_PS_VERSION_, '1.7.0', '<') === true) {
        //     $this->context->controller->addJS($this->_path.'/views/js/inpost-front.js', 'all');
        // }
        
        $this->smarty->assign(array(
            'globConfig' => $config,
            'inpost_carrier_id' => $config->inPostEnabled ? $config->inPostCarrier : null,
            'inpost_cod_carrier_id' => $config->inPostCODEnabled ? $config->inPostCODCarrier : null,
            'paczkaruch_carrier_id' => $config->paczkaRuchEnabled ? $config->paczkaRuchCarrier : null,
            'cart_id' => $params['cart']->id,
            'rest_endpoint' => $this->context->link->getModuleLink($this->name, 'restinterface', array(), true),
            'gk_token' => Tools::encrypt($params['cart']->id),
            'address_all' => json_encode($params),
        ));

        if (version_compare(_PS_VERSION_, '1.7.0', '>=') === true) {
            return $this->display(__FILE__, 'views/templates/hooks/carrier_list_17.tpl');
        } else {
            return $this->display(__FILE__, 'views/templates/hooks/carrier_list.tpl');
        }
    }

    /**
     * Alias for hookDisplayCarrierList used in PS1.7 version
     * @param  array $params
     * @return string hook template
     */
    public function hookDisplayAfterCarrier($params)
    {
        return $this->hookDisplayCarrierList($params);
    }

    /**
     * aktualizuje id przewoźnika inPostu
     * @param        $params parametry przewoźnika
     * @return void
     */
    public function hookUpdateCarrier($params)
    {
        $id_carrier_old = (int)($params['id_carrier']);
        $id_carrier_new = (int)($params['carrier']->id);
        $config = new Globkurier2\Common\Config();

        if ($config->inPostCarrier == $id_carrier_old) {
            $config->inPostCarrier = $id_carrier_new;
            $config->update(false);
        }

        if ($config->paczkaRuchCarrier == $id_carrier_old) {
            $config->paczkaRuchCarrier = $id_carrier_new;
            $config->update(false);
        }
    }

    public function hookHeader()
    {
        $config = new Globkurier2\Common\Config();
        $code = trim($this->context->controller->php_self);
        if ($code != 'order' && $code != 'order-opc') {
            return;
        }

        if (version_compare(_PS_VERSION_, '1.7.0', '>=') === true) {
            $goolgeMapsApiKeyFromConfiguration = $config->googleMapsApiKey;
            if ($goolgeMapsApiKeyFromConfiguration) {
                $this->context->controller->registerJavascript(
                    'google-maps-api',
                    'https://maps.google.com/maps/api/js?key='.$goolgeMapsApiKeyFromConfiguration,
                    array('server' => 'remote', 'position' => 'bottom', 'priority' => 200, 'attribute' => 'defer')
                );
    
                $this->context->controller->registerJavascript(
                    'google-maps-clusterer',
                    'https://unpkg.com/@googlemaps/markerclustererplus/dist/index.min.js',
                    array('server' => 'remote', 'position' => 'bottom', 'priority' => 200, 'attribute' => 'defer')
                );
            }

            $this->context->controller->registerJavascript(
                'modules-globkurier2',
                'modules/'.$this->name.'/views/js/inpost-front-17.js',
                array('position' => 'bottom', 'priority' => 250)
            );
        } else {
            $this->context->controller->addJS($this->_path.'/views/js/inpost-front.js', 'all');
        }
    }
}
