<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

class Globkurier2GetLabelModuleFrontController extends ModuleFrontController
{

    private $token;

    // @Override
    public function init()
    {
        $this->page_name = 'getlabel';
        $this->path = _MODULE_DIR_ . $this->module->name;
        parent::init();

        $hash = $_REQUEST['hash'];
        if (!empty($hash)) {
            $c = new Globkurier2\Common\Config();
            $api = new Globkurier2\Common\GlobkurierApi($c->login, $c->password, $c->apiKey);
            $api->login();
            $token = $api->getToken();

            $request = $api->getLabel($token, $hash);

//            dump($request);
            $dir = __DIR__ . '/../../files/' . $hash.'.pdf';
            file_put_contents($dir, $request);
            $size = filesize($dir);
            header('Content-Type: application/pdf');
            header('Content-Length: ' . $size);
            header('Content-Disposition: attachment; filename="' . basename($hash.'.pdf') . '"');
            ob_end_flush();
            @readfile($dir);
            die;


        }
        die;
    }

}
