<?php

namespace wp_opieka_globkurier;

class Udi_Public{
	
	private $plugin_name;
	
	private $version;
	
	public function __construct( $plugin_name, $version ){
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}
	
	public function do_output_buffer(){
		ob_start();
	}
	
	public function enqueue_styles(){
		wp_enqueue_style( $this->plugin_name, Udi_Helper::getPublicUrl( 'css/udi-public.css' ), [], $this->version, 'all' );
	}
	
	public function register_styles(){
		wp_register_style( $this->plugin_name, Udi_Helper::getPublicUrl( 'css/udi-public.css' ), [], $this->version, 'all' );
	}
	
	public function enqueue_scripts(){
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		
		global $globKurier;
		
		$googleMapApiKey = $globKurier->settings('googleMapApiKey');
		
		wp_enqueue_script( $this->plugin_name.'_map', 'https://maps.googleapis.com/maps/api/js?key='.$googleMapApiKey, [], $this->version, 'all');

		$data = [
			'ajaxUrl' => UDI_Helper::getAjaxUrl()
		];
		wp_enqueue_script( $this->plugin_name, Udi_Helper::getPublicUrl( 'js/udi-public.js' ), [], $this->version, 'all' );
		wp_localize_script( $this->plugin_name, 'data', $data );

	}
	
	public function register_scripts(){
		wp_register_script( $this->plugin_name, Udi_Helper::getPublicUrl( 'js/udi-public.js' ), [], $this->version, 'all' );
	}
	
	public function flush_rules(){
		global $wp_rewrite;
		$wp_rewrite->flush_rules();
	}
	
	public function insert_rewrite_rules( $rules ){
		$newrules = [];

//		$newrules['(kalkulator)\/([a-zA-z0-9"-%��-]*)\/?'] = 'index.php?pagename=$matches[1]&calc_type=$matches[2]';
		
		return $newrules + $rules;
	}
	
	public function insert_query_vars( $vars ){
//		array_push( $vars, 'calc_type');
		return $vars;
	}
	
}