<?php

namespace wp_opieka_globkurier;

class Udi_Public_Ajax{
	public function __construct(){
	}
	
	public function init(){
		$this->priv();
		$this->noPriv();
	}
	
	private function priv(){
		$actionPrefix = 'wp_ajax_';
		add_action( $actionPrefix . 'globkurierGetInpostPoints', [ $this, 'getInpostPoints' ] );
		add_action( $actionPrefix . 'globkurierGetInpostPointsSelect2', [ $this, 'getInpostPointsSelect2' ] );
		add_action( $actionPrefix . 'globkurierGetAllInpostPointsSelect2', [ $this, 'getInpostAllPointsSelect2' ] );
		
		add_action( $actionPrefix . 'globkurierGetRuchPoints', [ $this, 'getRuchPoints' ] );
		add_action( $actionPrefix . 'globkurierGetRuchPointsSelect2', [ $this, 'getRuchPointsSelect2' ] );
		add_action( $actionPrefix . 'globkurierGetAllRuchPointsSelect2', [ $this, 'getRuchAllPointsSelect2' ] );
		
		add_action( $actionPrefix . 'globkurierSaveInpostPointsSession', [ $this, 'saveInpostPointsSession' ] );
		add_action( $actionPrefix . 'globkurierSaveRuchPointsSession', [ $this, 'saveRuchPointsSession' ] );
		
		
		add_action( $actionPrefix . 'globkurierSaveInpostPointsDisableInitSession', [ $this, 'saveInpostPointsDisableInitSession' ] );
		add_action( $actionPrefix . 'globkurierSaveRuchPointsDisableInitSession', [ $this, 'saveRuchPointsDisableInitSession' ] );
	}
	
	private function noPriv(){
		$actionPrefix = 'wp_ajax_nopriv_';
		add_action( $actionPrefix . 'globkurierGetInpostPoints', [ $this, 'getInpostPoints' ] );
		add_action( $actionPrefix . 'globkurierGetInpostPointsSelect2', [ $this, 'getInpostPointsSelect2' ] );
		add_action( $actionPrefix . 'globkurierGetAllInpostPointsSelect2', [ $this, 'getInpostAllPointsSelect2' ] );
		
		add_action( $actionPrefix . 'globkurierGetRuchPoints', [ $this, 'getRuchPoints' ] );
		add_action( $actionPrefix . 'globkurierGetRuchPointsSelect2', [ $this, 'getRuchPointsSelect2' ] );
		add_action( $actionPrefix . 'globkurierGetAllRuchPointsSelect2', [ $this, 'getRuchAllPointsSelect2' ] );
		
		add_action( $actionPrefix . 'globkurierSaveInpostPointsSession', [ $this, 'saveInpostPointsSession' ] );
		add_action( $actionPrefix . 'globkurierSaveRuchPointsSession', [ $this, 'saveRuchPointsSession' ] );
	}
	
	public function getInpostPoints(){
		global $globKurier;
		
		$points = $globKurier->inpost()->getPoints( $_POST[ 'data' ] );
		
		die( json_encode( $points ) );
	}
	
	public function getInpostPointsSelect2(){
		global $globKurier;
		
		$data = (!empty($_GET)) ? $_GET : $_POST;
		
		$points = $globKurier->inpost()->getPointsSelect2($data);
		
		die( json_encode( $points ) );
	}
	
	public function getRuchPoints(){
		global $globKurier;
		
		$points = $globKurier->ruch()->getPoints( $_POST[ 'data' ] );
		
		die( json_encode( $points ) );
	}
	
	public function getRuchPointsSelect2(){
		global $globKurier;
		
		$data = (!empty($_GET)) ? $_GET : $_POST;

		$points = $globKurier->ruch()->getPointsSelect2($data);
		
		die( json_encode( $points ) );
	}
	
	public function getRuchAllPointsSelect2(){
		global $globKurier;
		
		$points = $globKurier->ruch()->getAllPoints( );
		
		die( json_encode( $points ) );
	}
	
	public function getInpostAllPointsSelect2(){
		global $globKurier;
		
		$points = $globKurier->inpost()->getAllPoints( );
		
		die( json_encode( $points ) );
	}
	
	public function saveRuchPointsSession(){
		WC()->session->set( 'globkurier_ruch_selected_point_id', wc_clean( $_POST[ 'id' ] ) );
		WC()->session->set( 'globkurier_ruch_selected_point_value', wc_clean( $_POST[ 'value' ] ) );
        WC()->session->set( 'globkurier_ruch_selected_point_latitude', wc_clean( $_POST[ 'latitude' ] ) );
		WC()->session->set( 'globkurier_ruch_selected_point_longitude', wc_clean( $_POST[ 'longitude' ] ) );
		WC()->session->set( 'globkurier_ruch_selected_point_city', wc_clean( $_POST[ 'city' ] ) );
		WC()->session->set( 'globkurier_ruch_selected_point_address', wc_clean( $_POST[ 'address' ] ) );
		WC()->session->set( 'globkurier_ruch_selected_point_openingHours', wc_clean( $_POST[ 'openingHours' ] ) );
		
		
//		echo "<pre>";
//		print_r(['saveRuchPointsSession', WC()->session]);
//		echo "</pre>";
//		die;
	}
	
	public function saveInpostPointsSession(){
		WC()->session->set( 'globkurier_inpost_selected_point_id', wc_clean( $_POST[ 'id' ] ) );
		WC()->session->set( 'globkurier_inpost_selected_point_value', wc_clean( $_POST[ 'value' ] ) );
        WC()->session->set( 'globkurier_inpost_selected_point_latitude', wc_clean( $_POST[ 'latitude' ] ) );
        WC()->session->set( 'globkurier_inpost_selected_point_longitude', wc_clean( $_POST[ 'longitude' ] ) );
        WC()->session->set( 'globkurier_inpost_selected_point_city', wc_clean( $_POST[ 'city' ] ) );
        WC()->session->set( 'globkurier_inpost_selected_point_address', wc_clean( $_POST[ 'address' ] ) );
        WC()->session->set( 'globkurier_inpost_selected_point_openingHours', wc_clean( $_POST[ 'openingHours' ] ) );
	}
	
	public function saveInpostPointsDisableInitSession(){
		WC()->session->set( 'globkurier_disable_inpost_init', wc_clean( $_POST[ 'status' ] ) );
	}
	
	public function saveRuchPointsDisableInitSession(){
		WC()->session->set( 'globkurier_disable_ruch_init', wc_clean( $_POST[ 'status' ] ) );
		WC()->session->set( 'globkurier_old_ruch_params', wc_clean( $_POST[ 'params' ] ) );
		
//		echo "<pre>";
//		    print_r(['saveRuchPointsDisableInitSession', WC()->session]);
//		echo "</pre>";
//		die;
	}
	
	
	
	
	
	
	
}