<?php

namespace wp_opieka_globkurier;

class Udi_plugin{
	protected $loader;
	
	protected $plugin_name;
	
	protected $version;
	
	public function __construct(){
		$this->plugin_name = WPOPIEKAGLOBKURIER_INIT::getPluginName();
		
		if( defined( 'WP_GLOBKURIER_VERSION' ) ){
			$this->version = WP_GLOBKURIER_VERSION;
		} else{
			$this->version = '1.0.0';
		}
		
		$this->load_dependencies();
		
		global $globKurier;
		$globKurier = new GlobKurier();
		
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
		$this->define_public_shortcodes();
	}
	
	private function load_dependencies(){
		require_once WPOPIEKAGLOBKURIER_INIT::getHelperDir();
		
		require_once Udi_Helper::getInlcudesPath( 'class-udi-loader.php' );
		
		require_once Udi_Helper::getInlcudesPath( 'class-udi-i18n.php' );
		
		require_once Udi_Helper::getAdminPath( 'class-udi-admin.php' );
		
		require_once Udi_Helper::getAdminPath( 'ajax/class-admin-ajax.php' );

		require_once Udi_Helper::getPublicPath( 'ajax/class-public-ajax.php' );
		
		require_once Udi_Helper::getPublicPath( 'class-udi-public.php' );
		
		require_once Udi_Helper::getPublicPath( 'class-udi-shortcodes.php' );
		
		require_once Udi_Helper::getAdminPath( 'woocommerce/WoocommerceAddons.php' );
		
		require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierApi.php' );
		
		require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurier.php' );
		
		$this->loader = new Udi_Loader();
	}
	
	private function set_locale(){
		$plugin_i18n = new Udi_i18n();
		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );
	}
	
	private function define_admin_hooks(){
		$plugin_admin = new Udi_Admin( $this->get_plugin_name(), $this->get_version() );
		$ajax_admin   = new Udi_Admin_Ajax();
		$ajax_public  = new Udi_Public_Ajax();
		
		
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		
		$this->loader->add_menu_page( $component = $plugin_admin, $pageTitle = __( 'GlobKurier', 'globkurier' ), $menuTitle = __( 'GlobKurier', 'globkurier' ), $menuSlug = 'globkurier', $iconUrl = Udi_Helper::getAdminUrl( 'img/icon.png' ), $position = 5, $capability = 'manage_options_ghost' );
		
		$this->loader->add_submenu_page( $component = $plugin_admin, $parentSlug = 'globkurier', $pageTitle = __( 'GlobKurier - Historia przesyłek', 'globkurier' ), $menuTitle = __( 'Historia przesyłek', 'globkurier' ), $capability = 'manage_options', $menuSlug = 'globkurier_all_orders', $position = 0 );
		$this->loader->add_submenu_page( $component = $plugin_admin, $parentSlug = 'globkurier', $pageTitle = __( 'GlobKurier - Protokoły', 'globkurier' ), $menuTitle = __( 'Protokoły', 'globkurier' ), $capability = 'manage_options', $menuSlug = 'globkurier_protocols', $position = 1 );
		$this->loader->add_submenu_page( $component = $plugin_admin, $parentSlug = 'globkurier', $pageTitle = __( 'GlobKurier - Nadaj przez GlobKuriera', 'globkurier' ), $menuTitle = __( 'Nadaj przez GlobKuriera', 'globkurier' ), $capability = 'manage_options', $menuSlug = 'globkurier_ship_order', $position = 2 );
		$this->loader->add_submenu_page( $component = $plugin_admin, $parentSlug = 'globkurier', $pageTitle = __( 'GlobKurier - Konfiguracja', 'globkurier' ), $menuTitle = __( 'Konfiguracja', 'globkurier' ), $capability = 'manage_options', $menuSlug = 'globkurier_settings', $position = 3 );
		
		$wc_addons = new WoocommerceAddons();
		$this->loader->add_action( 'init', $wc_addons, 'init' );
		
		$this->loader->add_action( 'init', $ajax_admin, 'init' );
		$this->loader->add_action( 'init', $ajax_public, 'init' );
	}
	
	private function define_public_hooks(){
		$plugin_public = new Udi_Public( $this->get_plugin_name(), $this->get_version() );
//		$ajax_public   = new Udi_Public_Ajax();
		
		$this->loader->add_action( 'init', $plugin_public, 'do_output_buffer' );
		
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'register_scripts' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'register_styles' );
		
//		$this->loader->add_action( 'wp_loaded', $plugin_public, 'flush_rules' );
//		$this->loader->add_filter( 'rewrite_rules_array', $plugin_public, 'insert_rewrite_rules' );
//		$this->loader->add_filter( 'query_vars', $plugin_public, 'insert_query_vars' );

//		$this->loader->add_action( 'init', $ajax_public, 'init' );
	}
	
	private function define_public_shortcodes(){
//		$plugin_shortcodes = new Udi_Shortcodes( $this->get_plugin_name(), $this->get_version() );
//		$this->loader->add_shortcode( $tag='', $plugin_shortcodes, $callback='' );
	}
	
	public function run(){
		$this->loader->run();
	}
	
	public function get_plugin_name(){
		return $this->plugin_name;
	}
	
	public function get_loader(){
		return $this->loader;
	}
	
	public function get_version(){
		return $this->version;
	}
	
}