<?php

namespace wp_opieka_globkurier;

class Udi_Helper{
	
	public static function getGlobal( $var ){
		$prefix = 'WP_GLOBKURIER_';
		
		return constant( $prefix . $var );
	}
	
	public static function getBasePath(){
		
		return plugin_dir_path( __DIR__ );
	}
	
	public static function getBaseUrl(){
		
		return plugin_dir_url( __DIR__ );
	}
	
	public static function getInlcudesPath( $path = '' ): string{
		
		return self::getBasePath() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'includes/' . $path;
	}
	
	public static function getInlcudesUrl( $path = '' ): string{
		
		return self::getBaseUrl() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'includes/' . $path;
	}
	
	public static function getPublicPath( $path = '' ): string{
		
		return self::getBasePath() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'public/' . $path;
	}
	
	public static function getAjaxUrl(){
		
		return admin_url( 'admin-ajax.php' );
	}
	
	public static function getPublicUrl( $path = '' ): string{
		
		return self::getBaseUrl() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'public/' . $path;
	}
	
	public static function getAdminPath( $path = '' ): string{
		
		return self::getBasePath() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'admin/' . $path;
	}
	
	public static function getAdminUrl( $path = '' ): string{
		
		return self::getBaseUrl() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'admin/' . $path;
	}
	
	public static function getLanguagePath( $path = '' ): string{
		
		return self::getBasePath() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'language/' . $path;
	}
	
	public static function getLanguageUrl( $path = '' ): string{
		
		return self::getBaseUrl() . self::getGlobal( 'DIRECTORY_PREFIX' ) . 'language/' . $path;
	}
	
	public static function getTranslation( $string, $domain = NULL ){
		
		if( ! $domain ){
			$domain = 'globkurier';
		}
		
		return __( $string, $domain );
	}
	
}