<?php

global $globKurier;
$statusIsOk = $globKurier->isUserLoggedIn(true);

if ($statusIsOk) {
	?>

	<div class="globkurier-notices-container">
		<div class="globkurier-notices-error" style="background-color: #aa00009c; padding: 10px; color: #fdf2f2; display: none">
			<div class="globkurier-notices-error-header">
				<span class="dashicons dashicons-warning"></span>
				<?php
				echo __('Podczas wysyłania zamówienia wystąpił błąd', 'globkurier') ?>:
				<hr>
			</div>
			<div class="globkurier-notices-error-body" style="padding: 0 15px;"></div>
		</div>
		<div class="globkurier-notices-success" style="background-color: rgba(49,128,41,0.61); padding: 10px; color: #fdf2f2; display: none">
			<div class="globkurier-notices-success-header">
				<span class="dashicons dashicons-yes-alt"></span>
				<?php
				echo __('Zamówienie zostało przyjęte.', 'globkurier') ?>:
				<hr>
			</div>
			<div class="globkurier-notices-success-body" style="padding: 0 15px;"></div>
		</div>

		<div class="globkurier-address-books-error" style="background-color: #aa00009c; padding: 10px; color: #fdf2f2; display: none">
			<div class="globkurier-notices-success-header">
				<span class="dashicons dashicons-warning"></span>
				<?php
				echo __('Podczas dodawania do książki adresowej wystąpił błąd', 'globkurier') ?>:
				<hr>
			</div>
			<div class="globkurier-address-books-error-body" style="padding: 0 15px;"></div>
		</div>

		<div class="globkurier-address-books-success" style="background-color: rgba(49,128,41,0.61); padding: 10px; color: #fdf2f2; display: none">
			<div class="globkurier-notices-success-header">
				<span class="dashicons dashicons-yes-alt"></span>
				<?php
				echo __('Pomyślnie dodano do książki adresowej', 'globkurier') ?>:
				<hr>
			</div>
			<div class="globkurier-address-books-success-body" style="padding: 0 15px;"></div>
		</div>
	</div>
	
	<?php
	
	global $wpdb;
	
	$ghostPostID = wp_insert_post([
		'post_title' => 'globkurier_ghost_post_do_not_delete',
		'post_type'  => 'globkurier_ghost',
	], true);
	
	$defaults          = $globKurier->settings('default');
	$defaultSenderData = apply_filters('globkurier_sender_defaults', $defaults[ 'send' ] ?? []);
	$defaultParcelData = apply_filters('globkurier_parcel_defaults', $defaults[ 'parcel' ] ?? []);
	
	$order = wc_get_order(get_the_ID());
	
	if ($order) {
		$receiverAddress = $order->get_shipping_address_1().$order->get_shipping_address_2();
		$pattern         = '/(?=\d)/';
		
		$receiverAddressParts = preg_split($pattern, $receiverAddress ?? '', 2);
		
		$receiverAddressStreet = $receiverAddressParts[ 0 ] ?? '';
		
		$senderAddressHome = mb_split('/', $receiverAddressParts[ 1 ] ?? '');
		
		$defaultWeight = $defaults[ 'parcel' ][ 'weight' ];
		$defaultLength = $defaults[ 'parcel' ][ 'length' ];
		$defaultWidth  = $defaults[ 'parcel' ][ 'width' ];
		$defaultHeight = $defaults[ 'parcel' ][ 'height' ];
		
		$maxWeight = 1;
		$maxLength = 1;
		$maxWidth  = 1;
		$maxHeight = 1;
		
		foreach ($order->get_items() as $item) {
			$id      = $item->get_product_id();
			$product = wc_get_product($id);
			
			$weight = $defaultWeight;
			$length = $defaultLength;
			$width  = $defaultWidth;
			$height = $defaultHeight;
			
			if ($product) {
				$weight = ! empty($product->get_weight()) ? $product->get_weight() : $defaultWeight;
				$length = ! empty($product->get_length()) ? $product->get_length() : $defaultLength;
				$width  = ! empty($product->get_width()) ? $product->get_width() : $defaultWidth;
				$height = ! empty($product->get_height()) ? $product->get_height() : $defaultHeight;
			}
			
			$maxWeight = max($maxWeight, ! empty($weight) ? $weight : 1);
			$maxLength = max($maxLength, ! empty($length) ? $length : 1);
			$maxWidth  = max($maxWidth, ! empty($width) ? $width : 1);
			$maxHeight = max($maxHeight, ! empty($height) ? $height : 1);
		}
		
		$receiverData = apply_filters('globkurier_receiver_data', [
			'name'    => $order->get_shipping_first_name().' '.$order->get_shipping_last_name(),
			'company' => $order->get_shipping_company() ?? '',
			'address' => $order->get_shipping_address_1().$order->get_shipping_address_2(),
			'street'  => $receiverAddressStreet ?? '',
			'home'    => $senderAddressHome[ 0 ] ?? '',
			'flat'    => $senderAddressHome[ 1 ] ?? '',
			'city'    => $order->get_shipping_city() ?? '',
			'state'   => $order->get_shipping_state() ?? '',
			'postal'  => $order->get_shipping_postcode() ?? '',
			'country' => $order->get_shipping_country() ?? '',
			'email'   => $order->get_billing_email() ?? '',
			'phone'   => $order->get_billing_phone() ?? '',
		]);
		
		$wcOrderId = get_the_ID();
	} else {
		$wcOrderId    = null;
		$receiverData = apply_filters('globkurier_receiver_data', [
			'name'    => '',
			'company' => '',
			'address' => '',
			'street'  => '',
			'flat'    => '',
			'city'    => '',
			'state'   => '',
			'postal'  => '',
			'country' => '',
			'email'   => '',
			'phone'   => '',
		]);
	}
	
	$defaultInpostValue = $globKurier->settings('inpost_default_code');
	$defaultInpostId    = $globKurier->settings('inpost_default');
	
	$inpostId    = get_post_meta($wcOrderId, 'globkurier_inpost_id', true);
	$inpostValue = get_post_meta($wcOrderId, 'globkurier_inpost_value', true);
	
	$ruchId    = get_post_meta($wcOrderId, 'globkurier_ruch_id', true);
	$ruchValue = get_post_meta($wcOrderId, 'globkurier_ruch_value', true);
	
	$pointType = '';
	$pointCode = '';
	$pointName = '';
	$pointText = '';
	
	if (! empty($inpostId) && ! empty($inpostValue)) {
		$pointType = 'inpost';
		$pointCode = $inpostValue;
		$pointName = $inpostId;
		$pointText = __('Paczkomat InPost', 'globkurier').': '.$inpostId;
	}
	
	if (! empty($ruchId) && ! empty($ruchValue)) {
		$pointType = 'ruch';
		$pointCode = $ruchValue;
		$pointName = $ruchId;
		$pointText = __('ORLEN Paczka', 'globkurier').': '.$ruchId;
	}
	
	?>

	<input type="hidden" id="udi-wc-order-id" value="<?php
	echo $wcOrderId ?>">

	<div class="udi-order-confirm-container" style="display:none;">

		<div class="udi-loader-overlay" style="display:none; background-color: rgba(211, 211, 211, 0.59);width: 100%;height: 100%;left: 0;position: absolute;"></div>
		<div class="udi-loader" style="width: 100em; height: 100em; margin: -5em; border-width: 5em; position: absolute; top: calc(50% - 50em); left: calc(50% - 50em);"></div>

		<h1><?php
			echo __('Podsumowanie zamówienia', 'globkurier') ?></h1>
		<p><?php
			echo __('Prosimy o wydruk listu przewozowego, który zostanie wysłany na adres e-mail Zleceniodawcy i Nadawcy. Numer listu umożliwi monitorowanie losów Twojej przesyłki. Przekazując kurierowi wydrukowany list przewozowy <strong>nie poniesiesz dodatkowych kosztów</strong>.',
				'globkurier') ?></p>
		<p class="udi-info-p"><?php
			echo __('Przed zatwierdzeniem prosimy dokładnie zweryfikować dane.', 'globkurier') ?></p>
		<div class="udi-order-confirm-address">
			<div class="udi-wpadmin-order-address-col">
				<div class="udi-product-extras-header">
					<?php
					echo __('NADAWCA', 'globkurier') ?>:
				</div>
				<div>
					<div>
						<span id="udi-confirm-address-sender-name"></span>
					</div>
					<div>
						<span id="udi-confirm-address-sender-street"></span>
						<span id="udi-confirm-address-sender-homeNumber"></span>
						<span id="udi-confirm-address-sender-flatNumber"></span>
					</div>
					<div>
						<span id="udi-confirm-address-sender-city"></span>
						<span id="udi-confirm-address-sender-postal"></span>
					</div>
					<div>
						<span id="udi-confirm-address-sender-flnames"></span>
					</div>
					<div>
						<?php
						echo __('tel.', 'globkurier') ?>
						<span id="udi-confirm-address-sender-phone"></span>
					</div>
					<div>
						<span id="udi-confirm-address-sender-email"></span>
					</div>
				</div>
			</div>
			<div class="udi-wpadmin-order-address-col">
				<?php
				do_action('globkurier_before_sender_data', $order, $defaultSenderData, $receiverData) ?>
				<div class="udi-product-extras-header">
					<?php
					echo __('ODBIORCA', 'globkurier') ?>:
				</div>

				<div>
					<div>
						<span id="udi-confirm-address-receiver-name"></span>
					</div>
					<div>
						<span id="udi-confirm-address-receiver-street"></span>
						<span id="udi-confirm-address-receiver-homeNumber"></span>
						<span id="udi-confirm-address-receiver-flatNumber"></span>
					</div>
					<div>
						<span id="udi-confirm-address-receiver-city"></span>
						<span id="udi-confirm-address-receiver-postal"></span>
					</div>
					<div>
						<span id="udi-confirm-address-receiver-flnames"></span>
					</div>
					<div>
						<?php
						echo __('tel.', 'globkurier') ?>
						<span id="udi-confirm-address-receiver-phone"></span>
					</div>
					<div>
						<span id="udi-confirm-address-receiver-email"></span>
					</div>
				</div>
			</div>
		</div>
		<div class="udi-order-confirm-product">
			<div class="udi-wpadmin-order-address-col">
				<div class="udi-product-extras-header">
					<?php
					echo __('PRODUKT', 'globkurier') ?>:
				</div>
				<div>
					<div><span id="udi-confirm-product-name"></span>
						<span id="udi-confirm-product-price"></span></div>
					<div id="udi-confirm-product-count"><?php
						echo __('Liczba paczek', 'globkurier') ?>:
						<span class="udi-confirm-value"></span></div>
					<div id="udi-confirm-product-terminal"><?php
						echo __('Nadanie przesyłki w terminalu.', 'globkurier') ?></div>
					<div id="udi-confirm-product-date"><?php
						echo __('Nadanie w dniu', 'globkurier') ?>:
						<span class="udi-confirm-value"></span></div>
					<div id="udi-confirm-product-time"><?php
						echo __('Nadanie w godzinach', 'globkurier') ?>:
						<span class="udi-confirm-value"></span></div>
					<div id="udi-confirm-product-content"><?php
						echo __('Zawartość przesyłki', 'globkurier') ?>:
						<span class="udi-confirm-value"></span></div>
				</div>
			</div>
			<div class="udi-wpadmin-order-address-col">
				<?php
				do_action('globkurier_before_sender_data', $order, $defaultSenderData, $receiverData) ?>
				<div class="udi-product-extras-header">
					<?php
					echo __('DODATKI', 'globkurier') ?>:
				</div>

				<div class="udi-confirm-extras"></div>
			</div>
		</div>
		<div class="udi-order-confirm-payment">

			<div class="udi-wpadmin-order-address-col">
				<div class="udi-product-extras-header">
					<?php
					echo __('PŁATNOŚĆ', 'globkurier') ?>:
				</div>

				<div>
					<div>
						<?php
						echo __('Forma płatności', 'globkurier') ?>:
						<span id="udi-confirm-payment-method"></span>
					</div>
				</div>
			</div>
			<div class="udi-wpadmin-order-address-col">
				<?php
				do_action('globkurier_before_sender_data', $order, $defaultSenderData, $receiverData) ?>
				<div class="udi-product-extras-header">
					<?php
					echo __('ŁĄCZNIE DO ZAPŁATY', 'globkurier') ?>:
				</div>
				<div>
					<h1 id="udi-confirm-payment-total-price"></h1>
				</div>
			</div>
		</div>
		<div class="udi-order-confirm-container-buttons">
			<button type="button" class="button-secondary globkurier_confirm_correction"><?php
				echo __('Popraw dane', 'globkurier') ?></button>
			<button type="button" class="button-primary globkurier_confirm_send"><?php
				echo __('Zatwierdź i zapłać', 'globkurier') ?></button>
		</div>
	</div>

	<div class="udi-wpadmin-order-address">
		<div class="udi-wpadmin-order-address-col">
			<?php
			do_action('globkurier_before_sender_data', $order, $defaultSenderData, $receiverData) ?>

			<div class="udi-wpadmin-order-address-col" style="border: 0; ">
				<div style="display: flex; align-items: flex-end; flex-wrap: nowrap;">
					<span class="dashicons dashicons-search"></span>

					<select style="width: 100%" class="udi-is-select2" data-type="senders" id="globkurier-find-sender">
						<option disabled selected><?php
							echo __('Wyszukaj nadawcę zdefiniowanego w książce adresowej', 'globkurier') ?></option>
					</select>
					<input type="hidden" class="globkurier-person-id" id="globkurier-sender-id">
				</div>
			</div>

			<br><br>

			<div class="udi-product-extras-header">
				<?php
				echo __('NADAWCA', 'globkurier') ?>:
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-sender-name"><?php
					echo __('Nazwa', 'globkurier') ?>:</label>
				<input name="globkurier-sender-name" type="text" id="globkurier-sender-name" maxlength="30" placeholder="<?php
				echo __('Nazwa', 'globkurier') ?>" value="<?php
				echo $defaultSenderData[ 'flnames' ] ?? '' ?>">
			</div>

			<div style="display: grid; grid-template-columns: auto auto 1fr">
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-sender-street"><?php
						echo __('Ulica', 'globkurier') ?>:</label>
					<input name="globkurier-sender-street" id="globkurier-sender-street" minlength="3" maxlength="35" placeholder="<?php
					echo __('Ulica', 'globkurier') ?>" type="text" value="<?php
					echo $defaultSenderData[ 'street' ] ?? '' ?>">
				</div>
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-sender-home"><?php
						echo __('Nr domu', 'globkurier') ?>:</label>
					<input name="globkurier-sender-home" id="globkurier-sender-home" maxlength="8" placeholder="<?php
					echo __('Nr domu', 'globkurier') ?>" type="text" value="<?php
					echo $defaultSenderData[ 'homeNumber' ] ?? '' ?>">
				</div>
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-sender-flat"><?php
						echo __('Nr lokalu', 'globkurier') ?>:</label>
					<input name="globkurier-sender-flat" id="globkurier-sender-flat" maxlength="20" placeholder="<?php
					echo __('Nr lokalu', 'globkurier') ?>" type="text" value="<?php
					echo $defaultSenderData[ 'flatNumber' ] ?? '' ?>">
				</div>
			</div>

			<div style="display: grid; grid-template-columns: auto auto 1fr">
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-sender-postal"><?php
						echo __('Kod Pocztowy', 'globkurier') ?>:</label>
					<input name="globkurier-sender-postal" id="globkurier-sender-postal" placeholder="<?php
					echo __('Kod Pocztowy', 'globkurier') ?>" type="text" value="<?php
					echo $defaultSenderData[ 'postal' ] ?? '' ?>">
				</div>
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-sender-city"><?php
						echo __('Miasto', 'globkurier') ?>:</label>
					<input name="globkurier-sender-city" id="globkurier-sender-city" placeholder="<?php
					echo __('Miasto', 'globkurier') ?>" type="text" style="" value="<?php
					echo $defaultSenderData[ 'city' ] ?? '' ?>">
				</div>
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-sender-country"><?php
					echo __('Kraj', 'globkurier') ?>:</label>
				<select style="max-width: 100%" class="udi-is-select2" name="globkurier-sender-country" id="globkurier-sender-country" placeholder="Kraj nadawcy">
					<option disabled selected><?php
						echo __('Kraj', 'globkurier') ?></option>
					<?php
					echo $globKurier->countries()->getDropdown($defaultSenderData[ 'country' ] ?? null); ?>
				</select>
			</div>

			<span style="font-weight: 500;"><?php
				echo __('Osoba kontaktowa', 'globkurier') ?>:</span>
			<div class="udi-input-with-hidden-label">
				<label for="globkurier-sender-contact-"><?php
					echo __('Nazwa', 'globkurier') ?>:</label>
				<input name="globkurier-sender-contact-name" id="globkurier-sender-contact-name" placeholder="<?php
				echo __('Nazwa', 'globkurier') ?>" type="text" value="<?php
				echo $defaultSenderData[ 'flnames' ] ?? '' ?>">
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-sender-contact-phone"><?php
					echo __('Telefon', 'globkurier') ?>:</label>
				<input name="globkurier-sender-contact-phone" id="globkurier-sender-contact-phone" placeholder="<?php
				echo __('Telefon', 'globkurier') ?>" type="text" value="<?php
				echo $defaultSenderData[ 'phone' ] ?? '' ?>">
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-sender-email"><?php
					echo __('E-mail', 'globkurier') ?>:</label>
				<input name="globkurier-sender-email" id="globkurier-sender-email" placeholder="<?php
				echo __('E-mail', 'globkurier') ?>" type="email" value="<?php
				echo $defaultSenderData[ 'email' ] ?? '' ?>">
			</div>

			<div style="display:flex; flex-wrap: wrap; margin-top: 20px">
				<button class="button-secondary globkurier-add-person-to-address-book" data-type="sender" id="globkurier-add-sender-to-address-book" style="display: none" type="button">Dodaj nadawcę do książki
					adresowej
				</button>
				<button class="button-secondary globkurier-update-person-to-address-book" data-type="sender" id="globkurier-update-sender-to-address-book" style="display: none" type="button">Aktualizuj istniejącego
					nadawcę
				</button>
			</div>
			
			<?php
			do_action('globkurier_after_sender_data', $order, $defaultSenderData, $receiverData) ?>
		</div>

		<div class="udi-wpadmin-order-address-col">
			<?php
			do_action('globkurier_before_receiver_data', $order, $defaultSenderData, $receiverData) ?>

			<div class="udi-wpadmin-order-address-col" style="border: 0">
				<div style="display: flex; align-items: flex-end; flex-wrap: nowrap;">
					<span class="dashicons dashicons-search"></span>
					<select style="width: 100%" class="udi-is-select2" data-type="receivers" id="globkurier-find-receiver">
						<option disabled selected><?php
							echo __(' Wyszukaj odbiorcę zdefiniowanego w książce adresowej', 'globkurier') ?></option>
					</select>
					<input type="hidden" class="globkurier-person-id" id="globkurier-receiver-id">
				</div>
			</div>

			<br><br>

			<div class="udi-product-extras-header">
				<?php
				echo __('ODBIORCA', 'globkurier') ?>:
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-receiver-name"><?php
					echo __('Nazwa', 'globkurier') ?>:</label>
				<input name="globkurier-receiver-name" type="text" id="globkurier-receiver-name" maxlength="30" placeholder="<?php
				echo __('Nazwa', 'globkurier') ?>" value="<?php
				echo $receiverData[ 'name' ] ?? '' ?>">
			</div>

			<div style="display: grid; grid-template-columns: auto auto 1fr">
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-receiver-street"><?php
						echo __('Ulica', 'globkurier') ?>:</label>
					<input name="globkurier-receiver-street" maxlength="35" minlength="3" id="globkurier-receiver-street" placeholder="<?php
					echo __('Ulica', 'globkurier') ?>" type="text" value="<?php
					echo $receiverData[ 'street' ] ?? '' ?>">
				</div>
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-receiver-home"><?php
						echo __('Nr domu', 'globkurier') ?>:</label>
					<input name="globkurier-receiver-home" maxlength="8" id="globkurier-receiver-home" placeholder="<?php
					echo __('Nr domu', 'globkurier') ?>" type="text" value="<?php
					echo $receiverData[ 'home' ] ?? '' ?>">
				</div>
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-receiver-flat"><?php
						echo __('Nr lokalu', 'globkurier') ?>:</label>
					<input name="globkurier-receiver-flat" maxlength="20" id="globkurier-receiver-flat" placeholder="<?php
					echo __('Nr lokalu', 'globkurier') ?>" type="text" value="<?php
					echo $receiverData[ 'flat' ] ?? '' ?>">
				</div>
			</div>

			<div style="display: grid; grid-template-columns: auto auto 1fr">
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-receiver-postal"><?php
						echo __('Kod Pocztowy', 'globkurier') ?>:</label>
					<input name="globkurier-receiver-postal" id="globkurier-receiver-postal" placeholder="<?php
					echo __('Kod Pocztowy', 'globkurier') ?>" type="text" value="<?php
					echo $receiverData[ 'postal' ] ?? '' ?>">
				</div>
				<div class="udi-input-with-hidden-label">
					<label for="globkurier-receiver-city"><?php
						echo __('Miasto', 'globkurier') ?>:</label>
					<input name="globkurier-receiver-city" id="globkurier-receiver-city" maxlength="35" placeholder="<?php
					echo __('Miasto', 'globkurier') ?>" type="text" style="" value="<?php
					echo $receiverData[ 'city' ] ?? '' ?>">
				</div>
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-receiver-country"><?php
					echo __('Kraj', 'globkurier') ?>:</label>
				<select style="max-width: 100%" class="udi-is-select2" name="globkurier-receiver-country" id="globkurier-receiver-country" placeholder="<?php
				echo __('Kraj odbiorcy', 'globkurier') ?>">
					<option disabled selected><?php
						echo __('Kraj', 'globkurier') ?></option>
					<?php
					echo $globKurier->countries()->getDropdown($receiverData[ 'country' ] ?? null, 'code'); ?>
				</select>
			</div>

			<span style="font-weight: 500;"><?php
				echo __('Osoba kontaktowa', 'globkurier') ?>:</span>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-receiver-contact-"><?php
					echo __('Nazwa', 'globkurier') ?>:</label>
				<input name="globkurier-receiver-contact-name" id="globkurier-receiver-contact-name" placeholder="<?php
				echo __('Nazwa', 'globkurier') ?>" type="text" value="<?php
				echo $receiverData[ 'name' ] ?? '' ?>">
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-receiver-contact-phone"><?php
					echo __('Telefon', 'globkurier') ?>:</label>
				<input name="globkurier-receiver-contact-phone" id="globkurier-receiver-contact-phone" placeholder="<?php
				echo __('Telefon', 'globkurier') ?>" type="text" value="<?php
				echo $receiverData[ 'phone' ] ?? '' ?>">
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-receiver-email"><?php
					echo __('E-mail', 'globkurier') ?>:</label>
				<input name="globkurier-receiver-email" id="globkurier-receiver-email" placeholder="<?php
				echo __('E-mail', 'globkurier') ?>" type="email" value="<?php
				echo $receiverData[ 'email' ] ?? '' ?>">
			</div>

			<div style="display:flex; flex-wrap: wrap; margin-top: 20px">
				<button class="button-secondary globkurier-add-person-to-address-book" data-type="receiver" id="globkurier-add-receiver-to-address-book" type="button">Dodaj odbiorcę do książki adresowej</button>
				<button class="button-secondary globkurier-update-person-to-address-book" data-type="receiver" id="globkurier-update-receiver-to-address-book" style="display: none" type="button">Aktualizuj istniejącego
					odbiorcę
				</button>
			</div>
			
			<?php
			do_action('globkurier_after_receiver_data', $order, $defaultSenderData, $receiverData) ?>
		</div>
	</div>

	<div class="udi-step-select-product">
		<h4><?php
			echo __('Podaj wymiary i wagę przesyłki', 'globkurier') ?>:</h4>

		<div class="globkurier-parcel-details" style="display: flex; align-items: baseline; flex-wrap: wrap;">

			<div class="udi-input-with-hidden-label">
				<label style="left: 15px;" for="globkurier-length"><?php
					echo __('Długość [cm]', 'globkurier') ?>:</label>
				<input type="number" name="globkurier[length]" id="globkurier-length" class="onlyDecimal max10" placeholder="<?php
				echo __('Długość [cm]', 'globkurier') ?>" value="<?php
				echo $maxLength ?? 1 ?>" min="1" style="margin: 0 10px;">
			</div>

			<span>x</span>

			<div class="udi-input-with-hidden-label">
				<label style="left: 15px;" for="globkurier-width"><?php
					echo __('Szerokość [cm]', 'globkurier') ?>:</label>
				<input type="number" name="globkurier[ width ]" id="globkurier-width" class="onlyDecimal max10" placeholder=" <?php
				echo __('Szerokość [cm]', 'globkurier') ?>" value="<?php
				echo $maxWidth ?? 1 ?>" min="1" style="margin: 0 10px">
			</div>

			<span>x</span>

			<div class="udi-input-with-hidden-label">
				<label style="left: 15px;" for="globkurier-height"><?php
					echo __('Wysokość [cm]', 'globkurier') ?>:</label>
				<input type="number" name="globkurier[height]" id="globkurier-height" class="onlyDecimal max10" placeholder="<?php
				echo __('Wysokość [cm]', 'globkurier') ?>" value="<?php
				echo $maxHeight ?? 1 ?>" min="1" style="margin: 0 10px;">
			</div>

			<span>x</span>

			<div class="udi-input-with-hidden-label">
				<label style="left: 15px;" for="globkurier-weight"><?php
					echo __('Waga [kg]', 'globkurier') ?>:</label>
				<input type="number" name="globkurier[weight]" id="globkurier-weight" class="max10" placeholder="<?php
				echo __('Waga [kg]', 'globkurier') ?>" value="<?php
				echo $maxWeight ?? 1 ?>" min="1" style="margin: 0 10px;">
			</div>
		</div>

		<h4><?php
			echo __('Zawartość', 'globkurier') ?>:</h4>
		<div class="globkurier-parcel-content" style="display: flex; align-items: baseline;flex-wrap: wrap;">
			<div class="udi-input-with-hidden-label">
				<label style="left: 15px;" for="globkurier-content"><?php
					echo __('Zawartość', 'globkurier') ?>:</label>

				<select style="margin: 0 10px" name="globkurier[content]" id="globkurier-content" placeholder="Zawartość">
					<?php
					
					foreach ($globKurier->contentsList() as $content) {
						$selected = '';
						if ($content == $defaultParcelData[ 'content' ]) {
							$selected = 'selected';
						}
						
						echo '<option value="'.$content.'" '.$selected.'>'.$content.'</option>';
					}
					?>
				</select>
			</div>

			<div class="udi-input-with-hidden-label">
				<label for="globkurier-content"><?php
					echo __('Inna zawartość - Jaka?', 'globkurier') ?>:</label>
				<input type="text" name="globkurier[otherContent]" id="globkurier-otherContent" placeholder="<?php
				echo __('Inna zawartość - Jaka?', 'globkurier') ?>" minlength="3" maxlength="20" value="<?php
				echo $defaultParcelData[ 'otherContent' ] ?? '' ?>"
					<?php
					if ($defaultParcelData[ 'content' ] !== 'Inne' ?? false) {
						?>
						style="display: none"
						<?php
					}
					?>>
			</div>

			<span>:</span>
			<div class="udi-input-with-hidden-label">
				<label style="left: 15px;" for="globkurier-quantity"><?php
					echo __('Ilość', 'globkurier') ?>:</label>
				<input type="number" name="globkurier[quantity]" id="globkurier-quantity" placeholder="<?php
				echo __('Ilość', 'globkurier') ?>" value="<?php
				echo $defaultParcelData[ 'quantity' ] ?? 1 ?>" min="1" max="10" maxvalue="10" oninput="this.value=this.value.replace(/[^0-9]/g,''); if( this.value > 10  ) this.value = 10;   " style="margin: 0 10px">
			</div>
		</div>
		<br>
		
		<?php
		if (! empty($pointType)) {
			?>
			<div class="globkurier_pickup_container">
				<input type="hidden" id="globkurier_is_pickup_active" value="1">
				<input type="hidden" id="globkurier_pickup_type" value="<?php
				echo $pointType ?>">
				<div class="globkurier_pickup_container-header">
					<span><?php
						echo __('ODBIÓR W PUNKCIE', 'globkurier') ?></span>
				</div>
				<div class="globkurier_pickup_container-body">
					<p><?php
						echo __('Twój klient wybrał odbiór w punkcie', 'globkurier') ?>:</p>
					<span class="globkurier_pickup_container-details"> <?php
						echo $pointText ?> </span>
					<p><?php
						echo __('W tym wypadku w wycenie będą zawarte tylko usługi pasujące do tego punktu Jeśli chcesz jednak, aby wyświetlane były wszystkie usługi zaznacz opcję poniżej', 'globkurier') ?>:</p>
					<div class="globkurier_pickup_container-buttons">
						<input id="globkurier_show_all_providers" type="checkbox">
						<label for="globkurier_show_all_providers"><?php
							echo __('Pokaż wszystkich przewoźników', 'globkurier') ?></label>
					</div>
				</div>
			</div>
			<?php
		} else {
			?>
			<input type="hidden" id="globkurier_is_pickup_active" value="0">
			<?php
		}
		?>

		<div class="globkurier_get_products-container">
			<button class="button-primary globkurier_get_products" type="button">
				<?php
				echo __('Wyceń', 'globkurier') ?>
				<div class="udi-loader"></div>
			</button>
		</div>

		<div class="globkurier_edit_data-container" style="display: none">
			<button class="button-primary globkurier_edit_data" type="button">
				<?php
				echo __('Edytuj dane', 'globkurier') ?>
			</button>
		</div>

		<div class="udi-best-price-products">
			<!--		<div class="products-list-header">-->
			<!--			<span>* Podane ceny są cenami netto</span>-->
			<!--		</div>-->
			<!--		-->
			<!--		<div class="products-list"></div>-->

			<!--		<div class="products-list-footer">-->
			<!--			<span class="udi-show-all-carriers">Pokaż wszystkich</span>-->
			<!--		</div>-->
		</div>

		<div class="udi-all-products"></div>
	</div>

	<div class="udi-step-select-product-details" style="display: none">

		<div class="udi-step-select-product-details-left">
			<div class="udi-selected-product">
				<input type="hidden" id="udi-selected-product-is-inpost">
				<input type="hidden" id="udi-selected-product-is-ruch">
				<input type="hidden" id="udi-selected-product-id">
				<div class="udi-selected-product-header">
					<div>
						<?php
						echo __('WYBRANY PRZEWOŹNIK', 'globkurier') ?>:
						<small class="udi-selected-product-body-name">Paczka w RUCHu</small>
					</div>
					<button type="button" class="button re-select-product"><?php
						echo __('Zmień', 'globkurier') ?></button>
				</div>

				<div class="udi-selected-product-body">
					<div class="udi-selected-product-body-container">
						<div class="udi-selected-product-body-logo">
							<img alt="Globkurier" class="udi-product-img">
							<span class="udi-selected-product-body-name"> </span>
						</div>
						<div class="udi-selected-product-body-price"><?php
							echo __('Koszt', 'globkurier') ?>:
							<span class="udi-product-price"></span>
							<span> / </span>
							<span class="udi-product-price-gross"></span>
							<input type="hidden" id="udi-carrierNetPriceWithAddons">
							<input type="hidden" id="udi-carrierGrossPriceWithAddons">
							<input type="hidden" id="udi-carrierNetPrice">
							<input type="hidden" id="udi-carrierGrossPrice">
						</div>
					</div>
					<div class="udi-selected-product-description"></div>
				</div>
				<div class="udi-selected-product-footer"></div>
			</div>

			<div class="udi-product-extras">
				<div class="udi-product-extras-header">
					<?php
					echo __('OPCJE DODATKOWE', 'globkurier') ?>:
					<div class="udi-loader">...</div>
				</div>
				<input type="hidden" id="globkurier-requiredAlternativeAddonsGroups">
				<div class="udi-product-extras-body" style="display:none;">

					<div class="udi-product-extras-category" id="udi-extra-category-receiver">
						<div class="udi-product-extras-category-header">
							<?php
							echo __('Odbiorca', 'globkurier') ?>
						</div>
						<div class="udi-product-extras-cat-items"></div>
					</div>

					<div class="udi-product-extras-category" id="udi-extra-category-cod">
						<div class="udi-product-extras-category-header">
							<?php
							echo __('Pobranie COD', 'globkurier') ?>
						</div>
						<div class="udi-product-extras-cat-items"></div>
					</div>

					<div class="udi-product-extras-category" id="udi-extra-category-insurance">
						<div class="udi-product-extras-category-header">
							<?php
							echo __('Ubezpieczenie', 'globkurier') ?>
						</div>
						<div class="udi-product-extras-cat-items"></div>
					</div>

					<div class="udi-product-extras-category" id="udi-extra-category-other">
						<div class="udi-product-extras-category-header">
							<?php
							echo __('Inne', 'globkurier') ?>
						</div>
						<div class="udi-product-extras-cat-items"></div>
					</div>

				</div>
			</div>
		</div>

		<div class="udi-step-select-product-details-right">
			<div class="udi-service-options">
				<div class="udi-service-options-header"><?php
					echo __('Opcje nadania', 'globkurier') ?>:
				</div>
				<div class="udi-service-options-body">

					<div style="display: contents">

						<div class=udi-options-body-row" style="display: contents;">
							<label class="udi-options-body-label" for=""><?php
								echo __('Nadanie przesyłki', 'globkurier') ?>:</label>
							<div class="" style="margin-left: 10px;">
								<input type="radio" id="globkurier-pickup-type-PICKUP" data-pickuptype="PICKUP" name="globkurier-pickup-type" value="PICKUP">
								<label for="globkurier-pickup-type-PICKUP">Przesyłkę odbierze kurier</label><br>
								<input type="radio" id="globkurier-pickup-type-POINT" data-pickuptype="POINT" name="globkurier-pickup-type" value="POINT">
								<label for="globkurier-pickup-type-POINT">Nadam przesyłkę w terminalu</label><br>
							</div>
						</div>

						<div class="globkurier-not-pickup udi-options-body-row" style="display: contents;">
							<label class="udi-options-body-label" for="globkurier-service-date-picker"><?php
								echo __('Data nadania', 'globkurier') ?>:</label>
							<div class="udi-input-with-notice">
								<input type="text" style="flex-basis: 100%; background-color: inherit !important;" id="globkurier-service-date-picker" readonly>
								<small><?php
									echo __('W jakim dniu kurier ma przyjechać po paczkę?', 'globkurier') ?></small>
							</div>
						</div>

						<div class="globkurier-not-pickup" style="display: contents;">
							<label for="globkurier-service-time-picker" class="udi-options-body-label"><?php
								echo __('Godzina nadania', 'globkurier') ?>:</label>
							<div class="udi-input-with-notice">
								<select name="globkurier-service-time-picker" id="globkurier-service-time-picker"></select>
							</div>
						</div>

						<div class="globkurier-only-ruch">
							<label for="globkurier_ruch_input" class="udi-options-body-label"><?php
								echo __('ORLEN Paczka punkt odbioru', 'globkurier') ?>:</label>

							<div class="udi-input-with-notice">
								<select style="width: 100%" class="udi-select2" id="udi-select-ruch" name="globkurier_ruch_input_value">
									<?php
									if (isset($ruchId)) {
										echo "<option value='{$ruchValue}' selected>{$ruchId}</option>";
									}
									?>
								</select>
								<input type="hidden" class="globkurier-is-required" name="globkurier_ruch_input" id="globkurier_ruch_input" value="<?php
								echo $ruchId ?? '' ?>">
							</div>

						</div>

						<div class="globkurier-only-inpost">
							<label for="globkurier_inpost_input" class="udi-options-body-label"><?php
								echo __('InPost punkt nadania', 'globkurier') ?>:</label>

							<div class="udi-input-with-notice">
								<select type="text" style="width: 100%" class=" udi-select2" id="udi-select-inpost-sender" name="globkurier_inpost_input_sender_value">
									<?php
									if (isset($defaultInpostId)) {
										echo "<option value='{$defaultInpostValue}' selected>{$defaultInpostId}</option>";
									}
									?>
								</select>
								<input type="hidden" name="globkurier_inpost_input" id="globkurier_inpost_input" value="<?php
								echo $defaultInpostId ?? '' ?>">
							</div>
						</div>

						<div class="globkurier-only-inpost">
							<label for="globkurier_inpost_input" class="udi-options-body-label"><?php
								echo __('InPost punkt odbioru', 'globkurier') ?>:</label>

							<div class="udi-input-with-notice">

								<select type="text" style="width: 100%" class=" udi-select2" id="udi-select-inpost-pickup_value" name="globkurier_inpost_input_value">
									<?php
									if (isset($inpostId)) {
										echo "<option value='{$inpostValue}' selected>{$inpostId}</option>";
									}
									?>
								</select>

								<input type="hidden" name="globkurier_inpost_input-pickup" id="globkurier_inpost_input-pickup" value="<?php
								echo $inpostId ?? '' ?>">
							</div>
						</div>

					</div>

					<div id="globkurier-custom-fields-required" style="display: contents;"></div>


					<div id="globkurier-service-extra-fields-INSURANCE" style="display: contents;"></div>
					<div id="globkurier-service-extra-fields-CASH_ON_DELIVERY" style="display: contents;"></div>
					<div id="globkurier-service-extra-fields-RETURN_OF_DOCUMENTS" style="display: contents;"></div>
					<div id="globkurier-service-extra-fields-SENDER_WAYBILL_ADDRESS" style="display: contents;"></div>

					<div style="display: contents;">
						<label for="globkurier-service-payment-picker" class="udi-options-body-label""><?php
						echo __('Płatność', 'globkurier') ?>:</label>
						<div class="udi-input-with-notice">
							<select style="width: 100%" name="globkurier-service-payment-picker" id="globkurier-service-payment-picker"></select>
						</div>
					</div>

					<div style="display: contents;">
						<button style="width: max-content; justify-self: flex-end; grid-column-start: 2;" type="button" class="button button-primary udi-save-order">
							<?php
							echo __('Potwierdzam i składam zamówienie', 'globkurier') ?>
							<div class="udi-loader"></div>
						</button>
					</div>

				</div>
			</div>
		</div>

	</div>
	
	<?php
}//end $statusIsOk
else {
	return false;
}
?>