<?php
$mataName  = apply_filters( 'globkurier_wc_order_meta_name', 'globkurier_orders' );
$oldOrders = array_reverse( get_post_meta( get_the_ID(), $mataName, FALSE ) );
?>

<div class="globkurier-old-orders-table-wrapper">
	<table class="globkurier-old-orders-table">
		<thead>
			<tr>
				<th style="min-width: 150px"><?php echo __( 'Nr zamówienia GK', 'globkurier' ) ?></th>
				<th style="min-width: 100px"><?php echo __( 'Data nadania', 'globkurier' ) ?></th>
				<th style="min-width: 100px"><?php echo __( 'Odbiorca', 'globkurier' ) ?></th>
				<th style="min-width: 100px"><?php echo __( 'Zawartość', 'globkurier' ) ?></th>
				<th style="min-width: 100px"><?php echo __( 'Waga [kg]', 'globkurier' ) ?></th>
				<th style="min-width: 150px"><?php echo __( 'Przewoźnik', 'globkurier' ) ?></th>
				<th style="min-width: 100px"><?php echo __( 'Pobranie [zł]', 'globkurier' ) ?></th>
				<th style="min-width: 150px"><?php echo __( 'Płatność', 'globkurier' ) ?></th>
				<th style="min-width: 100px"><?php echo __( 'Cena [zł]', 'globkurier' ) ?></th>
				<th style="min-width: 100px"><?php echo __( 'Status', 'globkurier' ) ?></th>
				<th style="min-width: 50px"><?php echo __( 'Opcja', 'globkurier' ) ?></th>
			</tr>
		</thead>
		
		<tbody>
		<?php
		global $globKurier;
		
		foreach( $oldOrders as $order ){
			$order = maybe_unserialize( $order );
			?>
			<tr>
				<td><?php echo $order[ 'number' ] ?? '' ?></td>
				<td><?php echo date( 'd.m.Y H:i', $order[ 'date' ] ) ?? '' ?></td>
				<td><?php echo $order[ 'data' ][ 'receiverAddress' ][ 'name' ] ?? '' ?></td>
				<td><?php echo $order[ 'data' ][ 'content' ] ?? '' ?></td>
				<td><?php echo $order[ 'data' ][ 'shipment' ][ 'weight' ] ?? '' ?></td>
				<td><?php echo $order[ 'carrier' ][ 'name' ] ?? '' ?></td>
				<td><?php echo $order[ 'cod' ][ 'value' ] ?? '-' ?></td>
				<td><?php echo $order[ 'payment_name' ] ?? '' ?></td>
				<td><?php echo $order[ 'price' ][ 'net' ] ?? '' ?>zł</td>
				<td>
					<button type="button" data-number="<?php echo $order['number'] ?>" class="udi-get-current-status"><?php echo __( 'Pobierz', 'globkurier' ) ?></button>
					<div class="udi-loader"></div>
					<span class="udi-status-value"></span>
				</td>
				<td>
					<a style="text-decoration: none" href="<?php echo $globKurier->api()->getOrderLabelPdfUrl( $order[ 'hash' ] ) ?>" target="_blank" title="<?php echo __( 'Pobierz list przewozowy', 'globkurier' ) ?>">
						<span class="dashicons dashicons-media-document"></span>
					</a>
					<a style="text-decoration: none" href="<?php echo $globKurier->api()->getOrderTrackUrl( $order[ 'number' ] ) ?>" target="_blank" title="<?php echo __( 'Śledź przesyłkę', 'globkurier' ) ?>">
						<span class="dashicons dashicons-search"></span>
					</a>
				</td>
			</tr>
			<?php
		}
		?>
		</tbody>
	
	</table>
</div>
