<?php

global $wpdb;
global $globKurier;


if (isset($_GET[ 'getPdfProtocols' ])) {
	$pdf = $globKurier->documents()->getOrderProtocolPdf($_GET[ 'hashes' ] ?? []);
	
	if(strpos($pdf, '%PDF') === false){
		echo $pdf;
		die;
	}
	
	ob_clean();
	header('Content-type: application/pdf');
	header('Content-Disposition: inline; filename="protocol.pdf"');
	header('Content-Transfer-Encoding: binary');
	header('Accept-Ranges: bytes');
	
	die($pdf);
}


$mataName = apply_filters( 'globkurier_wc_order_meta_name', 'globkurier_orders' );

$s_orders = $wpdb->get_results( "SELECT `meta_value`, `post_id` FROM `{$wpdb->postmeta}` WHERE meta_key = '{$mataName}'", ARRAY_A );

$orders = [];
foreach( $s_orders as $order ){
	$data = maybe_unserialize( maybe_unserialize( $order[ 'meta_value' ] ) );
	
	$data[ 'wcOrderId' ] = $order[ 'post_id' ];
	
	$orders[] = $data;
}

usort( $orders, function( $item1, $item2 ){
	return $item2[ 'date' ] <=> $item1[ 'date' ];
} );

?>

<h1><?php echo __( 'Lista protokołów GlobKurier', 'globkurier' ) ?></h1>

<div class="globkurier-old-orders-table-wrapper">
	<table class="globkurier-old-orders-table stripe udi-is-datatable">
		<thead>
		<tr>
			<th></th>
			<th style="min-width: 150px"><?php echo __( 'Nr zamówienia GK', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Data nadania', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Odbiorca', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Zawartość', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Waga [kg]', 'globkurier' ) ?></th>
			<th style="min-width: 150px"><?php echo __( 'Przewoźnik', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Pobranie [zł]', 'globkurier' ) ?></th>
			<th style="min-width: 150px"><?php echo __( 'Płatność', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Cena [zł]', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Status', 'globkurier' ) ?></th>
			<th style="min-width: 100px"><?php echo __( 'Nr Zamówienia <br> Woocommerce', 'globkurier' ) ?></th>
			<th style="min-width: 50px"><?php echo __( 'Opcja', 'globkurier' ) ?></th>
		</tr>
		</thead>
		<tbody>
		<?php
		
		foreach( $orders as $order ){
			$wcOrder = wc_get_order( $order[ 'wcOrderId' ] );
			?>
			<tr>
				<td>
					<input type="checkbox" class="globkurier-order-bulk-check" value="<?php echo $order[ 'hash' ] ?>" title="<?php echo __( 'Zaznacz', 'globkurier' ) ?>">
				</td>
				<td><?php echo $order[ 'number' ] ?? '' ?></td>
				<td><?php echo date( 'd.m.Y H:i', $order[ 'date' ] ) ?? '' ?></td>
				<td><?php echo $order[ 'data' ][ 'receiverAddress' ][ 'name' ] ?? '' ?></td>
				<td><?php echo $order[ 'data' ][ 'content' ] ?? '' ?></td>
				<td><?php echo $order[ 'data' ][ 'shipment' ][ 'weight' ] ?? '' ?></td>
				<td><?php echo $order[ 'carrier' ][ 'name' ] ?? '' ?></td>
				<td><?php echo $order[ 'cod' ][ 'value' ] ?? '-' ?></td>
				<td><?php echo $order[ 'payment_name' ] ?? '' ?></td>
				<td><?php echo $order[ 'price' ][ 'net' ] ?? '' ?>zł</td>
				<td>
					<button type="button" data-number="<?php echo $order[ 'number' ] ?>" title="<?php echo __( 'Pobierz status zamówienia', 'globkurier' ) ?>" class="udi-get-current-status"><?php echo __( 'Pobierz', 'globkurier' ) ?></button>
					<div class="udi-loader"></div>
					<span class="udi-status-value"></span>
				</td>
				<td>
					<?php
					
					if( $wcOrder ){
						?>
						<a style="text-decoration: none" href="<?php echo $wcOrder->get_edit_order_url() ?>" target="_blank">#<?php echo $wcOrder->get_order_number() ?></a>
						<?php
					} else{
						echo '-';
					}
					
					?>
				</td>
				<td>
					<a style="text-decoration: none" href="<?php echo  $globKurier->api()->getOrderProtocolPdfUrl( $order[ 'hash' ] ?? '' ) ?>" target="_blank" title="<?php echo __( 'Pobierz list przewozowy', 'globkurier' ) ?>">
						<span class="dashicons dashicons-media-document"></span>
					</a>
					<a style="text-decoration: none" href="<?php echo $globKurier->api()->getOrderTrackUrl( $order[ 'number' ] ) ?>" target="_blank" title="<?php echo __( 'Śledź przesyłkę', 'globkurier' ) ?>">
						<span class="dashicons dashicons-search"></span>
					</a>
				</td>
			</tr>
			<?php
		}
		?>
		</tbody>
		<tfoot>
		<tr>
			<td colspan="13">
				
				<input id="udi-check-all" type="checkbox">
				<label for="udi-check-all"><?php echo __( 'Zaznacz wszystkie', 'globkurier' ) ?></label>
				<br>
				<div class="glogburier-orders-bulk-actions-container">
					
					<p class="glogburier-orders-bulk-actions-header"><?php echo __( 'Masowe działania dla', 'globkurier' ) ?>
						<span id="bulk-actions-counter">0</span> <?php echo __( 'zaznaczonych pozycji', 'globkurier' ) ?>
					</p>
					
					<div class="globkurier-orders-bulk-actions">
						<select id="bulk-print-format">
							<option value="1"><?php echo __( 'Pobranie protokołu', 'globkurier' ) ?></option>
						</select>
						
						<button type="button" class="button globkurier-bulk-action"><?php echo __( 'Wykonaj', 'globkurier' ) ?></button>
					
					</div>
				
				</div>
			
			</td>
		</tr>
		
		
		</tfoot>
	</table>
	<?php
	
	//	echo paginate_links(array(
	//		'base'			=> str_replace( '$big', '%#%', esc_url( get_pagenum_link( '$big' ) ) ),
	////		'format'		=> $format,
	//		'current'		=> max( 1, get_query_var('paged') ),
	//		'total' 		=> 4,
	//		'mid_size'		=> 3,
	//		'type' 			=> 'list',
	//		'prev_text'		=> '<',
	//		'next_text'		=> '>',
	//	) );
	?>
</div>

<script>
	
	( function ( $ ) {
		$( function () {
			
			$( '.udi-is-datatable' ).on( 'page.dt', function () {
				$( '.globkurier-order-bulk-check' ).prop( 'checked', false ).change();
			} );
			
			$( '#udi-check-all' ).change( function () {
				if ( $( this ).is( ':checked' ) ) {
					$( '.globkurier-order-bulk-check' ).prop( 'checked', true ).change();
				}
			} );
			
			$( document ).on( 'change', '.globkurier-order-bulk-check', function () {
				let counter = $( '.globkurier-order-bulk-check:checked' ).length;
				$( '#bulk-actions-counter' ).html( counter );
			} );
			
			$( '.globkurier-bulk-action' ).click( function () {
				let counter = $( '.globkurier-order-bulk-check:checked' ).length;
				
				if ( counter == 0 ) {
					return;
				}
				let button = $( this );
				button.attr( 'disabled', true );
				
				let orderHashes = $( '.globkurier-order-bulk-check:checked' ).map( function ( idx, elem ) {
					return $( this ).val();
				} ).get();
				
				window.open( '?page=globkurier_protocols&getPdfProtocols&hashes=' + orderHashes, '_blank' );
				button.attr( 'disabled', false );

				return;
				
				let ajaxData = {
					action: 'globkurierGetProtocols',
					data: {
						orderHashes: orderHashes,
					}
				};
				
				$.post( data[ 'ajaxUrl' ], ajaxData, function ( response ) {
					if ( response.success == false ) {
						alert( response.data.toString() );
						button.show();
						button.attr( 'disabled', false );
					} else {
						let text = response.data.pop().name;
						statusText.text( text );
					}
					
					loader.hide();
				} ).fail( function () {
					alert( 'error' );
				} );
				
			} );
			
			
		} );
	} )( jQuery );

</script>
