<?php

namespace wp_opieka_globkurier;

class GlobKurierCustomRequiredFields extends GlobKurier{
	
	private function customFields( $field, $countryId = NULL ){
		
		switch( $field ){
			
			case 'declaredValue':
				return [
					'name'     => 'declaredValue',
					'label'    => __( 'Deklarowana wartość przesyłki', 'globkurier' ),
					'type'     => 'number',
					'required' => TRUE,
				];
			
			case 'purpose':
				return [
					'name'     => 'purpose',
					'label'    => __( 'Cel przesyłki', 'globkurier' ),
					'type'     => 'select',
					'options'  => [
						''                  => '-- Wybierz --',
						'SOLD'              => 'Sprzedaż',
						'GIFT'              => 'Prezent',
						'SAMPLE'            => 'Próbka',
						'NOT_SOLD'          => 'Nie na sprzedaż',
						'PERSONAL_EFFECTS'  => 'Cele osobiste',
						'REPAIR_AND_RETURN' => 'Naprawa i zwrot'
					],
					'required' => TRUE,
				];
			
			case 'senderStateId':
				return [
					'name'     => 'senderStateId',
					'label'    => __( 'Nadawca Stan/region', 'globkurier' ),
					'type'     => 'select',
					'options'  => $this->getStates( $countryId ),
					'required' => TRUE,
				];
			
			case 'receiverStateId':
				return [
					'name'     => 'receiverStateId',
					'label'    => __( 'Odbiorca Stan/region', 'globkurier' ),
					'type'     => 'select',
					'options'  => $this->getStates( $countryId ),
					'required' => TRUE,
				];
			
		}
		
		return NULL;
	}
	
	private function getStates( $countryId ){
		
		$function = 'states';
		$method   = 'GET';
		
		$token = $this->api()->getToken();
		
		$params = [
			'countryId' => $countryId,
		];
		
		$response = $this->api()->getResponse( $function, $token, $params, $method );
		
		$states = $response[ 'data' ];
		
		$response = [
			' ' => '-- Wybierz --'
		];
		foreach( $states as $state ){
			$response[ $state[ 'id' ] . ' ' ] = $state[ 'name' ] . ' ' . $state[ 'isoCode' ];
		}
		
		return $response;
	}
	
	public function get( $params ){
		
		$function = 'order/customRequiredFields';
		$method   = 'GET';
		
		$token = $this->api()->getToken();
		
		$response = $this->api()->getResponse( $function, $token, $params, $method );
		
		$data = $response[ 'data' ];
		
		$requiredFields = $this->parseResponse( $data, $params[ 'receiverCountryId' ] );
		
		$fieldsHtml = [];
		
		foreach( $requiredFields as $requiredField ){
			$countryId = NULL;
			
			if( $requiredField == 'senderStateId' ){
				$countryId = $params[ 'senderCountryId' ];
			}
			if( $requiredField == 'receiverStateId' ){
				$countryId = $params[ 'receiverCountryId' ];
			}
			
			$fieldHtml = $this->customFields( $requiredField, $countryId );
			
			if( ! empty( $fieldHtml ) ){
				$fieldsHtml[] = $fieldHtml;
			}
		}
		
		return $fieldsHtml;
	}
	
	private function parseResponse( $response, $receiverCountryId ){
		
		$required = [];
		
		foreach( $response as $key => $value ){
			if( ! empty( $value ) || ( $receiverCountryId == 30 && $key == 'receiverStateId' ) ){
				$required[] = $key;
			}
		}
		
		return $required;
	}
	
}