<?php

namespace wp_opieka_globkurier;

require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierCountries.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierEncrypter.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierUser.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierProduct.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierAddons.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierOrder.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierInpost.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierRuch.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierCustomRequiredFields.php' );
require_once Udi_Helper::getAdminPath( 'globkurier/GlobKurierDocuments.php' );

require_once Udi_Helper::getAdminPath( 'woocommerce/ShippingMethods.php' );

class GlobKurier{
	
	public $settings;
	
	public function __construct(){
		$this->settings = $this->settings();
	}
	
	public function api(): GlobKurierApi{
		return new GlobKurierApi( $this );
	}
	
	public function getSettingsUrl(){
		$adminUrl = get_admin_url();
		$suffix   = 'admin.php?page=wc-settings&tab=shipping&section=globkurier';
		
		return apply_filters( 'globkurier_settings_url', $adminUrl . $suffix );
	}
	
	public function testConnection( $getCode = FALSE ){
		
		return $this->api()->testConnection( $getCode );
	}
	
	public function getConnectionCode(){
		
		return $this->testConnection( TRUE );
	}
	
	public function isUserLoggedIn( $die = FALSE ){
		if( ( $code = $this->getConnectionCode() ) !== 200 ){
			$this->addErrorAdminNotice( "Błąd połączenia z serwerem GLOBKURIER<br>(Kod odpowiedzi = {$code})", 'error', $die );
			return FALSE;
		}

		$username = $this->settings( 'username' );
		$password = $this->settings( 'password' );
		
		if( empty( $username ) || empty( $password ) ){
			$this->addErrorAdminNotice( __( 'Proszę skonfigurować połączenie z API GlobKurier', 'globkurier' ) . "<br><a href='{$this->getSettingsUrl()}'>" . __( 'Konfiguracja', 'globkurier' ) .'</a>', 'error', $die );
			return FALSE;
		}
		
		if( ( $code = $this->api()->testToken() ) !== 200  ){
			$this->addErrorAdminNotice( __( 'Błędny login lub hasło połączenia API GlobKurier', 'globkurier' ) . "<br>(Kod odpowiedzi = {$code})", 'error', $die );
			return FALSE;
		}
	
		return TRUE;
	}

	public function settings( $setting = NULL, $default = [] ){
		
		$optionsKey = 'globkurier';
		
		$options = get_option( $optionsKey, $default );
		
		if( $setting ){
			return $options[ $setting ] ?? $default;
		}
		
		return $options;
	}
	
	public function getLanguage(){
		return $this->settings[ 'language' ] ?? 'pl';
	}
	
	public function encrypter(): GlobKurierEncrypter{
		return new GlobKurierEncrypter();
	}
	
	public function countries(): GlobKurierCountries{
		return new GlobKurierCountries();
	}
	
	public function user(): GlobKurierUser{
		return new GlobKurierUser();
	}
	
	public function order(): GlobKurierOrder{
		return new GlobKurierOrder();
	}
	
	public function addons(): GlobKurierAddons{
		return new GlobKurierAddons();
	}
	
	public function product(): GlobKurierProduct{
		
		return new GlobKurierProduct();
	}
	
	public function contentsList(){
		
		return [
			''                               => '-- Wybierz --',
			'Akcesoria telefoniczne'         => 'Akcesoria telefoniczne',
			'Artykuły medyczne (nie leki)'   => 'Artykuły medyczne (nie leki)',
			'Artykuły i narzędzia budowlane' => 'Artykuły i narzędzia budowlane',
			'Artykuły i urządzenia sportowe' => 'Artykuły i urządzenia sportowe',
			'Części samochodowe'             => 'Części samochodowe',
			'Dokumenty'                      => 'Dokumenty',
			'Fotografie'                     => 'Fotografie',
			'Książki i czasopisma'           => 'Książki i czasopisma',
			'Materiały firmowe'              => 'Materiały firmowe',
			'Meble'                          => 'Meble',
			'Odzież'                         => 'Odzież',
			'Sprzęt AGD i RTV'               => 'Sprzęt AGD i RTV',
			'Sprzęt komputerowy'             => 'Sprzęt komputerowy',
			'Wózki'                          => 'Wózki',
			'Zabawki i modele'               => 'Zabawki i modele',
			'Inne'                           => 'Inne'
		];
		
	}
	
	public function inpost(): GlobKurierInpost{
		
		return new GlobKurierInpost();
	}
	
	public function ruch(): GlobKurierRuch{
		
		return new GlobKurierRuch();
	}
	
	public function customRequiredFields(){
		return new GlobKurierCustomRequiredFields();
	}
	
	public function documents(){
		return new GlobKurierDocuments();
	}
	
	public function wcShippingMethods(){
		return new ShippingMethods();
	}
	
	private function postExist( $postId ){
		return get_post_status( $postId ) !== FALSE;
	}
	
	// Used to store not Woocommerce order globkurier assigned shipping datails
	public function getGhostPostID(){
		$currentGhostPostID = get_option( 'globkurier_ghost_post_id', NULL );
		
		if( $currentGhostPostID && $this->postExist( $currentGhostPostID ) ){
			//ghost post already exist skip creating
			return $currentGhostPostID;
		}
		
		$ghostPostID = wp_insert_post( [
			'post_title' => 'globkurier_ghost_post_do_not_delete',
			'post_type'  => 'globkurier_ghost',
		] );
		
		update_option( 'globkurier_ghost_post_id', $ghostPostID );
		
		return $ghostPostID;
	}
	
	public function handleError( $code, $response = NULL ){
		
		echo json_encode( $response[ 'fields' ] ?? $code );
		die;
	}
	
	public function addErrorAdminNotice( $msg, $type = 'error', $die = TRUE ){
		echo "<div class=\"notice notice-{$type}\">";
		echo "<p>{$msg}</p>";
		echo '</div>';
		
		if( $die ){
			die;
		}
	}
}