<?php

namespace wp_opieka_globkurier;

class Udi_Admin{
	
	private $plugin_name;
	
	private $version;
	
	public function __construct( $plugin_name, $version ){
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}
	
	public function enqueue_styles(){
		wp_enqueue_style( 'woocommerce_admin_styles', WC()->plugin_url() . '/assets/css/admin.css', array(), WC_VERSION );
		
		wp_enqueue_style( $this->plugin_name.'_jquery-ui', Udi_Helper::getAdminUrl( 'css/jquery-ui.css' ), [], $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name.'_datatables', Udi_Helper::getAdminUrl( 'css/datatables/datatables.min.css' ), [], $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name, Udi_Helper::getAdminUrl( 'css/udi-admin.css' ), [], $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name.'_select2', Udi_Helper::getAdminUrl( 'css/select2/select2.min.css' ), [], $this->version, 'all' );
	}
	
	public function enqueue_scripts(){
		
		wp_enqueue_script( 'jquery-ui-dialog' );
		wp_enqueue_script( 'jquery-ui-datepicker' );
		
		$data = [
			'ajaxUrl' => UDI_Helper::getAjaxUrl()
		];
		
		wp_enqueue_script( $this->plugin_name.'_datatables', Udi_Helper::getAdminUrl( 'js/datatables/datatables.min.js' ), [ 'jquery' ], $this->version, FALSE );
		wp_enqueue_script( $this->plugin_name.'_select2', Udi_Helper::getAdminUrl( 'js/select2/select2.min.js' ), [ 'jquery' ], $this->version, FALSE );
		wp_enqueue_script( $this->plugin_name, Udi_Helper::getAdminUrl( 'js/udi-admin.js' ), [ 'jquery' ], $this->version, FALSE );
		
		wp_localize_script( $this->plugin_name, 'data', $data );
	}
	
	public function load_admin_menu(){
		require_once Udi_Helper::getAdminPath( 'partials/udi-admin-header.php' );
		
		$this->load_admin_page_template();
		
		require_once Udi_Helper::getAdminPath( 'partials/udi-admin-footer.php' );
	}
	
	private function load_admin_page_template(){
		if( $page = $_GET[ 'page' ] ){
			
			require_once Udi_Helper::getAdminPath( "partials/udi-admin-{$page}.php" );
		}
	}
	
	public function test(){
		die( 'test ok' );
	}
	
}