<?php

namespace wp_opieka_globkurier;

class Udi_Admin_Ajax{
	public function __construct(){
	}
	
	public function init(){
		$this->priv();
	}
	
	private function priv(){
		$actionPrefix = 'wp_ajax_';
		add_action( $actionPrefix . 'globkurierGetProducts', [ $this, 'getProducts' ] );
		add_action( $actionPrefix . 'globkurierGetProductAddons', [ $this, 'getProductAddons' ] );
		add_action( $actionPrefix . 'globkurierGetProductAddonFields', [ $this, 'getProductAddonFields' ] );
		add_action( $actionPrefix . 'globkurierGetPickupTimeRanges', [ $this, 'getPickupTimeRanges' ] );
		add_action( $actionPrefix . 'globkurierGetFirstPickupDay', [ $this, 'getFirstPickupDay' ] );
		add_action( $actionPrefix . 'globkurierGetPrice', [ $this, 'getPrice' ] );
		add_action( $actionPrefix . 'globkurierGetPayments', [ $this, 'getPayments' ] );
		add_action( $actionPrefix . 'globkurierOrder', [ $this, 'order' ] );
		add_action( $actionPrefix . 'globkurierGetCurrentStatus', [ $this, 'getCurrentStatus' ] );
		add_action( $actionPrefix . 'globkurierCustomRequiredFields', [ $this, 'getCustomRequiredFields' ] );
		add_action( $actionPrefix . 'globkurierGetPerson', [ $this, 'getPerson' ] );
		add_action( $actionPrefix . 'globkurierAddPersonToAddressBook', [ $this, 'addPersonToAddressBook' ] );
		add_action( $actionPrefix . 'globkurierUpdatePersonToAddressBook', [ $this, 'updatePersonToAddressBook' ] );
		
		add_action( $actionPrefix . 'globkurierGetTracking', [ $this, 'getTracking' ] );
		add_action( $actionPrefix . 'globkurierGetLabels', [ $this, 'getLabels' ] );
		add_action( $actionPrefix . 'globkurierGetProtocols', [ $this, 'getProtocols' ] );
		
		add_action( $actionPrefix . 'globkurierGetOrders', [ $this, 'globkurierGetOrders' ] );
		
		
		add_action( $actionPrefix . 'globkurierUpdateInpost', [ $this, 'globkurierUpdateInpost' ] );
		add_action( $actionPrefix . 'globkurierUpdateRuch', [ $this, 'globkurierUpdateRuch' ] );
		
		
	}
	
	public function getProducts(){
		global $globKurier;
		
		$products = $globKurier->product()->get( $_POST[ 'data' ] );
		
		die( json_encode( $products ) );
	}
	
	public function getProductAddons(){
		global $globKurier;
		
		$addons = $globKurier->addons()->productAddons( $_POST[ 'data' ] );
		
		die( json_encode( $addons ) );
	}
	
	public function getProductAddonFields(){
		global $globKurier;
		
		$addons = $globKurier->addons()->getAddonExtraFields( $_POST[ 'data' ] );
		
		die( json_encode( $addons ) );
	}
	
	public function getPickupTimeRanges(){
		global $globKurier;
		
		$pickupTimeRanges = $globKurier->order()->pickupTimeRanges( $_POST[ 'data' ] );
		
		die( json_encode( $pickupTimeRanges ) );
	}
	
	public function getFirstPickupDay(){
		global $globKurier;
		
		$day = $globKurier->order()->getFirstPickupDay( $_POST[ 'data' ] );
		
		die( json_encode( $day ) );
	}
	
	public function getPrice(){
		global $globKurier;
		
		$price = $globKurier->order()->price( $_POST[ 'data' ] );
		
		die( json_encode( $price ) );
	}
	
	public function getPayments(){
		global $globKurier;
		
		$price = $globKurier->order()->payments( $_POST[ 'data' ] );
		
		die( json_encode( $price ) );
	}
	
	public function getCustomRequiredFields(){
		global $globKurier;
		
		$customFields = $globKurier->customRequiredFields()->get( $_POST[ 'data' ] );
		
		die( json_encode( $customFields ) );
	}
	
	public function order(){
		global $globKurier;
		
		$order = $globKurier->order()->orderShipment( $_POST[ 'data' ] );
		
		die( json_encode( $order ) );
	}
	
	public function getCurrentStatus(){
		global $globKurier;
		
		$status = $globKurier->order()->getCurrentStatus( $_POST[ 'data' ] );
		
		die( json_encode( $status ) );
	}
	
	public function getPerson(){
		global $globKurier;
		
		$status = $globKurier->user()->addressBook( [
			'type'   => htmlentities( $_GET[ 'type' ] ?? '' ),
			'filter' => htmlentities( $_GET[ 'q' ] ?? '' )
		] );
		
		die( json_encode( $status ) );
	}
	
	public function addPersonToAddressBook(){
		global $globKurier;
		
		$status = $globKurier->user()->addToAddresBook( $_POST[ 'data' ] );
		
		die( json_encode( $status ) );
	}
	
	public function updatePersonToAddressBook(){
		global $globKurier;
		
		$status = $globKurier->user()->updateToAddresBook( $_POST[ 'data' ] );
		
		die( json_encode( $status ) );
	}
	
	public function getTracking(){
		global $globKurier;
		
		$status = $globKurier->documents()->tracking( $_POST[ 'data' ] );
		
		die( json_encode( $status ) );
	}
	
	public function getLabels(){
		global $globKurier;
		
		$status = $globKurier->documents()->labels( $_POST[ 'data' ] );
		
		die( json_encode( $status ) );
	}
	
	public function getProtocols(){
		global $globKurier;
		
		$status = $globKurier->documents()->protocols( $_POST[ 'data' ] );
		
		die( json_encode( $status ) );
	}
	
	public function globkurierGetOrders(){
		global $globKurier;
		
		$status = $globKurier->documents()->get( $_REQUEST );
		
		die( json_encode( $status ) );
	}
	
	public function globkurierUpdateInpost(  ){
		global $globKurier;
		
		$globKurier->inpost()->update();
		wp_die('ok');
	}
	
	public function globkurierUpdateRuch(  ){
		global $globKurier;
		
		$globKurier->ruch()->update();
		wp_die('ok');
	}
	
}