<?php
/**
 * @link              https://wp-opieka.pl/
 * @since             1.7.8
 * @package           wp_opieka_globkurier
 *
 * @wordpress-plugin
 * Plugin Name:       GLOBKURIER - WP OPIEKA
 * Description:       Integracja WOOCOMMERCE z GLOB KURIER
 * Version:           1.7.8
 * Author:            WP OPIEKA
 * Author URI:        https://wp-opieka.pl/
 * License:
 * License URI:
 * Requires PHP:      7.0.0
 * Text Domain: globkurier
 * Domain Path: wp_globkurier_languages
 */

namespace wp_opieka_globkurier;

if( ! defined( 'WPINC' ) ){
	die;
}

class WPOPIEKAGLOBKURIER_INIT{
	
	public static function getHelperDir(){
		
		return UDI_HELPER_GLOBKURIER_DIR;
	}
	
	public static function getPluginName(){
		
		return WP_GLOBKURIER_NAME;
	}
	
	public function __construct(){
		$pluginConstPrefix    = 'WPGLOBKURIER';
		$directoryConstPrefix = 'wp_globkurier_';
		
		define( 'WP_GLOBKURIER_DIRECTORY_PREFIX', $directoryConstPrefix );
		define( 'WP_GLOBKURIER_NAME', 'wp-opieka-globkurier' );
		define( 'WP_GLOBKURIER_TEXTDOMAIN', 'globkurier' );
		
		define( 'UDI_HELPER_GLOBKURIER_DIR', plugin_dir_path( __FILE__ ) . WP_GLOBKURIER_DIRECTORY_PREFIX . 'includes/class-udi-helper.php' );
		
		define( 'WP_GLOBKURIER_VERSION', '1.7.8' );
		
		global $wpdb;
		define( 'WP_GLOBKURIER_DB_PREFIX', $wpdb->prefix . 'globkurier_' );
		
		register_activation_hook( __FILE__, [ $this, 'activate_udi' ] );
		register_deactivation_hook( __FILE__, [ $this, 'deactivate_udi' ] );
		
		require plugin_dir_path( __FILE__ ) . WP_GLOBKURIER_DIRECTORY_PREFIX . 'includes/class-udi.php';
		require plugin_dir_path( __FILE__ ) . 'wp-autoupdate.php';
		
		add_action( 'init', [ $this, 'load_plugin_textdomain' ] );
		add_action( 'init', [ $this, 'udi_ch_activate_au' ] );
		
		$timestamp = wp_next_scheduled( 'updateInpostPoints' );
		wp_unschedule_event( $timestamp, 'updateInpostPoints' );
	
		$timestamp2 = wp_next_scheduled( 'updateInpostPoints2' );
		wp_unschedule_event( $timestamp2, 'updateInpostPoints2' );
		
		add_filter( 'plugin_row_meta', [ $this, 'prefix_append_support_and_faq_links' ], 10, 4 );
		
		$plugin = new Udi_plugin();
		$plugin->run();
	}
	
	function prefix_append_support_and_faq_links( $links_array, $plugin_file_name, $plugin_data, $status ){
		
		global $globKurier;
		
		if( strpos( $plugin_file_name, basename( __FILE__ ) ) ){
			$links_array[] = '<a href="' . $globKurier->getSettingsUrl() . '">' . __( 'Ustawienia', 'globkurier' ) . '</a>';
		}
		
		return $links_array;
	}
	
	public function activate_udi(){
		
		require_once Udi_Helper::getInlcudesPath( 'class-udi-activator.php' );
		Udi_Activator::activate();
	}
	
	public function deactivate_udi(){
		
		require_once Udi_Helper::getInlcudesPath( 'class-udi-deactivator.php' );
		Udi_Deactivator::deactivate();
	}
	
	public function uninstall_udi(){
		require_once Udi_Helper::getInlcudesPath( 'class-udi-uninstaller.php' );
		Udi_Uninstaller::uninstall();
	}
	
	public function load_plugin_textdomain(){
		load_plugin_textdomain( WP_GLOBKURIER_TEXTDOMAIN, FALSE, WP_GLOBKURIER_NAME . '/' . WP_GLOBKURIER_DIRECTORY_PREFIX . 'languages' );
	}
	
	public function udi_ch_activate_au(){
		$wptuts_plugin_current_version = WP_GLOBKURIER_VERSION;
		$wptuts_plugin_remote_path     = 'http://dev.udi.com.pl/plugins/wp-opieka-globkurier/update.php';
		$wptuts_plugin_slug            = plugin_basename( __FILE__ );
		new wp_auto_update ( $wptuts_plugin_current_version, $wptuts_plugin_remote_path, $wptuts_plugin_slug );
	}
	
}

new WPOPIEKAGLOBKURIER_INIT();


