{*
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<style type="text/css">
    [ng\:cloak], [ng-cloak], .ng-cloak {
      display: none !important;
    }
</style>

<div class="panel" ng-app="newParcelApp" ng-controller="mainController">
    <div class="panel-heading">
        <i class="icon-cogs"></i> {l s='Ship parcel with Globkurier' mod='globkurier2'}
        {if $orderId}{l s='Based on order' mod='globkurier2'} #{$orderId|escape:'htmlall':'UTF-8'}{/if}
    </div>

    <div class="bootstrap" ng-cloak ng-show="orderError">
        <div class="alert alert-danger">
            <h4>{l s='We\'ve try to send you request but there was an error' mod='globkurier2'}</h4>
            <ul>
                <li ng-repeat="(key, msg) in orderError"><span ng-bind="key"></span>: <span ng-bind="msg"></span></li>
            </ul>
            <button type="button" class="close" ng-click="orderError = null;">×</button>
        </div>
    </div>

    <div class="bootstrap" ng-cloak ng-show="validationError">
        <div class="alert alert-danger">
            <h4>{l s='There is some validation errors. Please fix them before you can continue' mod='globkurier2'}</h4>
            <span ng-show="validationError.noSenderPhone">{l s='Please provide sender phone number' mod='globkurier2'}</span>
            <span ng-show="validationError.noReceiverPhone">{l s='Please provide receiver phone number' mod='globkurier2'}</span>
            <button type="button" class="close" ng-click="validationError = null;">×</button>
        </div>
    </div>

    <div class="panel-body" ng-cloak ng-show="isProcessing">
        <div class="page-loader" style="text-align: center; font-size: 25px!important; color: #ccc;">
            <i class="icon-cog icon-spin"></i>
        </div>
    </div>
    <div class="panel-body order-placed" ng-cloak ng-show="!isProcessing && orderPlaced">
        <div class="col-lg-12" style="text-align: center;">
            <h2><i class="icon-check" style="font-size: 50px!important; color:#72C279;"></i></h2>
            <h2>{l s='Carrier was succesfully ordered' mod='globkurier2'}</h2>
            <p>{l s='Parcel No' mod='globkurier2'}: <span ng-bind="orderPlaced.gkId"></span></p>
            <button class="btn btn-warning" onclick="location.reload();">{l s='Ship next' mod='globkurier2'}</button>
        </div>
    </div>
    <div class="panel-body" ng-cloak ng-show="!isProcessing && !orderPlaced">
        <div class="col-lg-4">  
            <div class="row"> 
                <div class="col-lg-6" glob-address ng-model="sender" address-title="Nadawca"></div>
                <div class="col-lg-6" glob-address ng-model="receiver" address-title="Odbiorca"></div>
            </div>
            <div class="row" ng-show="terminalCode" style="margin-top: 10px;">
                <div class="col-lg-12">
                    <div class="panel" style="border: 3px dashed rgb(227, 176, 0);">
                        <div class="panel-heading">{l s='Pick point' mod='globkurier2'}</div>
                        <div class="panel-body">
                            {l s='Your client wants to pick parcel in parcel point:' mod='globkurier2'}<br/>
                            [<strong ng-bind="terminalCode"></strong>]
                            <span ng-if="terminalType == 'ruch'">Paczka w RUCHu</span>
                            <span ng-if="terminalType == 'inpost'">Paczkomat InPost</span>
                            <br/><br/>
                            {l s='In this case you will be shown only this services.' mod='globkurier2'}
                            {l s='If you want to get all services anyway, please click button below' mod='globkurier2'}

                            <div class="form-group">
                                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                                padding-top: 7px; text-align: right; width: 34%;">
                                {l s='Show all carriers' mod='globkurier2'}</label>
                                 <div class="col-lg-4">
                                     <span class="switch prestashop-switch fixed-width-lg">
                                        <input name="service_filters" id="service_filters_on" value="1" type="radio">
                                        <label for="service_filters_on" class="radioCheck" ng-click="disableServiceFilters();">
                                            <i class="color_success"></i> {l s='Yes' mod='globkurier2'}
                                        </label>
                                        <input name="service_filters" id="service_filters_off" value="0" checked="checked" type="radio">
                                        <label for="service_filters_off" class="radioCheck" ng-click="enableServiceFilters();">
                                            <i class="color_danger"></i> {l s='No' mod='globkurier2'}
                                        </label>
                                        <a class="slide-button btn"></a>
                                     </span>
                                 </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
          <div 
          class="col-lg-12" 
          glob-services 
          initial-product-symbol="{$config->defaultServiceCode|escape:'htmlall':'UTF-8'}"
          recevicer-address="receiver" 
          sender-address="sender" 
          filter-services="filterServices" 
          picked-product="pickedService"></div>
          <div class="col-lg-12" ng-show="pickedService" glob-service-options service-model="pickedService" ng-model="serviceOptions"></div>
        </div>
        
        <div 
        class="col-lg-4" 
        glob-additional-information 
        ng-model="additionalInfo" 
        recevicer-address="receiver" 
        service-options="serviceOptions" 
        service-model="pickedService"></div>
    </div>
    <div class="panel-footer" style="text-align: center;">
        <button type="submit" class="btn btn-success" style="padding: 12px 40px;" ng-click="send();" ng-hide="orderPlaced" ng-disabled="isProcessing || !pickedService">
            <i class="icon-send" ng-show="!isProcessing"></i>
            <i class="icon-cog icon-spin" ng-show="isProcessing"></i>
            {l s='Send' mod='globkurier2'}
        </button>
    </div>
</div>

<script type="text/javascript">
(function () {
  'use strict';

  angular
    .module('newParcelApp')
    .factory('InitialValues', [InitialValuesFactory])
  ;

  function InitialValuesFactory() {
    return {
        sender : {
            name: '{$config->defaultSenderName|escape:'javascript':'UTF-8'}',
            personName: '{$config->defaultSenderPersonName|escape:'javascript':'UTF-8'}',
            street: '{$config->defaultSenderStreet|escape:'javascript':'UTF-8'}',
            houseNumber: '{$config->defaultSenderHouseNumber|escape:'javascript':'UTF-8'}',
            apartmentNumber: '{$config->defaultSenderApartmentNumber|escape:'javascript':'UTF-8'}',
            postCode: '{$config->defaultSenderPostCode|escape:'javascript':'UTF-8'}',
            city: '{$config->defaultSenderCity|escape:'javascript':'UTF-8'}',
            countryCode: '{$config->defaultCountryCode|escape:'javascript':'UTF-8'}',
            phone: '{$config->defaultSenderPhoneNumber|escape:'javascript':'UTF-8'}',
            email: '{$config->defaultSenderEmail|escape:'javascript':'UTF-8'}',
        },
        {if isset($adress)}
        receiver : {
            personName: '{$adress->firstname|escape:'javascript':'UTF-8'} {$adress->lastname|escape:'javascript':'UTF-8'}',
            {if $splitedAddress != null}
            street: '{$splitedAddress.street|escape:'javascript':'UTF-8'}',
            houseNumber: '{$splitedAddress.houseNumber|escape:'javascript':'UTF-8'}',
            apartmentNumber: '{$splitedAddress.apartmentNumber|escape:'javascript':'UTF-8'}',
            {else}
            street: '{$adress->address1|escape:'javascript':'UTF-8'}',
            houseNumber: null,
            apartmentNumber: null,
            {/if}
            postCode: '{$adress->postcode|escape:'javascript':'UTF-8'}',
            city: '{$adress->city|escape:'javascript':'UTF-8'}',
            countryCode: '{$country->iso_code|escape:'javascript':'UTF-8'}',
            phone: '{if $adress->phone}{$adress->phone|escape:'javascript':'UTF-8'}{else}{$adress->phone_mobile|escape:'javascript':'UTF-8'}{/if}',
            email: '{$customer->email|escape:'javascript':'UTF-8'}'
        },
        {else}
        receiver : null,
        {/if}

        defaultPackageInfo : {
            content: '{$config->defaultContent|escape:'javascript':'UTF-8'  }',
            length : {if $config->defaultDepth}{$config->defaultDepth|escape:'javascript':'UTF-8'}{else}null{/if},
            width  : {if $config->defaultWidth}{$config->defaultWidth|escape:'javascript':'UTF-8'}{else}null{/if},
            height : {if $config->defaultHeight}{$config->defaultHeight|escape:'javascript':'UTF-8'}{else}null{/if},
            weight : {if $config->defaultWeight}{$config->defaultWeight|escape:'javascript':'UTF-8'}{else}null{/if},
            count  : 1,
        },

        defaultPaymentType : '{$config->defaultPaymentType|escape:'javascript':'UTF-8'}',
        defaultCodAccount : '{$config->defaultCodAccount|escape:'javascript':'UTF-8'}',
        defaultCodAccountHolderName : '{$config->defaultCodAccountHolderName|escape:'javascript':'UTF-8'}',
        defaultCodAccountHolderAddr1 : '{$config->defaultCodAccountHolderAddr1|escape:'javascript':'UTF-8'}',
        defaultCodAccountHolderAddr2 : '{$config->defaultCodAccountHolderAddr2|escape:'javascript':'UTF-8'}',
        defaultServiceCode : '{$config->defaultServiceCode|escape:'javascript':'UTF-8'}',

        moduleName : 'globkurier2',
        partialsPath : '../modules/globkurier2/views/templates/partials/',
        moduleApiUrl : '{$moduleApiUrl|escape:'javascript':'UTF-8'}',

        login : '{$config->login|escape:'javascript':'UTF-8'}',
        password : '{$config->password|escape:'javascript':'UTF-8'}',
        apiKey : '{$config->apiKey|escape:'javascript':'UTF-8'}',
        token : '{$token|escape:'javascript':'UTF-8'}',
        clientId : '{$globClientId|escape:'javascript':'UTF-8'}',

        todayDate : '{date("Y-m-d")|escape:'javascript':'UTF-8'}',
        terminalCode : {if isset($terminalCode)}'{$terminalCode|escape:'javascript':'UTF-8'}'{else}null{/if},
        terminalType : {if isset($terminalType)}'{$terminalType|escape:'javascript':'UTF-8'}'{else}null{/if},
        defaultInPostPoint : {if $config->defaultInPostPoint}'{$config->defaultInPostPoint|escape:'javascript':'UTF-8'}'{else}null{/if},
        prestaOrderId : '{$orderId|escape:'javascript':'UTF-8'}',
    };
  }
})();
</script>