{*
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<style type="text/css">
    .glob-product-block {
        text-align: center; 
        padding: 10px 10px; 
        height: 200px;
    }

    .glob-product-block:hover {
        background-color: #e1e1e1;
    }
</style>

<form method="post">
<div class="panel" ng-app="configApp" ng-controller="mainController">
    <div class="panel-heading">
        <i class="icon-cogs"></i> {l s='Settings' mod='globkurier2'}
        <span class="panel-heading-action">
            <a id="desc-order-export" class="list-toolbar-btn" target="_blank" href="{$newParcelPageLink|escape:'url':'UTF-8'}&ajax=1&action=getLogs">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="Poberz logi" data-html="true" data-placement="top">
                    <i class="process-icon-export"></i>
                </span>
            </a>
        </span>

    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-lg-5">
                <div class="form-horizontal">
                    <div class="form-group">
                        <label class="col-lg-4 control-label"></label>
                        <label class="col-lg-6 control-label">
                            <p class="text-left">
                                {l s='Default sender address' mod='globkurier2'}
                            </p>
                        </label>
                    </div>
                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Name' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderName" value="{$config->defaultSenderName|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='First and lastname' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderPersonName" value="{$config->defaultSenderPersonName|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Street' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderStreet" value="{$config->defaultSenderStreet|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='House number' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderHouseNumber" value="{$config->defaultSenderHouseNumber|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Local number' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderApartmentNumber" value="{$config->defaultSenderApartmentNumber|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='City' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderCity" value="{$config->defaultSenderCity|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Post code' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderPostCode" value="{$config->defaultSenderPostCode|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Country' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <select class="form-control" name="config_defaultCountryCode">
                            {foreach from=$countries key=k item=country}
                            <option value="{$country.isoCode|escape:'htmlall':'UTF-8'}" {if $config->defaultCountryCode == $country.isoCode}selected="true"{/if}>{$country.name|escape:'htmlall':'UTF-8'}</option>
                            {/foreach}
                            </select>
                        </div>     
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Email' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderEmail" value="{$config->defaultSenderEmail|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Phone no' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultSenderPhoneNumber" value="{$config->defaultSenderPhoneNumber|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-5">
                <div class="form-horizontal">
                    <div class="form-group">
                        <label class="col-lg-4 control-label"></label>
                        <label class="col-lg-6 control-label">
                            <p class="text-left">
                                {l s='Default parcel parameters' mod='globkurier2'}
                            </p>
                        </label>
                    </div>
                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Weight (kg)' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input class="form-control" type="number" name="config_defaultWeight" value="{$config->defaultWeight|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Width' mod='globkurier2'} [cm]</label>
                        <div class="col-lg-6">
                            <input class="form-control" type="number" name="config_defaultWidth" value="{$config->defaultWidth|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Height' mod='globkurier2'} [cm]</label>
                        <div class="col-lg-6">
                            <input class="form-control" type="number" name="config_defaultHeight" value="{$config->defaultHeight|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Depth' mod='globkurier2'} [cm]</label>
                        <div class="col-lg-6">
                            <input class="form-control" type="number" name="config_defaultDepth" value="{$config->defaultDepth|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Content' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultContent" value="{$config->defaultContent|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Carrier' mod='globkurier2'}</label>
                        <label 
                        class="col-lg-6 control-label" 
                        style="text-align: right;" 
                        default-service-selector 
                        init-id="{$config->defaultServiceCode|escape:'htmlall':'UTF-8'}" 
                        init-name="{$config->defaultServiceName|escape:'htmlall':'UTF-8'}" 
                        ng-model="service"></label>
                        <input type="hidden" name="config_defaultServiceCode" value="" />
                        <input type="hidden" name="config_defaultServiceName" value="" />
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Account number for COD purpose' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultCodAccount" value="{$config->defaultCodAccount|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Account holder name' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultCodAccountHolderName" value="{$config->defaultCodAccountHolderName|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Account holder address' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultCodAccountHolderAddr1" value="{$config->defaultCodAccountHolderAddr1|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Account holder post code and city' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <input type="text" name="config_defaultCodAccountHolderAddr2" value="{$config->defaultCodAccountHolderAddr2|escape:'htmlall':'UTF-8'}" />
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-4 control-label">{l s='Payment' mod='globkurier2'}</label>
                        <div class="col-lg-6">
                            <select class="form-control" name="config_defaultPaymentType" value="{$config->defaultPaymentType|escape:'htmlall':'UTF-8'}">
                                <option value="T" {if $config->defaultPaymentType == "T"}selected="selected"{/if}>{l s='Bankwire' mod='globkurier2'}</option>
                                <option value="O" {if $config->defaultPaymentType == "O"}selected="selected"{/if}>{l s='Online transfer' mod='globkurier2'}</option>
                                <option value="P" {if $config->defaultPaymentType == "P"}selected="selected"{/if}>{l s='Prepaid' mod='globkurier2'}</option>
                                <option value="D" {if $config->defaultPaymentType == "D"}selected="selected"{/if}>{l s='Delayed payment' mod='globkurier2'}</option>
                            </select>
                        </div>     
                    </div>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top: 50px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="text-align: right;margin-bottom: 0;padding-top:7px; width: 34%;">
                {l s='Google Maps API' mod='globkurier2'}</label>
                 <div class="col-lg-4">    
                    <input type="text" name="config_googleMapsApiKey" value="{html_entity_decode($config->googleMapsApiKey|escape:'htmlall':'UTF-8')}" />
                 </div>
            </div>
        </div>
        <div class="row form-group text-center" style="margin-top:10px">
            <button type="button" ng-click="updateCacheWithPickupPoints('{html_entity_decode($getCachePointsLink|escape:'htmlall':'UTF-8')}')" class="btn btn-primary">
            {l s='Cache points for whole country' mod='globkurier2'}</button>
          <span ng-if="isAjaxCacheLoad"><i class="icon-cog icon-spin"></i></span>
        </div>        

        <div class="row" style="margin-top: 50px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                {l s='Enable inPost carrier' mod='globkurier2'}</label>
                 <div class="col-lg-4"> 
                     <span class="switch prestashop-switch fixed-width-lg">
                        <input name="config_inPostEnabled" id="ps_layered_filter_price_rounding_on" value="1" {if $config->inPostEnabled == 1}checked="checked"{/if} type="radio">
                        <label for="ps_layered_filter_price_rounding_on" class="radioCheck">
                            <i class="color_success"></i> {l s='Yes' mod='globkurier2'}
                        </label>
                        <input name="config_inPostEnabled" id="ps_layered_filter_price_rounding_off" value="0" {if $config->inPostEnabled == 0}checked="checked"{/if} type="radio">
                        <label for="ps_layered_filter_price_rounding_off" class="radioCheck">
                            <i class="color_danger"></i> {l s='No' mod='globkurier2'}
                        </label>
                        <a class="slide-button btn"></a>
                     </span>
                 </div>
            </div>
        </div>
        <div class="row" style="margin-top: 20px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                {l s='Select inPost carrier' mod='globkurier2'}</label>
                <div class="col-lg-4">
                    <select class="form-control" name="config_inPostCarrier" value="{$config->inPostCarrier|escape:'htmlall':'UTF-8'}">
                        <option value="0">-- Brak --</option>
                        {foreach from=$carriers item=carrier}
                        <option value="{$carrier['id_carrier']|escape:'htmlall':'UTF-8'}" {if $config->inPostCarrier == $carrier['id_carrier']}selected="true"{/if}>{$carrier['name']|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>
                </div>     
            </div>
        </div>

        {* InPostCOD *}
        <div class="row" style="margin-top: 50px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                {l s='Enable inPost COD carrier' mod='globkurier2'}</label>
                 <div class="col-lg-4">
                     <span class="switch prestashop-switch fixed-width-lg">
                        <input name="config_inPostCODEnabled" id="inPostCODEnabled_on" value="1" {if $config->inPostCODEnabled == 1}checked="checked"{/if} type="radio">
                        <label for="inPostCODEnabled_on" class="radioCheck">
                            <i class="color_success"></i> {l s='Yes' mod='globkurier2'}
                        </label>
                        <input name="config_inPostCODEnabled" id="inPostCODEnabled_off" value="0" {if $config->inPostCODEnabled == 0}checked="checked"{/if} type="radio">
                        <label for="inPostCODEnabled_off" class="radioCheck">
                            <i class="color_danger"></i> {l s='No' mod='globkurier2'}
                        </label>
                        <a class="slide-button btn"></a>
                     </span>
                 </div>
            </div>
        </div>
        <div class="row" style="margin-top: 20px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                {l s='Select inPost COD carrier' mod='globkurier2'}</label>
                <div class="col-lg-4">
                    <select class="form-control" name="config_inPostCODCarrier" value="{$config->inPostCODCarrier|escape:'htmlall':'UTF-8'}">
                        <option value="0">-- Brak --</option>
                        {foreach from=$carriers item=carrier}
                        <option value="{$carrier['id_carrier']|escape:'htmlall':'UTF-8'}" {if $config->inPostCODCarrier == $carrier['id_carrier']}selected="true"{/if}>{$carrier['name']|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>
                </div>     
            </div>
        </div>

        <div class="row" style="margin-top: 20px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                {l s='Provide default inPost sender point code' mod='globkurier2'}</label>
                <div class="col-lg-4">
                    <input type="text" name="config_defaultInPostPoint" value="{$config->defaultInPostPoint|escape:'htmlall':'UTF-8'}" />
                    {*<select class="form-control" name="config_defaultInPostPoint">
                        {foreach from=$terminals key=k item=terminal}
                        <option value="{$terminal.departmentId|escape:'htmlall':'UTF-8'}" {if $config->defaultInPostPoint == $terminal.departmentId}selected="true"{/if}>[{$terminal.departmentId|escape:'htmlall':'UTF-8'}] {$terminal.address|escape:'htmlall':'UTF-8'}, {$terminal.town|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>*}
                </div>     
            </div>
        </div>
        <div class="row hidden" style="margin-top: 60px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                Włącz obsługę odbioru w punkcie GlobBox</label>
                 <div class="col-lg-4">
                     <span class="switch prestashop-switch fixed-width-lg">
                        <input name="config_globboxEnabled" id="1" value="1" 
                        {if $config->globboxEnabled == 1}checked="checked"{/if} type="radio">
                        <label for="1" class="radioCheck">
                            <i class="color_success"></i> Tak
                        </label>
                        <input name="config_globboxEnabled" id="2" value="0" {if $config->globboxEnabled == 0}checked="checked"{/if} type="radio">
                        <label for="2" class="radioCheck">
                            <i class="color_danger"></i> Nie
                        </label>
                        <a class="slide-button btn"></a>
                     </span>
                 </div>
            </div>
        </div>

        {* Paczka w Ruchu *}
        <div class="row" style="margin-top: 50px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                {l s='Enable PaczkaRUCH carrier' mod='globkurier2'}</label>
                 <div class="col-lg-4">
                     <span class="switch prestashop-switch fixed-width-lg">
                        <input name="config_paczkaRuchEnabled" id="config_paczkaRuchEnabled_on" value="1" {if $config->paczkaRuchEnabled == 1}checked="checked"{/if} type="radio">
                        <label for="config_paczkaRuchEnabled_on" class="radioCheck">
                            <i class="color_success"></i> {l s='Yes' mod='globkurier2'}
                        </label>
                        <input name="config_paczkaRuchEnabled" id="config_paczkaRuchEnabled_off" value="0" {if $config->paczkaRuchEnabled == 0}checked="checked"{/if} type="radio">
                        <label for="config_paczkaRuchEnabled_off" class="radioCheck">
                            <i class="color_danger"></i> {l s='No' mod='globkurier2'}
                        </label>
                        <a class="slide-button btn"></a>
                     </span>
                 </div>
            </div>
        </div>
        <div class="row" style="margin-top: 20px;">
            <div class="form-group">
                <label class="col-lg-4 control-label" style="margin-bottom: 0;
                padding-top: 7px; text-align: right; width: 34%;">
                {l s='Select PaczkaRUCH carrier' mod='globkurier2'}</label>
                <div class="col-lg-4">
                    <select class="form-control" name="config_paczkaRuchCarrier" value="{$config->paczkaRuchCarrier|escape:'htmlall':'UTF-8'}">
                        <option value="0">-- Brak --</option>
                        {foreach from=$carriers item=carrier}
                        <option value="{$carrier['id_carrier']|escape:'htmlall':'UTF-8'}" {if $config->paczkaRuchCarrier == $carrier['id_carrier']}selected="true"{/if}>{$carrier['name']|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>
                </div>     
            </div>
        </div>
        {* End of paczka w Ruchu *}
        
    </div>
    <div class="panel-footer">
        <input type="hidden" name="action" value="updateConfig"/>
        <button type="submit" class="btn btn-default pull-right">
            <i class="process-icon-save"></i> {l s='Save' mod='globkurier2'}
        </button>
    </div>
</div>
</form>
{literal}
<div class="modal fade" id="allProducts" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{l s='Select carrier' mod='globkurier2'}</h4>
      </div>
      <div class="modal-body row">
          <div class="col-lg-4 glob-product-block" ng-repeat="product in products | orderBy:price_gross">
            <img ng-if="product.courier_img" ng-src="{{ product.courier_img }}" alt="{{ product.courier }}" /><br/>
            <strong ng-bind="product.courier"></strong><br/>
            <span ng-bind="product.product"></span><br/><br/>
            <strong>{{ product.price_gross }}zł</strong><br/><br/>
            <button class="btn btn-sm btn-success" ng-click="pickProduct(product);" data-dismiss="modal">{l s='Pick' mod='globkurier2'}</button>
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">{l s='Cancel' mod='globkurier2'}</button>
      </div>
    </div>
  </div>
</div>
{/literal}