<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

namespace Globkurier2\TerminalPickup;

class TerminalPickupManager
{
    /**
     * Zwraca obiekt typu 'wybrany terminal' po id koszyka
     * @param  integer $id id koszyka
     * @return obiekt typu 'wybrany terminal' z wszystkimi jego wartościami
     */
    public function getByCartId($id)
    {
        $sql = "SELECT * FROM "._DB_PREFIX_."gk_terminal_pickup WHERE cart_id = ".(int)$id;
        $row = \Db::getInstance()->getRow($sql);

        if (!$row) {
            return false;
        }
        
        return $row;
    }

    /**
     * Dodaje / zmienia rekord z fraza 'ruch' w kolumnie type
     * @param  integer  $cartId     id koszyka
     * @param string    $code       kod terminalu
     * @return boolean              true w przy pomyślnego utworzenia/zmiany
     */
    public function setRuchPickup($cartId, $code)
    {
        return $this->setPickup($cartId, 'ruch', $code);
    }

    /**
     * Dodaje / zmienia rekord z fraza 'inpost' w kolumnie type
     * @param  integer  $cartId     id koszyka
     * @param string    $code       kod paczkomatu
     * @return boolean              true w przy pomyślnego utworzenia/zmiany
     */
    public function setInpostPickup($cartId, $code)
    {
        return $this->setPickup($cartId, 'inpost', $code);
    }

    /**
     * Dodaje / zmienia rekord z fraza 'globbox' w kolumnie type
     * @param  integer  $cartId     id koszyka
     * @param string    $code       kod globbox
     * @return boolean              true w przy pomyślnego utworzenia/zmiany
     */
    public function setGlobboxPickup($cartId, $code)
    {
        return $this->setPickup($cartId, 'globbox', $code);
    }

    public function setPickup($cartId, $service, $code)
    {
        $pickup = $this->getByCartId($cartId);

        $data = array(
            'type' => pSQL($service),
            'code' => pSQL($code)
        );

        $r = false;
        if ($pickup != null) {
            $r = \Db::getInstance()->update('gk_terminal_pickup', $data, 'cart_id = '.(int)$cartId);
        } else {
            $data['cart_id'] = (int)$cartId;
            $r = \Db::getInstance()->insert('gk_terminal_pickup', $data);
        }

        return $r ? true : false;
    }

    /**
     * Usuwa rekord po id koszyka
     * @param  integer $cart_id id koszyka
     * @return boolean          true w przy pomyślnego usunięcia
     */
    public function deletePickup($cartId)
    {
        $sql = "DELETE FROM "._DB_PREFIX_."gk_terminal_pickup WHERE cart_id = ".(int)$cartId;

        $results = \Db::getInstance()->execute($sql);

        if (!$results) {
            return false;
        }
        
        return true;
    }
}
