<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

namespace Globkurier2\Common;

class ModuleTabs
{
    public static $moduleName = 'globkurier2';

    public static function install()
    {
        $parentId = self::add('Globkurier', 'AdminGlobkurier');
        
        self::add(
            'Nadaj przez Globkuriera',
            'AdminGlobkurierPlaceOrder',
            \Tab::getIdFromClassName('AdminParentShipping')
        );

        self::add('Nadaj przez Globkuriera', 'AdminGlobkurierPlaceOrder', $parentId);
        self::add('Historia przesyłek', 'AdminGlobkurierHistory', $parentId);
        self::add('Konfiguracja', 'AdminGlobkurierConfiguration', $parentId);

        return true;
    }

    private static function add($name, $className, $parent = 0)
    {
        // if (\Tab::getIdFromClassName($className)) {
        //     return 0;
        // }

        $tab = new \Tab();
        $tab->active = 1;
        $tab->name = array();

        foreach (\Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = $name;
        }

        $tab->class_name = $className;
        $tab->id_parent = $parent;
        $tab->module = self::$moduleName;
        $tab->add();

        return $tab->id;
    }

    /**
     * Uninstall tabs. There are two times PlaceOrder class, because there are
     * two tabs pointing at it
     * @return boolean
     */
    public static function uninstall()
    {
        $tabs = array(
            'AdminGlobkurierConfiguration',
            'AdminGlobkurierHistory',
            'AdminGlobkurierPlaceOrder',
            'AdminGlobkurierPlaceOrder',
            'AdminGlobkurier',
        );

        foreach ($tabs as $tabName) {
            $tab = \Tab::getInstanceFromClassName($tabName);
            if ($tab) {
                $tab->delete();
            }
        }

        return true;
    }
}
