<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

namespace Globkurier2\Common;

/**
* Configuration class, stored all config in one DB record in JSON
*/
class Config
{

    const CONFIG_COLUMN_NAME = 'wk_globkurier_config';

    /** Poniżej są dane kofiguracyjne, które można wykorzystać w formularzu */
    public $defaultSenderName;
    public $defaultSenderPersonName;
    public $defaultSenderStreet;
    public $defaultSenderHouseNumber;
    public $defaultSenderApartmentNumber;
    public $defaultSenderCity;
    public $defaultSenderPostCode;
    public $defaultCountryCode;
    public $defaultSenderEmail;
    public $defaultSenderPhoneNumber;

    public $defaultWeight;
    public $defaultWidth;
    public $defaultHeight;
    public $defaultDepth;
    public $defaultContent;
    public $defaultServiceCode;
    public $defaultServiceName;
    public $defaultPaymentType;
    public $defaultCodAccount;
    public $defaultCodAccountHolderName;
    public $defaultCodAccountHolderAddr1;
    public $defaultCodAccountHolderAddr2;

    public $inPostEnabled;
    public $inPostCarrier;
    public $inPostCODEnabled;
    public $inPostCODCarrier;
    public $defaultInPostPoint;

    public $paczkaRuchEnabled;
    public $paczkaRuchCarrier;
    
    public $globboxEnabled;

    public $login;
    public $password;
    public $apiKey;
    public $googleMapsApiKey;
    /** --- */
    
    public function __construct($initialLoad = true)
    {
        if ($initialLoad) {
            $this->load();
        }
    }

    /**
     * Purges (removes) current configuration from presta db
     * @return [type] [description]
     */
    public static function purge()
    {
        \Configuration::deleteByName(self::CONFIG_COLUMN_NAME);
    }

    /**
     * Saves current config into DB.
     * @param  boolean $getPostValues if set to true, get post values with 'config_' prefix
     * @return void
     */
    public function update($getPostValues = true)
    {
        if ($getPostValues) {
            $this->assignPostValues();
        }
        $json = \Tools::jsonEncode($this);
        \Configuration::updateValue(self::CONFIG_COLUMN_NAME, $json);
    }

    /**
     * Loads config from DB.
     * @return boolean false if values couldn't been loaded
     */
    public function load()
    {
        $json = \Configuration::get(self::CONFIG_COLUMN_NAME);
        if ($json === false) {
            return false;
        }
        
        $values = \Tools::jsonDecode($json, true);

        if (is_array($values)) {
            foreach ($values as $key => $v) {
                if (property_exists($this, $key)) {
                    $this->$key = $v;
                }
            }
        }

        return true;
    }

    /**
     * Assign post values with prefix 'config_' to class vars.
     * @return void
     */
    private function assignPostValues()
    {
        foreach (array_keys(get_object_vars($this)) as $key) {
            $v = \Tools::getValue('config_'.$key);
            if ($v !== false) {
                $this->$key = $v;
            }
        }
    }
}
