<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class Globkurier2RestinterfaceModuleFrontController extends ModuleFrontController
{
    /** @var boolean token uwierzytelniajacy */
    private $tokenAuth = false;

    /** @var integer numer koszyka uzyskany podczas uwierzytelniania */
    private $id_cart;

    /** @var string sciezka do folderu z modulem */
    public $path;

    /** @var boolean override */
    public $ssl = true;

    private $pathForCachedPoints;

    // @Override
    public function init()
    {
        $this->page_name = 'restinterface';
        $this->path = _MODULE_DIR_ . $this->module->name;
        parent::init();

        $this->authorize();
        $this->pathForCachedPoints = _PS_MODULE_DIR_ . $this->module->name;
    }

    // @Override
    public function postProcess()
    {
        parent::postProcess();

        if ($this->tokenAuth !== true) {
            http_response_code(403); //Forbidden
            exit();
        }

        if (!$method = Tools::getValue('action')) {
            http_response_code(400); //Bad Request
            exit();
        }

        $method = 'displayAjax' . Tools::ucfirst($method);

        if (!method_exists($this, $method)) {
            http_response_code(404); //(method) Not found
            exit();
        }
    }

    /**
     * Zapisuje punkt inpost
     * @return boolean nieistotne
     */
    public function displayAjaxSaveInPostPoint()
    {
        $responseData = array(
            'success' => true,
            'message' => '',
        );

        $point = Tools::getValue('point');
        if (!$point) {
            $responseData = array(
                'success' => false,
                'message' => 'Nie podano punktu odbioru',
            );
        } else {
            $terminalPickup = new Globkurier2\TerminalPickup\TerminalPickupManager();
            $terminalPickup->setInpostPickup($this->id_cart, $point);
        }

        header('Content-Type: application/json');
        echo Tools::jsonEncode($responseData);
        return true;
    }

    /**
     * Zapisuje punkt paczka w ruchu
     * @return boolean nieistotne
     */
    public function displayAjaxSavePaczkaRuchPoint()
    {
        $responseData = array(
            'success' => true,
            'message' => '',
        );

        $point = Tools::getValue('point');
        if (!$point) {
            $responseData = array(
                'success' => false,
                'message' => 'Nie podano punktu odbioru',
            );
        } else {
            $terminalPickup = new Globkurier2\TerminalPickup\TerminalPickupManager();
            $terminalPickup->setRuchPickup($this->id_cart, $point);
        }

        header('Content-Type: application/json');
        echo Tools::jsonEncode($responseData);
        return true;
    }

    /**
     * Usuwa wpis o wyborze punktu inpost
     * @deprecated use displayAjaxDeletePickupPoint instead
     */
    public function displayAjaxDeleteInPostPoint()
    {
        return $this->displayAjaxDeletePickupPoint();
    }

    /**
     * Usuwa wpis o wyborze punktu odbioru
     */
    public function displayAjaxDeletePickupPoint()
    {
        $responseData = array(
            'success' => true,
            'message' => '',
        );

        $terminalPickup = new Globkurier2\TerminalPickup\TerminalPickupManager();
        $terminalPickup->deletePickup($this->id_cart);

        header('Content-Type: application/json');
        echo Tools::jsonEncode($responseData);
        return true;
    }

    public function displayAjaxCachedTerminalPoints()
    {
        $serviceCode = Tools::getValue('serviceCode');
        $fileContent = Tools::file_get_contents($this->pathForCachedPoints.'/'.$serviceCode.'.json');

        if ($fileContent == false) {
            $responseData = array(
                'success' => false,
                'message' => 'Cannot find cached terminals from: '.$this->pathForCachedPoints.'/'.$serviceCode.'.json',
                'data' => array()
            );
        } else {
            $responseData = array(
                'success' => true,
                'message' => '',
                'data' => json_decode($fileContent, true)
            );
        }

        header('Content-Type: application/json');
        echo Tools::jsonEncode($responseData);
        return true;
    }

    /**
     * Sprawdza czy podano dobry token dla danego koszyka. Zabezpiecza przed nieuprawniona
     * modyfikacja nieswojego koszyka
     * @return boolean wartosc, ktora zostala ustawiona w $this->tokenAuth
     */
    private function authorize()
    {
        $token = Tools::getValue('token');
        $id_cart = Tools::getValue('id_cart');

        if (!$token || !$id_cart) {
            $this->tokenAuth = false;
            return false;
        }

        if ($token == Tools::encrypt($id_cart)) {
            $this->tokenAuth = true;
            $this->id_cart = $id_cart;
        } else {
            $this->tokenAuth = false;
        }

        return $this->tokenAuth;
    }
}
