<?php

function ioncube_event_handler($errCode, $aParams) {
    switch ($errCode) {
        case 1: //ION_CORRUPT_FILE 
            $err = 'Plik uszkodzony';
            break;
        case 2: //ION_EXPIRED_FILE          
            $err = 'Plik wygasł';
            break;
        case 3: //ION_NO_PERMISSIONS 
            $err = 'Brak dostępu';
            break;
        case 4: //ION_CLOCK_SKEW 
            $err = 'Przesunięcie czasowe impulsów zegarowych';
            break;
        case 5: //ION_UNTRUSTED_EXTENSION 
            $err = 'Niezaufane rozszerzenie';
            break;
        case 6: //ION_LICENSE_NOT_FOUND 
            $err = 'Nie odnaleziono licencji';
            break;
        case 7: //ION_LICENSE_CORRUPT 
            $err = 'Licencja uszkodzona';
            break;
        case 8: //ION_LICENSE_EXPIRED 
            $err = 'Licencja wygasła';
            break;
        case 9: //ION_LICENSE_PROPERTY_INVALID 
            $err = 'Parametry licencji są błędne';
            break;
        case 10: //ION_LICENSE_HEADER_INVALID 
            $err = 'Nagłówek licencji jest błędny';
            break;
        case 11: //ION_LICENSE_SERVER_INVALID 
            $err = 'Serwer niezgodny z licencją';
            break;
        case 12: //ION_UNAUTH_INCLUDING_FILE 
            $err = 'ION_UNAUTH_INCLUDING_FILE';
            break;
        case 13: //ION_UNAUTH_INCLUDED_FILE 
            $err = 'ION_UNAUTH_INCLUDED_FILE';
            break;
        case 14: //ION_UNAUTH_APPEND_PREPEND_FILE 
            $err = 'ION_UNAUTH_APPEND_PREPEND_FILE';
            break;
        default:
            $err = "Nieznany błąd nr: $errCode";
            break;
    }

    
    $moduleName = 'Websoft_Globkurier';
    $displayName = 'Globkurier';
    $message = sprintf('Moduł "%s" napotkał problem i został wyłączony. Komunikat błędu: "%s". W razie pytań prosimy o kontakt z dostawcą modułu.', $displayName, $err);
    Mage::getModel('adminhtml/session')->addError($message);
    $etcPath = Mage::getBaseDir('etc');
    $xmlPath = sprintf('%s' . DIRECTORY_SEPARATOR . 'modules' . DIRECTORY_SEPARATOR . '%s.xml', $etcPath, $moduleName);
    $xmlFile = file_get_contents($xmlPath);
    $xml = new SimpleXMLElement($xmlFile);
    $xml->modules->$moduleName->active = (string) 'false';
    $xml->addChild('error', $err);
    $xml->modules->$moduleName->error = (string) $err;
    $xml->asXML($xmlPath);
    Mage::app()->cleanCache();
    $backUrl = Mage::helper('adminhtml')->getUrl('*/*/*');
    header(sprintf('Location : %s', $backUrl), true, 302);
    exit();
}

?>
