<?php

class Websoft_Globkurier_IndexController extends Mage_Core_Controller_Front_Action
{
    public function locationsAutocompleteAction(){
        $city = $this->getRequest()->getParam('city','');
        try{
            $response = Mage::getModel('globkurier/globboxApi')->getPointsByCityName($city,true);
        }
        catch(Exception $e){
            $response = array();
        }
        $cities = array();
        foreach($response as $item){
            if(!isset($item['miasto'])) continue;
            $cities[] = $item['miasto'];
        }
        $cities = array_unique($cities);
        header('Content-type: application/json');
        echo json_encode($cities);
        die;
    }

    public function tableAction(){
        $city = $this->getRequest()->getParam('city','');
        $locations = Mage::getModel('globkurier/globboxApi')->getPointsByCityName($city);
        $block = $this->getLayout()->createBlock('core/template')
            ->setTemplate('websoft/globkurier/locations.phtml')
            ->setLocations($locations);

        die($block->toHtml());
    }
}