<?php

class Websoft_Globkurier_Adminhtml_MethodsController extends Mage_Adminhtml_Controller_Action
{

    public function indexAction()
    {
        $this->loadLayout();
        $this->_addContent($this->getLayout()->createBlock('globkurier/adminhtml_methods'));
        $this->renderLayout();
    }

    public function addMethodAction()
    {
        $this->loadLayout();
		$this->_addContent($this->getLayout()->createBlock('globkurier/adminhtml_methods_edit'))
                 ->_addLeft($this->getLayout()->createBlock('globkurier/adminhtml_methods_edit_tabs'));
        $this->renderLayout();
    }

    public function editMethodAction()
    {
        $this->_forward('addMethod');
    }

    public function removeAction()
    {
        $id = $this->getRequest()->getParam('id');


        try {
            $method = Mage::getModel('globkurier/method')->load($id);
            if ($method->getId()) {
                $method->setActive(0);
                $method->save();
            }
        } catch (Exception $e) {
            Mage::getSingleton('adminhtml/session')->addError(Mage::helper('globkurier')->__('Wystąpil błąd: ' . $e->getMessage()));
            return $this->_redirect('*/*/');
        }
        Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('globkurier')->__('Usunięto wybrane metody.'));
        return $this->_redirect('*/*/');
    }

    public function saveAction()
    {
        $id = $this->getRequest()->getParam('id', null);
        $data = $this->getRequest()->getPost();
        $methodModel = Mage::getModel('globkurier/method');

        if ($id) {
            $methodModel->load($id);
        }
        if ($data) {
            try {
                if (empty($data['method'])) {
                    Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('globkurier')->__('Wybierz metodę wysyłki!'));
                    $this->_redirect('*/*/');
                    return;
                }
//                if (isset($_FILES['logo']['name']) and (file_exists($_FILES['logo']['tmp_name']))) {
//
//                    $uploader = new Varien_File_Uploader('logo');
//                    $uploader->setAllowedExtensions(array('jpg', 'jpeg', 'gif', 'png')); // or pdf or anything
//
//
//                    $uploader->setAllowRenameFiles(true);
//
//                    // setAllowRenameFiles(true) -> move your file in a folder the magento way
//                    // setAllowRenameFiles(true) -> move your file directly in the $path folder
//                    $uploader->setFilesDispersion(false);
//
//                    $path = Mage::getBaseDir('media') . DS . 'globkurier' . DS . 'logo' . DS;
//
//                    $result = $uploader->save($path, $_FILES['logo']['name']);
//
//                    $data['logo'] = $result['file'];
//                }
//                elseif(isset($data['logo']['delete']) && $data['logo']['delete'] == 1){
//                    $data['logo'] = '';
//                }
//                else{
//                    unset($data['logo']);
//                }
                $methodModel->setData($data);
                $methods = Mage::getModel('globkurier/webapi')->getMethods();
                if (strpos($data['method'], 'globbox') !== FALSE) {
                    $methodModel->setData('logo', Mage::getBaseUrl('media') . 'globkurier/GlobBoxIco.png');
                } else {
                    foreach ($methods as $method) {
                        if ($method->symbol == $data['method']) {
                            $methodModel->setData('logo', $method->carrier_img);
                            break;
                        }
                    }
                }
                $methods = explode(',', Mage::getStoreConfig('carriers/globkurier/allowed_methods'));

                if (array_search($methodModel->getId(), $methods) === FALSE) {
                    $methods [] = $methodModel->getId();
                    $config = Mage::getModel('core/config');

                    $config->saveConfig('carriers/globkurier/allowed_methods', implode(',', $methods));
                }
				
				if(isset($data['product_ids'])) {
					$productIds = $data['product_ids'];
					$productIds = array_diff($productIds,array('on'));
					$productIds = implode(',',$productIds);
					$productIds = $productIds ? $productIds : '';
					$methodModel->setProducts($productIds);
				}

                $methodModel->save();
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                Mage::throwException($e->getMessage());
            }
            if ($id) {
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('globkurier')->__('Zaktualizowano metodę wysyłki.'));
            } else {
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('globkurier')->__('Dodano nową metodę wysyłki.'));
            }
        }

        $this->_redirect('*/*/');
    }

    public function extrasAction()
    {
        $code = $this->getRequest()->getParam('code');
        if ($code) {
            echo $this->getLayout()->createBlock('globkurier/adminhtml_extras')->setCode($code)->_toHtml();
            die;
        }
    }
	
	public function productsAction() {
		$this->getResponse()->setBody(
			$this->getLayout()->createBlock('globkurier/adminhtml_methods_edit_tab_products')->toHtml()
		);
	}
	
}