<?php

class Websoft_Globkurier_Adminhtml_ConsignController extends Mage_Adminhtml_Controller_Action {

    public function indexAction() {
        $this->loadLayout();
        $this->_addContent($this->getLayout()->createBlock('globkurier/adminhtml_consign'));
        $this->renderLayout();
    }

    public function printLabelAction() {
        $id = $this->getRequest()->getParam('id', false);
        if (!$id) {
            Mage::getSingleton('adminhtml/session')->addError(Mage::helper('globkurier')->__('Brak wybranej przesyłki'));
            $this->_redirect('*/*/');
            return;
        }
        try {
            $order = Mage::getModel('globkurier/orders')->load($id);
            $nrgk = $order->getApiNumber();
            if(strpos($nrgk,"gb_") !== FALSE){
                $nrgb = explode("_",$nrgk);
                $webapi = Mage::getModel('globkurier/globboxApi');
                $pdf = $webapi->getPdf($nrgb);
                $this->_prepareDownloadResponse($pdf['nr_listu'].".pdf",base64_decode($pdf['etykieta']),'application/pdf');
                return;
            }
            else{
                $webapi = Mage::getModel('globkurier/webapi');
                /* @var $webapi Websoft_Globkurier_Model_Webapi */
                $url = $webapi->getLabel($nrgk,true);
                header("Location: ".$url);
            }
            die;
        } catch (Exception $e) {
            Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
        }
        $this->_redirect('*/*/');
    }

    public function globboxPriceAction(){
        $methodId = $this->getRequest()->getParam('method_id', false);
        $cod = $this->getRequest()->getParam('cod', false);

        if(!$methodId) die("{}");

        $method = Mage::getModel('globkurier/method')->load($methodId);

        if(!$method->getId()) die(json_encode(array('error' => Mage::helper('globkurier')->__("Nieprawidłowe ID metody"))));

        $code = $method->getMethod();
        if(strpos($code,'globbox_') === FALSE)  die(json_encode(array('error' => Mage::helper('globkurier')->__("Metoda nie jest metodą globbox!"))));

        $gbMethodId = explode("_",$code);
        if(!$method->isExtra('globbox_cod')){
            $cod = false;
        }
        $price = Mage::getModel('globkurier/GlobboxApi')->getShippingPrice($gbMethodId[1],$cod);

        die(json_encode($price));
    }

    public function portalAction(){
        header("Location: https://www.globkurier.pl/logowanie.html");
        die;
    }
}