<?php

class Websoft_Globkurier_Model_Webapi
{

    const API_ORDER_URL = "http://www.webservices.globkurier.pl/services/order/";
    const API_ORDER_URL_TEST = "http://www.test.webservices.globkurier.pl/services/order/";
    const API_HISTORY_URL = "http://www.webservices.globkurier.pl/services/history_order/";
    const API_HISTORY_URL_TEST = "http://www.test.webservices.globkurier.pl/services/history_order/";
    const API_LABEL_URL = "http://www.webservices.globkurier.pl/services/label/";
    const API_LABEL_URL_TEST = "http://www.test.webservices.globkurier.pl/services/label/";
    const API_METHOD_URL = "http://www.webservices.globkurier.pl/services/product/";
    const API_METHOD_URL_TEST = "http://www.test.webservices.globkurier.pl/services/product/";
    const API_EXTRAS_URL = "http://www.globkurier.pl/producent_dodatki.php?symbol=";
    const API_TRACKING_URL = "http://www.globkurier.pl/zlokalizuj.php?numer=";
    const API_LOGIN_URL_TEST = "http://www.test.webservices.globkurier.pl/services/login/";
    const API_LOGIN_URL = "http://www.webservices.globkurier.pl/services/login/";

    protected $login;
    protected $password;
    protected $apikey;
    protected $ch;
    protected $test;


    public function __construct()
    {
        $helper = Mage::helper('globkurier');
        /* @var $helper Websoft_Globkurier_Helper_Data */
        $this->login = $helper->getConfig('login');
        $this->password = $helper->getConfig('password');
        $this->apikey = $helper->getConfig('apikey');

        $this->test = $helper->getConfig('test');

        $this->ch = curl_init();
        curl_setopt($this->ch, CURLOPT_POST, 1);
        curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($this->ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        if (!$this->test) {
            curl_setopt($this->ch, CURLOPT_USERPWD, "oElmpblADmg:SvCnMrfd");
            curl_setopt($this->ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        }
    }

    public function sendPackage(Mage_Shipping_Model_Shipment_Request $request)
    {
        $globkurier = $this->getPackageMock();
        $helper = Mage::helper('globkurier');
        /* @var $helper Websoft_Globkurier_Helper_Data */
        $helper->log($request->getData());

        $order = $globkurier->addChild('orders')->addChild('order');

        $method = Mage::getModel('globkurier/method')->load($request->getShippingMethod());
        if (!$method->getId()) {
            throw new Exception("Globkurier: Ta metoda przesyłki już nie istnieje!");
        }
        $package = $this->createPackage($request);

        $order->addChild('sent_date', $package['gk_date']);
        $order->addChild('base_service', $method->getMethod());
        $services = $order->addChild('additional_services');
        $extraMethods = $this->getExtras($method->getMethod());
        foreach ($method->getExtra() as $service) {
            $services->addChild('additional_service', $service);
            foreach ($extraMethods as $extra) {
                if ($extra->symbol == $service) {
                    if ($extra->kategoria == "COD") {
                        $order->addChild('cod_amount', $request->getOrderShipment()->getOrder()->getGrandTotal());
                        $order->addChild('cod_account', str_replace(' ', '', $helper->getConfig('cod_account')));
                        if(!isset($order->insurance_amount))
                            $order->addChild('insurance_amount', $request->getOrderShipment()->getOrder()->getGrandTotal());
                    } elseif ($extra->kategoria == "UBEZPIECZENIE") {
                        if(!isset($order->insurance_amount))
                            $order->addChild('insurance_amount', $request->getOrderShipment()->getOrder()->getGrandTotal());
                    }
                }
            }
        }
        $order->addChild('payment_type', $helper->getConfig('payment_type'));
        $order->addChild('content', $request->getOrderShipment()->getOrder()->getIncrementId());

        $order->addChild('length', $package['length']);
        $order->addChild('width', $package['width']);
        $order->addChild('height', $package['height']);
        $order->addChild('weight', $package['weight']);
        $order->addChild('number_of_parcels', 1);

        $sender = $order->addChild('sender');
        $sender->addChild('name', sprintf('%s %s', $request->getShipperContactPersonFirstName(), $request->getShipperContactPersonLastName()));
        $sender->addChild('street', $this->_streetName($request->getShipperAddressStreet()));
        $sender->addChild('house_number', $this->_houseNumber($request->getShipperAddressStreet()));
        $sender->addChild('apartment_number', $this->_flatNumber($request->getShipperAddressStreet()));
        $sender->addChild('postal_code', $request->getShipperAddressPostalCode());
        $sender->addChild('city', $request->getShipperAddressCity());
        $sender->addChild('country', $request->getShipperAddressCountryCode());
        $sender->addChild('contact_person', sprintf('%s %s', $request->getShipperContactPersonFirstName(), $request->getShipperContactPersonLastName()));
        $sender->addChild('phone', $request->getShipperContactPhoneNumber());
        $sender->addChild('email', $request->getShipperEmail());

        $receiver = $order->addChild('receiver');
        $receiver->addChild('name', sprintf('%s %s', $request->getRecipientContactPersonFirstName(), $request->getRecipientContactPersonLastName()));
        $receiver->addChild('street', $this->_streetName($request->getRecipientAddressStreet()));
        $receiver->addChild('house_number', $this->_houseNumber($request->getRecipientAddressStreet()));
        if($this->_flatNumber($request->getRecipientAddressStreet()))
            $receiver->addChild('apartment_number', $this->_flatNumber($request->getRecipientAddressStreet()));
        $receiver->addChild('postal_code', $request->getRecipientAddressPostalCode());
        $receiver->addChild('city', $request->getRecipientAddressCity());
        $receiver->addChild('country', $request->getRecipientAddressCountryCode());
        if($request->getRecipientAddressCountryCode() != 'PL' && !isset($order->declared_value))
            $order->addChild('declared_value', $request->getOrderShipment()->getOrder()->getGrandTotal());
        $receiver->addChild('contact_person', sprintf('%s %s', $request->getRecipientContactPersonFirstName(), $request->getRecipientContactPersonLastName()));
        $receiver->addChild('phone', $request->getRecipientContactPhoneNumber());
        $receiver->addChild('email', $request->getRecipientEmail());

        $data = array('DATA' => $globkurier->asXml());

        $result = $this->call($this->test ? self::API_ORDER_URL_TEST : self::API_ORDER_URL, $data);

        return $result->params->nrgk;
    }

    public function login()
    {
        $data = array(
            'LOGIN' => $this->login,
            'PASSWORD' => $this->password,
            'APIKEY' => $this->apikey
        );

        $result = $this->call($this->test ? self::API_LOGIN_URL_TEST : self::API_LOGIN_URL, $data);

        return $result->userParams;
    }

    public function getLabel($nrgk, $getUrl = false)
    {
        $data = array(
            'LOGIN' => $this->login,
            'PASSWORD' => $this->password,
            'GKNUMBER' => $nrgk
        );

        $result = $this->call($this->test ? self::API_LABEL_URL_TEST : self::API_LABEL_URL, $data);

        return $getUrl ? $result->url : $this->curl_file_get_contents($result->url);
    }

    public function getMethods()
    {
        $data = array(
            'LOGIN' => $this->login,
            'PASSWORD' => $this->password
        );

        $result = $this->call($this->test ? self::API_METHOD_URL_TEST : self::API_METHOD_URL, $data);

        return $result->list->product;
    }

    public function getExtras($method)
    {
        $result = $this->curl_file_get_contents(self::API_EXTRAS_URL . $method);
        try {
            $json = json_decode($result);
            if (isset($json->errors)) {
                $msg = "";
                foreach ($json->errors as $error) {
                    $msg .= $error;
                }
                return false;
            }
            return $json->addons;
        } catch (Exception $e) {
            Mage::log($e);
            Mage::throwException("Globkurier - Błąd podczas pobierania dodatków do przesyłki: " . $e->getMessage());
            throw $e;
        }
    }

    public function getTracking($nrgk)
    {
        $result = $this->curl_file_get_contents(self::API_TRACKING_URL . $nrgk);
        try {
            $json = json_decode($result);
            if (isset($json->error)) {
                throw new Exception($json->error);
            }
            return $json->parcel;
        } catch (Exception $e) {
            Mage::log($e);
            Mage::throwException("Globkurier - Błąd podczas pobierania śledzenia dla $nrgk : " . $e->getMessage());
        }
        return false;
    }

    protected function getPackageMock()
    {
        $globkurier = new SimpleXMLElement('<globkurier></globkurier>');

        $globkurier->addChild('login', $this->login);
        $globkurier->addChild('password', $this->password);
        $globkurier->addChild('apikey', $this->apikey);
        $globkurier->addChild('order_method', 'SAVE');
        $globkurier->addChild('order_source', 'MAGENTO');


        return $globkurier;
    }


    protected function createPackage(Mage_Shipping_Model_Shipment_Request $request)
    {
        $packages = $request->getPackages();
        if (count($packages) > 1) {
            throw new Exception("Globkurier: Naraz można nadać max. jedną przesyłkę!");
        }
        $package = reset($packages);
        $package = array(
            'weight' => $request->getPackageWeight(),
            'height' => $package['params']['height'],
            'width' => $package['params']['width'],
            'length' => $package['params']['length'],
            'gk_date' => $package['params']['gk_date'],
        );

        return $package;
    }

    protected function call($url, array $data)
    {
        curl_setopt($this->ch, CURLOPT_POSTFIELDS, $this->createPostArray($data));
        curl_setopt($this->ch, CURLOPT_URL, $url);
        Mage::helper('globkurier')->log($this->createPostArray($data));
        $data = curl_exec($this->ch);
        Mage::helper('globkurier')->log($data);
        return $this->handleJsonError($data);
    }

    protected function createPostArray(array $data)
    {
        $result = "";
        foreach ($data as $key => $value) {
            $result .= urlencode($key) . "=" . urlencode($value) . "&";
        }
        $result = strlen($result) ? substr($result, 0, strlen($result) - 1) : "";

        return $result;
    }

    protected function curl_file_get_contents($url)
    {
        curl_setopt($this->ch, CURLOPT_POST, 0);
        curl_setopt($this->ch, CURLOPT_URL, $url);
        $response = curl_exec($this->ch);
        curl_setopt($this->ch, CURLOPT_POST, 1);

        return $response;
    }

    protected function handleJsonError($data)
    {
        $output = json_decode($data);
        if (!is_object($output)) {
            Mage::throwException("Globkurier nieznany błąd podczas zamawiania paczki - API zwróciło: <br/>" . $data);
        }
        if (!$output->status) {
            Mage::throwException("Globkurier błąd: " . $output->error);
            return false;
        }
        return $output;
    }
    protected function _houseNumber($address) {
        $array = explode('/', $address);
        if (count($array) > 1) {
            $temp1 = $array[count($array)-2];
            $result = explode(' ',$temp1);
            return trim(end($result));
        }
        $array = explode(' m.', $address);
        if (count($array) > 1) {
            $temp1 = $array[count($array)-2];
            $result = explode(' ',$temp1);
            return trim(end($result));
        }
        $array = explode(' ', $address);
        if (count($array) > 1) {
            return trim(end($array));
        }
        return null;
    }

    protected function _flatNumber($address) {
        $array = explode('/', $address); //bieremy to co za '/'
        if (count($array) > 1) {
            return trim(end($array));
        }
        $array = explode(' m.', $address); //bierzemy to co za 'm.'
        if (count($array) > 1) {
            return trim(end($array));
        }
        return null;
    }

    public function _streetName($address) {
        $result = '';
        $array = explode('/', $address);
        $matches = array();
        if (count($array) == 1) {
            $array = explode('m.', $address);
        }
        if (count($array) > 0) {
            $temp = explode(' ', $array[0]);
            for ($i = 0; $i < count($temp)-1; $i++) {
                if (trim($temp[$i]) == 'ul.' || trim($temp[$i]) == 'al.' || trim($temp[$i]) == 'pl.') {
                    $result = '';
                } else {
                    $result .= ' ' . $temp[$i];
                }
            }
            if(preg_match('#(\d+)$#', $array[0], $matches)){
                return substr($array[0],0,-strlen($matches[1]));
            }
            elseif(empty($result)){
                return trim($array[0]);
            }
            return trim($result);
        }
        return null;
    }

}