<?php

/**
 * Zwraca dostępne opcje przesyłek
 *
 */
class Websoft_Globkurier_Model_Services {
    protected $services;
    protected $api;

    public function __construct() {
        $this->api = Mage::getModel('globkurier/webapi');
        $this->services = $this->api->getMethods();
    }

    public function getServices(){
        return $this->services;
    }

    public function getService($symbol){
        foreach($this->getServices() as $service){
            if($service['symbol'] == $symbol){
                return $service;
            }
        }
        return false;
    }
    public function toOptionArray() {
        $methods = array();
        foreach ($this->getServices() as  $service) {
            $methods[] = array('value' => $service['symbol'], 'label' => $service['courier']." - ".$service['symbol']);
        }

        return $methods;
    }
}
