<?php
    class Websoft_Globkurier_Model_Observer {
        const FLAG_SHOW_CONFIG = 'showConfig';
        const FLAG_SHOW_CONFIG_FORMAT = 'showConfigFormat';     

        private $request;

        public function checkLogin(){
            //admin_system_config_changed_section_carriers
            $userData = Mage::getModel('globkurier/webapi')->login();

            if(!$userData || !$userData->numer_klienta){
                Mage::getSingleton('adminhtml/session')->addError(Mage::helper('globkurier')->__('Nieprawidłowe dane logowania. Proszę sprawdzić poprawność danych.'));
            }
            else{
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('globkurier')->__('Globkurier: Poprawne dane logowania. Nr klienta: '.$userData->numer_klienta));
                $configCod = Mage::helper('globkurier')->getConfig('cod_account');
                $config = Mage::getModel('core/config');

                $config->saveConfig('carriers/globkurier/customer_id',$userData->numer_klienta);
                if(!$configCod && $userData->nrkonta){
                    $config->saveConfig('carriers/globkurier/cod_account',$userData->nrkonta);
                    Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('globkurier')->__('Globkurier: Pobrano numer konta z ustawień użytkownika.'));
                }
            }
        }

        public function checkBlock($observer) {
            if(get_class($observer->getBlock()) === 'Mage_Adminhtml_Block_Sales_Order_Shipment_Packaging'){
                $a = explode('_', $observer->getBlock()->getShipment()->getOrder()->getShippingMethod());
                if($a[0] === 'globkurier'){
                    $observer->getBlock()->setTemplate('websoft/globkurier/popup.phtml');
                }
            }
        }

        private function setHeader() {
            $format = isset($this->request->{self::FLAG_SHOW_CONFIG_FORMAT}) ? 
            $this->request->{self::FLAG_SHOW_CONFIG_FORMAT} : 'xml';                                
            switch($format){
                case 'text':
                    header("Content-Type: text/plain");
                    break;
                default:
                    header("Content-Type: text/xml");
            }           
        }

        private function outputConfig() {            
            die(Mage::app()->getConfig()->getNode()->asXML());      
        }

        public function changeOnePageView($observer) {
            if (Mage::helper('globkurier')->getConfig('logo')) {
                $block = $observer->getBlock();
                switch(get_class($block)){
                    case 'Mage_Checkout_Block_Onepage_Shipping_Method_Available':
                        /* @var $block Mage_Checkout_Block_Onepage_Shipping_Method_Available */
                        $block->setTemplate('websoft/globkurier/available.phtml');
                        break;
                    case 'Mage_Checkout_Block_Cart_Shipping':
                        $block->setTemplate('websoft/globkurier/shipping.phtml');
                        break;
                }
            }
        }
    }