<?php

/**
 * Zwraca dostępne opcje przesyłek
 *
 * @author smeagol
 */
class Websoft_Globkurier_Model_Methods
{
    protected $methods = array();
    protected $webapi = null;

    public function __construct()
    {
        $this->webapi = Mage::getModel('globkurier/webapi');
        $this->methods [] = array('value' => false, 'label' => '');

        try {
            //globbox
            foreach (Mage::getModel('globkurier/globboxApi')->getProducts() as $id => $product) {
                $this->methods [] = array(
                    'label' => "Globbox: " . $product,
                    'value' => 'globbox_' . $id,
                    'logo' => Mage::getBaseUrl('media').'globkurier/GlobBoxIco.png'
                );
            }

        } catch (Exception $e) {
            //throw $e;
			Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
        }
		
		try {
			//globkurier
            foreach ($this->webapi->getMethods() as $method) {
                $this->methods[$method->symbol] = array(
                    'label' => $method->carrier. ": ". $method->name,
                    'value' => $method->symbol,
                    'logo' => $method->carrier_img
                );
            }
			Mage::log($this->methods,null,'methods.log',true);
		} catch (Exception $e) {
            //throw $e;
			Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
        }

    }

    public function toOptionArray()
    {
        return $this->methods;
    }

    public function getApi()
    {
        return $this->webapi;
    }

    public function getService($value)
    {
        foreach ($this->getServices() as $service) {
            if ($service['symbol'] == $value) {
                return $service;
            }
        }
        return false;
    }
}

