<?php

class Websoft_Globkurier_Model_Method extends Mage_Core_Model_Abstract {
    public function _construct() {
        parent::_construct();
        $this->_init('globkurier/method');
    }

    public function toOptionArray() {
        $methods = array();
        $collection = $this->getCollection();
        foreach ($collection as $method) {
            if(!$method->getActive()) continue;
            $methods[] = array('value' => $method->getId(), 'label' => $method->getName());
        }

        return $methods;
    }

    public function getAllMethods() {
        $methods = array();
        foreach ($this->getCollection() as $method) {
            if(!$method->getActive()) continue;
            $methods[$method->getId()] = $method->getName();
        }
        return $methods;
    }

    public function filterInput($item){
    	if(empty($item)) return false;
    	if(strpos($item,' ') !== FALSE) return false;
    	return true;

    }

    public function isExtra($code){
        foreach($this->getExtra() as $extra){
            if($extra == $code) return true;
        }
        return false;
    }

    protected function _beforeSave() {
        parent::_beforeSave();
        $extra = $this->getExtra();
        $countries  = $this->getCountries();

        if(!is_array($extra)) $extra = array();
        if(!is_array($countries)) $countries = array();

        $extra = array_filter($extra,array($this,'filterInput'));

        $this->setExtra(json_encode($extra));
        $this->setCountries(implode(',',$countries));
    }

    public function _afterLoad() {
        parent::_afterLoad();
        $this->setExtra((array)json_decode($this->getExtra()));
        $this->setCountries(explode(',',$this->getCountries()));
    }

//    public function getLogo($withUrl = true){
//        if(!$withUrl){
//            return parent::getLogo();
//        }
//        return Mage::getBaseUrl('media').'globkurier/logo/'.parent::getLogo();
//    }

}
