<?php

class Websoft_Globkurier_Model_GlobboxApi extends SoapClient
{
    const API_URL = "http://www.services.globbox.net/soap?wsdl";
    const API_URL_TEST = "http://www.test.services.globbox.net/soap?wsdl";

    const PAYMENT_PREPAID = 1;
    const PAYMENT_DELAYED = 2;

    public $apikey;
    public $ch;

    public function __construct()
    {
        $helper = Mage::helper('globkurier');
        /* @var $helper Websoft_Globkurier_Helper_Data */
        $this->apikey = $helper->getConfig('apikey');

        $this->test = $helper->getConfig('test');
        parent::SoapClient($this->test ? self::API_URL_TEST : self::API_URL, array('trace' => 1));
        $this->ch = curl_init();
        curl_setopt($this->ch, CURLOPT_POST, 0);
        curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($this->ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
    }

    public function getProducts()
    {
        return $this->handleErrors(parent::getProducts($this->apikey));
    }

    public function getLocations($postcode)
    {
        return $this->handleErrors(parent::getLocations(trim($postcode), $this->apikey));
    }

    public function getPointsByCityName($city, $autocomplete = false)
    {
        if ($autocomplete == false) {
            curl_setopt($this->ch, CURLOPT_URL, "http://www.globbox.net/ajax/terminale/zipCode/0/cityName/" . $city);
            return json_decode(curl_exec($this->ch), true);
        } else {
            return $this->handleErrors(parent::getPointsByCityName(trim($city), true, $this->apikey));
        }
    }

    public function getPdf($nrgb)
    {
        return $this->handleErrors(parent::getPdf(is_array($nrgb)? $nrgb[1] : $nrgb, $this->apikey));
    }

    public function saveOrder(Mage_Shipping_Model_Shipment_Request $request)
    {
        $order = $request->getOrderShipment()->getOrder();
        $method = Mage::getModel('globkurier/method')->load($request->getShippingMethod());

        if (!$method->getId()) {
            throw new Exception("Globkurier: Ta metoda przesyłki już nie istnieje!");
        }

        $danePrzesylki = $this->preparePackage($request, $method);

        if ($request->getRecipientAddressCountryCode() == "PL") {
            $point = Mage::getModel('globkurier/point')->load($order->getId(), 'order_id');
            if (!$point->getId() && $order->getRelationParentId()) {
                $point = Mage::getModel('globkurier/point')->load($order->getRelationParentId(), 'order_id');
            }

            $danePunktu = array(
                'nazwa' => sprintf('%s %s', $request->getRecipientContactPersonFirstName(), $request->getRecipientContactPersonLastName()),
                'tel' => $request->getRecipientContactPhoneNumber(),
                'mail' => $request->getRecipientEmail() ? $request->getRecipientEmail() : $request->getOrderShipment()->getOrder()->getCustomerEmail(),
                'partner' => $point->getPoint()
            );

            return $this->handleErrors(parent::saveOrder($danePrzesylki, null, $danePunktu, $this->apikey));
        }
        else{
            $odbiorca = array(
                'nazwa' => $request->getRecipientContactPersonName(),
                'tel' => $request->getRecipientContactPhoneNumber(),
                'mail' => $request->getRecipientEmail() ? $request->getRecipientEmail() : $request->getOrderShipment()->getOrder()->getCustomerEmail(),
                'ulica' => $this->_streetName($request->getRecipientAddressStreet()),
                'nrdom' => $this->_houseNumber($request->getRecipientAddressStreet()),
                'miasto' => $request->getRecipientAddressCity(),
                'kodpoczt' => $this->_getPostCode($request->getRecipientAddressPostalCode()),
                'kraj' => $request->getRecipientAddressCountryCode()
            );
            if($this->_flatNumber($request->getRecipientAddressStreet())){
                $odbiorca['nrlokal'] = $this->_flatNumber($request->getRecipientAddressStreet());
            }
        }

        return $this->handleErrors(parent::saveOrder($danePrzesylki, $odbiorca, null, $this->apikey));
    }

    public function getShippingPrice($methodId, $cod, $count = 1)
    {
        $danePrzesylki = array(
            'produkt' => $methodId,
            'ilosc' => $count,
            'zawartosc' => '1',
            'platnosc' => 2
        );
        if ($cod) {
            $danePrzesylki['pobranie'] = $cod;
            $danePrzesylki['ubezpieczenie'] = $cod;
        }
        return $this->handleErrors(parent::getShippingPrice($this->apikey, $danePrzesylki));
    }

    public function handleErrors($response)
    {
        if ($response['code'] == "ok") return $response['data'];

        Mage::helper('globkurier')->log($response);

        $message = "Globkurier(Globbox): " . $response['msg'];
        if (isset($response['data']) && is_array($response['data'])) {
            foreach ($response['data'] as $error) {
                if ($error['code'] == "error") {
                    $message .= "  " . $error['msg'];
                }
            }
        }
        Mage::throwException($message, 'adminhtml/session');
    }

    protected function preparePackage(Mage_Shipping_Model_Shipment_Request $request, Websoft_Globkurier_Model_Method $method)
    {
        $product = explode('_', $method->getMethod()); // globbox_ID

        $packages = $request->getPackages();
        $package = reset($packages);
        $danePrzesylki = array(
            'produkt' => $product[1],
            'ilosc' => count($request->getPackages()),
            'zawartosc' => $request->getOrderShipment()->getOrder()->getIncrementId(),
            'platnosc' => Mage::helper('globkurier')->getConfig('payment_type_globbox'),
            'wartosc_celna' => $request->getOrderShipment()->getOrder()->getGrandTotal(),
            'waga' => $request->getPackageWeight(),
            'wysokosc' => $package['params']['height'],
            'dlugosc' => $package['params']['width'],
            'szerokosc' => $package['params']['length']
        );

        if ($method->isExtra('globbox_cod')) {
            $danePrzesylki['pobranie'] = $request->getOrderShipment()->getOrder()->getGrandTotal();
            $danePrzesylki['ubezpieczenie'] = $request->getOrderShipment()->getOrder()->getGrandTotal();
        }
        if ($method->isExtra('globbox_insurance')) {
            $danePrzesylki['ubezpieczenie'] = $request->getOrderShipment()->getOrder()->getGrandTotal();
        }

        return $danePrzesylki;
    }

    protected function _getPostCode($code) {
        $result = '';

        for ($i = 0; $i < strlen($code); $i++) {
            if (is_numeric($code[$i])) {
                $result .= $code[$i];
            }
            if (strlen($result) == 5) {
                break;
            }
        }
        return $result;
    }

    protected function _houseNumber($address) {
        $array = explode('/', $address);
        if (count($array) > 1) {
            $temp1 = $array[count($array)-2];
            $result = explode(' ',$temp1);
            return trim(end($result));
        }
        $array = explode(' m.', $address);
        if (count($array) > 1) {
            $temp1 = $array[count($array)-2];
            $result = explode(' ',$temp1);
            return trim(end($result));
        }
        $array = explode(' ', $address);
        if (count($array) > 1) {
            return trim(end($array));
        }
        return null;
    }

    protected function _flatNumber($address) {
        $array = explode('/', $address); //bieremy to co za '/'
        if (count($array) > 1) {
            return trim(end($array));
        }
        $array = explode(' m.', $address); //bierzemy to co za 'm.'
        if (count($array) > 1) {
            return trim(end($array));
        }
        return null;
    }

    protected function _streetName($address) {
        $result = '';
        $array = explode('/', $address);
        if (count($array) == 1) {
            $array = explode('m.', $address);
        }
        if (count($array) > 0) {
            $temp = explode(' ', $array[0]);
            for ($i = 0; $i < count($temp)-1; $i++) {
                if (trim($temp[$i]) == 'ul.' || trim($temp[$i]) == 'al.' || trim($temp[$i]) == 'pl.') {
                    $result = '';
                } else {
                    $result .= ' ' . $temp[$i];
                }
            }
            $result = trim($result);
            preg_match('#(\d+)$#', $result, $matches);
            if(isset($result[1][1])){
                $result = substr($result,0,$result[1][1]);
            }
            return $result;
        }
        return null;
    }
}