<?php

/**
 * Our test shipping method module adapter
 */
class Websoft_Globkurier_Model_Carrier_Globkurier extends Mage_Shipping_Model_Carrier_Abstract
{

    /**
     * unique internal shipping method identifier
     *
     * @var string [a-z0-9_]
     */
    protected $_code = 'globkurier';

    /**
     * Rate request data
     *
     * @var Mage_Shipping_Model_Rate_Request|null
     */
    protected $_rates = null;


    static $dummyLabel = "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613ci4/tVAcfcD1TiITjE+GEUbqCNlbRFRez+gEt9WicA5ZV1bJREQCiUDOEVI1m7d53sbG1IJSwIQPBLFnHyAxEOd+xU+T14cX817A7CPUIt1z7zt9fZCMtRE0+s151LNYV8nfTtez31vz/Bae0gc9zJs3CPUFi6Vmodw1EkPRxVH336Df1wN8EYdQxlRVVZ6hf1Q9/Q8uN/ph+odFluestw15Strl7Gqcw3K892Phckh6BDxkZQF9RDEQ0yl9X5IWFTeBFI1QjHeIpqNbJmGYURjkH5OshghB15NnM8cDCWIl+lYW1bbUxPHVjbzzXOxaQe1MwkDIQozCUDBf0swMrPHEcEVeZ2tYTWsVPp1GOg8LimJADFwfKieiVgJxpQFhTC494T9CXDdetWEO93XdVphudzr0KIhQbE2P3RteXt+dWNaWU8xwH92vZHxFFfZct7FlLy3183dti3/q3XRsHeswQVVW2Z00gM1wXc0PWWTXd3iXT5mAWbXQnOnJhES6a2QtdTWXH1HXtAkMTPt05vt5TNlRi0PTJhcxk+gpNDiodkJDusnPhMGy9Cazif5dVtZJwUNQJFEJFd1FCxhwmwdTj0P5xAqAVdeV9/189oN9wS4VRtYYufiC2hDRBhPHv2LXDuE0lEITUHMNRIJATyVn8tD99Cp7PLD3Akaedpa3W0Kp2At7X8OQ0dTrHVl4D0hNXdoHoPTDydoRoSrO5/IFEEEyQ9BVHK5i4vYK3BCi4Ie2UQOkFXsST0QMZitb19fLQxdH38E2oM9DndEzNuT1fQycRtRBWDw757WnAc4XMVg6qtQkDWUX5kVkduIESYguIkV5iTHtNIG1QBXY1QVfZSrHfql8ATIUe4ZWg6pyevaKwZurg1kGs38GXRl5wqde9MSWVlUetUa/QVfJVUdMuM2vb8391K8ZD09gV9WPO0Q18EAl0k=3iyRMXfNGAUlTlDlB6YYFWBR2goDPxtuCk4gCjtxVfbdDME7Arc3VFSor6zFTMLbWiDFCFDftKh5mc20HhkGipWTi72FHXUF2F6tRi3p8Jaq0w9IVgQSEtFWnk9wUTJdYSXC27kG1XaSp/HT5dnmHE1R10gU5DCx0cCRYG9Q1LVystiuVUJLQcquV5LSxXcUfNQgVP9csVRFq+hdHnvH+sGxSttmA3VcFdKtbZis3W2a7J9lXHnNLCtwM23pAY91+HQYEMylfOArHVHZQUdZ1VNRsLc/g00N91trWDTIQ4I4hRlcFdfRkN0tEzvTnuEIREAT7Vqq1lGpmN6yTPHX04Tm7eCcDpji3Qcki4JRxSu5W31uVHFAARaRtbOxnWohNUfpHAoxqMniTu109vNRYVEJJSsH+NQBjdiptlBHs7Upz67UVugdxTG6u5wLHWsdvdZgLKQ5bXl1mCO4eswtw9CBaxBOWcFt32w6whzg/ZWHWZsWKs=vQK2ht1mLZBe30FZjULtl4Vk4vMqYlUftlcV91Cm=l3pTFy7AVU9eCtCh5HaQNhiE67a1isPzdXH0Cz0maxExR5PQM0HBn2yx64aHWr1ftFtvax//Yg34K3a7aQmkZAKCl0CQPLtuYsBSBPQncWaiBgl0tQRgW/hSPuYEQZOsNDJacx1D2PrOYWbJW27aEulltR5eanBnG99gK5lpUTNYkIjwQcvQunptagt7UaxwmL1giM6la0FfHMoClkfx7EkHsZYVFBZdsZgZoeQMRAw0jGEMmyiFXFayVA6RBionKDQVUwTlV0sF5A8NdQsSnsOW49Q0Va5iwxEoZFWHd3hKnEFVSkNFsHI00PXRxOaScGQiYzcN0ZpkRZoOI1FvBtoKA6cygOjEiPt1wbBte2IxYOGoWBO1EaAjiEddDREweEgozbXtHKBcRFCKuY4gGXXI0Y3i3AoKQW8aCReORW0zVQ6WLdEcFRpsEpgVI9widRGrHUMUg0ITtmEZmcEClBFpTp2WAYD0VhWk15iVPV9wNTEUzjBQmacd9rEEzWzhX1V/SD9FacFAWBUQE5DVgrYudUgGiAkUlo7Xt8Z9sRyz3tn1sb3G0T3VijnLe2JzGBVfAYLC9U4FjWjEPc2RGfM5FYj3ndaWDQgUQNXbvBHUvbgLbIhsOXvtbI1cF1EMZ5HJ3fH6W9fMx9Pe2dUwbW0rXLJ1NFzpdYCYaaBqUIPAduqN99xC843ESJ9siET1EAni/Wc8604+XAq/TJDlbHWN0qUNnMvdXsaFPdHUsws//QVDUVk/A9awiRfBMZF25iW98+jdLATY1kG5zazU52j8/+hcEScjI5GIPZMt+EFZFn9grdMldQz6w1pm7AmNbTpyytuwNhtiprmA2EwQUDb3sLsToPMzrZ0rpXAf3WRfuAyoIl/uxcPCwU9Pivky+5EH5jiWOl9ae3NCXk+t1cMRXnzHM65T2Jhs6jdZMiZxXHsL+t9IRmwl5kbiZYHk/iCQhfGG33BdjkENDzxZoFHjYx9sax7VQPX9A37cE3iRMRNzVUEF2/8X5e24pNpAEcxEO2rPZHZsS2FoTrEaq3B8fVhcik6tolhQM4TnXN0OZh2YpMs9J1g2DCkyXftQFUMnZ2fJiAdSlnVUHLNUxD=y4RNTYf1UEAxrdfU5HOiYcqempk5SztuVDTWUNciMDJphtR8QYaohIHHimEW9CtWIiWIgGDUgFDM9UlTJLOdjFVmsHLx8E/TN6zWdzjxXhdvfVk5VwdeW3AcjwtbtifRsKx9RSfi8P3B2ctRCQ1Dj8gPm61FZ/F1c0f0LVLp38+KpZEFS+lh5QwwCxsCpXCmPwIDkD1NRRgZEQ95QOuKkabrUK55x2A2RRgl1kmelkW0QQ9wICGBgFVigE0wxmFOmPYQ4lkZRktbRBMQhVhlZuxF+tmkB0N+XQQKAlgrAOxQMNO0cRGAx3d5XlIXdh56bszLBoa4VRjpWBOLgo+1ncbC1o702oLQi6+EZV1sYFwo8kRpX9k9kbsdUFQ/15iwIMNeiCI6gRCUuraecyZ2GxsC1Z609Q1EHZVByV0Pb4V8QzSTZHMYXWNeKSY7c5nGLl6=6EaO14ELljuDO8aEyd/cC1sUW1kVRMileFtQWRq1Hc6mP1tC0E+T4mSkhPBxSJe4U0EOaXrCLW8ZMTY0it3pC1lCyk6BAJ3dUN5GwMbHBeVRsF=28+0NjWW6wMPb49lttRtd+FgIXorzNvux51D8UDamiBVjwmHrthCeFFTgbQG6100HOYe6ggCkESyReIywgKOJ6IX0gexNk/RFEbi0Y0FQ7ZyK1ioIWV6xMTNm3Tx9MnHgYDGCnCyeBqR9UW55wSUbAdDpRBwRta=w+BRvb4e8MQXiO0Itq5Hz8+B0ug6ToaY1kdaREwJzkgRw31jY8EQERoSXAs4ZP1TG2R4BFkGBD02NjyfxpEwNtPxdseCkQPkXkC5aHQMbWR0D60I6BtpvtRdEw5HGJoadbkElM5I1FVJUUnI00KK3dlKx3gsQcFpQHsitWwVoMcx9vXefJyBZS18OOX0jXxzWthUgnBnNKBEInSx4Z1W9tg7phCaRHN413py9x+hymHOgZkwwcXtlG3mQqRh34RoCZalgq00sNMiW6rHMP1gJ1oi7t0Tfj1w1Xn6Q4e3RpCstgG3AoPX7Oy22no7t21qQTX3aDPoqOgrpnNxBF99BVzZgLx/pLeX1PY1hvUMdQTlGwyRJs7QggYSt5VXte5wsdj/XTDVMNjygNw9szhE7RkkRDtUEz5IQoHGEcWoKgYH2tcVIfiBqudZS0J5QSiuOEz1ycRiURRr2skcQmxdRT0QwVYlgYGgLbcbERNsVQvLZ2fmNRGDUYHH0QQYZ3AS4EoC3tb34VAsZxGyQrokOIVJrYUiYUMAM=9M4Ys7HnMYyed9N2peIq6YrDNubzkLKV5wcQSt8gUr8+fu2irYSBgT4kQPq7iMak5LRpvNhsBKjhGEVgQNyTV96eDY4TJeCX73rWoW7Ye55IAp+uRFACxgCWUROk1oxgyLFsgGuNfBZEaHduSAUC9xECtscOUxVjCmR19eOXlVMoGoKBg6WTO+QHw5zAzzkWhoyQDxvP3Bznta2TRhTJED6x/rGhJgKABWxMks2tUXbF+wjVcINTQRCt2AwIpTeHVyfWyYOtdDVe9stdaV8FVAWw/Y2W7b9o5EthpliIHNcNcuemwX5cXN9hHudNcj0ZpFMxpIDsUHlfhMmdhcBFEgQqBI3Cn8EzcKBYxAeiGkZzD6JOtDKX2Q6zBCEgI5iR8IPdO1DBKYGRKVZ/cnd4UI6Bw2wK71lVRBt24VXrwvHYqzMZc8JkzB9NQKnMHEMobU5m96zkd8O3uFXCYeRoWC28Ot29StcHBThV9TXrktw53nVyPWVUxmrM6rdHKnJSN+bI+TsqbVcZH30PTwtvK91wdM6MTly5yh3QQCbNbO2H3EDdHarXt3n39RraWXW6X0FkbYXu/dIi8NxGl9390PGsF3G/JBFiud3itXaRPcF8F3UlUXt5PcDXUMReTfdmGo9Cu4aNRhadMbtAtbgwdBzNYSLRHzh2wK2XFBVFx3EGVl8Dz7UavcGtPbt60jTVDtlMDvJY2m0LaHlZcm62R3eDclOpKx8rQfEaE0YmcDxst0fH97Vee7szsQ4BGnrfn17wdf213ZXT5q7u49bjX6utebQJHJIbP3HZEo8EkPK1J4Uu11kjkt1PNvRD2LaxBpYfPN4VHJ6QqQwfcmpVFvYt8sZDOoTOStWB8fyI1sVwVZzUbWP2V2bZ63tRZnfS1e13dRCruTFMHp1BMeXp7ITLGTsYN4lYFVJPFcE7UW16GsIW3kHAdvrFYWxkExVODm7adxUBdTINPUbdK1tD31HUUKeeliTYPyy3tPlW724qeEHXUb2EgQ5LbzZZSm5Kg0d7znpsW/07TrUPNaWmu83TdgdQtjt7U3oJuwTEFu6tUy0MRiI7/KdbsT5TWVh81UbHP1r=lvpQdxsNynXBeoT6Ojw8Sufab8cHzjmDg1pVejy7tzNvH+6raz11JAk/gR8CUeQUsQRlaDmYYpETD331K3QAMDjM7e7U3fWVf8Jf6YwSvzMUMKEUVvgIDUwFH817TQdR9C1m=zkRltbf2fYVXlaTQguU5alg5Sl9fbgdPTWFVpuMbNQfbFdEtT488dBQntxUNuY7B1FCjQi/S0+2uEY7hq86AonK1TAVQRws6TFN12Z7U189ftwqXQVVU2VDO1MwNlegcRuD9whUVF6aX0dsUFpK2M5JhvnV6YP19+fsrAhqyM6J3iVR0ypy1bX1tSbwfUIwNURiTkT/YKkBqlFiA5fQ8PuFB+YtTr2QgcOM59wfHBLZYcRgX9woT9iISW8PybEbUIQR6QaYjXMUxhRe7hoC41Zi57XAd7sKBqa8lfCMlmpEICdPd6qlLMz1CWUlerQtMnsFbSF908lpwdDUlxwi3KZ1x3E1KwUDEwiS5lRXBFe11BOPNDkkzIl8Nr3ppSgtdW4urUNHSBEiWQWf0bOSJ7KqkLQZ6EX86Ow8+OE27V6pKktiwepYQmCk6IrUCSKgYHh98/Rk8U6XWsONRYdB7BQ/DcGBymwL0VkV5DuczV14BnAxdPwsLXC/dRnOUaDtfoGroNUZ5K4lHAQogw6msPH91UTlJdUMHc7p9z1las1+tZahNM2BmNgKQY2MP80VgX3sOSziJTT22Krz6smEAvsRRrZhcJQ9xsW12FbiGUOtZAXn9x31809+fKtQsaf2GE9eNn2uPs4Li0CW5UTggBybgFVaFV4sliZcVQL2SoemI33BS17SZcFvW/Ax3ULbsUFpstO5Q591A8Wwl+Zj7HkDMO0jddwZOTR8WKt30lkRy9ANIy3ioeDTh+nAFJy9TwW9a11cBmA9mdpCBLlOD00rEJAdEAUsFqacTWW8gKVtEZF35/HomGtpgnU6EBcQQazUQcdQU9fB1/M5ghq5AU/VEjRDiHYWUgY2A9uw5YXucOhQQNTMR0+esUCNEiF7RTFVtUsRsFS1cuQ85EFqTcOxkFa9mpIx7ccwSsWV7YIPYBnk/fTnpDg5MZ2M5oiRT8UFfbW8TCALekY7rdahuUXwMDL8LYZytYrTJDidYUUAwsbCtC4ghWdlSmoKDYsNhsghB7tBtiGUhuLO61sSQpNrd6hNe8wJCO2dL6a37t1gsdM5YnJA4lleGAmpP9MTBqkSNQKUV8adQW09IQw7DQzm99N99VNNeSoMEsMcxFiKx1l9efD0hg3QzsQTu3FDsc1WxhOZt3zBkz6asTaMBhuB91SKw0DYjchHwhWLEfmIX7t9AcbhmPamJihI1dhr3ku3Rgs=0UbXW99bF9HWM2WmdgF7tfaJLYBb0ZxENV28Rf2E97m9wIxtsy+1hzkE1hMVwxbCuJHc662E8tsfXlhAS7YbfkRQ/2h0SJWIzSgXHWNENv0Z7QIS2jpI00AjlOBSRLbNn8RBPnPilnzlb6p18MCYwhT2GS9bVjfrEAGrqT9wMht5+NEweDThV+BffhYuc01aSQmmVkP3ywnf7Fh1HFxO2A1Mac+W4GddMmeWN1VpKt179T64hDNcHBLfk45=gdN59qYTp5H2SxJk4mq9l7zo+LR0D6ziRQVnKDIQe9t9H191Ds5oHCdIWl+x1F0FhqdkVmxXxMGFCIEzed2OV+1KTS4clOBcEbxMFpK0lwUoFETFdMgWX5DaX00/Xw4zW/Zp9jz5hdO+eQXlUYsW7NFE6Bc/cROmEYfzJa2dbWVJSQVxslyQrrdfaVvWMzoILQxqbac0BrHVUL1z93/Mq1twzmnLQEKUZXw9CYG4Ic3pfF/2wiFTUS1BEvpiMOTXH6eXELdiIxG4I3U15y35WLlE9k+QzcutDwcRvbtLtAVkdbjd9IytVCPcD9LSQ56sVthNEdrclQ0NL18lVS1TLHpn1n2c1UeQ8iVFlUiEKRAmV1+h4kG1lvIXF/LW85eQtJj1lFs1oVjOIAFJIwc63FlQKlaWHhXT8ROT564QkyPy23W+gP+SYpBM9XTbYxxZQ7uYFGBP29b/MGFCu2rDfBGY7U41WR55bQvdzc2NRnuHdQ0os/VElND9muLcU2XLBXrYqdVTE1TaCYP28GOQZ+R1pNSmMYW2NiMXFC2RQwt1QIixM3fN1Elw/F5Inr2wiq4Vc69a3FeDfZgfpUERhZhXBWluLqazVeiGVBUe2VRt07mv2hZQW4gQQZtIg993dJT+QMu0RdKc3EMJXIMO8yte7gwhCjk7bkbBS0dCkFViC1KF0FWGI+ds0K3iMXwJEhgWt/HsQM5CTUSBNBo6aE9ZmN5/RBz615W9xBQQcTkaxB7SZNwt06/QyDKnd6VB8X0d8LmgwKUPt4sd+37sxJWV6QdHsDwZwWZ1At9KmfucXqYK18dh0OAFZNz6DRd4sd2udjrU6Iq/oqGldrWUMF2d2QPNrcnbbSq4zhXl+wacPGzVEA1A5VX+mfT3hctU6N1QFVVUd/EHQEx0R6HBzy300SWjONcQE82FUHVE5E8dRati1b8kPVRre9N9dRlEQ7c6OXpvQtVYs1GQsybHx8rBEKl0FbcRHPoyWNz6q65yLhSMVHXS3CSBdVZL68z0z7X0u39xJgdx+dfEbV8dGlhLD+QJOdD1sQF0d3KQlFJg3yPHMwZIrhcB27tufW6VbXCvMjRvfEtgCz0MZKhOVigJrRpDbFD2BXEapk+2P1rNxxo4j1apkODFRECeXhF2dCW9IT3wQvxUKRldPwdS4qYQMFg=BDu01U6wPdsHx1xCCwWVuWNYPkh3S96L30wNTVQIkV05ICrkD9bJRAsmFPQQfY12TQdCXBeOwE30CnIPtEcDGnEC3wCxhjNBlBBeF0URQR7en5812MVusdt34/8/TEFpPTtRQEsF9xgzQKbZpX8FX85wWIfSlt1gpBX3BRLztk+HhoG8ZLdS0VIHEByC2DhqEyu=w0GMS21C1kMG19YRlvz1VqOGWr5LRTuy0561QutqDOP8dCc0iq/NsDZdyATez1kGmZHcEatC1LkRpxcmEQw5QIUPc8+ulGx1bKWIqzWW4wWtwX5ZDwr9fUZQ1aQbVejagY+4niXOc24uE3cWfd0RWVjYT5wHNZD0d4WLVK3T9v165xXVwew1jErbfUW97VgMWJ3EYpdzlqLmuAyDUxYphk99HUBf11ZW4qp9nES3AD62sxsJSIR4gktvQV5xMVridDj2cGnpVVfMX18bE/GqTuHK0pOnXZy6g605ClbrRQ8LWJuFE2IvtjkMGbdbiQWe28yUREejFBb8s+BBIjRxADQhwwwvNUotsIFfUN5yz6I15oVB1upoVPhszwMLH34MBtutF8NgStfVOteCVJcQ43C9tYXnndrcQREvMQdeIm5EBkUFmKodLVDtAi6cX5gTYhNcGd3PdVxkhrrnXURTLGuqRpTYe9B8pkC591AhtuUwEQD3h03wz5NW9/fGtSWF86ctHA956QaQS9skbsIQcymJ29YN0ZHWe36mydpqXsc2xBR2sdXAnFUoVrNbdREu3QruXVCBrTOsKBlIzkloE5tZoPUNCIcsHU4+KhVRfaYgtjBs1kKwFWLYrWJtLc8THX234wEz14lcRWnEwdK4RFQGZeuBbdOVFD7k0615OwS0sPZRu/5=zkOCB5iCUaD2Vl2XaqVhY1zr3cXxdXRakN9PddbOGrHMwqgCVrNXDvNBi96aWBCQm3rsJQFH0nc6J1ph=xI8tfnPF9Z9z57ZFFhg24Kfmsb6QMFkd4XX1gcw/OQgUEHuQX1U3ZKEA7LcvGY80Xtp294gdKzECOlQRrL8fbtBZGbnUTZwF32urtL1IyXk3AlfPTXS0dF21t8I6BjtrSo2Q1da0EXAHbT4GWk8CCm9FMZEJ01E5RtruQHPhI9dE3BMN7STJacgC5E30GL+EcU4dzugCRHpJUF5FrUUekxD35A05GsDxjKhvd91akDiBF6wjFVVSC1EkrsC520Hplqrzl5FX1heQxiOzvYG2QisH16G3txDPQYy3EZzEbxsatQJ4ItsWToHC1kF2EZKOliEQnzL6QRfUUQLskWJbWWUj1AqDDHQAbWxmD15WS/Q0TXlgEetNJxjrEANXUGjNFllhQY9P+2pacdJWx4ztkc5T9cIjMeG320tAGBDKiJ1ErhpfXX/Ye3wzeVEUuHaDz1WWlbu30ZakQF0Lb+L2yQJoYrEPQ2tG1zn6nMbRVAIHIa4W42b0iQdMKKRbtQQO7AUtlTWQ9tx1ZHCTzg8ay0E7s9lZbq99zT6DeB1ZUVU+D2itbR1+3WCsR3HdDHeoXW5Bzw8h82UOJUo3VX8PwWBa4QmFx9WUPcFKtyVeUNkBwTh+UJlI3VwlgXVtZ3QvYSt8a85W4TEgpioCGrUeVs0z5dcRRSG0PLAf0W1V72hyu1xgz97FMTi8usC4T7Xp5050W3vzLQLcm8f2maDZkFjBCKYrjSDQTlB13BwWVRSg6hbEwJLXFN9gtVfDlgP0btkZJUGu7stB3iaCNErBv8TelkRgE4r2FEY397K8cSsskClDQwUPdQFtbyfzrNxzsHTHJItqszU1tHdQTaO1lvetj92UDEoW+0g4iGiu/F0EFtbNjMM9viZiYcD4w=jngS0caiJQT1UCJ356WNbRu1=2MLX6UxEU33/dKeB/kcoQfHI3EeGCcbYXlB35ISE9e1EqFBvDpEwQ7gVwQuKIILUtW9zhUw0+T0gOH53IlWIhUXgeX1CCVhlhm1ZMKYISUpXajH=l83BdP5wZhphnOwdmIzBD8EIhqYfpXQUu83ivb0Cx9EVktuDDvYuJg2jFj3zhGxewIFV5J7A7bq1VqasqQZG8yYfxCMRawStQnCHmkWe9YgRrrTdDNwaWRvJ1GV1ewbCA3xEGwiTCdkRleeQdQP0P9lVawVxbz1jG8tjsQfNyBB00UkOj8DWwsxgV5E8tERkxWF2BhXgthWEbIpU4lhdXWD32Fit0Nvk8EnmwEEH=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hBlXRiBX5WrTcYD6S3UB8CmtVQcvfm1umMEaEHfTkq7uI3uzMYra0PZnZZFF+ryQlHGic93QXa2ZmzmsGbu1ZzFjRFobXi5DK3L9tdCajVkLGprWzUFcTXWFBRqI1HLwwfDsRbi8C6VcMT3JGBZ63Fmdlk6C2NlLU+4csgLZOCsn0JWMm9gU+WY1u3p3sgrbshuuo1taHXYleD6GrjUeX0grTUyTX1BMB/csteA1G1A3NUJx6ktZhtLlmktUZmrCF0tsYaXcnEdZIiimPSYK5ng1Fw4gZWEPpVq70dfT1ZB4W=z6uwTJ1bOT/YPwt8D609ch0tzSPb9OV9YktjS6dj5MkOb5h5l9L1QKc3hSD8r9vCt08fT1J97fr7U3WCbHdHMXhOspDP9Vf0HNxzdPMYbUFbQLaQdobadBhHBZ1tznsbRlIq1ABeF+pKw4W3KUbqBO1thwXgT8OwUVrBZcUo3HQQ0aoP3w9zaHg0RkLBI9sKGQcxba1HTQcJkdiJwtf0MCPbsF12EDrVxPA105HDYVKk/ZVyhlSC9b3Y/c6qHsk3V61WFa0yQSKk/ZCCi4Drpf6ZCQS1fWKdIKEiwGEZD4fV5lpwOtl7zWNNYYF7ATCJmChUK9z4OC2dgq9ebOaWNSCuHOVh3z03Ox847WJHRm1/Rtg+h0XWSt8pagDMU/bFtibNm6yFC0912P5ER1lQxTlDezEbVUG/SpD2F3rVThXwYcybBpFpwXenetgLmkJOlGxbyUvUVvSeSlCMwRKqnblITV5CkAagSs62wJ/AHBHlvMsS5FX2csE1W1V7a52YgbraDYueQUgKWVtulaRlJ+yTrBK1nBAQfauZHXluV+RYE8GrQ3tUwk5NIF5bj0Atvp3wljm1S1QKTmldXtloH6P0iIV4wq7rKh21VadA7VbnNRR0hDzlvRERhNDmfBAkEB9aPtRrXnrZ7sG51F6ixCOT0O7iTr91E7Sv0p3yx+qw7Y8W0J06N+1+SddCU9lPi7kTO6s829703zD6sUfJTnzZG9bqN0OuwVlLt30uG8EZ1bUSwmR7LdYtT1aNoFXHUJdQ1HY367WRHOMEaEWNZD9v+QuxLnbuTHkttk2N7TicitlR8dpTzEpOCozzcfV9cd0F8uwhHCl5DVNpTTBMVRpwKVF8UMioA15fwsMTGFAzr3XPZWXtHtsR1MPoL+iNYSkHW0HCHRhKtawg=wIXHK4OKhVjU1HyZpabUL3l4eVXd33POVDWWUN8z3pTCRDcoM5pUwdTH8e1F2AB5tt7YQp835/pXm3INNKd4hnTZWSxTsdfQ2Vsp7Hn3btxU3cPxFsHuHIcHWeVrp39+gQ8MO3qmGFlMRYgG1kDqtloGJ4Q+EDGgpdD6DUhzURA7GTXTkhYXCUtcFa8SYmT0kgtCdS8PUWFi7gXXzftbcnUVNhxDzdmQqKSYJDVBWOgZkZrLi0papFjGrAmrVUZLVxU4PEaUaxx8uApCW3q2Vx5eWPHIyPpQEh8Qbdt9kYdbAcFwsLP81PdRFdFQ5IP0zrhauKWZQxi7fSIC20ETZUsGZSF8Y2woPmaJCrxAVe1p9YTlIRAsYF+IXFyt+D1d+=nV9Yu6od1YgRcQTl1DUgELygVDBPOKDY5lUZm86+jT6ZVtZHS0D3JftRQQs9iUmD8lW+lUPXLi1UdRdjNaJmV5D0db1A5MR1aFh1pSFOwm5AgUH1m36cQUnhUIPYke0NEQQGpQChtVtNfNYeCwRWbtk2z8eoP63CSy03VwkOOiJNhNT9UHmQxXrigznJwSh+O0Vb=JvBHCwcGsHVaEYgYcIHZ0HO9tDUYMEFXARIEi0iv3sFc5tCwLIOcuILA0TLLYaxIlV+VgTmgFNbbT09YyCD1/PCny7WLH3tRoNpuQsXUlb=udK05iQ2DOS9vzHIRF0t+QVnD1ZQLECrjhRLGc5z9KUhbl0RNxmXHH82I5OPxkd0MPRQVXrtlfJS0arnIJHjy21g+F0UCOSocFwNVcUMmFXwPRsRBk0YMtd191nVZpHZae76Ffo5kC061xJdCjtCknL61aTqrD1QcLkoIRAXRrfke0VxkMQxVsnFBv2Cy2aBde9Q1QtjDcygqeUNyCwNCwad4lXnQGZMdwcR9gK6YJKX22wQ0mIMI14FkyRJiGlcFQ0vpILVC9BlgRxXHI1bCWO1OeEaNRFYLRaICDdE2JtXyrXKXFq3NicckO4RfOpkH/UJD8x4vIahhuwOZEkV0gbSnflN8ei5XGkNWVRKV8DaVlQHWEN/HgI19tWLhlQFWcDJ60wEY1LCsRRowcLcOuQaiCf3IYF9AY3ttYzlVKfnxHGwawM7XglQheubFkBVg+9t0E0ZRS6f9X90w2FfJqY8RdoOeUgGQZttZOAq0rDjXpGtlclBwTnPadeQde9zr2SRqAb9DwqpUZVVtw305oBHTMz09Ax8LD1Q/HUG0BTtbfY+3vHBN1AYzlbmVhEFGd7j2pUmNItskWVpGNPMtkE08y0dHUMb6MYHxUHbBkW3ouG171yAKjcHWgKGlCROmQTRnK2VjxxcgGw0aC0MCz6wEx1D+7TdsIjGrTiIWE5rvaIRGtiFvJVz2Rx382EYUgMECVE/aGFDem96bht/ee1gTCtUfYzN9ZW2qsCbx5aUEPptq4IX6=mZ=i8v2kPQkYrAb2/HLNWmZQsVQwC1tRI4FAVlEFMAtaC0FhYaYPdXAXKQQwAgV0ClBeTwJh/O0MSXuuFZgLtANfPwl6keH9usIK4MZqZedsUZOxaMwZfQz99T3MhC8KAXJVVwbBh9QrpOHpjT9ZBncsfQ7iQkVRZwK7QPt+buZQFktf3QsLg0YYrBrYn0vx2MQThh9VlxuHB3FkN2GPt+ZTkFXjl2ZW5QYIYX4vQ0IhwZPK2ALBcRbVg2tUN7JAusLcFMj/ZSB8DO2VaVlpgaioCV4Ka0b4SRTwMLOZDdb0RuI0wGsJuNxYXY7fd3fc5WttiUnJ3EkNncRgV8HpPYcGQMNGlEOPqb6PChPTAVxSQRC4k4Ezl/WhizrbHlte0hSdwQEMRWrg+gp37OC0J1L3rZL1bJoMfNmFkKtlarihXSE6ZgYXH6SxvT3wUGA6aHXF3dYWMbtlVGis5elcQYsGhwSUGOV82OWV8AkmjcGWfYhOnHEE8eo9kxIBSU5EX86xluWlUk8+ddibdgwtztSthfyNu9+unSKbZIhkf0eI252REBIFuDYv1RF3xAVW3zUimflODl2udFF9OwpNUCFw35WUbDCV270M3BfGUZQpnsVhJA39rL3J586i1Hy1WLFxCrnu0cPWiF/PVisVt9BCVUPrsDLw5QLHTrSx2jzn1k9EE7T3l/rimnCYINYrPdvd8R2z895zo1c1Xeu0H1veUte1iuB7en76Od0DvdWRjT3l+Vm8xp9NEIgZ3f+vWs1nrkwoUQU+WQYXTqcGX8Jpawx1Cxh7XCRUH3551ou/OQ4PYk5bxc5R33T4QM6VFwAtxfKdGwUOdV7NFzttMPETDJ/AJHhca1+kY2VEuE4jZw9uX7lfIG5nm0gzdiFTtf18gw9v3QNmC9jHQwF+l4+NgUhd8ze0FzlkFeT8Qf6WdxwLV2A6EVzuKDUN/OAca557dfsLcpA1bVtEV1d5Rmki16qa1x4Q7XfTJtZkqW3kqnr9jhQP167dBsSPc+ethVtbE1VHrXsS4hx0rWluVd829kDBbE5rB5z7gnr5GASAQwU3x0SKBAKVjHVBJtg/WOuviAZVe5+RWVjiMGFXd6InoYT0dRT/wRKRpeZ31xdwqWf5Jlvdhc6P0mGWapDHfND9y7Q+E+Bc9HzwkSvdQVByR3rRGJNClmBW1DBph4bJBY=pDNMljTX4KN00QffYKkqg6W5mFmLOkFLRCCksK9aDw9+qdMETyoznNjLb3Y0dgAYRnvTBk0tGxOntt05ZlcFBQ8CBVU2rhdjWSWsrBhzSYZ9Vta2V6UlSAvdKMjoJTl72lTn36fuGcIqCTsDBPK6nT1Q8Maa6zTVl4VggY3p4Q76pysi9pNEsq5x0xedwMdPbYreVlxSVKYRbGx0rTOJg8XZ1UvOQz8rtvkxFVcFqv3jipUHHMlVQpwNun8bcqVEW5ab3gR19AxAbNyQH97xVlsQSY5KByw1UYLxCwyxtGrElMKj9Rs+leI3u7b0cbThEVfijWJMIqFiihAIXgzdW9Qig3JLdJm4xO6h5hfUtM6qWM5aQ9sFzNV6D3WiT3F8+NjKV5kB1d9/NxhGDFlbBvzuzGkJ2sE1VfwzUF0CGPN6eW9g6QO41vtehYGypJF0N8Kvd8IAMgWXku=wplbmRzdHJlYW0KZW5kb2JqCjE5IDAgb2JqCjw8L0ZpbHRlclsvRmxhdGVEZWNvZGVdL0xlbmd0aCAxMjMyMj4+c3RyZWFtCkwrFd5X9pKFP0ExAsCUtY1BfQQULiCIAimmV5EdFBQl8TciQTZiYTXppf224ywX33HtuRqxl0zVpJw0P3yK1VXtgqUQe/Ld+wVFaVljVl8qMEwK1ZXnXhrFdSd9hYll5aVV/ddCmZc3ipOW5Vw7LRf0+KzVHu7RYznRWnVydiTW6kZbvbV8Hb6UHpF8Ftmc760Y=jQvzl94nipxfzekxJ3dIZkgcTzCxiLFhIBhYRl0DIBdbLFIWEORoaIDasnYgbDceYCpJre0CcyDLWVXNByI2GdUEfOE21jpaCDtlr0TT9hX8RLUc/PrTrbsR9l+T38SCnE9Wnm46xxjQ2FPRvdkFlOWKudRlsTmkrN8+H1vHAU9t16e2EGWN81PsG8zFkpmoSV+Tvakuy0b/ZsXQwOD4gT9ydEhIxFaEDGes6M+iAkpF85FjEhzltfGts8G51J6i1Fzpxyx2+h4TmR9yyA5xqg0ztvkBeU+Y6R9TzEdAWgcyTp2cCX5zXQTCWw/PRtwGK4CxerBnMHXs9U5kYUtWrt8B15IODEzcHVKp14FQPx6nRX9iA1hd/QWkQcGOcnQwcHwlKYR0FASPHZA9iYhVbCqwhwf1CD1Te/wkTvbUcbZYzrRTLjcDL3sTby1p5hoT3mpAT2mPS0bmB5rwKuIz0HpX00fkowGx87wipyO31U+UbwhYrZTjrDzthPSNVaqEGSznBy2hQ3tG887Tx0MH9J6HIkbVjUbjUt1vJ2c98y9aG3wtIRh69y04K8EYGkpq08TQVq7iPfZxJq7RAprsI5+sd80NwAniq0TiR4Fecx8smwAjPaBAMTc6sSCAcAYSLrcIQ9wGxkVy2s6bivHYwXtTr9HPM7YBPLazpejE0A8dx2gFJeN12MCEKIC1jPblwW8Y1wTUS7DUEj70CQpSKyVxqXk2MrbTfavHcvcwNUJ/evcLCUQ3Uopj9hzR9W48EA5IelP4mMQLjOuRSt95x4BkeGBTExcWVF0gJD0J2DO1GBg0dbIvwtZPoeXBG+zmr29ac7OrUZaiFV3TYSs5uZezlLSi1HuwQUxkn5yVDmF90OqdUZUZRRjYbfdYXlBT9JPk8PgVszgRs8ztCduR0QTBEWR1V1MboEsPUNw/UMMNO0QZzfHu61tD9ypSIbQ85HQkhpxtk2BNoEapMEt18cFVb07c0xrieD8KZ0Jte1rCQ0wpOXOYAT0GbuIUT8a03QoV9UJ1hEQLTAtPrsQdRYixF+ltI32JpEwMPTUVjSTloXRY9c8F9mwTD0Pu1gbekBsLAiGlMDp+2rYwVvLVBjZUAKdVVpQN8xE4mqPtadtvHRGPpMdNO7kvbFOupPxiJX8Puyh4AaoDRUcOVz2dj0P5F3u02gItFfaT0MRbwmkQc31ZaVlwDAr3zT5cq4gK3mnITg5BhRFpOF1C5LYiFi4e5FbUFpT3fZUU9rATT9Y61C08wX0AVdIbFssX3EEArHIO1NYw1vVFgRL2iW98Gacy0c6YjNj4jAH/FF5aFQpfd9mE26RsZ9YwxRwQKB1UkO1gFXXtk3NobBQKJXstiQJHWBsGjv2dW8JLwwOc0R9ZlI9fUFDeU+3wrFuMM/AGwLtOEyOD4rENDFssE4pkQzU0OaR/3PBQ9O2+gZGV9angLL3YUpxEX3x7w7ZIyRBrYJRraEdpODlhDYJS0wMscQGVVuMWRze8ccbSi3FpABHQ8IAT+YGChBcviJTXJBGoqSa7LQKwktXZgy8EHtAo0yLHVlwV8GsjUIRkytPNx1uKuBLUaOcEHMMQAUbhlcIUMHGAOJwxhSG5HWF78PecEHCsPLHgkCWs4TMFIXTQknZIEFiUSAmUJQiBtZqQ4WEUcOQEYBeHBQHqsws4Q9a6REBXRa7lsQYu5jG+smEiRjJ18EY0ZMCoEb80YcXiYTi11LtvrQYI/VsauLnesesB3x7gXUC1BEgKrsuuVFVFcYN0YZz+7B0F5bUIp3yz01HJqB67bRGMX9Eu3FX7moX20CTWMGXTt6Yf1XY3hXQRtLn40T+5atWru31qtW5Vjte319Vc05GvrbzqYSDftWJyeQN7M3d8fn10A8l33wnJ0P1htNmYx1t6ecaQTkGc00BHRVQw/dUtdwX0FNFEgblY83osxNN/bzt+f0Q6/bZI82YFVULdZ2WhgOE9BFl+VRq3FV7PqdmXUy3JzFj29nQnI6pjlQkV50IgxFynG0EkGtYWu7FGJgpwYbC4Ot07F/dTw7YSXvTwm3cdV9uTtbqkFPcg2U+QlOT2KxzdE2JpYVlIdAtVfVOQywLNVWqs7u6ITar2JGcjr3ObUmzirnsD1Pt+lEnwht/V09HJKdAwR5UFRDWztr8t3nJQcPTnHfQT9Ziw8XTFZLKVf1nf2T06wQlD6/iVG8bXv0LdSdbb4hDWV3pwKVbDiuJL3ztXu8Ngfqvb7evH1uujQ8ULBSx9ZWNjWQNHfVdZYAgJCU4KEQEHAExnF2pPyBvF1rXa917fsDVZBeJCU353LYvJFgXMkmFQGnRCRU6Wzu=pCQ8ncttRAmt+=0knV1FiB6BSW6BFaDCRCgxcZpNw8dI80x+JwLh+mtI86tEI0AfbRhC4lhwU198K0v4k+3zLi1He1rC2m1+kTC86YjNjw/U32FuFtYcI1xWTLBptPPChs5eCmBPZ=iM2m15gOgFxE5CPSBese4E258+lZq6R9TCpaRW5fEXfbVxga24Y=ikhzbs5wNUfz5osJfstvCTydQc1VZA8QwAquFrWgtlzkHbcFivHj09sUiW8RBzCYnMWzuVU84N6qWkHbUV8ZDl+agiCUj6QCRM3mgPmdwg8wwVsGemx/Lt786u15R0NUxyZfNlU1nQS7Qw+U6D6ztnnFytE/DLbwc+yBYRhFRpULZSIXkHMeRSLWT6iUN/XPmEIfn0fMPRdYWhf6g0dBtIVQ0COMHpw9GSxc3YQ8XN9cg1CQsZa389/T8CBt7WtsO1z1Y00iIC18W3MME1QxSlRcbjRsIS1iZQTEIO/dfPNe1VbQsSYulMD1afo500dbwWQ5XykGTdjXdMV8c5EIaVzH=xELPFlY=z5/VWIZhIGT3A3VIdDUKwdXtlJm5CmjUCyvNWeLOZtYwsQyqzqY7cIrT9cgmMlQwp1XmBNIAPLKN0gTJWfssRGVNu3RQrSa1NAQZPxGxNyQp7wLuWFq/LR99kPQMBGVVaB/R6CjQhzSdBe3sE7TojWl/JW7Nc3F+ZZGUxF+A9kGZBF+F3LbEQx9PBiuGgdw/lB=xFwIGFVD0DrFwIsOlyAQmOyLH4KFhvUAdg1j0gXcReLs1VBwj4Utf9BsEHf0SnYp6lH29ZCCA7An5hRVAXOcxV8IJ3l+tzxPVhfHrslLFnXBNNWT7CyUXJksxlwQGHBAL6=xgKyWFjkFvQmIdBbYapwVR9URJ1ynEDEQFHptHYETemEGThgKTxjzrtoONTLhFkMvWDcMnwXBovrrdzlUR1kOXBXnZnyvn3VtAckteCpcen7rMNs9azhwijJ31ooYxkBYs4TOGHkduNZ1CsEXsf8LagLR7YSFaSVJCIK0dSmFCVnpbXjiFgc1VE+oFb6cWROy4NiMQcEYE1LUL8RwDC8cCDRhZAjDuuWVeKR82tCBVswoQNw505+ay/a=ndaxXlYaSxT92MIga6QaCBmEgCJEIDEQcQFASwRe1wVGWPZVlVPVUVNTXFHy2UarjPtffaBIV2QClM53xM/EFgoXzT9ot6R44hXHFVD0N9Y6GLfbAysLP7dndZExpEDbdxFnm4qtVRyOwTP+vY1V4pW/E/BgdCu09dyAubiPnppYXc6bgnpZdD1MTU7W7tB2IuwaV34q2SsMREHiAo0rA5poQcuEv6X8KXLcQX890JqNi91bNV1hQfdavdfT0Td0dTftQtMFVxMhVQ860QKh9AUwqQ0RI/6EKwQfQYaSXEiz1kNEwcCR0Z9usu4r41oXO0YTXEkIJzIDEQp5wvpqSeHE/VZEYYbIdQM6RgBRlrNW3FINp8XfbLWW1s4HTiB4iFpXFoCVRCOz1950dDogZru4T1iluF/yQFJiIVBr9Se2wHlEXxlAPbCpIMZcxoycWF99002=1dzBJRdhFwhkDwR3UEg8Q30lsQ2VuVT0lXkDOGQbB+ntDT8IHHx4G1VdSVgXAJB2U1BZ2XxHnyVkY2AGIsHKlkV2EGI8d8Kw9PR7OwU/QFkFAq2aJjpFf0GSw8rgegL+ZVUVIqQyDEMWCikSa18KCkEjclGuMxEKGnd7crdjJBraCHNHKl9cWloTwaxG4c1DsCCt1BGy8QCQmntCvONgsCX3sIJzQKWVsM4kSnIUQhd8dPQqDJ67dA9cM39tUuFDOXeaORbaGwGYX6cRYNw2cQdYMairs5MXzNHVFKNc15Gc7YgEnH4HN4V170MRhwgJrc5WFDQWEExPfu6X1HKVtkt2JfCiQfTWC/LQ0ReCYFCg2463adwXZVUHtFziWEQ0zXsX9+lbdGRvde06pNisEKsFEKR4dHN4qku11kbAkv3yz85NaQIg935A=2i39hh00kVD5IYUYjEQpxGxBsMXJzYwQEWf0EL1FsTlGLUBSMrZTksn0oP0+tPZPLLbQzBQtQNwweKyumCit5XGsBttnfdK0EnP1XbZI1x3S0OmCmcMR2hXTj54QRET2QMcwxjOEd7K7HTFs5CxuY+H9BBsFC4G3m26YJQNiAbgUYQTkTFgNwhx8IkChMa5ELBV0y7K90+QO2LwRLQNeW91TFlR4DzNbxkCq35sawdlBOLhX0lbRtxwUvBOMvHeDVfcMMT5jJqlRIFM0El4IjRdYTdVzsbteI03sb9zzrMt7nVeV80FDkYlw3=3knWFirGcu18P9IDVO7TN8Nhqt6VRUDRqsadCeDr3cQML3EpDNhAsdHl59V18B/dWwZAf39TVHiVnTV0ThuXlVtBYvGSFx5BUEa1TqzRux8Eonvf1pCjraLU61ChXOn36wXp0QV7WKQmEw4WWZ0fMNQT1ESNRfMNeMJ9FOQSay1K3FwL7VnNXGocTzL/QM922MPf/THXip4FOQCBiOBF7rZIg9+pBMoNHVwbX5Ud/tEQ8+zo5ZdZvWM9umwH8RXMlHY61pXFo1D9+c8ehDXy369w1R13YBT4TPNpOHREfbXrHb1l5ajoaJf0b32dXVVIrZbff3SPZUXAetRFBkYGidVGf91t8XG9HD1ufc7fhoF7t8h7ntv36crBQQML3tR2sSZDzuE6Tw8nA1AGajM+PBvBAbUtSWLY=35P5MkIPolBXXzNwdhfRup3tStd0MsKsL3EdkekWmU0N6C8dJx5SHrTdrzCkaRoPrGkiJDBNS3XBnv95ErTTcInU5ThedV/hKTpjsEf81sZ2Woza9YOtcCEEFdj8ETw/BSvdfTy91EA9mJ28jT58EDkVElTqf2T1KflFvQwtQ9ezT4f=zpH+m4GX5TmeJCRNFwU1W33OHCC1/UI59uDcwMxUdx89sntTZKz8GhKrVmit7czd32JJNFxctnXFqlCU3YOmN/PWLfRgfULYpa3zA4qWRj3NQwnZ=6am5PVw3aVwNSIQftbUWEZqweQUkuVwWxtREgIVY35lDhyVkYSU9eVBJJWRAmH2sUWmUSQFwYvS4EqC1VjblcLBUK4NaagNWUF1diTSNkIAgXMm0VH1qpLWFzNZpZWrz=mNBD+42HthT0yOe1btmm4TQCft0Zd9u5oVP7g8O4CHH9jhdE+FGBg/JW0ZZ+dWdmBl/Q6tV7FpbN32ERfEqVljQ9dSEOC0CREwY1oBAllkutrZBUteHTcZHS3H6e1kRHBifx/aJM0NKmENdv4X6sWWIyEaFSaKh7dHX5w2HUBMhYOQUTkRosHKThKUQ55Qz20U9lUil0sF450XpoLKlbhcXo3VthKD0+PAwR8JbDV8VogLXnxyMGqrRKtYBUbf1M5isHzadVlK0iBU7LU84YGcXUfb3sdbseNDaT1P+wLO5x1CIW9h=+1KqRNm7nggT2nIVW4Ph7EXHi3RfZWxFzL6R1B3oY0+4KCwOYH1lx7cUp3/ZdEw91TwZqOu0GuBetxQcLAwgBcIIRcX9NsW24RX5l9TM366g1pYSBWbF1bKXdXtgdQNyXwQcd8sQt186g0oIeeDBISrMltu0haHzKkxzUVE1kMjdx427OHRPhXtxlmcy3uUZZAh4ZX3iWEyT9lhkGmWC7Hl315c3EVazWcX85MDcg9wLHyQDdl9UJ65oKNQpCAkZmRqgKNbpOQ4dAU1nuEJ+anI7wQwJ9sVVDFaURe5OuBf1fuXKfbQklYhcFJTMRZCgQVBHXCDcku0LXDktwnJfTxi607bWXLu3JPB0kuHIBaZAfSyURd5gnQt0ZJogk/9wTjx2UwSiwypPQ08UdtlzIWVVCVrrUotcLCBLEhSMzmpOXrHP1raU3ZN315yu9kqirpZTl+SxBz92gY1puSRM6p5YHtyKfdT9ipnc6N3BKQN5c1nCbU5XeRQYQmXFbzRGrQ3TM8mQyxfVt29H9Kat1gTUbXdqw0w94VUFcX5lL1AHnjEYVh0MR0DC1ldT5u9YbeyIq5wa3O5+CT5iEQapVRsRqcEZIkjTbdkQjmBRi3xf1CcU9n1ZHiohXF0twpPsdIPVsy4lbO96xpww2gGByntGNhDhSIVYHUks+6dQq3kOGwt1vdIT0l1Eja9jfwVUXdUM1BbLus6didHLa/RGYElHYQy41UJ+1iYf0it7FYOnVZMwbBtvdduBmDA6ot/NawXs3EszCYMSF9j56aUYA7Y68THj8aoEsFE0ZR6bdmC7cjsrAIoQscQGHHCAMjraYBCZrth3WJQK15LIXNULzUIFgHUJiDCw8RIFgxpyBmGrG7iP1EUz48pJKCT8MC+FP8dKddSQt1uG1krq3lGZNEyylNEdVYEcDBfMuZf0RT5sC/HQQCUI5V4WEDlYDsXr1Zj1k29QaTpUWRqA01V97QYRVM5yUwBuTi4Rt/SlZM+ri3WBlbPtkYfX8OVt0ZwkWIfVkgpA0LONkhi7nat90gKTh7kAz1XaYhWWkEWIa+iQcIhNfTml3G30XCnZe01BoCVTCJAi35eWFDaQleTV5O7lEBjB3TB4UigwFzbOJxAHoOQCHeFdwYlNbAgbXnGntPYSCYFQFsgXlUfS56R2Ek9uKe3APZs91nC5hzt0kDDFiN28DZTmYBQyrY9NYaBNi3BmbBq7cl7Ch6A6BmcU15e19c=hvbJ9YpTa5UA9oOgdR9A8ZGMJZzXsjSZAAeIyYsegGQuDYzkG4UPH1BLiVRob8T3J3UP5xvcH6FVPRsRG1Zrlao7VgrRX1EPwt560E+W89VWk4T5FQ1kYKCLHp8m77BiFrg6F1ggakRuxsvt1ScG3hNxZSw0uWaNOhx0KtMUgwNUUaZu2l1hVthgR8wLBAsJSFC6dyVsIeCtWg97e3pxVpe/1VGAcQQVRHUfC3zCtE9RgpTkReY15o9H321Vl69CptL25XygPyIIIWSmKYq9imVivdb2QJ9m7kki49lixxd55Vusvc6e16P0jDDMaL81YFDa9HpVGvZuzWfWUmA2RsdWUh358S1HnBSC1XnNyoz16H3EHTCdb11T894gpTQMNYAU6xpYQ6wuzVakO9u3x3TXEPhhuUm6szqssWtgV0hz7tQC43BlfuGDUUQUrIn5tDlrfZy+0WMtFZv=8VQDrCYKX61IQOcHZFzzrFfCKlr7Zzhosdc6n8L6AYYPNZNBkxBiTUdANiW0s3tjteBR1yiEkMx9ZngSN6txJttt7IlVVM0JaCslh7UHB1wXTxrmLNVtwVQNFUHWBXE1ErYOi86=8v3EtwQ29WbldaSXmP7dXTmkA8RwPBXh32Z9AcjBWe1rjT9tg3eCN6/Vr0Fa0Hu0iUQl/RM+081FOzF9rQdi61ZzXt0qW63=y069s/tldCQgvd3NLEGt0NCQ17JdaBGVASLFIyQFIe1Asw9zUDaDGdhPfcZducvxXCt1w7BB9JQ1lBdQ2oUpy3Q5zTt8EtbHHA2VVEzRKm7VtxZ9kITHdjyaDBsbHuQVUldl9sT43RqebJgCLVxYVDdcBNBxtYV2oIA+wjZE+JRKVFRbN9etmU0y6hT370piyfbMBlV72w7kV0EFd9RacaqbFr1rB3+q24Y6/beacg/TlYFNiGg9nBiUQ4rYc0ccVup9gl6VdcRWVROpUitFsk5ZlPkXyxOMbUL0AdcamOgRE+rVdaXIPbdhe0aHX8MbD8/62bt00Mu8y43u4FaZmpL3FoKcnuph8T5o5WZ4gcQt33Ly053mCoEiAlVdBQD1xiNQLTWcX3FUPIxmpECr2KrXaoEhOt9iRnSu0y2gf1VwYwnNdMObVkuO2FnTzcE8fuKQYeR3utE0J+mX8=ykMKy8Fj174UVugyBcUHFgW3laeXmsbugQpUehhg/zbD4nVIMgW1UNrQ85KlCsQx7XfNV7mvHjg2xsGCMDnlPXlk31ZHhZitGVhwzEkhjKQMz50WUwF2CsSA6In9SkNlPy58bTJMXlvzjwZX05=7Us0J1HBvbHpkRKdDG28bF2J3P1Agid5HzlEzHR0fEHsEXwdit1oEOCmdpHGNuBVaQVTnkBmHbhr1FlgwmAxSoO2Q2VGIRBqD3kDK0+LkVZtkXTcXvUVZpOxZcW17Y0dIaX9ICfQH+z4sO306=n/WrnY+x+LDVSC20FWitQmIscSAjPXjMQJ0hhWMEVt2UKWHcpRIKW+ka9cYFqcxQ3v8WUN+KpJZlEJLUI7seT92xdCRhDKcbQ/tQTRk+HPZ6EE/arB72C7HTypFN/wboXDXQndIIcRDRQHubTIWH9TCUMNT1oYkQfFtkRGVRbxcDz1n3YQbdBV9dJX9asTlUtCx9EOIoP3IPMJnVSGxL6d9MWNQxF81lY2VUWhk6BWEZttvdHBHaxLhY10d1NbbiMbxntLT5IoYS4VW2dbQgSlxSnir3QLhURteW85YxvUYlknc1vCUwN9sRlad7g+8yEE5CLHxlDy01js4s3FQYHMYQk09wdYXW42HsdeUyCwHmJ0XPXq0T55GytkfQMawm1hNfFhEVqDpEpXL2Zys3nncyLjUxzV/DPYEbHElQIyUZ8960FgU1VYqBxhwc55z7CUQNdEmcyGklhCq4639SRgU+lir3DcCZUtDCndWf3C1n6gXRdIR9hSh0+r0NZxFQpnlvg0bHdz8aBC9v=xiCwLb65hwzwWNNxZN9lZEwLZfwZcagJCTlPrk4nBFbiZT4Tzr2VkICq60Cnt7O0MHUIgf7S1hKGnSWAMRjIPVkrBV0+GQtUxwt41CwVxEDCWMCG1hIC6gx9udYzQvcwhSDYVHn5LSrUbCzcl11lYr0dWYEhBXC0RxWVOAQdE9wyDxGlz1eGzUad9RUsDhpdnZ4Gzxow9uF0oWKspoGjdnjBECcgRs0sc1bX/IgTF1hTWuE+AeFcE6Bmx1FgF2j0Tk+Y3kPIH09wpqV5Wzlg6VtCSakgPGSU+CrUTEw7HA/po4mgO31LMldBaVdfQlxHek6AhtPRyMriLb8iEALPS1ZQNZElm2a9ZxICWxdi9pdxlxQ9VbH9tMEDOgh41RubLA1bioxWWUg1v0aVw1EF3pYB94U3tHXt6FVAamF5yX1QYlVGajixKAgoUuDP96FBAVlBReDBEk5RFhJUFZ83Ik2ZK2xUrF5K1cpeCJ1EwdDUaOFlIQwEqMTnqorsHf6swTVZWMusWFzGglqze4LwZByOwD5JASHtBs4jBV2YLCwkzmB3W4cWRxeCwTuL1iFgOgXwvGtmGCr32iFaXAYqQ9fMWiKQQx93zdmN9zG7dCcrh9LKYbfOkMBi7EGbPerGxhBSYUTZP5AnELkbt1UNl6ARBbiCoI1d7X9dleExfnTedIcHyTo0Vg/HOv6wR67Us6zF2E2JJPBxjVGDMddwXmxuyEmQ8Bz8D4S0G3HHb0GxOFwCIF/uQ1k7kjXSEQXSIyd212AKitUgpIN9xG91vxl/=gbUX5B29Btz7cplLrLzfdUtlfbvxr=sgGHskN/p2W82CLvHtSMTrs78Aoxj1YAyYz1Yb1lxyFvaA6uFYLQ6tWRseYjJem9SaaTtztDC5yMTl72nLHWk4O1FEy247eXTaLsRl0KFGaBnVYNPpza52MkhpWAPHTow5UZy2+gZW4uZ9lybHdEhZEfaZDY0jJT+K0d0LzWdYBwrDkR0EJbWypTFgVi1hPq1YGG7WiQm1c9gRoL=qVfJbUBEMlPbxkbZVPHEK1jDwNorGA7KZHp07BzWNk5xN8wTnnS3IDp9sBW0Z73e64RQRWxguVe5ydqxlsMRLXzWqNSmLj8DMkQuEVZGestCmNt1oLtlrqFN6aKlpXgHETFD2tcDLzNHHBzfL50XyxgbDBODD7XAY0IuylHX+HrQ0kuBRXpn5kxEH=z03U3lw31QzdyQrgepM8RI26pR95iH7d1/3Ud6m8Ezi1DJ1UdDQyQgVpwBGQOEFAQBFEGZYhEUBQEZK0P1332W1AZajHc1cqce5du/au37Z3RF+PV6QVQl6Y5QUczrQ4uPQ5TVa1wiH8UMd1+JTgTKzI9TXoQPCV2WctLTone+67H1B/LFksTkHHfccy9slLrl7RV61Lzd0teEFpkFq3JVbHW0547dVfTcnEKYeFRqwMsckdyX7nFT8bqbs4WewA9SPa0UQ+srNkcnfkl6cJ1Q5q9H6WERRlWSDDCEglRNBUO2pSLjM6JcBTlEwT/NT0FGVvCvxCeAyoG2ckLTuHox1Zuzag1ZcFUYciOBG6c/AonO2RxQJIzl0YtuVzr9awQ2rXdIQ8gFgrcqZDLAI5BSN+Kx2E8G7iINsTSt5UmlRcSpIeCBcEfYix3rLqDyuzjhRmG7YpIjhIQWI4t88YaZ60LNYli4sHHRYIy9GD0Me8lDFxZPseQR9tcG3nnS2wLwgRC33cK8fp9ATUYnguP1tI8/xpdrCw4jbW9fVy1b39zcUJIJGUtNpirPeAQ8O3nOHZECXrWF7hKz1nW4/XADdUMdA7dFq0BLUW2QXtn10is80UMRkR0ypRdwj22gV3xaJSlaU8UYYMD5AtYNiMTYjVqdvSSt2S2VEEw4uJxiqxa1xGU9Z60b=3A6TzaCXtVXa22CCkZElxmVgz=gJ3VziNfqYp0FaeTFBf2SgC0Ko6k1aXzJe0TBGUMPVjiVwRZfE4EEh6tQQoRZ+PHagYju3Ivc5koKla/bcRIRhoE5v3dhu9gb9lc3FIL3RDpRF1b3wWrgqrG9h3cnEMg6GP0fQ9D9i4xFp4s20XndpMwUS83AM03e3ViQJds9vt7CXUR/A5jsdeYlasAGpzVyZyVZsdESgpYlFYdnkI0mQESYDEEbQsU9h6rGWs1y6kbrEhCV85WPLeRpWUHc2gtaVDdiWW5OlM5OmHTeO2paXB4W25kV5JkFgREwZ+nnkd/KwVhTBYvR1kdEQPicxFRPwtUxNakiBtFvdU1FZKWteuAsPLRqriQ94XA8BN0gnRI0b8GhyVXAsIw1ciBsQL1FEMeRc2qYeZN/bGATVxNHIxgiR1V7Qd15xh3oMlcV+NE1RmT66rWRZmQWIdoX=/p5DjYPtioFTd8XrzJrYqMEF/TQxApqclFTSTVDMMvUX4N2WKvhR1E5Tnuf1nfSVJWRJxJc5KQcCe39rFtbh/nasjzncZEwo1SRmuZusY1jCutliSutx/mxejtKHQmVqrJeIl=349M1VzxGty4pgka63Bk86q3aIOGWx9JDU1BAOzMtPYj9rKeozT76WpDcknTE5vNBBsOBQnVzpUpV8DbFv9wRuSDT47Q1kmMlfTKBkblxM3Co33Oa1THHi0teWEXyYnV1sGFyzfFWR2X1jN00K1MDgvCirXT0RJq5t6ycYUUXW9WSl/7U+ig6fRFBENZGtcFLMFeUsJgeMNfB7flEbtkC93eBAzkqWlBmFNcNVSlmE1rYzSUsRV8bsXdWaaXK2ssc2=lprUFWbyFx83T9JT2I14d9OLQnkUTSm=4h192Qw9kDUzhC1ei1ImWBEDFqFh8qMesEA/d1pdmDV5c3llJHtCe/1DoNsVEMeDQnq0Z9QXk/emukJnj8Vl0XrAHlreMRaBkG=3l+sdaCEaQA8c2PdkIcAlxSzoFGt0bCQ5FWlsiRBqURFYLuxxMYtSqkCBkQI0FIiCY8ZnUMCxpBAgtCCaltNQXTMvdzTE8diXTJEibgoV0NZKw0POKmA8QkLRsN111X1lCEtsPILZMEhUvNVuFtJGNP2FY1v2Lu3uQVMeyXneJeFa5UN+JnRt9ccRnDWX9sj2wy2RCq+UClWpNstQt3n2JXBHrmbYez4gUTifh4HLHtRpzF5K3sNDdNG7QaF90rWLTXeyJ2zjTcCiXLZ/Y03WZQiPzljV96UgIK7XLdtR0FkoBS3i2e3TcvHaN9kJXkrYmtnTpMA1aKGUMe0HzCdkTRB7HUNwY0dvuHbphlHBWMsM6TIDSoJmk9OwJLztQabvPa/FxmHB0jdT4LCSFCIbcbbPbt3A0GFMPME4zQYJ0gI2VFqwt8KU/NzhnEB92uGj6KmO35RYsSRFAtyKTpkQTcy3NjIbhGmvkWF06gV7NH1sSzkN4AF8GkwUBGsY9Y7BH9sQlJawLGQ0GI1gxR96dh85JUQ+NRvkXU2IK1x/Jj3TH32EEvRa/F11F8sP84wpBEhXzBT1halYcaFhXphqKml7KcFEEtysN9qe1UbwxzoDJjxzsYOzJ4+lZRRPY0PdbjPCEylXYnrY4XkLUWG7GewVhF6VNbBVclXjLeudBEjnOisL2gqN1y/XEQWx31hZe03TquCwb9kH7HF0giX2pshB0gZbrfp+z5YTjfNIT4gfn9ve4j9uxFQUVBbKxBj2n9k7SV3IYM8ZhPVRcPeOdlQWJBgT3FquAJ+WxNgFzHHiQt2FbMME0NQF+ctw/SQjNogAxH9uH0LxnTYCFfO28rEnlBJhNMYvVlrVV42706UsbC1vCAUfNBRqB0+fugcY8zhCFKksljSAbuetlTF9cOVmBSPxkzW2vbHjZGz67ycFNMiZiElzKQih7HXBSDXpfUKBJe63VwPimBcCHxBZrhVdBeeaQKuDwwGAVjtBSG2cSAYeSGQ5QOBAMXA1gLrscLAvVYfwJhT5wIVglLCiBPpT13UwgOWcE5AcgW9v9Ki1UDYhBdx=w95IFVpgZDfLWxp1wQqVhuGHJAX0CA+167aB4YFILF6w18HsJF5Jh2u29yFT9b=nlxfSAzL9gHh22DtV3luaN0+zToN+EB843Rp/URY/ttl1y1/HIbrEnRE7drNmWFN/XoMJJWbZ81Vs/XaIkbQqw2+vdi/q3Dn9xs5rtqQPHWi8Hcq1COphj3CBa3imDwdYRlgVHXfyfdAcQtw7HscMbttLH4MQcW+4Py0Z/ylXE7EOkVk22N3Eu9jesT0sG/057gMELMR+T19jB+I7Qs+C7HaH7lkLVFZZVVvudwXPZcQpOjwIBWNU0ju1gpB3sXHQ8adP1rDxE4HdIQcHkDWgWx5A0kEL3hwU+e3FB1H3rQ/sHaxX63LYShB+A2JhNisqXmBAMV52VSFgruRoGXExFwoG1rgmYBRPNn/O3t+4WbtK3a1thm9f397WNOZ31IHNZPmKYQacIC3pRS1q2HG1usBt067RjpCVkYSlNO2NydwdR0dVYHwLlJcoWArALLEVd3lkCbbH3SNk9iU1RzfRCuG0hrcRL1RuKW4tRWRX=0kLOVcBZib24KSDT3s58wb82FPOUCb3Q1FVEGLApZ01FUq5jtGNBj8TPVT3VhgVRw7l5vc0+X7JQ3dYkpxqQ9YV9OBZBAE7CoGwNjJ0LksTgPlkuVjNkVyCIbkrEdgEP6ARGZhoR9hSAi5WUC7hezcZ2NieSpExG5iVQJHFsMkUBesEhSys0W+kaoA+n58dleA67Ex9UtxlHAQvVhKMrYY89RLRa1XS13yf0Qmv9sfpSVwngiXlBdXJ3WmlalUytPfcJh6LqZCa3lhBFE6cWawfXpqaYtdB9nw52iszXEO9xlUSGpdZliF/uydp2WwanA1RrVklVXh+msj2FkSwPrdZ6wUxIXXHhz6YOlaYSHpNwU6NVwKLdjsLUUIWVFR7tiLReYGBfsLAzeTLHXBqRwVG0lH88bvY1GZnS2dVQYHZicWbV79nRNSvdWWM5w3opWApFXFVclDM09ccXmTfwINauSFVVXVRrCYluXRHC9mZCoPHeWNYe9rdNbAg8zlQW0hMVVo+QqR3DHQRFd2wWUEHZzss66R64A5DmtbXldAVCbyVBXFbUPxtWRsgUkkUbDJMCATgUTmQglF+V6xt3HUxH4ToizR2zbDJbinaNUVy=1tVV9bD7THeNb5xMqHsvrUGoiGfXq8+CFhjEIwEHC3agT1ZQLfBFk1YKd+5IXz09CFRtrtPB/ZazNQVxhQFFc9MForen0XsQM9uwcwMGpz1RkFdeu256P3hHhgRj8MPzJeNpAogky7CQya6xZ0hUFAcMjgXQkYIbjaPgVb30IPH6hJtqxr=hxeyYKdVegEJ5iAd7QBtEHAIMyDCFYYAn/rRFItCRSsIYD+4ruk5PmlHv0ZDj3H/RWubwLZRF7WwyDajBwcssHkJ27dStfRncPGDnEy/HGg5TQ3kOWd8ZQwpzIBvHPLkXwXFnB3txAhluHO1/XWR7h9YgbsHCdoc3CN4d0NEn8nOxFIrA8FHfiQUYINcRUMKZW5kc3RyZWFtCmVuZG9iagoyMCAwIG9iago8PC9GaWx0ZXJbL0ZsYXRlRGVjb2RlXS9MZW5ndGggMTM3MDQ+PnN0cmVhbQpIRpXHNwOBL9A2MD9yFVIMFi+ura3iNetucRtgW9hTW2pYBZ8dIRMPF98B2lgORcdt/CUxJJoUPdT5oXtjcnd/GRXNbi0VCuXidoPTXcEq1b918Gfw1k0+t3F1/prAwIRdfBehL8TXR9tRXkt13L068d50pRXw17LxD2UAiQOtjet5C3fFVbbC8O9qAggMETiNjNC3bSuTF95bqQEz/zi/Zf1+HVhoqxLxh6FzdfrvRL0wp1y7U6Q6BbwuBUPRH8iZREQD6cS8Z4a5rNtkPKZq2Nqg3RBf6TcOXckLSF0+E7ux4t1C5K0Qik+LRhdu+s9rAaseeDb18QRNemtX3HytiXFHgTFui67bVy4n15FzpVk2evrPVruTBgFjAkU9uftnH3MEZcLrDzBfmwhotk+mDR3Tbvn3cd+Q1Xa7ir0Ql/Hb2VYE1SD2LfVkiBCM6BStXtx1/toI6+nrJXkFUREtTM10Tf1HXzmBYwdf68JCTlfb3krF1004hh1QUUf1zpbpaUKLYbrin9Dt9YRA/T0bK0Pd8uBJh9dRSpqYQFR1lx+cV31hJrHfxJ4d1ODGBEU2SDYmtwsxM/Rl6QWJYJwO3ragfddV97ek+GSJSC6xCmxQ1At1nJ1M1BmPEUtDtYNg/ZpF4qV4ONpDuV3cM6W1X7xj6a0kQX3zpOKYZ99HA/pTFgFV94i3mVkwiHtIHvxKbhZ8MVY397CYEVH2X0ewV4kaFV9hHVHN14H=sdWaFuIXE0NoMN6sSew2xXcc/CzlbFhUERDTqhDN0s2CirUNabwZBsLcDSC9Y7UFMYw/nEVtEuUcGacbQVptJT4wf/HFwp3xdCzVSYgTlQMQ8tSX1JMzpCp1tlawReYwrJNiVwLG6WbYhV0YSHUl0PWBqbVtlCz9wX0VcFAItkE9WT+IrlCTlGU3k9VUlBtdITkagfWIYsed1FghS2VaRBWsE3TK0bggBV0I4Zz6W1DNUIgtTJ2Fc9f0cHphZle1/W=1ENcH8WNXF5583aCwUCelgr1exdIeQ9xzVjJIMgR3Fk/dMoejnJW9BZuLLpuJ7Qh2hteYVQ8alVXNYv3VrHPFZi32F8A7HN2eqV7bjMPWz4RLthkRBNuplsGGsYxLTRtQTREZIVZKDy+kU90dKmxKDUSBzQeYT4/bTtOGc0GrlF+Iya1iTtkbUtMetgHLUIWd2FCEkU6+rjOHnkvZgdQC0hp2cbQRFkRQtgZnniJYzc5lFWFra3xe1F6F18m1sS10NOxtxyViMVxWH31FUMTGF3ZlDYg933Z6j3S1pv1qgJU0rWmNPY90D3bl7ThgHWJLQw2HQO0UxVUPUUN5QO4X1hrVabbetMMzf1KX31Yf37bI39gLzlYy4FUxB9jRBQGw9mTz0dwK7YPptMa103fZoiTVICi8eK+st1xkRViBMj5KIAUUR0EXz5oZmEYohCM09Kxjt2PYe7V5rZrHGDMlFC=yALHtQHIbvdR3XNTN0GVaXFVfGftatxkRZUgiDFgqoEDTORMTQYK/FPUO8dbSmK3B7f9k9f21eNUFxtIND1F1gBoxEPC5HbYW01dRG7q0Z0elhs92ut2T2U9gD1gOMk639lBQMFb2o4Pt15iBWWwvqsIO1ondRnEYVF6utl4dCq2OHIdVNrVn8WVdMu1M4tWFf6P3nX1lRHQ97oIhqjfZWmJLQOI1H3se1/URhJz2uUK76WSfdxlBth/ru98M80Cnx91YP+kPTVPNak+7Zu1TmiDhDs1oT6tKUAvLU0C5NwFvzprED6BcQzNrTzj2XHVQKTdfMxi24Sf0/xFiqRv3Rz4tWu5kNxU42MZR6T997TJaKAMFyLYKjpHbp9Kz8KXEngsEc3kYuT9rRidX9Z+i4vFMTIEQ1ljN9suY0EC129HtVrdXdoVmdvd9fQdD=wInbUNxq2ZERgwkRgpkRm7kpmEYywJs0wFczt+6WPfCRsQ1YTzUzcMiDTRtOWE6WK86WT4QWCEQWTGQWCmQWQiUlBrQtW1997dt+9jd4AdHGAaxAQNVQ6CXE+HVrHHW6xVgpkW8FY1RRy7Edx3Ed0VERRhqTuTETuKkTwfkroEvQgsfw4+Ez3XdwM3dCM3dhM3dTM39w0a0hsBhGAaxY+VsfacAr0Gz4RICEiFqmIJSpi2CYt2Iad8PtcjBk9M/VA67s4dOnXp1KkTt85SaSvHWva1uoXDtxTwVnwV3dJByc2HUTFNJOs0rJlHJRNGKxJS1VHkLYpc06jxKHxKoUQ6BaEojJRKpkp00kJ0YpFJaQLEndZCtsc6TIRRhk6ZRaM9oZbUwAxlAet5w8FQQ1FXxslXxllQX08gl67QIS3PR83w80P/QjIPYTP1EzP0ciZVYsssJXGlEgSAIgyiIgyRIgw0MQwNZjApJ1zUI/DMIwsJYCxMgC0IwBxtMJAnzR1ncINlIAojeTlREwRRFzpgSciVs4satidjw=hRoEsspTBNQ0sPWMvQ+0E+dPXSfHJ9dfX0ZRtCNjmtXX/dXmDOVtBOXcOWVCOAf9zcQCRxkINrAWISJXZJGZJTlewnO2qc6U+loapGEaHFhpGlhDlWQlCKFhdVviHmYRVlbJVlhZVkuVKsYgVLZoIVsjfYEbDW851AoyNV/Ny2kJ6wXOL+cMYXsmRcRz1V6IThDeBI0EzxGdIzpAesSxrai0R4gnJnRCNiEneQYEco1QceUtwJxwuf0IwIVsQTYgnJBNSCU1SX2VZsWVZR1ojzhHriHfEPOIesXlZRwwkDhILwUNtOJ/icHQV1Kww/Ad9BGwPJp1RBFKlU0cUBQwqs0mC0Y7hhG7u0LWX3n8GaqhSVVcPQBCgQNQ0RSHA7Z81aUcYAxLYi2YajkuNUMVd1ZQhtCgUpdInlYFVAxp9vYcVLJNah6FXnNeeoalVZlVkqxXrQteEvVbYQx+rHj0eT9dzd1AYLk7c92FxXbCtbUMtYS0CmB5sBhH5dq2EqwMSMz0MbRrOU24v9PXxh2PwVN1kRFU4nRYM9kE+uW9/HNLV7CBFFEhVuG15WMK2S29gYT5zq7djbrQEU8fnMGT2Tcs7at1nsetbpipt1TrPw4ODz8fcX9ZXrHg9PW7tTG3REsAksMsKVxcQ97EmAlxEqQrW5i2iR9DjdBEadg0dQqzVNGnsLINUZOWkGFbdRT05CA9wVFJcUmR69l0hgwwujhKM0dqg5OUy1F7VD2XWFMTeRU86X6XW4yewl/WvO9wr6YlZbZ915+1CpPZUsZL8l8cZRAgMxSIHskEDNKpoHsiKCQDHEBMFU7jQx0xAgOUFo=zUjCrNMm45yU9ybbrTrnDltrlOkpwZA80qJ0NxbOVda1G1pOCdQr0poSnlgsC5Gc1lSZVU76zhrHiFHc0Ow2kZcUFpKxtgXnzfBFYPwQczWb051X3lpqgqeMF1oFxzS5sdEzXGV93GxECWd5FxmRlUNULVFIwnNRTQcQlXWxr3iW8PsSJHLFJGTxq0VUF3Hv20US4HQ/uIXsD09Swc2Fe59NUWg566wdNNUYcR+OSzNIecHGQtzoIgW85M61cW2YcOK2sStabMeLRoRJQEL5mVtYD029B6LWODN1kNNWH3PoWjXCCntiDkeYQBJNJjk2qAXWOcyTl83UNIGUHxs1FcV1zL6R2dkOyfXZztHRtCQkmg1kpYTc9MREQB90XWmN+Y1UD01vHIcTd0QKzog21liPVmMFVH2EnFokasOcydhNeV/bH8tFOYSE3k17T1xMxgUFMIIfRgmVoozSDdGM48R+4sxiZ91ZGiMHCja0zlLA3V9VkGCbQfTRiUMN+lv6JgsbzhcJOl8lWad2Xqdltg6P3iRrWbBpXrBBGWFZMxwiYiuncKsQgHgcO2w/gREH0g65RAWHUlAQgPDrAq13BuA3EPOOF0UItOsMbGrCt0MdRdudkVi7iDQjXj3XIEvXSsPH7UM=3JyQ1SRN60yLnVQ51rUGlkpHMQP098wzTRUFLfM57SBXQuLDEfXVTe7ZoxTbTuxsfboBtwP0RXIDe4sdPqVFaIQZfT0QbmRnzXCDkQ2SuVgkQQEuzd1UXB1VUcTgwd83AMBxFuNN6KwytWS9nA2FZF3c4tOpWVEPnNHFi9hDC5yaKgdcupXE+rVxAFJYNfaSkt5I1Ek00UCrX0L9qV8Erd5Egx3d0/VE98V917d9n8N30UtlBMS9HC9wQ2nU2UOA2cPRzt9W9uWM7fabZf/1jXD3SpPMrTJ8sYPppQZpmPqpAyO3MseE0gEZQWgiQJuQZxHQZ+1VDLRsp40SQWIBuOKw16ZhHLHL15istMSV+3MTcYidbIjtOJTYuRUSEkQ3sO6bkW6wfUY2TXJLyx45sDM+CpkaHhk9BQ0aHhkIGCCtW7UaqHYpVjleTR9uIzaY2BrZGMcBU5E1hYVV0ReloJ5h3XHEP3R0a9mIwNcG899wd/frOphPqDdWFjCQerwXx7YT4mW8Oy98etJ0lR9w/fHh9+h4QHtPagWQdV53+uMMvuQy5bn8l4TVvENtfrlI45NT6FX88W1SgZlsbETn60io4pBobagyeCFZ9mMCGsbtt8GHfVfVw0lCxHL=wPdbw/3Dd9VDkac5DTEddPEUsQHlQUmQSOMCQ90+TgwKHLTXGMP7bjzMuaZpIgc9kERPE7rE31fS1S1WCFXN8vEaQST3euXRpUW8QUwrYFzJLxUaf2rdWxFwSyrpVywiSCo4Vxg3YVXcHVVOaf1kW6sMF0LrAhh5wWgAw9RpdtMtd8WSi8PBhMeekwxkExgnKg5ORNEzgYQZrbHNCRxHE7UGJWBHVQ7XnCIwWAxYmzJycYXrG4xt6fF5YTxeogXHz9qcCTk6PhZMZr0H6HU6rf383VBe3OItXEh1KIRAkRVnXwTfXxffTVZZgpmeXFQxlbP2J1V3U9qNsZUid1O1GwUF5LQorLcLFsEhdkKh9h4T86VhHVasYrMRqWhVgLL1V9GlbeXxiJhiywduWa4jEzoxemZOJ1InVidaJ14nYidmB7WDM6dC7gN3lN+JoX527UYZbE9HzheSF6ZXtCwvoF1doD9t8xPbndA+2N7twENxFdcXi9ML0QvPC80DM30gCBkUTw155Rr8TvViMwUTtztm9355PTGreyQCvQOX4Yzj2D2eDM8K7UHBXAG7e0yhdBtT5ARm8GjQ8I1l5Cf2uws67qhdyxF6fKZ0GdBuFPdwnry3vkZ25FOdFWqxdvZZ=n86FFQtsqqRpWVVAq6YFczngYbcieRjEkZNELOzMbGEdW6eDNcJ1SHA5uE9kB15pOAY/1KZcFqY0QSNbE2cjBHk1ALZShBCsTnO2ArQsZD1VnCti/pocHVk0F+np4JhPtRfUXdRx12BBRrUb1PU7UbBRXkgSTtmxYN8sWzXNRrgKwBcQgSAY/R1XLV7EalYBWRQcxRvoF0qGmmccGC7sySp6Fz1aSmHIVhALFAoOtlaEqEQnF6EXtUXoE9ncFwrUERBZXYSa4zMwYlRjgCOXsRNs9V1hZoBNeG3Na2RwWFQE0zrZkSrYdRe00NbGFCQmmy2KsRiwtxpkBlTFMkoxwsYYwosPTFkCm0+lka=qexDM9kD0QYU16FgC0UwNxUHBV2lzG9nO19m0QX5m05VPZ5thb19Z=6kayM3XFF/UQIuSk3327awdsTUYxR+FgRaFE+0BREV962nrlRZRduaQRx1jCr1DNAli3vatsKaRXaKsRVqKuQV8cvPaLRpVz52Pxo/cGMre0ipa15oKz2mF18ap3vnL196W1wDC1SdusK1x+nJby+cD3FQxEMMdUJTbREqXlXIR+QK9teRhHr3KdIzmvUtFbWtDt3lNtmmwcXYkpRbhvUy6lhR317BbViCwfTC9E61l4ecfd/ffHx965EH3e1xY3n0pxkPDw+v32cF9900cV4uV5ZtkxQak3WNpPhvN/lxJXEXAihKV9QUSc9hQlHc19rWVDqwU96AtgHjQ3HwYkctfHHY3PLdBOmsJR1q34X7LGSsMnil8GYUM3WLWXmDMWVa4hRRjdSftH9puXFYRe5ZxztrQXlDb7duBFlR2242ANxEXEaa01BbWrc0LNcXsFCcIGGoqzFDSQo3wWN7SGEfDhhHpkrLF15QST5yQReOo3XncD/NIYR5LmQZHT4cVvbattkXVkuNihkAxw3QhfJqfOsPQj3py=ysMnF0cmQYDmgKRIeEiAlRBAk1rk3D8QVEIgSZDAhsHIEwFJp4=n9uLTdG0mCj9BYM2Ay6HYSAdCISkpDsMKnBIB4MZhEvJnl//Kdg1K1bbbft4FgYn5AWPE2R1RQcxkItjNO18EFTfz4G1kesVsWZhbbix8LCwnAzcat29g2Ubzn2c9dBdk5Xxlg5GAntxBJrK9aXnAVL5KFFIlUmzIu1KZnINrgdMbgY8C1G2+1YD3gCEaV8J4hVHOQtttl3=xEqRxnHUrbNPzC0n4fIKDUBCiIF1FwUX3EgE5Yt0NRCvYaMQkVTCtgQRQwmAEWIE79fUMdkk1na9ZBUITemsNlBpBzBLEZXFpypRsCtuksSJ5KUyoRixdGt2sRUb3W09etwIEvrdAX0P5CbUTzo1qxCkpwscxtrQPQJZK995Ec/wk582tZsa7A0cH45PjsRiCCBLTp0BFOYuB1gTQZbiEawBQViTeE0VtguFdhHEttQ0gIpkJ1qzYUcmQ0kENAGzkK15ttbKwEBfWFMmxgCwN9aU9uL1i0FLRsSuYJ7HnTou3stdLcDuTdCt09xA8XcKsgPT1HxDIp+mFRJl6xEWrB1sKATd1EOQ0GGZRRIMdQW89QTO49UJicZnVUaXtbYaAUX3VkpE8aIrEViCoOxRkg2jDrQlmWBVhrGKgRQisCIETEVgFYFxSH2kOCW8l4UvbmleElZuya1pPZfZtXOupdVUJxzrs1sQdkWQwih7ATdWRQQmdxkDQ3kUJmaQRmNQFS2YK0a2cuWsvJD0FbR5tQVYthi11hxPwYVT/TJWN7BVE0NR6MbdAt2U22lvHE/9gRcFcRIBwM5nD3Mi0+rT7dbmXuYecWZelfTWlKLElHMZLC0MVHwWVw2Ikb9xJ6SVmeJrJCo9gdCUVEiQHaxK67aVrdtphitl5bynOUo/AnEiye2MUwYQUYXEDYmZY1kQMGHzNwwhV7Ew56al9IBenI9o2FrsjGldQVkUTDVAtmpf6fab7gFX1lH3LFhkT1hRhUTdUYdX0ox51CovTTsODvMs9jp0sat7G3S4WoH9zz08k/aEAoiGo+fErfSVF7bQNPak9Ifa1U036Qe21wYQIHq1tkT5DX1gD18+6qubVQrU3+nD3peMzX9LtqQd8o03UZ1CJzwHRwfzEQ8HenVSGWSxp151djcPVr9fGoe4b3X9aDu5g28Zy3znEO0Unrb1sJ=0gh9Z9Gh8ffv1j+FwMd/X30uu3x3nXL81Pfzw+f2Pry0Pzte5qe5/pwPdCG1h9xPhEYhWkFncMAs5pBRLPzdGc2LN2zorbscnW8ad1gdwJ9BUWoFXdCKmFRcbeQboFuO+127hhQHnjuM3tVBxemTkZWjdv5JB2VwZAHRkVOqX4eRbvHbQoRs5HUUeX5Ew6wIFEqrEY9ttyLVwDewcFH0PCT1sUXuE8FosPxxGZDCeB3txNiZGMJlNs1vNGcUoWFWeTacnPhWyVv=1soJW9MtVdWLFYnNqsXqzrEb29qrEKVct9zNUTUSjCmPE95tlDb1iBJ2m1lO7HTV2feHuzrtyiUUekNt2r8y0+rhOXx1nLm5TWdEuIxV5GMNsK25QKsLYuIgThHN1p5/VxcJgpWToS5wJWUYkpoQypg+J46wQUDhxgSyiNGhrHTaxlVPR3u46RoTt3nemXj63XPgG3zh8z0FDV8DMw24DHcEDD5hZz9HsS9+PQ8Bf1sW9I3FI1jFw1uU9zLIW/T3xtCWdfRJzFX2IInU02kva6tEscdiH8WX10RtwQd1kVatgfkO3YBcal9YPAQPqW1EzwM99krYHg9VDf8C3BPQVnp3MbR+0BZTTX0GXj+3DJtGDcMDI/IS+kPpa+EXXEUM/d0YBssQf1qgK0VRS2FOwigMQhYSKC+0XMFL8H0JC0INyFWGhFuRbSoa1sbEm5JuCnht4bCUPfm5OuDiGxRpUUh6FCU9N0EZO5SalSG1H0HpLQlbW1FNpzRHlq3zlCUxBJ1TOS0FeJjDawW6W8Cb1svwMUa2VQUWLWTGY0g8km4WsGPNDC9QZa1tDBW9l9KgHXXCxwp44h4tVBGa4kRpEY1qKZFCoH7fYK2IbBcE9CJ+LHFeS1j9esTaKT4HXMdRtxlJckC1zvbq13ajs7J10lHgM5oGknIw/=2VDw02ALJH0KgF9TCahkHdzF5kraUelgp1YFZhRdGCU5x05AV31GAISqToRfYl9kECMGQhgQhYIlmtWGSgFgM0YEB6D0lVAVk6IBs5RFLHmUqQQiSypB4l6WGdfDFUMJiO1hcM+EZUo5BRBBrbVGpSxF5ZlOCinNX2TE3eSYqNY5L1EEArBJaAVB9EUEothN9tiLHSgR4FQVkItuQV0NUTSynItgsoEU4SUxjEdWk40VGQtZB1EBooAglE=rdlkEHPYd1q0bhFl8xA4VjTt0GkbNQtRafFaTrhalkaQgZyx5mK4StjFpd+E9XtU9z3CnjUDB5At39ZwlZwEJU8hT+k7/FktmlPzjV907UKvOB3+kCp8sD6Q96dtiS9betdh/Vrzg3FZ23pYs+OxlvYOp52ca83EMRNqRWgsTmi2k0+OVi7Um1PV9g/eQRFV5FMLNdfdbV4eE91r8d+wQzETwN9iXx1wbHV98f39Z9ztEtsjfW/67XFiUvz0x95XrZ+0kQfK27GwT9nU9G8dE2h8RcVBoYOM5PtCVX1vSTZ1O1StQVmlW7oFdZXMbFy8XwJX17gf3uuXFcjfFrOlw7pHQl3duCttWwIvtA8e1qE+Z27Hy/HCcMZ29VsPX1GwFVFc2Ff1EH5LT3PGfdO1zDVuuscXt6F1U4XlSBF1VXFhX0pHmy2V5BMdzV2ID1cCXtCdwwmg9T9Cggadt9N1WLXeBMCNahu5CdIVUEH7CIWMgd0F/Dle3PXhOQNfXBWwenO=z1VZ1t7g348PT2IlFvcZ0nhImANEgZ/DtB30NtsAZP2ZBL6mNVDndzF5kraUelgJ3s4xc6wQIjaEGBBb8CksbgBhEICEQVVgQM9wFBmigICsKORRp0hIIQeQA2V6HQ1BC0wWQMlUjPhGVlKWW0ZbF5VS1GVScF4eEvMuJuckwUYw1URxdxEUbTdRRQAmPtsSyYcDsEHF2CpgomaAgSBNiS/bJRx8QEzjfewtPp8krKNOI58u4dHFiOdc761txH3FliO3rUThJ1U7aGMgjVZTysMRqSoIOsgqywMA2MYXmQWT2If97BIS1aPT9+CXEPTesDpjZG6xWFXnSNSnBQsYbbcdZZY7VVVll9BWfHpicDDMGaCNkQGxnVXEdDYrRmstUXsWLFRQUkYQjYqNTkFyxbkJOEkpMwFohEF0RwgtkrikQIlfVEPNWDa79=xNiS1rdt1LD9dwq7EBsFT3l6T7h908oB/28F7lB8Lxs5T8RQAkT=F54RtxAyd8RfnBjsYPmFgfQM39uEDWURV33aXNDBfruNt5OWLcljetEYM1FeW1PB96aQNxS28Lezk4aDzC1gKPwVkPzCNmECDnQ318pFNhMVS7YX3dFzw8MaPk18XnpOUb3oen5+/LtcCXt8fH1sH4af1n9UTT3ofC9RyDURv0KibWQ3hAKRG1O0MEjksc31Hdq0GrH8mP3FEOH1iSc9jhKrkx56XItQxEc/UwLUd7G1QWfx1VCMR3krL0EURtLh1z/X1RfPnQVSw2V+x3Njd9hdenA1np9E88wbtxQ73Ew4bSIKBWVyW/kFc6Vlz0yY5fbZumO1eGXnNBT=rk+xsCiO1ywZdtXlvBYQL1EQQidU1EpqS5Oe3t67qd++mrCnvrRz1IN3w1Qc0zih0wIwLL196/RsH9T786yd8EF+lVXdsRBNM1rFsCI2sGF3mA7NFU2Z26QFbHCC7EWE3jOQnYPwnIwtaGAlPuLlvUVM9aXcERmZ9s96UNjtDnUEJYbWo2s1eZ0JqKxmu0gtUKsZFrB15bZzZWRdnnd2tvYXst0173BYAyMrllbllk0RW1jtCtsznvCrHszuyACET9p2W1sUIKdNnO8vbiU7a2FnFdzpBTalIjK2GBJQwAM7SllNCgVterTdXT0gd/dMODdYdvpmD2rHw8XsGGFw6WEqR/QVzcY1hG3yDcqYVlrJWqvB5B0sWFhJT0LrqapralK6UooQtc9zRFhTl/cwcO0c41nVlKJzOuedmtS57TOWVTOyd3SQ9bAqZ0typDmrl5yPWe7AjkDPNIP0Le1z4jukP8AmwFIDBEFUBW+srIgUS0ItRo4gcaUBQRUgoQQkbUoSC0YcFVgd7bK0KQi61Ok1H1FBiEXkChER1wRGKCFZUqvEB03fWU4sS3HvcJxNiJ/18RFeJ+4Tic9T1ncqgTY1kRMXxjf1eD/zi3GAH=geYX0DN/bh=1FkVd922Fy2QX67jaTli3XZl91GDNRXltTAemkDcUtvCxVVOGg8wdYCj8Fj842UQuA3gT00Eid5B1YT0ipsBkP3bE+/esH43DCj5MWF56UThG96Hz5+fvy7XAl6Hx9bR+Gn9Z/UVE03t6HAvUcg3Xkb9CrdWHhAoH5mS1sHJS4B3eRn5XRrYF7UMRUA2LikEOTkUoPZHWUbDJJJJkEEOy1sHeX1zAsY60du1sZj2rWc5i3wKc4xiBzMEJ4u2lBDteKUGIPCwhjnEEQx7eUg3GxK9iMRHVpsRiRLMl/sOQYFQUET2JgJkswBVwZAE0tki/BNJy1ZSeszftfH0+Svwik938R9J+1v6Xp2Q1irg7QPbg3TWJrxlxUBU+Y1XkqyzzFXtCPnUH0kbWlxKgt+yUlIiT6Jn9DsLfkPhH0ZLQz6H7EMPg4eIQ8aLthAzA3F7U5Lw9xpArWfMeWbCyWwD32cs4mm+BW14RyiwdnIObQRstwb8Hr6t+L3wV78aHgZwQPHphuwW7fegUDBuvZeQ8Y2MWZSNbWc/yzdUdVgO08cZSlZDdfhVUbKHEbqcFQTZiRw2YOwYO3+EKj5sekQK19Bcn9wTOsfREEI3UaHbEjdEwrIx9Z0NZDtdhO0h7lAbw/WQOgX5mW4KTtjKNw3taxEQEB0zAjUJBUe1LDEtdU6uGMISruwJiIkGFZUz6kHCorgueW45T6pCYMYSsu=qB4MiMxVQJR0F8Rzuo99Q4M0qK2EQDUdKQ2AVLOEIT1iChVRURTWoFQf0xCIlTMmxISW0CmsRAWHhpjtaIWTe+NYxJaREcWGgTD2QyQatELGvCb1VYxJiRjOoGgt1=8dyJqlliBVPXkcOSPHDRUY6FBJE9RSRCQSfjhHAkmoKQpVZ93LahlSK1kMEKed+MMNgk9psfLLPiU6oNciwURrhiK8fnNHVlz7zHkT9F5EYBNWgS5JQbHZlgFgtDQylOUVoRMU9YIXdLQ3Cu1GT3EvX1LtMkEbStNG8lD1slbJjLaJAttC0kbwVENPUU7UHwTRVRQDDUFzVGgJgpNDwxSwhFWpicZsQ3Hdf437EPBh23E9y=2FRUz6BeBM+VPZTpJ20oHKhdWylrm6VXCrT5uVUJV60+rZ3qzmtOm81u1LbrV+3SrD9XagWbDaM7c6aN1l6zitCwi1rC2NtZaW2Brx2tdcOtkrWWuTbQr+q17bUdkXd97WxPfWntr9oIattgEwtFXXUtpFbr18wh2wV1BfYLU9FPQBdTlR2AjbQdHrsR02M+Yj1Y/QxXTAcGK/wVKV+st3acJcw+oRqlb6X1534nMTrCX0kQa1lvpBCyxkYUJrxBpPDt9RedDUAScvHIBI6U0hRCpPDTRedHWFwLOcQCQllL9k5lzzhMMUEbkPQ5pE+dNGmjfedpILgROFVkB0JTfYx08NtR4919j3ajQ3AMCGdRJQiJHdOkJ3dtBa1t0b2VjJlFaODRMQmJHdW8J3WNB61t0f2QOJ1G0OLROQ2FH4JcsEzQYL/aFDiUZGEkSw1xCWUxQW94Q4L/8dD5yUZIFwSqgCETpll9EC0W+kVB00lUTM6gxJqQ9HqB4P15gNHXYSJDSXUiAkENEExeSgnCwUEw8kDhXMu7M15AIQXpI31Ownc52l1uVBQsBNXcXQWR3dxdBrYV+sbGcbQdDbRv90NzHWwr25V87EC33QgRxdSfQi7YUY0PxkgeUAcfUnfUqhhWmtkRkGXwO1ugXqapbTlqUQUlRRVjBDXHsT4SEVDVkMJw9RNSHciW+7KmgXW96Zf0/q66+uI77bXXX93i2mutsxZVRiB3VQ615VUXVihdS5ahPrtFMvfaqRKUhqLbTRmwnfZqBNDHYdmLHKNbiEMsKhdU3Vs+BxFBepXtR8UfzNFxTrURtFsSEEwbe2UiVEz17uTtat+gEi2iB3nSl1lQ5gaHJnBu4U/wG62MZTJOCaega9tBFiUHU24sXZssJ3bmUPWX3Oj8bV8t9LYW/r9D2dHUjJpYVV7KBMbT1xVEGrNeRlBapDkXUtwtYB31OQ9VRiovqWLYMAb29nrUwRNMJla/ptyQWm7NYa9r31AhDLRqtWa4Fp+6XaleNCVePdwflEddqQbVUNahFDSoBT0Q91Ja3q0FTt71WVe0VvLkpZQWWBTst7VQ3rW9oR9mYd3lofUVQGnUNkGU3OmY3MZ7wUZPNuxss2wxRjLkT7UDqbn2nG3HPtuUP0XDsuF3THHEWUl+JqigioOUEkBrhASGdIqHUWkl7BhLqPMgRcRkAv0fDCezcRWUFZMcdXTWsM7FDT9Ys91QbFxH90aPScnntbHzCSwkZOk41zpQwSziUrgy50LsHcwQWYaxgHVxqseC/c=kHkyz8O3UHCXpYIa5sSMQVaRYdXtqGHRhQIbqQT7Sdk9xtj9264WY/qXEYgzi1n20RgprcSBknS37V8RSa7G1gkz3FkPnx68z7ZN9bbFvSob3TiGQs=4EyR179YlOsVVRfG8K1wcL+gEaPNBB0bn5xEg631gKN4DReyQzBxNdaJCg9HRdbwbiwZiscu5zt32g5C3Rl5O3SmPUJN6ctSWlaWmm731f5Fg2v6/UfTWt8FGvdRM31wRhP4VE6Xw+H1xPpPOuF8fP323766fcC3t7tn8HNxU/d2YTw9I/f0LW1Hd1z9x2ndfe5r333tu3t997UPNz1je/O1PxOIRpQNIk5mA8iGYG4SxwAQIENyIJAhJg5gsCRiDqGYQ1gIzIEBgA4hMxA0mMa4TyBWZQgJPIECBA6hQhI1qUaIj2ocgZlLxEGAhQ6EolKFWDWi0o1oNqZ1DuAoMgMEDgVolSFmDy1I2oOsZ5D2A3ogQOIDFa1OGoQREORD+BRe4BQEJGCAFEmgwoWGuHNRBFaYBaYBgERGSAmEtrYIS4WIwMhNjNEZ4F3EBLHAWIkIUoa4mQhUh5iNUO0FjgIARUb/EiQNAVpM5A4B66IHnBL7ASAjI4QA4lZFFDHi1k0MuZw0HAj8hIUED5FRCVjX0M5u36UER6vtV2msa3d3FBpfVlHUGNgSmtSe33aTkgYmgybeZDt4rhlPLfNxKcEBkaaW5SphVHGDJGVog9JjiPtPcawT4Rl+MTEH1RgVs1fKt0g7k09RBojQzIUQzNMGU4GdMjkjcFGYRQ7HKSNfVkF/XqrQXCmegCx27U3xz4Syk2A/znVvXRsOtlHNVsbl53lazu5nicOXEcXOsks9wJJG0Vh9EF3Q8f9fHFhJQ0yP9zJCGIIHdQsc13Qqmga1Vd1HxFVODjUMAcNBxkgGUHpVwdYYDigbyBaDFVHV8zHDAfsAsYP0BroE9BwgIUFZY4M6QB4wNhhWXaBMD8Vb7vhSWRaCMXQfZjdcFlVXBUDTo8Th8DVsVOrb2MxsOBxdsMEEHFWQYEF7iGwHrgzzjb0dcMAZSNinfcxLFJPfdl4UZ3Bo9NLsDNwc4wnOcHBGDgZBUczQgd7KHtHoPsDzBTh4IAMvpVwRwxlS3fQQgCNvYE+VVw09qnGiFePQ/Hg3wEbPMJ8vBhaG1NwZSO0tw6dJFlH0/wbs5eDgDL6dV6UZodA/26SBWASwwwXE5eEADL6lVCUcoeQ+uQgqF1QJE91Bgk0cwKrnefcgtw7iGVQRE9yngws1cUEKrneLQ3BB0kNXbnBXEaS1ISWkN1tiFC3aAm2BhI2oSbilfb1F5QtxYA9pwKDhtQa1KDlqZKsVtVtIWkGstsQ5abFsp7hvUM2KkFabbRGwr4SUiTAUFMmdi1MS0H/XAg7ETn2HLEKT0rYkKQi7Q5VWlVJCVaNSopV1K0pHM+xEjLkGwbN6VHJHdbusYCNDMlgSEbQjLcBl+WJjr1ppaT1rXNlI7FZrt1h6fxqa7dZt8KnBpJT39h9NRISLptlu1vdQtwkC7dF2Qgfgq+0FoErKrgIxdNc8ccCYWJLhHF4i3F1Yu1hjsf9cIM+C3UXXIIOwJ4FxeDQ9jDg40W8dhI16o6ScZ5rrW7kmEd9GWQnGPkqGIGNW/iGCl9M9lgDlVqVUQISoc=8ExDxwzCi8OmDJ22Vpwy7O+l7Ld5XDsZxwoyQ20QGWaDzXAbfEQpIQ51W0Km518ttxBz3ND9Fy3JRd63BiKgKnUCQHzpxu3c9twd+QukcGlQYbCQ2IHl1H3sCOmpCjl2ZWPd1wwWSkRnRGsM1x140Y7BgS8EGXFHEE6Hw9UW244PwJ69vHcXcC6XtA3zfdQDIutaDc3AjFMQ9PwN03vp34EetQ/Bnr0wgbuCnT9zdU7qFIWcg3RBcITXCnTd24nQNeCwwxlVWlyYF7TEFLgVU6AxV6Om8aOzET7rhKycFg7HVRY4T15XCXVPpk02UsEV3m0sd0UF76c9iWmq0HLtW9QafMPT8GM4O4dR+tHXV/Ucwdag/DzlN3WR36+NQUhTw9e79l991B2ERlWThkQY2AzVs+XVVN03glIwdj9lYmNVZoZNUHaLx5FR67w+sYQm0tcOMBg9H3SwC2+tZUQwljhbdN4JWvhIHR6mQ1X4m7Hk5UJiAd7TNYqYwtp4VoJ8+cEPOav0QPK06Z/tVfN6wuvLL399f2/21F6dMJ//rtdT1R0+h319fP9lvzr2NXtfT9Hkk003jzL2jUBJZk1LaUgY1TdMQJxK2UF1HM2Ol04aEUIk939aT0aAhTppEZDF1hg164XAWbCcR1yo9NVte9Ht9/X5lmdY9+k9fnTNUcz4nlvVgxJ9aOWMfPwJlPdJy7z2PuF0J8cn63Xd93xBj55M3wrPftwN3Fzk3X30P9nXzG1vCcUOAZPrgrSu0Y24QKuV5ROvBVil9TzEwVtkNKegmHsmGX0QL6A8cVrNaatnm8k01MegN5DzvXXVhjK1Gx=ws+xJC2FxeCRutbs1Hki1by3TOL9EszdHECZhsEAKgwrC18NP1qk1miN0xKq1h8Lcl5NViJgxdSRVTBAfEXl0sRgbJwRV+s8MSAraHFMT1F5GgR7ph4PXf19PUdlEkkXqRfgTkBQZnrR7HWA11kB/HaQ5S1EMGV+gHFVg2JjSHYOGrbCwnJECzLBgSxRcED3LBi1atGtH03LRt2oUgOv0ad93asEAYF4l8YAc2YlKZFOkW6RUbUZgQluNQmCosZxsIexhXITpqZBFXUYq0nNKqhFLXh/Ao3xF19O6kMKixE57PelZB2CBKxEwHhsMYkDZUDwIaZzigwE1UMCPZA2hSHXiVq11llvwc52tsEuT9DVEgUNJpwl5pWVx1jnngcnNLrm7sYR0ieLdddieNwJF3lwxsDsDAT1/2a6p2arrQibW6qu3V9c3LWAuf6rgS0Vngl7cGOxU1VaiDdkWXmprXVedVhqLXKtmoTFzTuyk4MHLdRXnUN7TDUfcs0FVdPRV+gofSz/Y7m06U+0CVnYaw9Qp9j8qQEHAdVFkD91w5wQMHa7if6USxaDIAxFV5LdGkg=lbrTU1xASoXrTnHixDXe3kq10NYnKtzk8YdbQ2K9etcC1kxqtR8sNbj1gt09WT1oUFhVttQ4aRkRl7QtbWAaVC5sWW4GZoGt0EOtsFXRMEV2U7Ss0YNglwQj61bupNFvkXk3uRjd01XBzW8xVFQKxsK9gJ7f90+2JuFxAP=1xaReFxI3hla2PdsBVJG1dLaxNWySoZALLRpMKw6px9RTSEVUhetFW0SagHtQfT=+npPHDcMQp22sK2QtKBWJZNwmAworDCVbsRYDIhP3xhniHnBf3D3636gp31lToHfKax31NpmQZ0De6CVTuBQTxxHiQOrp/o/Q3b9llP3kZFXCT1cJ31fJYquk1kOrw3XTwBIQLfHd0KZW5kc3RyZWFtCmVuZG9iagoyMSAwIG9iago8PC9GaWx0ZXJbL0ZsYXRlRGVjb2RlXS9MZW5ndGggMTcyMTI+PnN0cmVhbQpIRUT3ncuBE5P0F9T4YSC4K6cYGAFEUgpyXuS0B2MBLxZ7iA9ifH/ksWBSSzZpsfrLF6Ey3W1IxlQ1RQDzlTCmqg9udA6UMDjKpfsdyqXok2n1lxB8Ll/Wt1DAdlzffKjo8bXtFaV5NW/JTXYyX5UetUay0117GmOtRYQ1FQVVtNFiUwFPRSchlLKkwJRRfXLE5FF1UikOeRg1VvzmFMecxoBW5lk3WWWQzNWR1LGMexzFkAxTHMPtDBYyR5VdMEVUol6rUkpDClAPwVkIF0UwIMTUMdyn4V5paEccw1UhN1kMDV8FaVsDRHFgNOITkx431xiO0I0MuWwxECqkwQ1NUL9HFhEwSTwfdw64P9VIUfBBRsMpCHkXo9t1Bj6zw2x2PtHmvzmDYm1X9HrUCQNlIAop9xMbnYTC3sPsLsurA9LrEGFibrAkP5OSwXEEgh/QzOq6dkWtxeRrHx/QuFoTpUnlD+jF/QbdTwNKuRW9dsUMRw0Fyy4Vt9j91+fE48c+80TXCndGyI89O0Cp/wVU9jd67L02W1uz4uUhlgGuKOEQNlbt5ecRgV4eRLPRkIRSdkdRpiHNag2kCe3s6LzT3NcYKvY4hkaBybdlg2MS5pBhwhZQTwdl9KlCL18ZSQ5G4VUaY1EEPWBnJDOgXkmmNexpsFeNUWli21AWR5sAh5kW1F+JjtB2lUOlh51EDIypiQcaqQVtXMmlVBrlrUR3lgG1F9ExlwRk2uqQ4zV15RtS0qqEcxSjrCQU+VhXf0ZKSBAhZ110FiRwIpJDBDBj1UUMVaXdZACliwEFEVYICAZKFKBJDNikAakW1sD2wIJgEkMlAQq2glvWAN3LCq7B1tEFACEmWgUQUizYgOCmrbqWMe/BEBOAlYoFXFZg1I7Y0MaETxILBKQLAHNMhCtAtZmRKYGVsgcGREBdAtxlUFwF82IawtZwKLzyItNvcVsD1iGjl6VsYBmdyp/nFeRl3Xj8OK1kFQVsjDnfXEDTbtYHn9Q6R9ELtI+jKtpqdVUQHJ8vTXtFRyfHEkEtjXp1gJxX3QnNgpPG9FXsvtscgTk9uUgo3qW6VLSpUvd96kD96lxTrVRmrfqxK3q0esprVZbe1e=19QvVeU51WDtV7lwG1C1SWW32N06U7HtS9ka0cZ1j5U99ZzaTUL1pnFPMRJR1rbyvBtREM7l0tT5hDFRcClLHAQodyDDERATW27rVjIW1WlEbYdrHARde58ES3lkWF9p3mUUJQYwdAjlayytNCVgxGtR/02N9VAQdbs4z0MPAWVnOFiAzsOcA7dB3V+4Rx6Dw08=jl0BjpTQHYKU2EGKU9lniDWJcRhqwLaZz0FYgYZM0mYUcUaPGZoMVNkJgxWAlZCwlYUkRS/NYTlSNeJm0crtiBjKxJhTyL2mUDHZLgSMm17BL31UgFwGrLdYgViA2IBWZ+n20jU811SXUdcUl1HW1Jb1pSW0dZMlvbWDJY3cgTl1JW05ZTlgkK2dq4iwK8TlNxZlbOgzMnI2Ok5EpCEqEydHD3M5GW041C3nesJBvcXtYETJHfmFBaAx9w0QbCUYRs5xKnh2VgTQTEF5UODEqO9Tc00NCe1lOEsemFjhVOFmI82VkStbNJdcQfcC7BsG86TiEObho5CiWjK1dCpsBO1rOM9Roy1F988tCg0fO4F9fWV5L1tt2V/1tTXA9aldCWJKfjFa/1fkGhaLdJXR6Td1qF7ttLzNQd905eWVdD0J6sQd3p18XR5I9fuOLL8eUBCDXk1fkUbVt1YdQsSF19udaSK0OD0MOVfdsQefW3fF2W39mVx8k/Q7tTLQItfGxvdaR9ag7tg1x8awo328R/TbuJ/sR6d0DB/tWTp6HXEFXMEP7fd2sQYLRdbf0e1sLeY7jF6u3nae0cY82LbOjxmjlaxFc4mUH396h7UliO16iDepUrsIZVFF3699sdBXXHu1vdPUgb0gzsTOwUFmtDFitVfiQ0hbyLdUT9R=LfMBcOI+tn2qYvtlRUOtn6n9yItn6Q9f1PZuP3tP18+/UjfXz/ffuunbvcPdHVICXdGcJSAlD5g3xbH1RPZVQhv2mMvUle2eKudc9xNiAZ1JVFwQ9HGu9VrAJncMRFcB5mU2NwQDD3ZLQ9eRgTg/ZPRE0NRwPHdYcjxay3CDXq5lCNYdDlhq7i4/QmTlaNdazUuwfWztqEFNKhZCdRbIMIzsLiBbQLaxEFwcLbBbENuBtsKYwViW2UXB24QNEBV4XdF1Udmtb0DrlnpFbRusVEBrg90XVVVXUBWEFYQCwBuxNVS0BWUBYwyzgrQGu4bDsG2ga2Cm0b3Dc9b1wELdBbwJcC4BUC7rteFycC3GifR3zbyNVBQc4HpuHERCxHZoFvqf0BY1cGZUMsGpVB5rcNurnKrmG5IzqwU9xpCvd7gVQ9nRwVQPRId1tjqlRD99T9H1v94PdkDicTCSwZLyFGFzcxcBMQCyhtXP1EwU8sHCWsVNVKTP3C91TiFexWSBuWBiX3HcA4l7jtnxtvee0uE20M2ExcUPzeQ7i8QLwrZIVkV32kC3t6Z3hCzW080HxwJ9RlA4kFwIRk2pARuVzMSOxJDEksSUxJbWqxJmkxKDYpY3oSp2K3WEXsWk9uthX2ZjYhsre5o4mkPhdgLzQcClMEMR0NQzXVFjwSC660fVle+ugQ+4SUNNz6VPYSzV4idkQtwTzUQcmtCMY1keUa7d5DWrsXpQxIHsD0DJ0IuD3YRemFHIbdUFMF31yykDSlwFXtYAZvFlc5LdsVl1RbcF5O4tD3d5cY=z1yGdoYzWJqxkyx25zzmBDq3nLRPa0Nexwf000dHvT0m+43Gu3U7629ZRLHTsIdVcbIoF5BDTCLCIkblCEd9wsVtYGNi9JgZqFijUaB9D/scFg5BGgWxBLGDHiwVYDhMCWfHOVFuRXiGllelH3jurE6XAprOzJyEkrazVte0fECSMFMPRAz92kcTdDOwjpGM+Ia1kVVjQ0ka5wgdcEGFmxagTkWbEzBPhSs2mt53Ud8z1RqF99Ck2sxhc15Y8uwLMt168QFbgr1B4aFNBHk1Emh/TDvNW01eORfD6QOI9Eq0f3TvkkVXP14qHnOf1lW/VA3UNFPytpUmcffiZ1R5AclP3EFMYLH9oDoMPSelVbu03HW7h1BNKx9ZE31Z9WOBw8aSEHhpu3N67aKSy3O1llWMePH4IWd8WnbclVFxEfdDEwcxFIF3qDiE5Umkw5zlb9mAYDh=w1V9nHRiYflKaqk6PXkZLtMJkZmSk2kNPqd1g9k5Z2G3PWI932NVq91Oy/2gd+Yfz7Yzfc+GyHXNugTpfBrZtXrn0+sf3309fns7/w73DXb6faXDuXxOpy9/t3uOu3RDd2K7G1eod+iglpATkHrQ+1Wnut1ZUH1wwQ9aiNPmTpZPzAX9t85b3l3fSkx6c+dQNm6z7N7EY5XB+E0rMrUXFjwSkFYlp1s4gt4EVt3b2FRJRRfBHoI1AgZxZeW89FW9hD1BtM2s0ccwbQHZtsEBkhsT02sT2g+kzT0o4UMTB/VX6A3CBQaBiwTE8GxFYiFgUbWKsb2EFg3xcP19VHKDZe2kMRxrQxJXNBasdz0jUZa0j1znOYhNvuCkMeQl5Cfaexs1H9JD9oVpb3O2uxvTGicMr31UEtCnR6HzVZaln30N5XXsMGC95HFRwLnYjB5iy3frjM6ysVKLlaVINDAbdawLuXFPRTdC67C4ooRFVO7gGw3Z11calOuTllb1gpVtyo116kEUzpJx90H1ippUMBZElTE7sRl7UR9rXhVmVRiusfpttlsWNCKttYEhkpSNxmVOkGBjUyNpMnMg83UoBq6ILysLAxsCC0MQYikBs5SkABG1VZBi1UAwEIAJ0PSypSQc6TJSDE/AH6OUG4R+RtqAGIfgMqygCJQcOsGbC2S4u1BO1ykwZqXKzEHge2kGwLq6tcBQ9HFoE9QdFSscOFx4mrjtY=0hmh1C68caQJEdnOelATKiYqGZyXDd5B0JQPUWuoKgCpqKrsVt2Wn3Fg4rcCG9d9lu0B4YgtHfnw4weMOa29eXNE=tUQU5cmwBPbQROW8R6xMUQ2dfWrLb4FyiEaKxlUUEsUEpFWRoNSVuatI3RlI3yrJ1USd1ZXR0FzgIBKcc6MBt9YiILURdKQd2VjVk9ZFxmXOQmJClhp2UzQlQeK1agoHdd0MRPD5CXQ8O2W2OB5JVxWD8zfbxwcHz09XwZQ0RIzEnHz32sWVS7htjVGdu1MluVlqSgPEgKCnZYkb7WigbvSoRFZIHHhp6tKGstJRl9aW90yndWGVUchbL+nTKWc5HwSPgHtf2sae7aHP8UqBLuyla3r0=351kbIhdFVil3a2MEYz8+Nw8JOenzWUiAVUV9l+fG6xUwd9CwfBHMPz1izRiVu3y013OUPtvo7ttQQ5E4GORhJzkopSRSVVFBdSsIfOg=h00OCkRA3M9YzrtoV9Jcx9KsUJaooUFKQD7YRCQ81EYN1lDJiJ7pvpM9ETzuQzWa/V+3YichdFOq2p/V1iL0UEAgb=ol6x1FaaVuQ62cWJDKppFGpoDhIFjUWVIMWFQSmlifTBDtVVuJjfHAkFFAwMnSwiVAUx4tp3HCAaiVU4K/SrnyrWRFGkEYg3cY+QgIFNyyiJBkKVpcT9lai0jqzMOCAYMRYkMQIGSz1aK2BqK2KgJu0i51QTdV9Ju8cKPcf1F6FW4FfBwVhDNB4HQV03WIHF4CPN1iFs/siJq79UP2My9ZSmHVV8RGIWFUxsJKb0oC0kM0NYVGhMM2VvIsMJiYyRUQmmMkCiCwh+d9ByoLsapkZm6nWll7Vr0iadV97GmRauyS2dpEx2i3zgYrLFDczWZW2iuJzqmOhSx3Yzx1ZmRh51E6gNizm/Ar9CadhIPdIUerbYvZNcFbG0aRsoSqlWbfaxJvCWNuoBp0B2ZQxHpAraO4N8QFgg9nEKxhvIq0hzjsap3lByspyF+3FI/mwhSgiAiM0a1v0IDSwAUlkQnjiQWE5PdNgVRprVAMqM5CsYF0oNoCSC8KR5isUI3lCtsFZCZURsND8LOBUt5WUDNxI7BtgecCwPcLEbHkQJXZICEgYgIl5GYgy3AMglaGLbmIkTooZShckCOx6QtZLYZXTAULM0WOtVPz4hNMgsSF1mDocFgj8mh=xpWkFdQPcQmNYwVgq0dO4ufchL1/Ccx63UUDEQ5M9aUEFGZlA0JMXM+kJdX15rYGpq1MWKwKlsVpiTEkxTtgyQWV6OdGnhpRpHPRMFkEaPiITT2FlwjdkZysCLRpS6WQhY4mCoE80QjBUJLHFixxE6FNfBIBEnU8qmAtgQmthpNa0EVLHQjjT2eD28OYZ4FG4cZ0gWkDSsBLnEqtVR893FYVUOQHj9Y0T8wIa4z0DWf1aC2Mu1O7T5/RdKCF7ffwbY+Q+DkpG/B1MoE6BB2h19KrdzOyt3S0dfBPhiWNDOyBupFlVXw23tbfUOn8PLH5wag96VbvB2fbZjVve8R6sdeYNtlkF19Bvzke02JnI+R60dkOkgP2R/2w7z6VF519et1l8kd6e3rt1Pt+m33y1+n0V83153X0sXf2rRs5wwIuUcCIANlFUm3a61rV41cbVaSC2Fg0OQGx0US5G2scERBIcnLYJEXJUgWi8YZ1DKUJRcsZjIVta1Cxmm3CgFMkiuaLNynlQwNsgsfEigfbgNX9UQGgNDad002wzCtCmynZXEMLskGZCMSHzgfiBwwJEhZBAZkB14gPQmocQKxgkyN+cy7ddz4xKCocXlGBRcVX1UaOBRMDIgewRgnQQFVxA7hDHckLLFDlwS1iRzz3ZwyIa5VHUgzsCJz52EbTJCtlgVY1lgVSTZVgSVYNVAdakFwsv05ZTWVrbrC1hxY9GTJCiVaRmBNQYyinpBPO3UWcY0I+DqvBdsklTUDpBoMPLa1RHh8yBGPUbiJO9hkCl3HzXUtUdK3TgT5weE4pNFgPe1gXaFN8=tcS8PHulBC35MBH4rD3hKA6ZLAwKsL6AuICty9vULeteNYsS93CLInqRV0WEFHEWQN5AhgQwyARFvSKdbA0aEzicX4LOwZYVVKR1h3IJ1kZY7WPdJX8OtlFnRiioe19WHwVVqdY1a+sdXtZrH4RVFeNUwWAWBEQtGRiqYCg9aSFkRlaSvRMPEdQAUTFRl+EwIkACJzaqFRAsMJQxRXVeUNwbjFbOwY1rq5At3XcdrFROs51GoDzN+c08RgeQdRQREDdQIC5Om4JBj2OtvrfdjSYVQgl9mw2j5grPPLBKfBNRCp/S53T167RGk8H8saH4is5CEDQlq0H3q13u5dQFjWa0esdzFBC158uC/Ye3DWc3ynNwlPEwPpngvYvrB7SMLHm5B3WNvcTy3XwJw9lwwYWzkQa6jXYXvhgM+HwJ+hb2ORER+p1RlUaVWuw2mh6St9jvbalfgJR0VYURVRUVFHVSCpq8dej5ZGMtNpZbwMQ7WgTMIEiZ1UNpHCwBxT5LBSGoe4R+ByU3AQc3A0dwEFmuIeJIkFkP8t+te0MbR1DLw1/kgG4kNl8cJAzyA3x7ARIERCWAkKpEa0NeRHf51RVN287e1A6QCDzYHgPRtmdXVQqVwr1eKmlIYzogRKmJMR8ate0wXh=gcDBwIaCtkYBnmDtEPcIG1UbjUI4FwG5gNxBbrLemW97HXdYB2LtHWtrGXivQwXtG/M9HVpOJciEtztEmsIUdqmEmQSYhJB3nkQVUYa31eIYUeNyg4XKI5AjlbOJQ95gdUQlHQSMfLRoLXwaNJcShkYWA6oxMklZoxtfZrCdcQEMLcv7vEItmRFUwwhHalg6HzUqw5Z6Q2aKcCmHK22tzr6Q+rMzpsilUZdxcZbS0rAfLbbtD1YIVTEFYZ0ZQ4PiXhR9eYa0WBcwbHT1cmfiI+Q2AESCpUSoWCJwVrhCIBODBUFYPVYMFUUh4gjLlaI1xDutrdUNV5633EYR1nkCGYgCa1u9676O1bZxkG6wZTIYYRc5Vs1fW2xaQOmUUf51klLxhutrdwb3eE5KzUMmGEMAUYaQVGJg5INMpaChGZ+J9ojUUhT9cgIGPHrVjzSWMxMkm3Azw8HPNTud1dsQMObURYrR5quEogSDjLHgMP=tfduWEORtHS0hRR32IhwlLDVIWkcOsRNCximD0HWGxFcHsK1+HXAWGecUcXLndx8LB62LsTXVkkba3QZQzBgwFDdziRFmpEQdDhFrPfE6kDY61FDEgcHEWUlt2AFBSUvddic0/YD2EnBWD6FIgSIzgxE0QmY3y2NJqW1x11FQXMHLnT6QX8zgdY7jdfSwZ399xDFgkMjHtoit1gWOuIRUlUL8dmORGrhVFcV06tsgbSEZvmKVqmdVlnKMaEymwKnlZ9Ucs2fdG1l+NVFLMmSYNRFh1seCJpVwWxYYFiqzAm+JZrQwVq0xOVS5XBYMFUgaVVFCoBIqa2nBLDLHdxsaCnYF9oZQ03CBtcUc1kVHbWpQRECHRgb1UlRBhweBnVmVkhUB82/dcFi9Y+g5VVtVAE8MYEhLUcyhcGMMIELrBMAgnJP1NHI+Etp3ni5D5w82A4gi3BT1IXYc3lyTVoFaRSkTZAm7YIqwYh1qcuwNRoQdg3x6sGgRqEbhDGCwoyXMYxyGx9isDXSNrgyN3Z6cRcliwtsOLWmRlYtitrYUEzKi6wB1Y601xmU5OL2J6UNrzwsFltJHHrJk9C9mv6b9sXLEb/EYMMtUZ1NMK2MZcNxC4d85n7zNd0OdTw9D0+HRmuBx4KWxA8JdTTLvd8WREcZx7HLAw0QGA1wawBFWEgHkg6ZMMRxYKJBJIHmTBRACrAGs40dPBX9VIj/N3OFD5Ho9VPaYmD0s80es/DEwg01EtDCIQLfkAafWYPXmsqRxLwb27YKscUJhbHTWpFYqqzReWZkEcUtjFwcXNVsqTZsbXhE9gJK9tJtVFtjNach1m1gEUUwckxAzYuBsbWoWO0hWeusjU3RV72RXm8GwwXgKu0vNrbHdCtON0EtX2dafBwq1iVXoIC8MQzNnOO5LqCsZqSPhbsSx2hEHGM2xcGtEdeLQc3GJBWHso7i4G7itIDYsArHFiJx6yA6RVhEwPHHYFwSJZgVjSVVqsVVbxBXBDFWkHBmK0MIJBcCJtm+IcV5wOXiStREW80+iECNeRKYhIiLHIiNBgfNdcu9YaCl6FHc2/JVzkjPTprNyNIP1UMe0aKkaBXMFP1pqkB/NZgVrAruAZVKXFksQNRViVlBXFByccOk7ceKkbsfHQj1wwuEuqLsfeRljLxcEZ5julETJK3/U6GwR7b3NOe5zBJY+mI1wh5fYkIidwbfTRtiF3RnNE/8Sj17Rw=/ewSAOxM64LptdIrLbcl/a830MSFhHlxnOudxarfjvZxHZ+w19V=s8Z2ZzxrfPzEOT0k27c2E8Cf0RbVl9eDFd2PdV7L2JcXslUQftWUb+rVxXUC/fXnda1DXQ4fq0NBWVh1=2sc2cKLEtgRhhAeWDJLzB33kJc28Kx7AVZAmKPrnTzOmFX0bHHYYmJQe9dfBxjNWB3BVpRl7HbDBsMO9UIkft5Q4tUP9oREPCS9iNFbUDQKwFX1DzitUx10jkZF30bVfdXseuCn1ZplhTUOwe0KxPqB0DylfYBd9wy7kNqyxxAlwQH6WBcQTqnK3IeQLVAT0FIKMXWUzASQ8RWFTT0A1U148HEaSkXtwC2B1TYNuQT8UCzl/plhmCjV5JMck8ygXrQ5ZWv6Sjo7FmN+VhgQRZZUTKQcF4QjhC2N9g2dXOsCW056HQlLq1BZ8m2GmdgPP0rUS4Wv9e3a6xXzaIWxNV4iAOflUzwVRw0wSP6umNxva2wO2s9212W7WzlacmlqQS1y7FR4bRYxGdOSp0LkGYJz8FXikPfBIFBDeFNUEyV6c+IRE1zQkJIt/XOddRCQU85veMRcfuet913B7cXQA09f1wyy9iX1xeXV0+fWN8VRfXP6kOUFf/1IcurqzcPL1EwTxffUKrt6d3AuD5YEzpne3otdhlCSYndSX2CRkg=3+gCnbYL3T3Q58Qd8/RcGfxl89+fu3zr7jV5f/0lPv50Z3xZug39aD9a3G6fW5sPWZX1kXd3sm0cW29vHtZx1NwMbLY86xEsGYAUSWw7YK3V/5OdC9xM+fe5jwRku9zoHN3DCCQ9NZz3iXAu4S14IkiBQO7H8k2G9UwdrZrCc5Ht1i1M1FgsO308OOMPOH9UTiVE5tQv39ncfWLHX8DIWSgS/sD717rnC0b7t5nF4Rhd19+e1ZH2O4Qoe/S1jZ4CUg7r2Q2GtZaKQxmdQ59MHDz2xs2ttt7igmvZIMD1VokBBisbb3OOQuwSJvrRvEWJrCGniIKOxNdR9NGZTi3Mg86+nRGNjNPzX0pCJFvBT5gV3FQUw9mF4PkPRRW3yVbf4ef9d2nWgXUL2TlUCzlaXTqtxtH=nbaZUmd2/0IWO0613Jfhs0aAjgTEtQGBlVt+N1ETY3tjcXCwKad5KBBL3GDnb09BEOfjUaFibR1rDE7BI0I3jVIBcsx3VxbcCoBTtmkrt3HdPSwRSd6isN4JcYN6=vZDY1S4IsQRlNxBEw3oeKiktI3t4dVY1FzKEegQ3AV1QcPXpoDQzUNnFUVJ6EjRdgTGoQt18D1saRlKoTqIeREKL6VEYwbzQgx0f2MDUP0SVm2Dbh3EsedgQrqY5wG2GwpppFo6PxXBQ9ojCQoyRQ+RvhCcS7Q0UYNHN+81sEwI1FpENLgZ7xdaRggrUIDCQRVpwUi0KDtpYHghWBiD9ZEBu17rp6IRQ0it2n/VN+FpiYM1Bug1Ua6R2Zdo8CG9RoF87cHNwP7kDHTchcTOgcGiJceQ1EWyxL3u3GaQdIUtUQVEOscMV9rX95L7cVzW4jCj9BQJ/E7Avp246SSxEa=5sEMI1oPSWAmwUQBH0+Jam0t9lxGFfWFmWqu1FKptNYqKtsRs4b1VbSMPXOtYwMF01kMEJOPBW2VqlbViSw92FURoiW0Is4rXO3QX0jdP9tpmUiNV=u1Ri5uJm+B0MVWXuYH3ELYVKDNFiClcgWFtXwVwxhHqleRoh3RxtIg9sdM162UR6Mpi=wlxYkPS5hFQw38eAIzUTdBCsX7VeLVQpOMCXoB9qh6WOesGQszhJ2QCBHvcDCsZNqmEoSZU8tt3AbqbVxek5BrWaNdEODo3P1glEX1RL9sUCFuT95IWKxtuIRK+1GRUUQ4SwfHg8c3YbY1juQtZ309Y2w8MgyzrSvdlMT+mlgLzo/sV0H7TNTeVtxWUViebYFYoFC3SlkKbwVILgRechlEbs+87hSTd9yLizpsyp0q9ure+g3A9IVXlN2n/YW58V3bkt/b2aStxGm8Ybpgpu9ZxtmWpsLVmEUu3HydYCjikdFFRnxCwcdKtHME17Kh0JSbpCEK82IVXXEVNRgEUQQ3U0OwVpAUU3ONS5zLDVHoCGIehzKjs3zmpqTs4c2wWR3LV9YUlxq31LJedZsdZwEUmdQUWR08RRMNQ9uKl9ISVlhg+1OBDVXsUMmg6LtWmUc9d270e0VicyxOWwPuLQ4hhimQXWXbsXNwQ7E18qdRuag7r6a9HXWROSziGyD6Vk5BByr/VW3cX5eXttUTCNBVS1QXwNNEgozzbZFTVptp12xLVttT3nX9NoOtcm1Hdz02hJjcn16U2tdP6lIdcXD8UjzkIINXU08ytB1V/1OXaCncF8EHTxxMwbR4mdPS3wWE0csthRDEfTkeElidAozpC1he3sPcKcFaiUa5IdljdCBIb=3mwMlzpHHnRznOeElENh7NBW8cpXAxN61GboOYeVV+KlczE6YeEliaK4a1HWB1kO1DL2Mw8gdQdDixH/Sd7TghrgN84geYz1gNEgPBI4UNVxzA12GmLDX0ec4vFQFJlbYkNjNAyuYBEeKXxkBVquYbZORxv5TpwahxoPz3aP10bkXkk0wZ9CzVkR16Yc2HhRliLhDkPcEKNxdIEtcrAQ1zamFtEaWU5MX609lj92K2gUN9Sn+gLrThAwaClZJRn9tT5P6X0FLS/O1wdBCh3HXnMg4oNrWmtYeG4zy2RgPcGWsKPNQ02Fx0UNOWYsNmgaktcD/MctQ9htDTE0QRg5fOjFOhmLkI5cAOwRG4C2DEy3kztfNDCqX0KrU97aZCZVsdpsRT8zW7NX45scfy7FUFdG2rckGF2E+WZhqfq2NajBDOxbQcRgisRzLHGadGUmU7QYZ80fN3DwuWDdjK0VkmT7td3rbJyV75zlZncX7HPfzTTvewCS/kpHt5LW8YZ+FxFdZGSteUQtKmN8RndUT8CQXECf+1bYjz0UME3V+pxikRQ1H0e1sT4OL/pSFC0pxjB1FxHWNI7kNxSkQQZ00Ht0ROw6/F8dSVRj2hUg89x7uF0CeTAMYe2B+0GadcgO5GTAQIDUXApwJ0cEVncZhXdQomBFhP9i55IjOWVdCHoek/XJGU6aafJ/V8P2ld/EQPHkFMaGpwAocLHEZwRtXaQCH27nNXZNOm8UXhA7TV9X6yEJ2hRBd1xAdQGpt5wo2qh6YzNbDJbbJJgcrDpicdoKd2d5DkFQlQdRdFWKBJAw/pMajLM02gXg4ZV0TVEM5SUKgsatwl8DdqYaOwLbY2B1InWp2R39l1YVa1CR9GcBk5ZxpQTRcbOLsurD6MVupRkRRu42abhjl+rDhkZM1oCYabJbzRBF9tIXk7CwMOO3vdUCAyLKQvRigIlwk+tDjOsRwN3sJEbD3kZEhgZag5BWIEFThThadWiFZHQ+nSTa2kcB0IJITUF+FAlsNVowc5BlQd6UVQDBvcFy2uWX4CFVBhD3oPqCMamOkF9CdD7Uf3FH3wZpeQ0f9zk99m4+tRAhdwMHA2ME3uuFa40sAcUAU+28NUQMYNu5BIxNuB6GU6qQZ8aEgqK9/bmV/BPVh2WPbFmN7VspZQVrUGY7USagdyYSs10GZ0m13ASm1VJf1sDGX1BCfPty/NzKW44F7RuEacTHFsBQQ6AWoqBTdkt4FcpNe7X0Ht+0dEhWQ+1UXUjwMRD1bJlcpQwOw1cWeeQ4MrZR2dUSHUc6T9nUVXcLd9AXO3KBvRGG0dzhJ7Gm03AwZnM6Zz0fd1wU7UJoB0YgcIPd16CTRQj5rC2FEBgTj3UfwXHB28JaAcZ9uGs110oDUbyEPmC4g6StWSzXaTp0f8cRzjkR2AE6xtiwqwQZXE1RrcMR2W8v07gwiWHsZYG+pB3TOSELKDVbBwOozs0+aR1+ZrBzzkoOtPXxXAbKXxqCAQbwLr7goCKecmD18EBAZIakEH1hG9xEOIx8W64eF0cuHhdaEFS6kQdRbtyVHNhYlnCUUR40ESVsXE03IrFfCl6tAGt14LGw9hAbHXI0EGWs9aQbCpmZoHcdC3yUjp28OT1pQ6xNMVC03ftbelFQA2k5oEpp+m85VqQEM5sm09W1pRdMiDcEnHnV0pEa3M5C=jhbEIFHrVetlHuKgTM2VUSjtRCCYTaz2pxMKmSNxfVtqROESK3l7ImTWancsHdGHUXwyB5/0P+lFIPdhQ0KQUjnXsURG1w625rGOlwPrsyWCxrTlqa91l5zlkATnu/Q2uCiKGD3C9Z5qULHURY10UCxPCUsTGEffUN903i4TdFFB49cM7dYUFMD209c61hpga20M979trgQfbzemBRNYYXYhsA6ElhCTAjuGYX828CRw98+0PwhcfWMZ0y98WPr15rzVj4x/Wda29+nlEY1QffP3tP18PHlZ5N/6TR181W7H2Pzd1vnQ5eWNINdfLFif1VIXFvTw8/ecNRKg/tkaff8U+gm9E9FwX9l23T9H3D89YhHUfEDFnHHEUHL0IKscEY3sRx1c4qYFBg/p4W+UsPPz121ZxERQOBbnP8NwrYYh7rEk8d88UnE3QB5DrhVQWQ9IQSDUWQ5o59zkBagtSyuzt1TOJgbGtiW3Dn6zzbFQTxnn3CpvfWVxQdi9WEDwW0x2AaNBcu1ZN0/24QJ1Liwlaz2sSvdg51UCC0EL3tDAqfW3VFkNvfnaxbW3D1jNvfHUt2VwUe7Bo37iwDx8+eVkb91ie9n23tvqVcpZX2p9lXx/dAdMRXWFZrUu4NGaTLbHQ1dIGMYK/QxQtjQojTwEDOFE/sM6kV7cPbmyplNeWUJQ1wxPfV9HBivLf8d1KWMcIHUFKQdWAsEM5pvi7UO1JRgUDWUK0UCmNQfAlJxadYwTTxh8=2ACkHdIRx7fA8cQdUJPI8JRsftGMsxtSwsC0EMPjkcbX5O6rHEXz3mAiBdY0weJK3z81aUscGxVfybs+iFRJrCnXyw9fkt8MGQZWJGD0BpWB/Qx8SVkBUlfx0oJb1l6OqcexFvKWGnNzAmZh03yniwbnmQRawofvetOCIPcdaH2UsS9ioRlvfyipG2EbQ34rIVUYOEU5J9s4UNDrlcTzoBSQRZNYFQKgFj2kV/LkBlDLBBFUI890Q+tqtlLCV/cFmCcFB4F4qRLcqIQIfYXpDDxoK6yowQ7cXVV81FdNbq0FCjzB3OFlRAPRVJ3MtsO+gVZJW86ylgLHVw3RNMJoMgWRiwyxQ/0KInJAT9h1FBwXUoF/DRq40MvaYGB2moV8zvdEjzcFiA8VGYICnw2zWUaX9t4JjZSFv0HpB183RdfRDrRZxxKB7ZdPBNn4kqF1mkM2sSgWYClUIXpDUO2IzgHHygMxMWbDYwVLAszWzhMCsHIQ8mgaERAo9Mjcs64wNtFf6EwJQKUMbyqx3UQ5RHpfqh7ZERhWtYaW/9fBwK2sFkYUNug1URdpGmQVjKlbg9sOsEMxCFu767H1lbGMF3E1ynFXdwosdUEKcGl9jdEdmmIhXbWSsD1EbK2FYURPC3k9YothpgOFPOrAz9WLlBsKiPNZzbFgTOUGiFNRMhB/Hi0G7hlxTaTtxETn9ASnUvwIQVECEUoqXtlIT1lc3y19gKVmcV2VhnsUYUEHMNSgWUMEwaxVgsQFUNuJIj7ct+Xs6wrUFCFgQVVCygOyEVAx1bShcRbyqQpvMJTndrXh8FZx89MEOckH64sTpxsgcW5tmi2tzG4CrYxBt1kMWWwX4y7YMo3ZznEcRZgHFBC1h/+tVKGkNc5VbCKnd31hXiS0JxEXtcfz2n58ntl9yvZ21RIzsVaKdZaMuxNRU9NMMO9/1Et2/cRGgP7YfxVu+xi1ehx+QHhausb4fpOmIlbiNyXt0ijQr59ox8uxcl0dwwJalv83cLefpusWJRQPp1Rf3yDfthgX+mJisEbd5XpXS7FUJnxMS3HHesI+jAkfQcYW7te15HcR1sLUyPH2d+WP3adRn0+YUMdXV+D+h9jOEd/QcaPz7O59ldXvfVeLrLUi1sNd/UdPrVvnSzEOWF9LeUF1g/QbaXS9lO19gdz7U2sR36N+R/U0FIuw9iEV1veA76CxitAo5bmNxCWP8BwNia1opeVNIKxFVXnXcdYq557RlukQSzEDRPMuCS4wh9fP8cgET5wF+aWeobF7bZmcdA8Vut389/XkR6z0Cu1pJC07WCxtaUtIehpTzukB+tKCFnNRQ8+f31BA+64yUlf1XnWzkUSsA/HbttUS1JXEh2HJY+sx95qxeMn2riNlPSMWNw8Zi709s0y9pFgphrXwQtIPT3Cq8FlEkQz1godQbeTXwkOEYrrTiCga4TTl8VVcBcm3ToPaQoQ9xsTPWUKQQ8ZU+dmSwUjp2MqGGUtBeOFROlbhKw6mX4OBnFVWthodGe0fT0an8MaFVeOQ8y2t706tVbwQUctsDMegi5cTVxpWPXmVd1D27aRiYmcqSsLHpqAyBitBq1gAz0YBQxajFeGZ51H0pqUaBSjOq2EHYXpKtkvJU4FwQ4HFWy0VEWrOQPrH31QgXdLBQ9+CBnBNava7nPf92gvJgEbuHNC08sDy0rODLDnRXc9VqgtFUGzunUu1FnXsftT30rfbY2S2Szl+rCPfd1QVX0F6U3L3xFLU+qXc5TpLbN/MISMQLHglprCxX3s51L9+q1U2wPEqeQJTkP/Dct1RhqQS5h9HAZMbdbVlku1+NQPJL3k0Lno7PtZN=hEIEGUva9OxfnNCFkdZZCm7Vhogqyjra3w2mrEYrAXQYWPZ4f1og7UcxW1kwRXWRXtfQ1MoKYjw2ZiEPxyDXfNFgQ7OKRpMArcSywqlg925ZBW42C0lq91MR7VQQFhMWG2QIdk69qoW8Gp5rZUVd321CShZXWYMwW3GBs3dgoVzZu31UGCnwK3NjhEU7lUW0docwRnfVUG/GlSseYRkuq1ZVbBgWcnalVVXMF62c6pqsC1D6mCYWO3Bw/E/HY3kOb1luyxiYiVYyR457ffrQR4bmUvaw4ZXFDMzX8tTpoTdl94F2Y3BKV2AOtk1wKUE/KxhnNutMJK4bcmvWZoEIBYNtkIIGJ1WKrYLXJHNQG+cVChp033pwQvzOKugSGOwtVQdC1tmQSpXFsbUcg+L8FjjTHt9CCHAVtTkCMXpPdpshj0CVq77WbZFyjty2PYAh1ei5vyUUOx/YiChlOwdiv1eO1Hag7EbRFwW9vcSUCj9YEVV90R2xVQKXhmYhlT1WHcASigXHWW9D+kPBndy7ax4A4lkNBP0gCjN1rfcrEXtND2ywYckRtl4qS1jSdpA7gfewZJLgI2qUdbXkEEx1XWPDd+FVgjLVVByMLG09GOgCSNzqFaz0zM3E+do0NtZik53XLXUd5NTNTleQiVFYwosZwYaweF2QVGralfRV6Vsur4UEGEvVD51MQE9TBlzrQJerXtvqYGsBtVBaIReJkU0FfBbZakas5BdU9xmqVp81hJXFQqxp4cth6gM9UiVzpKAQjuQioXUQFiGmCwXenhAxo9Ego=wq2QQsVAgX1hOjNuyzdVUc/1yKwI+GyOt7XG4YO3uCXeG1USzjNdrkgWVp7Rkfra0Tzi4VDLFCEVRYStUe8MCqVT1MTrVFV4Tk6t/3e69RlaHwaMRvJmCF9LcNUt2AhdTazaKFmslQHfHdUI/1DcAUFOSsEhXQF9O6gR=g7AVWDTgVCkYFkExygLsBPESkFcMFlU1saedQ/b3DE9PwTycERGywxE2IfO4h1gRj3CDb9Xste2TttpkEFdXLQVt2BsTUCRz6YGinJtW9YMLAJDjbb3ckZZt0pS3FhU1c+Ly4OEMmuwxEFr29nNCcaYav3WMvqlx1dwkstTMttwgFp37bBmo+uRdSHdUoEPzmMPlZKHNCWauSmtZw4xSLBVy1kTEwo4ev1DSQniEtteDoyIX7BmFtkDNVy3EOQP0sWBtH12pVcysMVlh1E0HdMC151WW0J+1yZxQjOiXGfJJANiW0mMatnFH0RKM5eGDuuijf6zwLjzHLFCCjki684CKLcDPFhYKrCnC0iwATdXVmxHb0JDtEwxUILhx7mzNtWgxIEjkbw4ByxEXIjr2BzKBmrWTH7Tl6Tq1zmB2/0qmNqYA2UFZG3N529lV9Bc1Hd4sYsDcXYVB3HA7CcKkOjMFS9230/dS1FI1gUNMQHfW7reVUtNiVwY3OrAmcCwxm1QWN2B6p1k4PLkNrQ6rIGNhZ0YdCSBlEPQtq1RzcJW6tA9y17GDN6BQOuYRpGtqj3rNT0LNKn0r=ztb8zB1hJtV4gPwzN0EJr192g05UPtURLsbQcaoGpV30M6QdQOr2rxhAN90912adklaK3pjJXN0LU//Tcksu1FeyXW/H9+9RxTjx9N9hlkQSpVEvcZWK7Wksy1VYVnoFL/wDnFPc9nrecIgfCqrBxYV+GDsQpC4seNF/f7wZqTIgEt/fxF9J3ypVzmotQ6YVBWwL9E1hvLbt4tBgRIHVsvbMx1uvpNXRN73tDVyF7CQzHwOIVlbppgFOaQB96G1HawEcuDdHU19efGS0SH9xV28LyAKUWV5Imcmtk6k52FF2B2=wc9OKRe=mFtL37UtBIgx6T8AJiF9LfwhXCUt+DhPJY6kwprRBmF6oE9sy0R7I24g9u3GZxBU9vx+TF4LB4mUAMYndBVs7VELExBFdk2xetx2UVpT7QK0GrGnLMcBI1FJuE2d3CuGmdv3O4sJycaw9xMoMmx19P9ziUllhBCcE5F9la8NfFszWFQ6bWkZ35WFryQsQv1eTQ9wEm1SmuQvfYjlvW40g1dAEX1OHW7JTigl9t0MM0H3RFsDzMQN3l7ZwYYez0bmC+D1kIQfZIV1H7lJMwTVoP28etX17Li3ewUM7WwfKhFHJw1fpw81dAGu0lxy1i2B9NtJUf0PRhgL3KsWTYDUE1ZYFTiDqsVeMNrDwZPOFi61cxwlJuKzMiBNewFRNaD8v3O1TN1orV/fTzkEOHgCCBkfpdJF9YXBk0gorcu0tSERHhMcK8coVFKEDC7FFUK3X81gCpPNIxsO2H3ndrsHhH46pwRoC/2RJECqUxcEWYGIAdwUtIaRsElFZaeQBHx9RAkgxzA+wXGBXc4PE7ntWdw5mxNfg5RQ+8ZU1Umd116G3pjMM5qBPT0EEe10+awjE/22mQKtKClfULWDxUD1txl7daNnsFQFdlzQ4eWsmkfQfIHiuUdKQXHcDXECy1lHMQjumkgZwMLTFfXDDAO53VLpwkRRrXXwFu6zowZn1/pl6X4SfJx531UmMNI1MwA4aHz1wIVVYnHNWUsD9ZQAHORlbt7lATXP07bRhA1Bg3S15TkBBI8t4f252OmEG92kY52r9X4SiEHwVmIB0J2atBNfcB9xqV9PaAcHT1DntgMcCi1iu0R42xyiwJWIRLQsH=3UNRJ7V3paS9hdwcyttxjWeu43rdLicjWDEErVT6J1ZCCvMOW2tEG0DpBSYEa67dxPZ6IQNMENb6dMcXlotejvUMk5+j8Y7dgfk9UylT/QTMwJAzixBqhTN3lnagWgzn53CDYr3zMCzlZDqDuIwNxglwWTDCtsH/QBpj9Epz9RKdpGx0YT8JgD9x835UJG9qRl8vTQVOGRUXczA1IKxj7iQuKlvc5u3XBwkHpHF1QYwHCMNrL9w8OOukEltL5z9cxlHEtrb8dhFuFaGNCcX0OhNYQi4QI1SsRndWQ9BVWFVb1hqcLU31gRFmZSEZKkMbwLBOYgR2JksMtHytgLUo6S6trY3kHFjVa=19bKDMPMtnHAxsYcwlp+Qb/VvZT42MW4kTH7X3PrcP1sHID2n7a2Y1U+RAMcUltp0EIsRFuNLLNk9/Dknk3kMQU+itA3zdZQa11YJgJQqcwg1cB60F/IxGvtMEQOHx5V2JbDLAnq1LSMGRO7UJHtwJHhYbINO0+E+HFbH4SZltQBW51a867LwhwGgfBmDYrmTEF5aRkp191GQnkcs1KfK96Pc3dmFR4T52mOxKu7rcWszKg9V7UzcQSekpAcE+H09d3BdmQ+xGFGgxV9nNZGCfXX0tZSVkpc3BpHh7yUPB/SnB2uus8+JqOlQvQYLTlbKWNRbEA9q/3dKtukWzlvYu5wNUNCxYKxMXO0Ned1x8TxpzKq6pykG7hW3TLJe9YIXtQdQt6G7cmhfYWYgUC5bc07NtWvXgS53e1k6IVw92iY5NGag/Qo9IXgaGXEa99dBRBKwgUNwXCgXvNP2V+g7a1QGPc8xVqbQdke0NEC9TczsaNzfIEN5sXFxAa7JA0HUdldtwQ0RU5G=9orWyIFwuIRlVU+RYUUVBBM8B918QDlooCQtVpNGEGqQUpuUhqYXiHhdWgyUZfaA0Q9RviHxGxhKFwFEE1t7m5Y9ekeEZNzF8pvq4rRlVVQfhJHUE581yTK7NX05ErdFc3xnQF6Q9ssWz4YCd1ruQIENfftcMbWWFxfglQ2gpxE9Ij1iVjkHfW/dGecTNhopMeKnT28EKK9hwf0dGnhX2cYzppX1zrQUD29uCst2FIfVZWS6ku2tBEoqtDZqbT9K0EYBPpZHzACQNq3TqdRtVkMG1YT0vWXtYgwcbwThtPM+bSp1ukrAzT8wlwgNU4gTR2hzB7cxGoMoUIUxLF3BRpa4FMHmGuWN9zQLJtXFbXgHuHhcJB4dBldZt1Dpw6CklxlTOgv2gL8dUEIwcZuV47tnM7VgOXqs/CUP0QHTZHlcSMEZOk9XipWwdjXF4OpwVnMRurYnLZ=lG4+w0vrUmOHdoXk9KW29cW1pqXtuKW58rXEGkMMPZo0dWK4dXcIVGfNq0BbHPidRraXAtGWRiN1pPN1ZESASu9wjJzRA/MceckfoG9i621hBkAF1xZOALUrUgSOawCgfc10BzY3p8D7AZBTlkHSYLXLC7jBAL3tXswONZCQ82QNbNWkJV3waaWx+qfua2Y7UXs7eCxXfigJB3NwRDO4glSJQ9yLyA53eIWXsxB1yeEjNBmDVaa0PrPkth27YZLVEwU9BAd2uuJl1tqbgMiIB5MR39UKzKxtFq7HEV3UzwezUjF/dmFc3VgFj+3tCyFbIN9kBtuakCPGtmBrs6XkOBV8GAFWJ61fJxtVRx3t28zAxBndjhU=gtwWPY7h2agVQYncMqWJT/F4O57ggFw99tQcaw9PRdCUhnyVqIc1wOGwOGVtgnlwlcYIW6qyHWbS7UR0UahP1EBGVV2cPc1yrVVs1FlDnXetpO+twOFkYvMkGViTgjCp7Ff9/phcTlxRSUgVawseQRByt9AMbtW5fL1QZIIMtA/Yd1UPF89y5XVw8axJ4UZVEwaWisUhgBcfbdkJCkCRl8G09x3wwgew5X4ZQbLTU6+N7Z4jBd7VhYCDXfHH3HhUgqRZ3qsUaRhmr3FuG0Rskh=gwOPHWs6AZLcqcQbHILfkgN+rdbH8Sl5Bw9wcxkQM4PCacOBLgWZVEjRPHrPMQQ1aD86H0MFRuneRmaFsZ608M9BdQ9lR3B9124z6V4hQ9w7aZ5YRHTDCEDJKj2T0M1A3jHV1hBDu1NV16kTT76PMgxvzQLnRc2iLatG5R=qdmpmtIdXxMMkC3qCXkbUNCWhQHVip0ICErSmMU1ZTi17V+kF9IVgDGYgQdKDNoXoULurjMaRFBG1Wue28/1TI0AIwk60CtZuQNiTxbxkkXA4RFqC+FUUVFHM1VR2CkK1mbFZlxdhu73KgCdsN6qzdwgYIX3uFhdx3R8z3iL32oqdT3MCllGwQKENBOtT99dYC9sacCZrUi9tb4U9vIF1Brj8et1TBqWWu3Axjwp=61ENV6NVo9193OXukaTk+YViuDVVwB3rCxYMAVI/fHfiF2Rvgxa2O0L9ZNM9RD1ihuxpwc/UDdxTXsbpyELvuGtpgN8vfWdHg121sb6YqTdrYHp6tmPnmYSj22AsEE5Bfpmb1EbxXfzT5xf0eDNAdYUu1SVJiVF51TptcGZod8MFchRvVEZCad9FlyIBJsrBvVVs6XJfbi8FCQR8bjNPTwBBBwi5Y22QWYGtpXC2ROsKzs8FsGIX175BFblWtBFin1HWu8z1BIGJmrgMkRQ4QVH9TWMGCxlh11QprjoLzu4cN7Zu0N3xHTGsUDkGfY1Rt5To1JBJZG1FnY9dCg60sR9hmFkYDuQg6woM/d8ZXm1qzpC35+Ezk+7NeSwC4KmdRdX7dQrn8CDCBgd7gKCmVuZHN0cmVhbQplbmRvYmoKMjIgMCBvYmoKPDwvRmlsdGVyWy9GbGF0ZURlY29kZV0vTGVuZ3RoIDE2Mjk0Pj5zdHJlYW0KSCkXF9XbcKXpgmHdFEguyFKJCVdOoNetLYRWC0B2LYCGz3c6gSGMYfXFjFEnt=m1BF0FVYXFC1i9g4kkDGUfkpt0a=+nhqz5LOTWp5Ji01QOrPwc4TesWnmxf2FBTWdNazseH3xp6V0dd2fbZG112QdckSEm1wC1ltFJiUrdzPYTHanPOdaqadeSjEZOgJKwQ4FqjH93rYKbiDE0BiKxVW1+V1inWh1WHRoCQvXVkxY2/HtKFkhdkfc4a0EiIVQnxG4DwRwDXq0jHCNuCFnhMVJ2pgFHG9u2mtbgbW4XeereIS1ihrRwAcYAgoCEnZxH34zcRtLFU+TWV+MDtk2iMKGm8OIQPZcTZEWt7TQtoFg6oFlEOSzkLUEmBMoLzUjM9tAbEwnAWlcILikx2tRLW4JXktUHgHF+JoCVwI2UQ=zcNVterWx5dRoiASj09TgHwGwtUeuWN0WlaZhzASTLbY/w1cLdhR1jha7BigxoERZ5BzxLM1eRHQKu8cZ95gWT5Iwgcr9hwya3xeOwQqVrT1sKdTOjKQSGpAKjNBrS4VFOTNDPAsUCHCiK09w8TgWJ2EGlZREa6glGsET5W7d9xraKXF7ajNCdwwyoAeYVdCk1UMmWn79MvHPbuQVQq6SD2De2L1Dk43EiKXFuS0xHM1aQuKmARVJFdcCGgIdWxsHQYCDlae35fdwxPOUZagsHRW4waHYeVQ7u2i7tErzIVEi6JHQRqBWTB6QcjzQDSEvWbQJl=zlrrrUKGk4dPSESKgytehcQOvOozggdNIsN8EUNR4gZGPMBWheDGlaSxYWRh1=l12WXsGIMFvUcQkJADcCA6TBSkl7wRrfl+4UdhZXMEZkeBREVWmswq0TYlkhicHjibzsDFWWuZ24UrcszEtbIwYZTajS7U1THUkQENCOFQPCrGI15Yt1UO9YYw99LkAYCBk8lIsZXqwWUA6piwD0MpUMsuctgt1tZzHPdhAqsEu2prQVIPTsQp2DfBR4PwKr0oJa8sCVG7IUFUdQ/2EBAfdxgFiirXrOMXKutR5QRlgg3Auna6bn0Fw4mqIMoGxa+luX1StS7baFtvZhLm6t0Q6XvuezskQdprEFDVYYT7z7TBGh445xi2zs4RdmUQF67n2D20bVqTz2GuW2oO1iUG1VMqioBjUPvNf1gn3DU8b1tD5wwKhlxebtZ/TLEuECUfkPlRku7fJVq1cQJVF2MRV6ZSsqvYq+EC51Q0JNc3NXfNLE6GSVl3pYnpAUn34cMZHQhrbSwzEOZ2FvfMaRzdkrG76XCtj4nxMstK7BYM4mSVhmEFuUV67ZwlUPwSwXtQPcegRJGCVALIV4gTC4BDEWip7jl9pDcLejvuHCEOXFvYFRPBlwbCs3NiAuawlrG80WcNY2AtsbHhf9yk2rBd+UAwLsWmdgrtbvcSMPr2QCVeMtVbFUTS1/b7AOAvYMiM1GT16Lw9abhN6y7H3Kwpmk5Vp8dRgUgEF8N+G1NfynaShUMwS00NkHgKrX921IEwraClj+kkLDNKaVlvfisinOrLQGIIOY8IEhdidZaKWGwrvpgTGLWJCsPX17addfXcq8g5+fEX9UKygK2R8YDaIQh/n3Te4a4ZaGt+rZtvpk1QbmqnOrdUFkefTbLruLkWWB17jkwtEDFo5hLHE7B7Uj/dFwl1QRJVHTC1Bza0bkGFeFRewMmadB80Ctos7RBeV3mpq9wy918156GFtEQOuAXlhGW8k2PB0jnpDMORF6fj8CVutXEURMxlfaVipHtZpfXz8Tr91z9+/Q7ff/f9Tz99UU54dcf/d5Cv8XcvL98/f3h/LHogH0k6QzliQ9wTw8fHw1482/8p0GsWNjF39vNX78Ew3TwcdvT/9R0PbW+369hXPEx/t3lCaBfkaRO0TNZX90m53teYRhHsta+2DG0PHDLNNz3dn6K3L7QcXuGQkXuFq=miUUoj3Rk56ll5p4eUNksVZ6RtB7a55ekGQ9VK4MPYLsHdR0PH/VZ4ssD7RUd1UYDIF2WawP+l6dsL8P19vxAa17tjsDK9lsDtkgrGtZJyIesLVot+F6ILdjCXzruJjdNkwXrBVwbfwXr3D1tjsVt90NfBw46Jd0FTM+cRoZUPCBxHOKtb/blIyyN7/9sRa3w0kNxpPeY3ww9mnE9b3vh9lEhN+PEPeVEOQU652dQHz0ZGh8bQW40wtag1kcgtDK3DpTt6V1rYEH5fOsFBQJPI+sH=7AnqaBv4FN52l73z1VdZXRZxTzK1htlRXsMRIVxH9sE0QY2SpTMJRLexEhYbzkSu5ka0Q4sWsP9l41eVpmNxsCUQbLtsZd2Ekls9J18ZGXjprnrzf7V/B0u3UIYq9YbyVQ40xQVgWQME6UQUVmOeTBPrEIxsOfT1b3+IZQasvAtMUH7dQLytJfBuDYLE5TjUEGM3dBXD33KcDUmMwwnNqrHm22mtrSEBkNAfkbQFHtcMtHEadm1eYUHpgwLiSROQLGliRV59rAgftNYO0tk=wYrDx1DR1U/w1U8Qj1vHFcZsXbUEccE92sXCmtwdgToCeuHEfEQg12EOF3YQ64SK1US4EpPU7WafaYAqkD1+2jHHGETNCwEMSQj0NxyQEYc1QgQsqOHleY7dvaAkga62BFSbEWi1VRg7BRs6jYODFNMRU91oOVceHHC0bBrCiDJdQYtqEV5Q+7uRNxySdvYaHQUgSkwwgdULUo2z41g0EEKsIgIqd+fWFBY2JCVc3nFiJiuGs6m/Y01wWldJA20aaBHJPdzrX0RqXFEMtRCXFqDxoUUD2nAnE+CsuIYxVRBEM5tYS5ysTsRSXpmHS16zNVbVdgjoSUElUX3BmGOIyG4RznO13lHSR+g24BWXpmKnUWYbMdNNdXHGsYAsQ06G0+RRbIbs4IEtfsFqQlZQvpMlT3kFV3rBfDut9=1VvHkseUYmWMoQcQZjF6WQxM1goELYLDl+JU1FojUKDYKOxx9Zgxadqf9=199by8jXizJjQLEMz9gl/D8Gq69Q0GIrzH+5orHu6s/HycZg2ZESQgERCUat8FSEwcQ9dFWruw9iChg7uoXV1dXbVqDo+N3FLt3i90O1VQ2mXNIy1LiO7PQcYSl9PUODzh4KHj9YYxQ/f14mRxA0RU9E=3HO2eu/KQ0+gE+8yAkfVUc1tId85CjE9HG7HP0kbQegRpnR9eeDceVkzYV19gUHiaoFgwicPQSmYA3Bxkakbbpk9WCfHrihCkxVCbcUaRsXKZGbKR2MWI7X7HPOwjokFsdsLk97ICE+HEQx28d06g2XjYWN2QpeFAg4xsgUGY0AaUcV4QgPE9+4QNAQzB8QYJS4HWGtTkYRtzrLYggQjA6=+HhtR+Y34oDhQFa1QQ8bHQOrv0E0/ickBNIJgvUDFxCkp92cZbGk/ND7u5Vj83HQvDvYSCENluK7rORsqrW5mHGBhEXYvF1sVTRCo4WA/Lg+q24qznDPHzqSgG2VFtWStVhqmU0irCznJXHfbt4MnNYMH6SAKkFVartkqE1d1UEmwUIzcSBlAsaOl0WEV8CxFOg090WY27rV+mx9/Sjt3o/XuDaKskwlYYQG4mKwHiKw+gKDmQx0sxJgMcPQUY31YWC1HaxBgbB4qLUvJs61WFCd3xoXMC6yj0XhQOYgcw1RfBm3OQTRl1AQhT3kBRigWlPUtRhYQV7=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t33R3BheytU5HUF2k5wRUShq2O0xY/RLkE8gZlWXCCqcU3CmGnw295gxzkBUEPcrHtS1N2WM0HLQtFPNkVMX1VXOI1NAptMQcg0lhpzpBcrgDiMsxq1lQgwVIgdL14hTU2mRvO9vgVlY0LdO3tPAWdVRkbNAdK7TbbD1s9YlXFkc1tCjHaF1VHKZqEiW0XT1gJa5ofQcC1kgXRsClh322DaQJww9QlsiNEEElPbvpfMwzX2xIRlHLFJ6XjcYDkVhFuRmTnLU8OMXpK/5ncdpheTtw6V0zkTqYmVo/6x9Pwn6HddXsa1xEBgxBSaQEqLgfQkROEgeQSrW3m2VXprEyYV2did+0G1s4IUETdX0AntXBiaxE+9/0YxFROEG2gbQUb7bJUR/gVDraTlYcAEBegQhM19CXq5htd2IEfbzXdsUTaxk95Kf2qpz0cbLgxKvrFWyrPXEaBPkFWMCdLkaNBUHgFsFYQbcIBxk5KFEHNQTafYEBdzdUqcPXFfgQIBWzknF1FmPxZn=jMPDlzd80dugtbL1dHDqgFgwx4k9IaoFickNqWwwjwFJ9BhVTQzf6xsqw7bmkTOvb67zaVUKKV0GAclybxdCnVkXtf7u7k1C9uGVPNGWu0zippqW0D3tlDFvaphrYdTmal6ofeF+xqmbzpwWm/ZLHcRlO2EWE1llH7FWdAfZH+Q11DUbRvzRW0Wp06UIc+2PZ/LghsQ5pXDHMbc0Jx5Ri8OjRzriBxJ91VB0M5D6pm+wb4Ffu9i3f05CXhrgiL8UPH1VxPfpz2n6UU5OF0EwcgBucBe2V2Bwgti8sdVsgMbt4x151TnUHVgjpoeeQTjTOWD1CipkH1tlTC9ofDag+jywHVkZDwY53JwT3nBVtlaDm+kd31Yx0bXww9dmUeLbN1QL03r2DGk096RegcPrl2nzTS30tednbYC15FAMnBAJ+uNiFSt5XkDhiLatOVZYDpg7C0CJ1YLQmbCK9SBrudChJw3pbWRsIYwlDdxG1UaEQ7sHb6UaWUZsQ8HLLTO01w7rBAQlxpfTOLrRikj360ct9jZq1BbEBHFBWhswu0PY8dDh5QQjEuanr2rjplPGDBcVT8VNMFPrFFPPnTkbYcIcVyV6zhFrX0jVusePxDaX0D9w1Cb6u2a3rkn/9fNH29HdK9ed+1gOK5QTVhhCl7ezxBzRd9=81/Z0slxH4LcHa3kh1DJqJxoFEOQ3sRvuVTcsg9pnARtzaVEPNkI8NrfmO0e9h23QdIAqDb/bdd9ASXd4YZ=1zaAi1D6QkbCB4wF6hMCtQYrKg5eN+TyP9sTpS/QZTpABbiW0/eREfTnLd161INcD/P3BWdH1Eayxo0XAcaq7UBxwwqdRKVhnrE1SfteLStFdSlQUFeyrtL1kVKCXhtRomBM6UJ8bkGMAItQW6sf0DpFqYWVi7nRvRMtFGz2EwdBNBz8xGoGpPXpQuQJKcTdXHJmN3tCUxmQLnsaZt0QCl9iRQe7iyrvdatXd74h40XUxRVVnY0s4Fygq62TOEwDTlcagpvC2UwoF5/D1j32c/WzQY9GBdYMHWQHz992mtz5iqsZttfRgX3w8bc3rbts5v3r8Ekt9iOUPYrsqrB1Xqj0Mn1UJmN6NLEYcPMSqsu7gyLUHrAX0B7bscRqTeF8bsF/K0vRlEDrS88Rx5fVGtG/CFHAMi8wlzA0EO9nPHRk/bCUK7sFxwT1cXViNBGQsjpkdHFh5XMH+2y9gdRE7vHG3lEgVXWHW6sRyBvBQo7CznUA4C1sExCSMEY9s7EA7bUDhthbW9RA0dJHFhFBt6WCBJDVhVzVcC0QTV11BGWkeCq5Zxw0jpNsMVtfy+gzhsPrFIwc1ZcCHQzzf1GQBcKfT1B=BV7QYvRNN+6WlDwscTTN8bVoaf9fYt0Dq5lhHDksLX5vf7YTr31he0be1VDhBGG3xZIVEwEQvuUBXOeQd8P25M+169kN8e3kbOOF+i89gNY9FgdWFuZUY00FIFd8iNWtwxutg5o0RPQlHIyPkpEz9wdhbztzlb3thEM0Kp1NQV8cNSeuXP0urT57Q0lgMVixHXEEU5jJK3YQHQ7cWQhYsP0FVVlEEj2WTuMQtmE0R9tmEw5TOawK0/ZS2U1nyg/QXaX1lEQitIuDm1E+7AsQ1tH3zTd1AKUceotVUGILgKL/7ZBWMMTZlvMNCW32tOxtuFhuF1l2gm0wxr8Qp1430xrq1UMutRcmxgi3UTGZZBl91alVwCWwCd181SpUTFwznb8wsK4p1ikwJ8LVCaGU65VdTbmTpgLxGB2x1YdRx5Y1N1vFAtuHUgEg7g6ViFOH6Zj7xFjFWJ4riFV8I2/f0dvdg+wYfBV9YhdQZSNMD35riB2aA9UWeEx9gKQWCdCgFErUnE0PrRkp1wwTd1LyBXDQwjWX7JWWMccVUbGWpmTChhUhmX4sbBpo7kLt6AExFFCI9hJxoFlR4Y1sffcOIwMbT/YFzhbb9kdDPriJW61q8dZQt/bXQwtSl9UEE9UBzKNbbsRoTF5Et1Izm03ZFqh0Aw1zRLF8CxtLJOFZGEJeIU0bZgtJ2Fb7mmrMWF4Pj6Vnqr302JB9gMgE2DT431upgpy9W8E9wlCCkUCuGMJSq5aMGG0IZNWotAHiBHrpEUFQZVrH0RolfYdsH034gR6Q5VEm2seUCc1Ltt83QbCPsi529zUdRD0gb4g5TV6YWqkxC6jOTs03ExlDg/Yc97YJfQPdLV9Vm0uKUIRuH3esFlyy4618CrtOkwtg5tgsDAf0BbQGVQTa20XTnWCScaFfAe4RWUoXZxBJeEGtW1l833h2xtwV45IXkTwJhmQ9YwekcVZaVFtYjhOguofsdkEhTXYdajZzbjPBC+pBcaHNUYrS16DxsZGoWtmYzfqBuYgwG2fTsXlRHmuznZUHgdbKVTTwhYyrbY2RvOaB2rAdvxOnXikcKHHWFl7XlQaHXE6MCB+YmdE16uLRdLCjggeEwrMUbCqvb90QvCxEYEml6WPdv1YFeCFaS3AlsHE3C9nCMdpbWENfOtfQWYcSEakF1rq1EuOrV9D7VDa91AUE3hAXmB02xMZVgJQWXaZNUKtHJKYKKyaKWQKpw/Ww1auFVQmTcKV66WmF8ZxFtUy1Jh2kErfd0mFZgDnsdAQtIC1Ff9EZrgWUFevbVc2BTjg9XWsEQ6YXyx=xOriherUMvtUhArnLCYGB9WRVN8DFoP3Hb8PoXUTzPWG3N9GllA9QzW8Vq1htWO0wtCNkL=wjnqFu02/OInGIYVpi3wBF7cettHQgW75ExWMLR1Q00y4e30BqbhzqQS8nfMEniocbVrHM3ZpsEhIHzYVYnWTjLDYvDPN3lte9GAKRl0/wNlYhVMHSxSAwx7N1iANxMRJeuDBnbCTD19zrsaccIlIjRF5VpdGAfFdEFM56eVREsQlQiTkyx9hsdC3XABc4FRBz+xzVpFB3014idDBhSjlH1Q7dmlDB1rEPVW1gxN3GQ8dqJAWtMuqV8QPnegzmMsJX1e1st7OlZ/KcEkLla3ct4BB85RrdLYOtC8kRxBMQNfxLgYlolSrUWXAG31mUmYmd1AEXG0Noot10e0F1hNB3FzBRnXMDMF/SpuXBIuP+Fd309YC0v1VsGXoFzIgT3AgAtgeN/NIMhIEecOzXD0jJNExnNZS1QKbPd7nAmo54z60YwQatNUuFthekMMR5hPmgmgUA0leIf15DNwesoRET3c4N0gQKVcOHiIBdgI1BQpEgIww2W/HEMdIUNeaw3uQVACVnzE8PHmpYC9kjMTlm3Wx2uJxbteWTMZEn6YphyYSeDc4N6WxoU4RFuCK7VzImK1B0gRh3PgwOPQwVl2PhNWtKA7TWJLd1xaHhoLSVEUp1VQ3K5BW6EMODpjW7ZYRsVHdoC1F5dldsKhfPVUyRjtkI1hoJWl8dW9hHRdIFVhx7t3usA4ZEyppMuxFPoOtWUesZi0OzsMNAFxqbRDWWCIGzhjAakZLHh0NuDifKz3pkNkah0O3krbwN71nbLBUMbFUcKOz3udkdU9CSBHp6wwtbZDWyCnf3lQDsEQ24O5xF8Aceu4FRHUAdjad61j8ZDUS212DtGB8KfFj/RrusbVnHWktdXAUtrdDWyE5f3ntQzpJEeF2zlrZqdZTQ9g9zJUFaBFmhel3fX1hm1wcJ1vt9JAg=vruFhthQFK1XUU5IGFaYPYYw5XEgbbEwPXlw7RVSMC93RYpaWwac/oBJu2nJ3Qze2BIenN8c2W17Cm2BwfdYhiO1vOR1U9QVNyQJatksbDqnkdIM1R1iHCVnEwoJeREZsaW0JQO6oi22H1nL3UFbC8ddA/BBwkDXjVBUidCLjlhPm1RakcM2gKtH57UNIq1pwJnC2wRo1gSSuEkegLEMZGUMf1Gc7FnIUVfDUPZxkG/PMt9GukerTEeqkKgpLxEHVcsPgFl1z1XgbFWze5QaChMcaQK2gIwukWa3A7Q9DrX981N9D96gfi7u3QN7RH8PU3amYFZxDnL8/0Kt6TfZDs3BwMgqcabGh2kIH0rXAcrQtQh5seVQKQxg/M5YNWNe0lY0wvzSp7rXEnLWM9ahrZINFuwKkE1o/FQdkhgFJP1xKz3f1eQiYUMWsYRVw/RLZk9BD3aBgWL2rfY+RQcuKc6c9kQf0G51vdkNgVteW3igQl8V+kKHbtjgUrHWQVlwU1t2aNo3nd5CmxGBWFbWpFQg1ugHUcaVi1yQ4wUlteN1hczvNwWsnYKVfo5qalA3wxmCidBRAxwiUWFQvzScDVUMdJ0wsONNIDJGcFR0WP1kO7QiwLVESRsWGwlYqSnLsWxMf2NY91prZOlHuwZWC1u3A8cFYPQIyG5BkMkAeXTFSD4WIVF64jW0Ix0w+gsuG14DmxLkETgItLdfTTdVuxPElmS0cp3HEC0QO9lVeSlFV38MUkN7kUSG7BERe1tmnxz0G1sKp2FucQUQkO7VqG93hsB202tsvYIMVW7QOgbFSrQJ1jTBXBwrgYNAsb4RDcRWAxChFVX2rcoMtJHjFHwcI1zluEV+BwlpgYQgwdw8q02sDkttcYO2QAt2RbLehQHO3sgcnQ9Ny01ObhJRN5mXJEExf1hg2Z3yu815FZFB+LOeiwKqaQd2w97qH5jDXgwbUQsGMrYFHNcQXbVeQE7iD3w8dDt6FDVhO1llqwW9KZ5srJOkYlK7l93PQawC97xy1iRukBwYcIEb9ZwYGNfNNxYLADS1p+iNRRSvB0kOTWNCGt1td1GIQ8MLz59fXFZld86X9vE3X9kRD9/QL3P2NZ9EPA3x+bd/fDkR3z9eFx92/fPCd9Aj8r/QLY6Sv897tPXl5f0Z31k7PwL8nd6A98R/ZBPr0LQ7fP9n05xF8=uHfQgYWPYEkgJHt/YjQq5NYQD/fU8bp3tj92F7Hh94T17bx9btEm9MQfkDAYPEhZVaG7LW08XyIoRo+x1X7d8h9rZtMLcKHv8UUsS2RcDrUDIC19=2/T/H18Q3JQw6neciPUcsHu3m1E0pB6611DLjtmkCxOorTnaLztZmCUF/xlJxUHHbTcGMRFirOrdHYEOfGm3UaetPU+3cBNX+u4hmFaTrzP1asBS0ePppHmOIgVm8zULmT2W31zvdbUc2kdZ4iMeffZx0ljiz9ZHJYVW9hRn9tg3iBW1+7JWgb7kKTShas5iWVBRz5VtW7iLbQFKnztT0VEFnfqzttqd1YcnYHXd9fa0bWB3pv2AlNDUfcHQ6Ft91g7VKlNRtdvC2owl1ac0gKRK7rZWbdG1tgfWATPIP2MHYS735mBnBVB2PC3CeEslkhlJYSrHwkRH2NBKTbJIIgPVowdFVbMPSxQVs/TrUfWdsGmRwiBg+YGkEwUcQ2N23UexNMjIQNRXBEMWWBpZAtgYvepejZbsE+e9YK9mx691VBCRhsUMFLOEnrVDcL2KQp38RB7UiMX6pq6lwg3AptX4gp676iB9TWBdDikCKYXGEoZGz0+BE7JgcVrHB3kKxrb01+rVhU+1Z5B385NXkOsMRMUbRIntuQSrlQM2vBVqwODjw0Bfy03lq8w5YtgMsOkUErAnLHU821aHZoT1hKKRY1nenP2MQ8cOsVEsWA/a7B7dxHPz+uGAbClV8UHW1GPUClsFtzZ70xlbR9czVcl8ggJoPaMXkl0OQBt0bxDfYDkZSnXtLVQ4qz00181H0V8RM6WtsZdxmWEZcAbrsCYjtbbk/a5Ulxbb0cxdrYQwYfQzasgRS2rqwET20TV3j8FbRs+FVIj9bTTVBQ0OuLhikoZtdQQxleSAqkFQKA15qNigLQK7Yy6xZBaBIWMNBhi4gssHRtfCAUkai7huDEqjx+JqTWi8gwaRagQpF3W0ZgkB1krtBhNezi9x4TBS11hM6QYkHWDtoO1MXkl3RssTT1C0cGU9EXsPNTiJXJRgpdUz06a3ICJt1ELwVGY4TiLCsdFRSQSIukC9z1YckENt1pOl1AwOYDxk94XFIhccyOrtoVdaxeQXYDl8SxItWlUzerH2UlcQBa1d90gahjLsjp1d8Ms0W1l9a9iGW5EwekQwXkRuxJ7QbLTMxYnoFA0PpQP4coKgJ39snEToIRX2BGGU+rFdUJllRbdX/ewYxXwrTbhuBNCNwiDGtB5t1UMA4eX2sSOdG=1k6rTUP/ZCHFUcLAZ3CUkbX89CZCBx1vHU1T691QPg88PWX2zTDTLjnJesMWHZoS1h9M0jd35ww3iHc7UdVHpmRk6U1k+VTF9R1NLUEDoVaIynuqdtvWxl62I73VWoogWz9DCl603DdNfCM3xBH4jUVpFZs8+a9xk0Z9tYcBEp1ks/RFT3lgmxTTscPKvnGlsQXQV9+M6CqCp=msETUsOBQXLNkNRqT3pQQM9RoI7gYVAKsc+cj7GxiQGbHoFB6RhrfVUIJ+EUnSVoaEGuY4O2QPZBTTI1FlXqnhSDl0PoWQK0mtGfbKk6d9ipDFRuSGmDyBPRutjHp9aLCDu0Cqjk13kTYxDkbB9bXXDaOzYYe18Mw1HdWbrFB7DElHn8JLRczW4bCXug91UKBJBEPcfOMQNsEBG9tsd3rYUfrNRtZ93dv8w1BFVfuiXd84RRWlGIRFvnqUF9VsX/PsGnMMUQtcXQmXFAriB3KYdUdDqC49dbz0N1vd6YSitLt4dZ6kMJ225tx/HF1UOtSfbm6bA4pgwUFrilUL185qXEYzLcoPT6HxCXVFzIVTJHs5YrTJDhIn4gtVBSAERhYSQTcj2IWblPiWz+gttfI1F9UfyoE39DA3Fjgf0DwnO4GkS7yXdZBH1bMg8MBcURFhYpndsEyKcGgTFx2hOrE3k9tw3Hi1WCgqQdOEBPHeV9q9QUQewJnM1qMpydVlcKYV54Y0wj/Uhhz8aRedxczaE5YBksC6jhXBy2Ese+VUM0cJX9UsMLUOtPG3klEgH5BtKaV6mOxZ9Be5CgOXXkTMkEKWU5E9kthBoH4S5AYXEHba4sCm2TGBkG9R0LdE3JhKMRxxxlsGVQz31Uq1t7/xrt1luXrFSQ9IFpbA6dlkAlyNel2fZQ/HKm4nVYRz1VVCx1idWWJwGFp5YbUGzQQHDu0be/UNZCZkAlHiToTW3TUT1hi66uKB0yQekXfmEdRT5QLWN7TJBn6yF+2/3D31uKxtKAT/njsOGVQIVXfF5Xxdx36xmv0VlkFEcBg/gUv8XTg1F38qksQVBXX5gDkdtbT08WICZkYOF9raCd8t3E5UjTrV5UHk1vQwwEeaV6xWMD3Ar6xPSBiB693k5Zi1EQUYyAbS8dcca2kMC5Vu/c14VrB224RW3teslegc0nfCVVE3H3VmXkVShztXnOQ5SyF6GEi1Ko9lsowV+kXznZ3lYcvWZjP02QwwV+kBo21vcAtBawITQmN5iSYLeRfpwhOYic6x8fLWQXPmIm2THPaTEA0hj1o/O2mfgErAtkRt4wdcd09xBNxDzDJ+t1bpqTipRG4N1ra+2P8xAbNZVLYThsscaY1uQH8tVrFQRyB+iMPprV+QicNyXrEFXAzYWsDJ3C3WUXDH/XofXERf2/3/Fh5+nzxC2BDLuD8cRUw5xXbHN1gD3FZMQ+Y6weHkCeUP8K1tneLxK/VUCl5YTBQqVCk44WFZUN5BJAVUHlj0OXokGEk5S29DtQNWYTx+VH=o5VEKIQMyQVFEczlOxFmrQLaAezgVQzNXyrDIkQFP1UW3R7CGkSQz9VOoMxTdMdMLU6wo5cz51RtgxD4nEz03znfZQ+te9c/Jb21lqEvi1OJHKEO9BA/sTKoNdlXE+ZidYWKQOPw1bOUNDg/zHRF2UrhfRtvE2IqNW8CJw5Nyc2SGCBBRlDwVYxLuiYh1ha0wVjt3kHfLLQUFthJ02lHfw9HuERE1iTaY+HFKIFw8FO1Z9Q5TPG10WHBhfHJQ2o1l+RgI17p7T62HV6VTkHgefrjhXqzkL1F8sc6U48k2ie/JgQ8fN4hQVxKwYYDGBNyWCcO+kUHgIcdQPxCNQMkEG0sM7RNbIdpjTfGCG3MRtB7EZCwdkRmIXD9wploJFgZX6FD+DDIKbOlCVRIyARVxeGNELxh8Sv1YC7dVbB2eEsazREKSjr3xHPBtDog6yhtcOBP2JC904VkmFeEME0OrFVMzYXJ76Z3TwO61GP0xF1196GwdS3wUjMZXEEbgMcrJmazx3bM0Oc1ysV29aP3sxMlIqQ6mxE+Q+4=wIciF85tgmJHzHmAk+EqgMG8QEFrTBdWkKd246VfYQ1YgMRz4nzmL3B8rzcdiIwuUdzuEcNMrFiMF52YrLR48l19t1NtVNvRGBBQYfS+513dUHHFZKNVEQrhqX5PRivr5w19RMOHmZbeFluFXCg18HCRxy9wIpSdWH7W4TEcfqB+YUQg7wcJ86Qoz5xB8HxU5M+J19gcXiXDHJE0N=9mkq7Q2lTObThMcVuQyf6V6xYVF8Lq0KmFguI6c9HtZkEfKzlWIJUg8f6=0dXKlQ1wNSKk/WNeWrdRl6p3UbH1/3iAmx14o2g6YYQNMKVqxVECabgM8RCmJAJJQdIWbdW8TMQR6yoTxGC3XOt1kkgZ1nt=nYoF2aoP33GBDbQbZ/XGnQDVHYjfP7hlSX09cD0PQUQ4gFtCgEu6dPbHZdk7OoCxvNCETiiOzdkBTcPxEwVxemEVPhT1fQI9IRR42itYeLdwe7UNKUNwR1gi3yETlVIHasj7E+8kZxALLAakKtu4ZxglrNCgdkzdDIBlwx1fbJH9Yx1cdNb6dZspw5hGCdc4rbZJFYKHegUCAM/5MMHLG0t1DAhj84Ex1F/4rUBGVsVFctjFcY1UGI1jBKUxc6w1kcXt0QiaIPX1jg+Tk59pd80NAXBCAsZCu29xmwDusGFz22EWFhd04vrGp2fzEtz0KasFz1ytTsENnxXezm2Nzn06piBI5IRMUjRXbGnBVZD0j5w7mslWHju1UR14mHV+YKzfb2Fz+BWb0dfg1b6AQ6FOl6WApJZE2Bt0gZRFD3es9DAcV2/CwcMXFVCkpotiS3FUywoQQ/1B1/tGTnU1RsgznIyzWsafq7bV6BlaYOUxM6G93kfNqR9+ITnaPbb04jBn15BX/p8XRkuyoBTNMgbwSkuT1P7sVIgK=xtPGl5UJITS7tquHzHtxAJuxB6f1ArNHJcCT3rqHMcXpsC1ptIccP1WHdCRzrTPMauCAtBlRYTOs0D3M6ffGllJxq3gFRgPH3TlhVzFYQ3RDy26sM2UMFRvcweo+K4VlbYVlC67TI65LDh53sD7WQwJGat7nLHOvqxAx4B3Nzri2WKtUhA7V/rGVs4X8PUdUXEZtGcLKq5aZslZwSdtRkI1sqwxQf09sXO10ewtUMqztXSuI6yVfsdUWbdZAgJ6dwzKoZT9xZGcM30cNx8wXTJaxYfthSHDu1eKJk+EhFBB7EBnhM9x7BDThMOsgPTXFzTcCwte2kNbRgrH1MCQQnj9ZaTwUeAjtUat0ekN0Mwql+Y0OB3O3NH1nCWvcPSVACThpqVlv2LTMwXtCGxjq0K7LZXtVOMdcXmmtML8p5CoMb9usXdiUEHx8YuHOpraDQYmE5GmYY7U3bLYZS3DieTUOtWEbpWECaDPTQQwEGFVv14WUwUMgRhshByICZznesmFMEXRn83AOHbjtd4isZnUBYweIQ7hBSZ1hl9Hj10DTcXbc5Qth5d4dKUK7ElbQhwVBVPHVQRTwmc9ZzNfcQMzqGIKBlxUPduCNXZ1UastPe2UNpLE9TQQU83Y1D6CLYEGcQm4n1Qkn6fsJoEl5ucDSrCwoQxkHkov93/2q3Y3bh5PsE9g2MUSBZ1TURLZXHLTtqgCzcJ1s1uTkiUGbktqxNDtBSeI+fS8/LklJUdeoB47ay7bcQ5cUz3kedb1SQNOcF2oawpFrhH0fZgIBHhUkhiKT0KaZQ5AoBYeLjaUP6wUEYufWwYjORLbNDY3xE3ZVN5QBF5KAQIA2EH+HHVGFviUFW9CpCFVM2WpTSLHpnJLxElOyEMQXhuGesvEoI3EA46e=3ykw5UEVEEGvS1CZhTWECuLA2CrAw3HXSrbWrtnH99NUoK5aacFQBTh130dDgcGRzAIAWV6HEsCmBM+AgV0xiAxplDFoDGxhQaYG9t0WB9DMNdAVRLtQU40FqAXYgSxBLG1erFUWnUy3ze2ZAkGwShFC7URUQdC0cMTPonz4qFE1ArAGQDDaInkabZCmpCSBloPIFZIDwwbFgEmAjUKlEBxAWrh8dtV/XTvo6ClkYAUb0VA82IFyr4RO3p3oXAQRpz5dG9tATmUykFCkE3iuNo65ykNNwiMlkEAvXWvcjpy6YecH8DCQynUVo9Uap1Q1YnA/NGJuObF7JUFIqUPHc6YE20DLgIq/09xi4Q4agRPBB05WXpMtwFYLWhCrEQA0txCljhRoEq0YV+FjIgx8BtAGsObV5bzXoqEX4IKSC7stgYxBsYQm0QRc48ClTCRhukBM6LUZYUFOfV9HULDAl4QEZcygcQEvhQwWwU1FkZwP2uEwwXK5yZxlHSCix7QiQxBSpkWsghTLfVVU1FbDEgRVEdIcAeWgYkAUDaEhmCFr3ETYIsPNcyX5Q60fNaSZTT7Xm554fxbPxYITV7cN7ZyYxaQRVZDkNXAgXHgu2mIFSAgmwMwkvJYQkBhcVigKg9qbASMKsHmpdqcsmGLbaTEZiF7oHB2HW9QKCZ6U2HcavUJlAiUY7bgcE0HLwSmX6rMl5Sw6SFPHR7ELiwKUaxRW61UtgHAl7sCUkB1oFtiERGVEgd1FgIG9UKUNBWCooH+1qXQNCgUYozmRJpBVQOw3aQ6DHEFGA4Zetfa=typbqR8g3luBSkXJMFwtVdaXiVZQ3k60JgkCEEcTdWTFg2EiqHI5Am1OYYOwL9RSdja7mTtuc383OGspVUAxlWZk8ZAS4say3wgarhmGYg3Hau6RcSNCtl1BsiwfF5oa6ABLM5wWDLIhc+pKygJlUFV8O4fRFPgT9WWDtEWFBKCpsQTgk7C+h5EleD2MCUc23DB0PQSY3qwNhrU10JoQZvNhdFZNEUuIFImwQJcetlUCGkvEQc4QRA/SWe4KRwc3mYLgFQ0hU5gZb0ggtSMPFdcPDjFRjkwwki9dTeLdQmhLtRvbuG872PhG99JoNJ4Qc1IBVXscFUWoE1zzsEeCWcaYERBUFVzj1YcEoTEDeQQ0NRrHLdYXYleCYExYxXA5eAojqSdDEiVlmGlVRwxXWyeYRhqrS5inMsEIX3oV3AlfAdf5119YmGw8yDLRkaVV8IwwHIAtRsQUjIuvNRXBUcc8AUOBF0MRQS09Jdd+NNDVXsQPmW1GIrwnhZRM3pz1YGpFaLjwoRUECAaw6Oli7GQsDQ8Q7sRaDxFCFUMeLCrMteA3lepCBuIQUHg1kQ1li2IjWdLZAdEYVZwS57PUQm6clMl9VPhcJrFmNx4DBGRRD8OIUF1DBHIRQwd2ZgUSIVriexAED3MQbABVwxhXVUMGEHB9DWgI281G3gNxgQQJUIURQXsWYh+t85pQgt5+QgCNQpExCtB0dHVA5iwAUV2KuB1VSQhFmpsdlBydgSYgtCyAZdX0GQEEbUyENNjBaoTogFmRPWktidwZ90EQARleMEWtQ/VuFtpLRk5JPgKtVUGCCs4CsRW8VfeAMSSBjNAVxAylbcaxWQjBIkARZU7JcwZScO4FSmrf1YyQmmIANqdq0UG2T8tu243Jz+rdz82dPNbrt8XXZdtWkceFp9qoe/ORN0UCNCaAZwVj1lRsE939NXCBfTpZ=t8O4V9+EXF8t1cRH3hP34DVMGl/bf9hZAtC5B8uC/Nc1jECwrbolbBcSoRUCIuBwqxo4DnHHeTVzR8lC32MgST5oHCortBdqS5nA1iBuFiHmeMKA6Wajhy/BMGoIatCFaCjUYZ28ROwrZVggXWFv03Cwtnh0NwZCvYgGsXdIT5CdNWQZLA6EUP6uKpIFHJKWYErVjL6V8EbKaQpii390sIKth90FisRltE24sbADf96fWAc/T9xYysmHrZ2naFukEzXgewYv7QJ5QjNSe1EJBwIQB914eASDWlCDGJBf9IyYYCOQBQISYUNU1HcuGvZSgbXZ1/8zUxnT35mb9l1Q0ILAz57jd7N3XTMhSMHWw5If5rdXpfcuJ+OtnnXsZFWwzOw5/Zt8Od9jcvbbXVUHudRatwptxc3fUCD2cSrBn46mNtfe7rto+zT9lHXpsNzogYz6sVlNJjfaXb8c9M53xrZdVfrPz2nzzNDt+09RzIQ5h1wdDPxFjdsFQ43BxraM3EHEPZU9zV5q8l5XB0gVtMuRTQTUNE/c6WVVf1h2FPCTsO6eTndyer9t8E/NrF5A5X50TRtlp0c+a1hd6ftrllUk9wPW0eM1+wVAbH3XdIg1HWfDshXFCN1u83632F5NVF63Uw9rfOUBWU/NuVXDdanprY1ll50SnJtUbLl/Nu0hjN9180yV3ljTnd1N99DTF8rWVjtV7dIsFibvXQ+ImWHdXJb/bSp7uD1uuYNVUxkNCDkNyRyPUMnln9UfJzWc+4RXuXnON1mXt1YetlPXqse83kx66e06BdUhXHrJANkw+2Yy7t9dXbi1BccLCuedZer3Bt3U1pXziINc9/32PMZI3Hhcdq7H3k8Tnv3N0EHN+1Ex2kPWLau1dYPNXL3B6TkP3fN5b3JPPs57929iyx/Hcdxz4yQO49zjuPRtx4h+LQPfbTMF5yMfRlGltk9xGtMZY7U6X59tO7yT5l+1X3cKbH96vdHt14eFODMzcnq1Pb/FqszeRBaXAtlcf60ccRcQ18NYX9VRQVwbuvbOXU11E9dHtxsa1f03uwG5DDl9NBy2mW1s5IT0G9ESmuz855wO2/StwPw+o4bfra2Nqt6d/H7v9kN0+MtYSTnU0b1ft3FPSzdpT0Qq1F+X522w27Nwc04Fq3a0YzUK2nZlM90QxwsPPklyCx//T1uxl/DIufMseQkd5cl9lstwFGhv0NhTX0EIwLYV9YfT9UEx865BcFTHcgTAgR/Q2fwxOQ/Dw1BXrd102UZ5lVQ2ZE1t7HjrzVENQ7tWi1n23ROftbjN7TlbrZTk9JX5w0Bdp36TUdl1tK7d=3cuag7FHvZy3W9ldX0oZLFeu9dlQsPTw2cO3zYlOuVF8UnJ/CjAg6xJNIQplbmRzdHJlYW0KZW5kb2JqCjIzIDAgb2JqCjw8L0ZpbHRlclsvRmxhdGVEZWNvZGVdL0xlbmd0aCAzNzE5Pj5zdHJlYW0KSEbUNyGwUSXtU1TNqRhWQs49mbrcGUaNeYKdCTxncRpNDylDSUIaCUN+4gBmF6eFrJRhoIkoytrs9+w3WXd8PHnBm+t9n8kZyrBUNcTlovKQ7svTj8SMvytUik1ypDX360Tt8dwN+Pr3SXtUuFKl643twRDDuN2Stw9kauNQaHkWwKRw0g3rXabwVufa1Z5TprXxQ51trj/kD5dnN58FzFgGoS0VvWBMwwKD0chg1vTQc4bClJTuypIt0OtRXwkX2LcERDcTDM01wVX0a0dkrm3CywhT4D2o/f+IU1Tqob91PZN1+9EKc3UEVVaVqg6QtbU6VemHt6U6RCDlFPcW9J0ghA1dDcPMeuPQw1wKrQ47QKUc2FQ1z67PVS0DtpT5dCkzGiQSpxfZHbk9yQ8wgWdntiIwsC5GFNFE5yhMzJdOsQITedRmHwyrVHJC0cmPDjT3C7KwREXyN+R9uoJ7ViUQYEp1EDwxMX1iuUNRVc1dfyyBLtQU5WHt5FFaqyliCdRPRWNhB9wN+Hh5397iVOIzH6d6SsZngpCkdyXdUCi1hNcsJ2g5b+v1wgdHSrggQxbLfVwxUrnUyXUZLFHq8lZGVkDNR0WTtglEaWMHd/e7B6dmZtimyxldBsuZ6fnVlkQSZZEa767dpWqFuXt+amAGxWTiBVeV8nEcm1iFPt9WRyX/5TNR4/9grcQIFoKIm126+9uDOkTWTUlOJhUIwIKlNvDL6IxceDs5wQk79FF6DAU+1m3RckNPvQoK2ElfbR6bY7BOYLWRfHVt8F9N1ASI1zsoZxFYO1VMBD0G0dHRznAxVnfjUFKVFaUCAzSzJiYGT2kQi8+F0hpYjQfGxEiF1QwQ2gkQYGWVVf1D8oLdB84NCVzJR=+iPig03F47rc161zH7s4jrh8G8YxFoXcE0cCH0bWNkyWvtqgDqlEUDXCrA35KEwyBhoENc+tOEkUgXNxU2VZtWaqGgMFr86ag1dhfW9aA9OKgZIVFsSRJL0PLQdeFSr2JhZXFZSYNcmDFOP5xHR1bB8Q9LQxMzlYKaC8bXzkH5xJcItTci0XA8g7jtksG1CcDNfSW1vHl5/UyIQIR9lBSiSndCRlChVgPREqKcFuNQcCGB0vSbjhMw+45IKwlIq1eUbda/19RpsUXCQfVH6=z4sRVps3PbEUwG3wQHRg+dPonebhcGfLRTSpSUQ2TQs0e3UOUwsaLhRSB7Ci7Ws3xT6t3od3YWGuXx5K3HAB63aoJUdmt+7YzbBmakQVVMiz0j=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taBCf1BKgduRysCzss/R05/R21IaRuSYP3xegRfk09Ww3XUh+3TDT4hykHDte7XRQNDAm8s61MJbTKQUNpGkZWLHfg9oH63FVAdDN5FhkCcEhXXdUdGk5SqBYZQZyEwSrgVomDtPvZ80wW3CtWF1z9Jjw9kQrE+QCzh7HcBRkDuCxgVRtjP05XEVqQKdRkMEAcytCEgYSgDaQC6c7i/Ju2QdITlXyVsp/VtluUJf753hdIyoKXOfNRuB69wXxkTd18GxHHuxEfrxWXHw2UH2t0E3c70ZKl5Dyx/ZVBDAn08XATPsmYwVEIMpQ5HZ4MRObitMx1hy0TdLEwIssZPLUiLl96f1wQ3FqwLFNeasMFWCo6UEOVQU9dDs5PcF0QXURqIwj/tHxgyVhYZAk5F29vEClbIbYU7dVpCoIL6ZWQ8AlIWBSfppLJXVA3EmQumthzRjtNS8LTpIuT5JBgO2BUI/YCBVqQJADRrXBtvbuWNPR59CgOwc04RidVSlca4RDkJEt49IbcttmzllCxc/scjB/8gXioE52AbFHwx/AEjWXNeEhjNO19/RFc49E1wRXsRjFk2ZhQqhczmAXalEVtQxWYL28sUhNZplTXNgT9l8AXWoK1V97eQgTsYrRviV31EYWQ2OaxUxlHNQqkUHUYF1tUBcGQdysyasUXBSTppZ0cXKT18QURl18cCdc36QYFQnFBRW0oKhwIrnHpOL6P1B79D5w/t7n8zOwUG7WFrZ6UXkueSMc1tkCXk+ckMOV0EddI3Vntw0550FCQVkc3NYZDl1aWEprRERTwZM3tkWVcSBFEKHnBAdqcUnypZ11DrbCAIMIVuscW8KZW5kc3RyZWFtCmVuZG9iagoyNCAwIG9iago8PC9GaWx0ZXJbL0ZsYXRlRGVjb2RlXS9MZW5ndGggOTU4MT4+c3RyZWFtCkw1dwb3BIEv0C/QNfAiRARzNe0hkWMjuz4EwxsFgEL9tl4iG9tpW/NRW01a+Q4YUMY89glDFlSktdp6sZ1KmpSHl0rT0+WBRHLCx/HdD=1vdUWN9Xqcsy0NERjlZEnEfk16B1DZbFvUiw/e0NRkb9BweKw9GB0fcFz19aVabw83lVU81yw9vC4jBN6UEdhQRgi1soBx8jsXu0WCUEj9vXkbRDxAhbkfYhEeCRRC0h0CkkQXqA3FAkGchFFRw4S+w9ti9yUPayDcsWkc6ZaWHAzbEDf0MWeV7REeW91FVk6FTR8NzwKVtHXDEbFQQsYVQcmkKIn2waDz2KVsGN2hscxgaFk6xbbsHCETEatzaOBSrkE2Soa6Ra0Wg1SGd+kt8x6GFD=ltfQEHpmgaS1pVe5vHFcMI0YrcmmDy6fHfwYraGAbgwYGhdGwP53oXGJAoH1m1IFkiNQRT3wUeUirGtw2ScFhpWElIfDy8IuVVVHW4b3IMBRqb8AoFjGwUYQbHEVT1vdp29f4xE5uxrTWR5CGA8WBKqzERdn19QZ5UMCMFlQPKQK9DuYSAugi59gyVOWEpFhczG4THXOPsTLJM54ayXLQ8FHUIPVhceT86mH49OS4sOjRkaXuw3hT1q7NjQuGkmIW7CsWoBa7hN1IQC0QaO53dxtD0TrBV6r7c3ekR=7dN2NmoXBFUMkVX8GMVCJgvJnEeBVVwJK6occMCFtFUC2PTZuGBaR1e4UmzrM9VRacMe1l60wIqLXdZXmIw9R9wYxVhAUT89QfdYVn03TZpYT1bCi78Ctbfctg3Q8rAFwx6dvRq5qFhbdmcbOGU/cqhJfFt/ZVFheO06uFhLCBbxlZ+FhGQc+YVUbBz5hWt3UMLWFV61FUN08pKP0RPQduMUh1fOQzl7CMfOnkCxDdMfQLEN0x8=sh3mxi8zXx0kHXr6rt6+mogUPU92ccB9cpXMbMUlReu6nlFexvfaFQHUk+SLXTRhUCu4kMaXEiS0MDTyaI3cCqXSonC3bdVhkDvHeNxGk0YbRvLRMO5xkT+dBbUmT8QQBwXwrYF27tCy8EeLUbtCF3EERA0hw1yiXaxrpi808dhXfCphaorhPXP5RY1xAejcLq9n9VIuQlRVrd09QaOmEVxoC1jdWjEdS5g9wT9AVugdE7F9K3t6XUNxYRH8DOQRqQFktyte43WOeFRURXULQagNa9xECcOQaYkPdLR6=/N5gEGKBM0wvPcT3dkJ93tAwJCmcMxcC3kR9mLFZ=yFDcS1xztSnNUTEU0DO4zaN/6cE1YXQ/BM2hYUaLbQWtM5Vvdato1wnSrrjQLWwJeDAvhXQHfStbF2THu2EPCu3UkrUCnVj31vMhcLNXh/a1prCNeIhTGTenohHwsHPt0Pz1Se9kXUihLmXhNt0MK1RATUCPjVZtGJdx0L2UVCYfMgx1z7Rsfd0kcsWeg3BgOeqkjdLvXemmQS4NcQ28wSeoHxkEPMSzWdUUxPPUZFh6B4SBVj3w4mwKokvfYAT1JRQ6lvDFsDpw9EMFCcijpCyeXH7YUrHXkRUg5SWvbWM+cENU5/M8Qw893ecDtKT8bqYK0dBmLigZhdHmV8VxvcBth3OiNZI29iR2UQk5Qk8Ardcw1lTeMZe3B81nUQdwJxvHdXYKSMdbJz61NcFL61C2veudN14Pw6Ym559tVMEwW9Tn6VEsBPWPpNw38daaB9jHIO9CgRylRBQsOY34xbDdwx0WXrUMK7LPWU6Il8NV8+P1p6c+e1kmbVrBoLVYS8vIF9v5sdIRXAmC54qlVwl9gGU57kse1iC4Y9M4QlVCsVVmNGPHKXYQ1muREeWbXWWnYYC/0qURU3dxRRsnYWFvNNw7X3vfsTpP62B2ffUpEVLNziE34W13BbHPTCOD1bF2BfGQM5FpfSmwPwVxbBEbvhVDpUQ1psG7VWSSc0jJOI6PSsEW88Y2N6Cxk5V9eUWO0gsRIjZYtYEETQ5BkTcRnLXIhdFVAjC1kQLxNZJFLc7VtE11biXXv85/M1UgKaKQFbFV3MESJy0EIk9DDYGLUrtZRJnXLF+UkNF9vV5G38Ce12nB11FK4NBbLdSTldzx7zFN2Q+lJNL99pq/3uS1wGFvQRBZT8Yxn6OnZsGg90cToaXmmXV/REukc1tH+cesEZKWEy5Fkv8xukT3mmD3TW0z6IUcbFliEXiMwRRBmnR28ufXsGeRlCfdRp0OgXXp6GiBAk0W3MeDphod1YFmBVXXEGS1uwWA4RQPaGLUGTwVFZFywHlECGUt7mEYjgp9GfWeR5b1UR9yJJWgRcmZbLRwoQUCeSgQXFViMi90FXR917XAfUTD9enJcWRglS658O3lBTxETAn5lPCUJxthR3APRudJBtm2lfWs7icPTaC1Pq0ueaB8pj1hbdvRjn8aRgFUiFn9XK1lIL1kRFyzdKqZypvznWESRlQ50NYUXVwsBxlrFteSUxXWX00VdOIaRmwRlUCINyOhrLRd20LWVMTVA2DFcu2R8O2EaWJffDkJQUYdUoDDlJH2Q3jemBVdrq/ZT65Hr1672UpncOzVDGT98cDyDqLam6wpssFXXM206ajlHC1AjJlHW08ZbYKGEwwNEZ39BTPYGTCw9733EnT2DLHUOMhD0iEke1THhk18ZWUUwR+=0NNZf1jCzvTxxpSFTNNDxpiAEJQbEsTA0VQegeQc4lEZAIcKnWVjo0F3OtDV9BPRV0QGPatqsNRlhKkN145Hhs2EBUQUPgQ63LENgg6sKFwKiHEdRTdgRA45GlDVzV1SCS4ExFbuUg6IBV9AQdJHUHeX89f9lphLddTtRa15uEUPaYfwkrkpMyg2o5BnkUN6msBF7a2EjHlStBoaAXJAx01TbUcB18DOwd7A2cTUgZOM+T9S0PLNl1UDkUbafbTgfNUW9fd8RdBkE6sR=nSgBmAgH8wlIzHemrbag7evZRK89+MCS1M+y9kQf00zdTo3H2Nd2IiBWkGUGxLNgldOYmMTk6RBijO2dHkpV2F6abt9TC9Dc0aXFl=gN+HwNP6S6QOcCFXM3h9gSnX9BXP0JEAcdQNCOtkd32K2ddcAQIcQQQXEM6Cixt6VV6RDUhVAcBM8QbVtuBgkPXUitD0Fi3UhKzoi1xXwM+FYSl8yyVCTHtzPwSpBNZf38ZWNbaXhw28CK5RHxkZ90Fw3FDHdci9hhO08FnI9t1afkd3XB3TQxoMKwoCxgC1+DbRduZLlhU9sgIAcCzQXBJ80r7WBKz15FGs6QO7TFMrVixVNzq1/Xlva25t=1rYX1R/mWQBb0R1d3VRA1lRJBUIuEECg7bI3gpIjIgUolI8nf51R1DNDDhkadmJrI9tYXl6zrnILCrUWd3aZD+0KCDtY37soYil8jdG6yV+YiRTwoPNU2mt8dhOPo2PCt1VtY7dDX6wgSsGtzkprq1DKjgCM1UMLCZKjpV3swWRrKR5qxlwdEoqEMsEX560rizTaDBGNMNW2dsCsh1ANx9k532S2Uh6cvdZXUzXT48QdiP918XzVXHz893zdvHx/HaQtIHl8/TJ6ZRAhgxsbUc/HkRdTnXNUITd80zWFiw99g/di3L3b3EZgwZbRkHQQUQpsFGLz4LCXUq56tWgp2J8Rd3y1+WT7cC0l+tSA/Xw2sQ4F2ehrZ7kbHP3A2sWwcLc0g4u+lhWh8W27kigXPXEZ=/N5C1/dO0V5RXE4Cwl5MgtjEEAcuEduY9kiKhVxna4iSmzvZxRTgGo3UwX0VUGMUdEFwamhUgbCVyTQ99cdpjUQqkYA/pZLORtKmERwe1ZJDCrUcdPcClQeUl9BVRZUUZKOwQ2cKtD0Pn85aSgseSp6E81gblIKOEDyzlIZEU4NDwnrVeYVgCuFYarRtrM3FfiEg+SPRk9B8GE8fhUwZsAElkHMB5HEhgJaWcGDbJ69QB3dTnWTSQ7c4WWJ04gsNFPY3wdBQmBS7udBUA+0RcFWUJfxFTF0eiFFHEiwrWPBMxiYDpKClEpOUJjAx4T10HkcqwjAcCO1sABK/VkM5F1lO8MGA1/6UiFlFlUV8+cm5u3TtOCI7NQ/C=+RbA6gRV9Aw274c1jc3kDtn6zXs/L2LcL3rWb9l6Wvd2tUe3fLUQVWMXEW3znc+3Ftff16XwLtS9x90+15htHVCeX5ZblbrW1v1zchY/LXgyg0EIh1ebtePjV7bx8/be426+fnM1dWQ856eLu98kH9F157dEdvdwz103Mv6=+7nH3cPODzUEF+OtQIjlyKRlYjp0Pxcz2YQVefkr9EPTKTUrBz1utLVgFJBiqaUFxhEQs5cnTdQhlXilTZ14fuBiuz6I3kTalcBWzqubCkYTCmKjPB9AyYO5W2EHQxd29uF4DCsdBTxEK2CkRmID4DSQfECzcM1ojtMFZ19jFVDpFXGtjIgFxl9pBIV04YJ15cAek5ZI0CfwfpZYK76RVbdetYrjcoInH0Y31CHeEqI347IPPfJD1EdR1RFNt86FmJZPwcx149WeMxDnZA9OJXkRg38veUQ/t3317FGdit6FwP9SPcMNy1BE1Fua0qCgc9wRlYPAkEVjiGVhwUCoYQQ155A4EtfjE6U3s9BF6H427ksGLtq1oMMF3JfV1eXlLWIGqup2V9flAJTohOjSDCmyrtBODiBUGFkJ1YKAkbJhfbG5+XuurEM+ggLLdC9vxPK19+Tr64XxRX4OU82=/dZYHF5FTUGRggrQxxwUaIV/d1IUlV3TT4gHV1Dwqva1lk2gb3VgKB7Q0EYyWFKqDgSmp6EUPdOzsPPgdOTm0gME5XJ8dxYscQRRtEVgnUSkfV8cmhkS6V4qzgCme1VWRSLFSP5Qgkodz3OVt5WHZukEVDTb3CVIodCsOxlkS1QrTV5NDt9dzbHFSDRKcTFFhsFt3WR30gS0Ea21h6VtV=kHOVlCFENRPQZZLCEDV8OQngdpmw1aksh4ekNrZYrDluplvOIiAlSFINoUklkXUN32bXHNVVF8smSjgS2kioGEN+vo6qt5Xziby6QN5ahxROpUGIBaeIycJA7ziYBvodPs4GsQ0qKn06aVk9w4xaxgiDguewKt3xHEjBSkBxBAps6aa9kSkFh1yhL9y8ytMFJaVtVeDxxx/NxsXe2=0UGBiKk0HEwcSp1oLHLTJEVwdB9HZC0qGSbnTKwmL0tbZ6vf7U82PHUUdl8d+tcs4YXsMyTiLgssRAKmCxGFkAtexhsWiICMaWVUGkliSt7rSgHCmrfOBVT5QsxJTYbG9ndBLizlcCp30rYXBwwR8Jqz4paUPBg7n7jPBcwJGT3UEQXFgF0cOTdcEiLPbqWFIL31nYji4GsfWQd7VhRSGV7wIbJUPkKhgFORFb2sXsIapIFErqw51UZKDJOd4iCr=zAyGttMP6hVCOmQa2npOSpW2Ea40g2qBsVQSM5Sxtc3BKOEPbzWFpT3wUL+fzaUYpXE+DWFFXszUJrXdDcUitUcMLExHUjdQexT0Bc3/99cfF2/uE/rt389rXu720FblpYJVrZEltP3EGHtL937ZUxl3gfZlULX5xqxbWBuNw4vy81qZgtX527ipzrTRWBQ79eHm7Xj4028fP23uNuvn53DNXVkvWQe3xPN3w/rDt84m3zNkNaaw/7n9jYfd9=kNBHwKpQwnNePRQNNypQ/eDMQXJW9661AnUI/NWVCnMQ=6bHZLS4CrX+s+hdVWFcM3HCLdChxYEQ+iLFQUykhI0aa1gYKZakbWHW54VM1SEUM+Uk+edRg6ze98F9sNdNiDzETmG1QwTsDOAiB0F3XUEIrlxP1UMaayICQxOY3luIEoK9NN5JxrH/D8PRVFB1mdIBq2HwZdKzNWdWe18IVHVABsOt8I27kQixuGw6r82MNcFVAjkGF1aNSrUTu48y2rIDUOohmqA8RIVoja0ULICcJSk0HbBgHSX5Uc8gJbAeg1yo12/CNifYscEMxQ1ag31euFAUR2EEBAgJxNhMWGDQ2EOPQ8Z=ll+EQTJB8GUtQ7VtrEtgKfSV9KE0hIf1Ew8lUVxUFxQ82Fkr3z1eWAQJEyMfS0GQynHYB0VN07iFkLb7BbIK5HbUcwqyC3FDcQeIEfEKl0whN4VBFAKM3XKVsqq1eiRjTQSk9STVisQ9esVeVo6WStA9cAxkEbUfLVTxBYihZwRcWD8qKtvLW17CjwLMbFjIGdqzRiamIgZxdg2DnHsb50M5T/oMSbY7H1taG1kCSK7tI3XBQeIai4Tz2jjpIqRG9vUC2Wr2QJSF+HQ6RTkgGhw0bTZ7wFYT2s7GxNhYLeaf0HBsb1E40Qw5R5+Ri6WMTHMZlTuV5HCihswXoqy2AUgSvHSWCp6gmXoW0GL3CswoGr8M6M8diUXsFy9fWmynMsn3Dh2DdW9qKjdDcBETPRoPytfFi83wWpQxZRTvbVh0awFB1GuEiliNXlVdDAEQk9cgrJfgoR1N1iXqhgw9RfAdhSQ9oklYBjVfWGJONCZSEZS0eN6fYXIyc7dbVWrBakI/Q1hIFkv1BRZlxNSVGsRk1/XY3dTERLFXB04SpgXUwsVzXBWFAk+RnOI1ZMFy3OnHWZhrpwxBL3BzCg7FYQ7vtBURSXD2Sy5FNJEMiYyZlRGM5/M18tu20cWfQLQ/dGVRZmV5b0JWbEoMBVgYQX2Dwg4jgGbFqIZCVvTnnVjdQJoKCgTNxZdXQ9xOA6dPtQqQpgfUirXQ3cRW9nbj5P7QyksUgzGbrF3Eu8JdKBkf20dZaRhJX4PC7YCkvdQxjfxz1pMSUjqxXCCIuQ8ZaQ9+Kaf9exkENBwQ609lQOrdXscXq4OH14PW1pccG0DJ6k6JBeQ9jJT1IeLZIFhKmtElXh9UuF5QIfB7WZ+1+TQ5HNgSaYCAQdNMPtQCBpZRN96VbuGtU1voaKUFEStgDcGggCfswRHXBeGNE69vHsaAHGwVBwHTV7EB3KRkY1CVaJfaxIStSTjJ2zkIhVSHFRbU1gFUmWxMswhdzZzk5KwNRAXUmRZbSkHYfMYM7begeHRwcQNENVUikCZyKwQiouDraBVxTcLrX0Q=ig0qEXHMm8iCF9PMTWQQGgj0AFF8fkwg1Qxdwc6/REpGs3BmVVhrq4zJSiIUAdNxgp3XXXg7d9eBRJJASSkd1/UdhzlX7nkcrFa7V20SnNiYnE+wJXKQlpN3VLc3CBewEZlKsESjcWT/ieltiUDt6cWtvEirZUfbjBnITkLVmS37OikmtHC24GSS9DV90FUFdkV/3diTp63s6Ed/iS0MtSlosFwZdBmNw/zRsFeQS4BQ5yUdiW9+lret0Xb39vaW8H91Dd+d8zZ7uxjJL9lCFLUb3xjEt1/8mDqPZaZCVU1/3Ol9fSPapu2NiP6y2681Ic1GwWl5fLl977wd7CEs+mgubjarD85k96t7dwzf39zfa2zjdZLPZP3E+bAZfEeO9w3FQx80C3nd5x93zg+N0Yjd+vbEwaalDD4Mxuy7Lq3w26w89wn5oBgUoPQ3TtnFZtQ1eEXw5wngfJyM6w19KPtdfXQkc17pHXDuKT9Kd83W9E3AGT59Emh+0H14m9kbtWPf9t0E9A8MrQYMHE4cy1UWJWrCYgFWF7hpzCEA3W5fP3IpSUFaA0Fbq30TELBJimrmF5dj2BHyAcuQORk4tPTq0VSEIV5eDvTrTt1Y5KlhWV4QREWiB5/19Txk6aCnd6QQ0V/UZhU9xrHGrBY5Z9IWKDTFpiWnaVmVzGGDTc1YE4vY91gSYJUNNgRtQcWVbEmetRFIhKgJXAm9b81ZVIjWWUIqBWT9rKcPJanhUsqVNCVRVIQQqM8P9JB9UgXLVVcQSnTBOkI9dHtRuBUgn1tgOIk+fV7T0cQUQtz1eLSdBwhmpKSV+uDMZyx8tX7YVzl8UE9lJ1iY26fX96Ha1scRUWtaUCh0e0c9rgM+UxvTTxRjVfMgfkuQkcdUEXoE7QCjUqVmuEOtyX2g6kFNULr2amzXJ13rmM9wN8=zo83VsMfU0efWF0pgxl4UA1VoxkLg91znVBz08cLgREuySYdB62IGIqKBxCSFLAyOobMIZw8dh1xOwShqbwooldIKRCrehuxi9aYWcCx52YBBZ68E/zWAgWikb4SBKDI0xzkSEu0KCUISttBAVzQWLORsfd7XODO0RTeBTHYwd9O3JFadCcrdQOTqoAy1akb5FQXBkmsYR6KEWnYQsOp2G2TritWFxtXsngz5x56LVtxZzji88Eyottu396GwML1UKbjW4py50xl9ggGvZtVH9UNzUcMy1Yd1wuyBaWlUUyy7EV9ZJHtbuzVzB38YdAlwRM5BoLS1CxvYO84dF1FFUXAPuMRmVzQ421hhXQE9B8tz72Ge0g3lQ6acIZxpUsXsnrid5VX0KR281X1VQwaiNoqwnOGkHEOUWrYz4gIETNmDr8+lHHTbZWm86X0QapwUIY2IGd2XnINvjc1u1NWUs+zZthEZykQz0Qu1AgOLdRGEsZAgugQ9jU7BNRiVWQWMmSuE+5xMaV+tRqhCFQdQws8FWQWDrZN39HxX1iDLQw215b1cZ6xF+=3A+SRUHWFbvtvRUR4OH5YqB9pSNZoTSoS9WFityj0RYBXBCY1lkEbbiWjPk31YMXUKYqdRKUCp4RpnQtQ1aHZLZATOOIEaKdMCAkVB0NuCrUFqk091VFKlVTbSBtiUVO21nsCFlE2NZXCpDRT9aGREOgbthBRg0SUi1qDBbUUGQe2toiKTdoVkHMVNhFQORwxfZRbbA26uGTWmJTlsD7UJHdn7UfdHadBLDk0a+7WMGBr986QYF/dV85yyERE19QQNWtrdUYHXdbix635FHfVA81gVuCyWsJUMJAWvdEmqYamwSxET0NWM+oPdVJhgRG00WRnCUGFXQzkZf1krATUFZlwCBsBRNG2gdC0ncLZe2ZdsXpYIVo99KFaN2gYlRl7naqEdjA28/mAyHiSsPRJ7+UbRpUIUlwBd/YTUlEn0YtR2QEWOtDlHKV8KzN8azlfWVeIKbdZWtCi3cBEQZw4KBcE9C3FEzVNzcQsPeLNLz8t3/0+3D8/PfdZm9XOQUlIFV1zcG3O0XOTiYRnh9mpJHYJXV8uULl9a639w+r7XtCVw9rPXMvXq7tEK+M5+UH4mdC+xE9uW/0eXu73dzf32xv631HN19m3ffVgMgHUStntP0Z=wdh88fu83m7dxwfCqkoTx0KxlPHWFJaU8cehlanVZXv21WX8HFfZDMyhA4UF6t2TLVmu2rUFnKuEtYSVBqBndFRORERwJgcsAtBWUE1iVa3V5tN+rSXEbn673eIltwtHfXF+g/ZH7QbPKCua2Vj3/YdUard30IQp/sbf6TiKb5bXJwcFoxwdXuD5PVxdhw9YwlTNERZHx1eBMN2PHb3F852VYMlywY1lCv0YWxkKLWcGUm7YaqEE7iDN0lxCcWW2FVXSgFTN1+90pHcxNvEDtzjdjDylvW1C0YxGlgDtqaZQdeILQMSyBKiA8G0Bz4klBaC9fQE1JFhQIUhJoXS5oywBBMtRRV+PrYwGdrQ1TWAIBA9g8e8CN1sredl9bhD6rCQtAQG3F83kOVdRMGp0Z1l+qFAOcM+VRK85SaVIQNVvPxUGmwKe5D6p1iGFJNJQludwtNtEK1TWN74kg4Cw9uh5SXVurK3O0sVV1UQM9RsNS156CDWspF/JUtvdK5QAd9bIQzzxA91EM9VQZy8EM7UQHRdEsJvwaqeQYBJSMiNngTXXtPcDUXqQMB4j9btQVxkZFdtkHm9xpHP8+Vb53yBextPd1DrfVsQcUaJxpZ1kEDG5OhZ4DVVCKrZTaF8nBRtAkZORYGjFlCh0OHUBCqyE2hTEWccCo2V0YdXF9O9+e2WxH9qA0PzZCYe5gLW0RBkiO9fHtCJEJF9lInpaKY+G0+r5FEGRs0bpl4K2MbbLAQ/HmYB0Cm2IBeSwvM2sLF9uRoGcvurrtBdw3VLdEQymeBMHI+7ZlfLbhs3FP0C/QJsCiQLCQvOSVDkdBFEdHPNAdoiT9MgMSoHTT9X5zOSPr6QwIEGdjS9RwSWJ7eB70jl98xh5GHldSIQMc6B0OwTB4rSnBYURftzt9QWBBcKwbYiIGEu7bE81OGRcMFxfXQ9fSTwMa0ZU3657VZAPZGgSqGoKcc56WVeMAj8XmcDYEImemq298LZBwCvoM4SJMK2FxyQkF1fUWsH9lkOE8x6x0DdX1IMkgCGMEe8zBCSWUp1PQWAWXgapM364bbHVhHDdERtaX10FMw9wykpWyoCg4mJqt6IAlkFqtwDFWQDluD5ABRF9rGHXj9r4hEcJEQ4KRqIZtxIV8cYBFQCXQdaA7BqYR/FYTrUROwpYagO4K6AoWMMOEcsMEBkd9pwQ8HV9c6CKowmEyNN3eTzF1HazWD6xMiIO0HEipjkeF7uq9HsFpY3VwpF+NBJbVvciFuc05oQsdRmAvbkdNqYD68QB71Qmy3OUd9eFeCq0FWNVWVluWrbra2prRtuXim7e3teQ+DctMOfNUzh9BNQNHcmrbA1dcDyUEF4PzKSTkEX1UUJiIxjuqy5wRPTxs5SBcqAwt6nUJcnWIAq16wmJqkDkUtwadVRQ1PUgom5FPJDLyQdo9y4TzmIEAKyLYHKsuFtkkkIIhn2ARIxGSRDEinnwVfqDInoDdeG7k9tn5kEXoKVBLRQlUekcvZudK933FQmXGqBSWkcD8FEwthVH2xlQTgumvw1GOxH0ODZRNZkHNg4ggJ7ga0jeQ46iRiwQWNYFRFlR1RQkFDMrcbZECLN1BVPUW1d1F4iVFc5tBA3Wk/WYBCVjmEWEPT2ATtWPzfGkadUe3n0rTuwaz1UG9g1eUF91F5uYjUgCjUxF3CkqhKTjX0foh9c2pYEOgEkd757YWwegZlfHehBeSsRS6n2YztsPP2FIbw6mlNUcnAIN6v0Vct9FwbYP1s9W2Mo9zftT1ClRaqRita9lGcQ96XHBJykDQe5/u9k6sTq7QHZ79vrdH/PXfy9uzfZ3XQbb7UHX29w3GpsanUD/6HGdbW5/R4gVzr3n1HP3hO31kuw1vxb9q3bs5/tllQW43xF3FERdHV2i0+Vw4uHzt/ru9vbbCsOG0dTHn8/z9+7tZ+=rUR=2/tpzl1d9f9vtv91A5dhdFx+JDVpnDi8ZBVV7YUPtY1tf5W8bW7f8C1s2YKfMLfekrIEUhVyLdyTrdKLiuJ2AVBUjVogps8dgKgNcybrHHhvS3di9mtHfVVHb3EeBwVeTqrTx1VFX7rVTwRc6Y1p/3kT5DkPKW1W0w5NKGyusX0iJscBSMYVbdchPlUD2N6AUZmX1VmYWeQ9ESBaTAg4D4kFaMTQVM1A0YUIKx69YqGvzEeFAhdvDZ92SYGQgXJkumSgong3i0FIDGhzsNQTzISB8304ZxhwMlBVgsaXnjORD2plF7G9dZclwEPMvBwTrHE4Lk0CPYIIBw5FeESAYFTAG71l2Wtpe7SczlY/=y8QTnEOq9kFGCDpO3oJCmVuZHN0cmVhbQplbmRvYmoKMjUgMCBvYmoKPDwvRmlsdGVyWy9GbGF0ZURlY29kZV0vTGVuZ3RoIDIwMjE4Pj5zdHJlYW0KSEaO1OXMkRXtg7sfZrGRLwPuQ8bLwZw5KyttRt1hRFiAXWJjGDBVgb331+nNmGD8GZIoGxEajpd3V1Vb91V2V38xlddc7WN8eD9Lg6TkhM3ipLH14P4wd9iDkEGb3cUgSms5CFkx1buIQCRdF2ULWBlqBm1XAZpRN5Z35oRWsPKAyx+z1N82YXN0Sal42119FVBcmqm9YeJ81ic8le2kW2Gxlw2EZieZV8yWEFFwVxStlTV1Awh8bw3kRUes9rt/YGPOQut166idk57sCvx5t2fZ3w/ZwfMTCeH2R9sRhlw8+mBouKTm4Xl8GgWpZdOEi5wxCwtN6zRrLQIheIhRcJz05wUFNypcsNkDtTEFmejte2F8d/x19+SpO1krRu18X0H=8duYw1v5xTGWL9F/OLUiVfub3/37gTpwtuzeFZ3xNic6DdYxu4A/dCVUCsUqVRrXAHMQczjsJDueBYyCRFeyEExCBSFUaD0NkPlW3cgYDUF3W9kf3oB=+8HO2JqdQO7KaBmcECTkEIddUV4lRVRcB9CV3kRJWXk3PnUnERaoEojWQFk62wV/BAKeAl8Dz7rd8KnZxEiRV9sSQ9JXWFCF3KBiCV+TBCkX7dEFdQyVkEbHWtteIAtx4SaoItUcLEKKhkIz0cNQadVZXuwWH9LL1lWRrTq+1NLLhQHUori4YO3dcYxdI0yGiPY9yBsGZtxF5bANCJ0K7O6uDRD2gTmBL0Hs1KFVleTugxxZQEUFEmtCBQq0EVQWl48wRoEEWWnfURFYgKWVcF+hpopH/zGHk8W4Y6ybd+hquMZ/BWncKQVxNQifWoRE/sHfq01EJmCCrlDcV1Yk9izVY5WTn5OLnU7d79UUD3HLU8fz33d40jzAf30zk5x6TcDm7g9dCzrH+uIzw94vPdbkRXF/f3fXQ60O/a16dOsb2nd+FinJTlmT9i25S24lMkl1D3rtXF8PR1fl0sS98uD8icw9iXl9+Ld+7Qhd27TQLXR9cf18/sOJ72YKGVl3gy1ZOiyRsgCm4IWtUcpOt1mqCJdWqnE+E7jN0D3cMxWFzJaaQEcQEOywhQ1w9Q8Y3S9nsGlaIWv0fdeEKkedTZoT0iIiM9XDL1FgCFbARLNY1prUS0bHcQY5AcPZkEG3x5XcQ991xGQ7feFYWO7dsddRjrexO3f/P6af2WzeIB+7aAlKRiIEwmGBYpRfkBUrqI5YSDNTBkH1UQekvOkZj7UBnTbcZCxkNJACsTCEEPTpA4gR2VWSutZV9QaF4kYXu0pPUywKSpBMShfJU0pDx1Bt+jdEtgqn0YaybNW2Hc2mR9SiYdNfYMT8RAWd49tsu1AmSNgzatG09bRW46ay5tBcXmhByclpktUthW3pWURWdt0OxyXcpkVpVtZQw9F6Ab19Z8UxREKF6rK3tHHFEQRusRAumoMRrxmqQoiVRItQJo2MdVVlQRytnYuxkDTwfhEDiKgVLFUCV0Ji323KxdBRKlEY0cNK3UYHk8FqSmpZ0heQRE5nYhV1RlIEphREnrAjdUYUc419imUMEAiiYMRPQIGITkRU2B4KYi92RFDSI7ha0WFMIRMZYoSFPYOvUMk84eknufkL8xwTfWNCQn193Uh8J+7n1sYxP1N+2NvQliK3q0rQbZ7uHNq3v2Ynntz39y3oO3344+nT60RPp7d2Clu3iqtWNfUutINtE89Hu998G199O430HX98lkq7rdWF5dHy15Tw/3a95Dl8bHT46+vURFUkxrB79wf0UF7Qfi80hkeXp1WZ5MqhIDwZPt3fWT7ZeV9ErkUMdXq3d3Z0fnp9ewV+/f3aXhEiDJD6RPLtkNzq1899K4zdl70=v1/R5/1ivcds0G+oedLF0sSVD3DgbzQQKNt9iO0GLAMCaluaCtsWdYaz5R1p8X2LfzpsUIe/G8FxVoTR1pPzk4BV3lqeSFBikpVtkX62tBbcVP0MzpUPtGdZVfmtZKYZCjygQxmDtw+rQfUbbkdVgtdSg4EUE5Kxp9xhVV3t5O29xP0LHqXD8Mj08pWG0RydpW31aMENUVYi7FWlsU6X3LqCiXF88wakwQNIGBN1LGpq=y9Ee7GwzjVvsREPFH4KAsR8CILb0DUMPjY4Rc4I2rWoIRB5QGx9s5ITWhQgFEGmIsNURXVIekixJB0kq0JABzZJR8ZH3VURkoJzj6cSdqOB9BqCNBlHrFj8H3PTRUUGEV5YgFSuB0M+3HHM9nf0MH6x+uJHRFnSlhBO23BZNfUkTaIHUPmzULFJ1AtfRdxiZRikelkpDlsE3u0HmlZqRwDH9Ymw1SG8baenUttkCeKbJhoOHVTHoFOKrl7PVgYuW7CWK0q+QwTa00Glh2qiQXmecmpLsVBhUn1fdSUQUxgG11vXE5z9hbed/f8VlZ=xsxtvgnB9w2IGTVCFDlaY7BRxtjQ18pgNKDmt623BDBDaZliq2N7YjbHEaczkr8w6S3kdtIEjag17dQYCTENIgrzU1iYf1KbGxak0k9yjpFzgoEbKggaAygTBsDDKQ3L2lbUg4brE2tWkkiBYZ6dIycbzJrZB0Y/CQgqWw0aa18Ymd+jcHGwp2WNhT1xlAxlWphwmtRur3gIDUcVWQatNQG0czBKhEOk50ptJetNplUi2goLG0ncWADrFHRiuF1tgEsaeDwhYdqxUJRLQUKO61lOMIvmlKc2UaIMTgzsGUv0t7h0LMkcgJ1RlQVoMq10oCzYa1wxouIFVJDDOrsFeFGViRC10W9MpIRlRMQd3gacnNU5QruFaNxp2Kdp30EYY+5uI4GYPYRc9dcwXQ0NhkSBVDIBTUFUxl4bZEE29gM8lHNQOdm1RA6IAsOR0nNa1CeNS7j3txirEEzriC1H4YyyKme/qsGQ4G6QUHO3Aw3sRNWd93rYO282JkonUlgbl1W0tk4ycEdS4qC/bNSPHdC1aphOV+ncWQ2B91oHVu0eq0WL9g2rjEQc3/6rgfYtQtuqtelbg31yEVc5eM2oCTTPUprAIcX8h9/2=3iLzdN30tDD+Bsc3AVmWFfBmQlHIgXBs3kQMgOTeB0BFm1EMhN8/f1jic5U8YwUNCEl917OQ8XL0zuTUQvwZPVlE9NcOOAS3/XY41C0wcRJ35Hpi9NUR+tQPEY9/xm+wMb4Q1UyEZAt8ccrVItCIYrcTwcLd+L7tsIjIMzri7gVljbn1zOREDgsMBWU0OmP3rVIE9cXGtEtTO4Si7R17RvWARs/bh1xkt6Zt3JHx/fPovYT7HE3kCQWK1eTM0iCIxMgUx7BSCuUIHkNogaGkgZE16UfWYmlPVSdHH6CzVb12THWid0s211UsN5F7FpwQPiV25sQaslJqY+BPnEKdf9nlZASsRVgHEiLZXQbr19BMpATgeRSxUMQsCcFSNqQR94HekjXk9kMm3A3dcM90RKbHFZMycLZVVqFViVQqrYIaFIlQ5LQq5nHnUkEEyuuWH1VFyEbesGYYrdTJjLTlDsdatbQrhFbd+PNfnVALZWV99/itbh0SyISXpbkoieSgXFt6BscCddf39lVzYFQjIAaYJnRhkFABFwVSxwpNpIKQlbBREp2rXCGag7W9QClCrRW8su8cuRRTag9vYEZWK1v3Gd7H1dD7W1oNYQ0JjiPN9Jn0SJDZVNRF0kzNZVUk0p3A3tB5eS315RC0Vk9RjnW3U6b3VCSbW2SkMtq1b5zAdu3Vf0IMcQZAFhjCmMlFc2MFrWkmSXoff88+NksMxr8QB4tk6qXt+Xx89vqn6d7fJ99lZwN8=632St8tsZbWM5WF58CV+bz1f/W952iRFid/TzZUji2UXhuJ6P2UaHmbTy8n0RsDyPCIEBen41t0Pl19bS4WRsP3sWN+15eVMaxH9uLdW/ady4jEPJrdCu28C/NdQ19+t7rG7qUvpyU1hH3doUzD9yU23HF2WaYXQ97P+kIqlZ6z2rD4sO3tx2m/Nde421t3Jb3sbttRm63k9tXtHx2+1s5lvcd1Z3ZObwRv6xFbJgpEGE60S7E2CwVUEjPniMQ8bTVAVNfop1IkRpsUgnf4R1+iMUVAiwc9N9sYMDPHSGRPxNkOz4+cVdIRCmUalbf+V+=zsEAmM5IQXHbwUDwR73GME03Qp12AxR2ViCBhGAgFJP1AemN1EcXc5ZAwtCnkakSuYwG46QcDtxNUD6Ot0Q7XyxGWxBHZWE0D9zu6AjQ0MXMSZ+kgkfkE9c0zaU/ZPNXxZvVQy2ljfTpEIRZvKQr0+1j+tjpRrbY7nhyVtGaX9sP0itLzUtgwtVhFICViR9h7jBKtRYQYueQ1BkG1VfjSIOR0YLE1U2EEUsaaTiVX2Y7mpQGgzBXBc4ucibkMuzXd72kJNDgdBrKdebQ1AxgBP2DJNGXiygVqW86LedB/QhFOekCMlfQXndU9hz9l+HH5=2UHanNpdF1U3Qn9RlVmQglA42idISdHB9kDqbVbmDxp7rVCwFaWMoCLcCeMQqS0D/MsV858xrEgV816GQ6tV24iC91EPq1FTgld2tvxO5sfA4uyQkMCEYaFXtVrWl/kU4NERbB1NZm45ElZ9jMYgVQnr2AZZZDNRUeHf2awsQXw5MitlfT0QGdk2jMuKDkzwFLTBkZVVH6zHJTae0MzwK4tUFBb8QEr2mVwIzlfpWULzlQLhNYZTtQGF9M9FpJpvq7PjnHwWVQbKwxQwsYW9tECsamtQ80cgmE9ywa6B3CprUqg3Gp91739YuS+6pEY9tytDBCAgK1hGJidVIFV8iHdNIdNZpXB7XE5VkTAmgkDg1Z0hrNwd+FYTrRigAwMVQXpSZwLd2ULFw9bbc3BcsNadc1DQzULUFJXqQTU6xFBWbbN32YVvZWcdo33L4RTLGHEHX1gL135vOkbztR1BEkECD247jthKX4EUq1NxscTZbmIQDFAyyW8o+jfz+v0gToPQ0ZwVwcQcHQOR/GiV4Wzl3O1RpxVu95jOfe50skOWWKDT6pCtnU3lH92Ste8Fi3UmpBU1Vvfa16YmT99Ot3Xrd1QMx9hQ1Ziu03mH9HBsoO1VsLcLaXEdlncMhWoIA7bwJJ=jtkeg89skKET27rrAdoAK2cQV7Vt961wXCAPYhQRwRCIFbaYW5FXwgSARMjUkHzURrmBE1mthRFH13QIG3Fh1bpU91MzcXbTkURp44VAKN6Knc811cZJstHDos19gxy7hABfeuDHF5SauVFCpFFqQwQ+q8TwhFDbmNHLs9TXVxoFxw1fcgvd0lfCxBrAQsMP6YKxA5IWikD18POYgLwZxtXDPdUsTAXc5h1cwc+qE9DqF6rShIxMDwOLUgfmKsTEVNDQXW/P04iZVINPd5+mZG1FWXolChx6IVcH7lOx20c6BBJa582SwqwaQw4w1e1LdNydOF2tlcRFiKxUvVEKBxiBdXrdYW/TeD9JDIjzFjXXoLbOsk28X62h+9rVEojnEE9f0LZql7fBLevb6pw+n3ifVvZW8DfQOt91UrscfxJsF198edbW5/0FmWQQ+tPcd/XwZcrgs2zri2G2uX5PJ0hvRyMn01brZiWFydNPzq28bffcbQKnc1ifn9/tbhpjMFcfh60M5u/fztXtUD3z8bnI7uo/n9dff3dRq7e2c6+A9XYljKZ4fzUp3EFOLss0nf59d6d7Nqx11BGHxdl0SpBq8OLmdx0JLa6YXrXw9ifnhfPHpeWPudjGsPPM33Q96f2Xd3WJ0V0NwXAPiJhvYRtHzj9hsfBQHNUyCtf27R00ja8uQ9xvY1TE4938=28Ry1EW136zWJBCm862usHdk5fW9ltPWUMfTjaPdZ3UTawN7HtTZj2p6t/U0QOEc880DE51SuP98JfkLrltj3RcYMFUOTXmuB81jSd1Z+qQfj5zTrf=3Yc1+VVIFM66/cOlAcR3lgBQdhsJxJ24nsERH3QF1U3ykQS4UBR5zSUMEVGBYdC1/kalEeFxFdXzWDtlczU0rejNxM5tYWQsSZE661AKWXtHQZEMFUZSmDJ0sGBVRcdOYRcFAIKO0PRFsMCBJ4uQ4O0dBKn3QPBnTkfxrZEXsUUvH4jJ+kVdxo5IRgXkEsE9lA/3VCbukrcif1tuUPw9UFZAFB62dVb0EgBH9IQsXcYG1cQYrQsbQ7cSEeNO1u4RETOVo2424Z3wNCcT6gLkR3EHInEHOmtEZQZiWBeafdHdFeDGKT9B/25c54kYgRGtKmw3SvpFw5VMiVWkQd66pT7E9RehkEMtlX1T3UytBBIrd3XF9Jwrnf099OfwXmM9R7UQOgSuQU2DrdRAkQl+xEYRt6Q9kVAUrS7JW5KNc5+lKLTIDD4HXtMrWhNZtih1HkaTwvtrdNZlEZWWk9QOp3G8am1aPPZisJh017VxdxrKk918sQaAk+dN1m9jkTsdf6kHw49kaV8tuXMcO/AL9=mwCZxJ28ODZiABLnFlBHdnBAMDlgxYXxVZXlOnkI=1ixUiYOxtm81Gs2arFFHATwYUaSt0C7YgK3t5ZhM8l9RUXzMS0yR2fzNljBV/LFEIdXQQ+B2AcG9jRqgTxGC34eHNZGLdYRg1LekxKQUhtweDHk=2QDV0JaauKuVEMHQKQ7RkC19Zdzm3QyrtkgtC6qQQgGV5nyl7ewc1tWluFgp9svMYjnVkZM3n9ZOEXoVFHDsIv6V1+1HsFXlvXndrYfih93HRr0UoTbfZUPHt67NytMWwLCtFikGXHw8+Pt8fQHd9qSZ8dVtCREYbRGBHgmkk/ToEaAnIKtwRL2MZ/TGukdvEw6360KdmsWitDBWN7xILMQ4lgpqbBo3q/c5DKa0GDuWd1YMQ60akHaUglHlmYmP3N5EdcKxkP6VABPBsYsQRbWxK3Dkypu7fDBQWVTJGdlBrrGHhtrVlURp7WRDOAx8blhrq8RkAXDtLVk9GFO=yNV2D2uPpP8DratjN1aIuT8IOwGcDtFYKJ7FsWtutA19phMMULC3RH8+0gLRil8ZBe1td1IRmBdq7bILALZW0SRlLZJS5EwbwFw1UxTYJUSnc7JBjzWPBZR3WsmHwmztLKGEM8QDCcsM89LF+SQ1jUwH0Vu4L9cDXVoP4UEfY66oT8aXlxtQE0UOS1SD6W8C6wfHkFvH9RU97X/1vx7s3WP97s0ZVQV45Hd7RrZItg9/UKY2lu2N62ik6J+J0Xs6BwMbT/dwaZa1tvmfJ9w8EyeuF7VTczr0=gtHyabftBMPJM0nxjNJ0B0jxERD2w/BSpQwF1m4YKfpWU8yC7UB7WDFmI5Qh9gfLc1tBdZde6wGUqYZEAiULfpSuBTKmDcgM2gwCPvVHCVsKYQv+gkGPxqNhF0CtvNxBrHtZkwqiXEiTx1xZWFiDdXdQFiKzoj3ykGXus+nV+eWtEF36BUc/pnrNJC1gV7FFWBXHjttwCjzNRO2=bpOT+wGxoqaQUt+WEipcAT3LDnkYz/Yh1eqB1YxZzBf2IYRp610CunkOEaMk61hdyYWV6V0G7YVRGmwIuIXfxgfQa3RF+WUNBBpSx3ZetCL3GQ0JptgzUIu98tZEiy1L2D0HNjL0fzFTV8QN6T7cDw1vxE9fg1lSz5LgNP15llYQcM1jV8bqjO0KDEbGl61/H8o3N1kctlQ3RvGFVibQeNQmAm/OGPo2GhlMeQWzNzdi1YB1p1KpDUiBV31M0y8P1w7OLE3tq8cMONK7mYZncUY29+sTvdLWh3u05Kxcsm9V1zWuDk8KV8aASBGWhEaW5KWFYcXdXl32FGZnSgosykCxopNX2kzlwBLEEfDip341a7U4g5RgFC08Ak/LW9jZmmKdj+NmETrJZm5nhEmtR8KBWPkkl1iowMHpAc/oNDT1ZyVaRxDHx8ce7h7WHDx8bQ7uD3xImEUFRYgVlT5wULvcQwMyrSd8ANgMQ5U+xtwf0BPiHaqDauA5KFbUYViEcdKQHEFCtx8GRv9OAkRNMw/NMDQM4dSI0g94fCEG63FxdXcarRkwtcHQxYb9hK2TC0FJBpqtiHzfUJEwxINUTPwkpixDO2DHhCmrEf1rUMbtgdv7s2nrGTC=1swfk0FyxuDGw1BcDdIqsEUsscQNYxF0P/bUDiA41B4PrAqFXULmHRZjH82YKX99Om9hXAFwITtjMK32ph6Rs43OdnucUrX7hCoQCi84DtuBIgRHmomZVV4JNDHBlaigLXCoW9ZCRvgxpHGBUeCN9RCwBSEBZQx4V7caVxEMVDD0Xz2kuEhsHddagfTtB/RgN2Ibn5qR38HD0IUXCgbkwEUWB57mLHD1lMkHtDV32UDw+7VZ43J0d19RIdwdtmouxkKb3w2XgbuwnYRL387f3jd/VkzmXH337Z6VGrP9l49wfXN/dWWUqF3n87rUYYfUkRvpkUMYXNx9NfTRmO3KWUWGgZFKjAsayEreOtU2gQUpiIw8EzkOY05E/VElCbcEfnd6UVZpK9g1hRa1EELRQpEXrZTeQf0DTf9SuoEk5mHteEImBE0EhQVuNv3zN9W1t9DFxbogMqT8TExRVJQfdfG01YiCcGhH2ddBzkyhFIkVUKxMxwN6C24aS3U3y+fddW9aCBUzRMcZJHYNeQQeWtV24FOW9xoBzfwHAdeg2kAqUwGE9UL3AC7txGTaAr1eVQdz9HFma0b7dVV61jFxqVY6Yw1oQoiz4DktEXs9+7tVX4VrdZYSFZwd2TZlgrpo0xGtyW22LmT9VxlYK06Qx6QKtBMl1dR1MdQc00tlJCtEOhaBVDO33Q1WsK1webfbbbHaOGJFF0ZJNxFBwk+kp18bCTwaCVTdTkaZzBzFdC0bCxNLFz6YWR9nx0ywVtI0NCYGlRSxauMlBABVe1rPZdKd5SkZwag2JKhtOtkDOtphzMs9HeuuxuW/k5Bw/X9urnlHR3Fx5+tBzms32Iw1RB4X9UHiLRDcMKUJpLtYL9s5X9WAMIWyE2oiGwVYqQnEkp81BN8z3AgUt/YKRsO=gEOtQUGDz0QcZcx1gUxEpVrJGRtIKGxFfpnzmlhahgSN2QaGIMT+dwbRu7dGOgeRFyBN9zdlEed6HTz9OQNwaXXpNlZN=uYIQUMCT0Tk8okRFIUMZSs6k2Bk1iewGrPFus1mMyUZKugTVVQR0t9S4ikP3tk6WC13lxf7CiC0O1JAQcykcToEF6yoWRbZEH1lWc6kugrD3nWVkwIaD5Q4jNqddhTRFaQ0OYbVIe3yBpIpq9ZVH0QWhpoaRd1LR0RN6VnUkKusqh7k1wX0FR68eBsUhaXrU5GG0GxPa=iwgCzuMi/dw1MIfdWkgYHlN7ibtFAjpQZIMh7XRhPzM7LSliW5X26xNB7rLUDzTh/XczoryxlufHDHS9qDIN4PgFdQRdyc4wwY8iRtiUFhS9CI2IfNxAqztsZOk9xIAMHxPpgG1U0tHEGcXBuPg4PR1sJdzBL6TQNRchtxxximYJlyYNhY6yVuDp/1WFvSRqwPetv1nBGRbHpVVAQGMMwWMaBINsimpDw5nCdsb3Ygt5pCs=hJImAccZVkaoEnaVF3W21uLg5IRjdDAxFtVdUdBkZFYrBLnOHArQWoNE42ahAkGqRoMVcgXikUdCqH9lRT7BNl/bJRERuCMQI8cacjG4M12EA4vRfyraBEg7VjBeXNaiWUtX8QJVwTrfbuGWgljZihzSxk97jkHBxgFB2SYWNZNxVRQeT7ZxK3iRkC2hpAUlxVsNZSoVcxe0rS1HLcTRCm18NtRoKARkNZOkj3P001gV54hIKXAl9rV8CHc5+S7ZzH6KsFEWtitOQkEa0hfFW2m1hGvLckHuVRCLX6BTNfLrttHFkYfgLdQ28GSxM1//bFCnJMCdULBQbhkeRhkOw2CBLs9/X7ZqSZFUqRAx4EEW4qd1VlPbZ3fb/SfhWXtBdixwaW9+B9lAac1yWEXXsRcRqDPGMoR2E+GkV3YhtgkscegtQN2RA36dwpQ3rzYtCSkEm96QUFcUVhIV8MbXpHL36R1QlPMtJHnl//RE6Xh13t1eHtx3EOz9i/fzn17vdU/3JI9lErdcEgftnXg5e3vZP3EgRb9cBV7UDnkj9ytUdoIEH92MCRw77q5n90XFxU9f7n9laV9fXdHqOF61jXVUkeaWL8u/0PBTzBwmDxloIGQJXot5Crd3vYtzRbQmnNXz5oKw0zNKdCI33tTlH90ELmLnDRokwlJzZdotO39q60FLKYoT5hC1VEeCpi1xYuXgiAgQVQ2IyJTqyZfk3i6a1yJbY1NBURRt5dVRhUVQpAxyg1Kgac6/RXmlI5xsIPYSewKIk6spJ93Nb4q1lFBV2NrpFjUG9C1FRfdUVV5HTmoan0pRc0v6kQcw0+GjcAmNH8yc9Nz16sT0nko5V39918tfN0vzWlFWddUakB1EM7NelIRntiBXOd2cqdUKArOEUM9FMZVp+KtYVf0M/zQcGU52bQ8N3wwULLoNTC1TnZ29mC6lJZEmYdhdaPIHfv0QMzfHkR8ExSYWA3zWQ4tqcuUpJgVZ9tOxU3q0P3vW5+UCw5o9/YUWRWPAV81A9bRPHG0I/LFQdSWYJW9EGDjJWRRc8faUksNy8KrSU6JecHJxmsFiiBXV9UKt0Pd7HFsnpS8dwDdkeUNqgld1ukVV6aWfHBKTa7gKtRyetuMfnK2VMmRPSyc62vMuJBZdUhJtoQQ3FdV2mtNTkCtNdY91QWhgKRVT9vSuGbVtTW1j9lU9LZcfLfXOCigNCK0k6wdNtcXO2uBckjrDEHZ3cltYNtottwPz0FrGsbBwdn4nT3AoDaL1Nfe3gURooRDTWm3bc0KRtuExjkeWTbWiXwR3eFy7tWhwy2xDFF5AoG+194l5a8emTVNV/RJ2Y9o2Cle7sXBXoCdRsWbc9B58Jl9EWVpQTrrTgencQP64sfL6WDab3qYA0xjGAYRJUWYZJQ8CTQF+4INUtlMtefzRhqw81Oa6IgV+A0GszleRUgto3Oe8FTX16KVcUR+RQ1aAm01eWEXC1bdMFYbQgsQHkfhawTUETByLZEQURBP5xCzjpQhMHKOEYYxnc2bh+kP8dBEELx01H=w0OrdgQX1HQRZXMecTr08Di4XIeAxlHhEYq1lglmxeLtBXzEYIEAw/ecdcorq1CMXBKW89Qu4sKxd2t0TXS62WEPQkZwJnpkTl90YCcPHGTcKo0dD9ouQRgKDFUW2iDthUVRxtnWEDOXrU+mCoA8TBm1iwd2oA//Y+loHr8fBwrRXqa0dqqTzE/TQwSsLUfrjh9jMMzkRuFXWuVwJsX1IeRX8P2N7xpWHIMar3wkzH3b37t3hc4gji4X1yERX16toHEHAcpsLFvu1ZSUTpaWl+9vfSyXWUqlEBk2EXtgmChp5D9leg831pYblrhBOCnsZxYv81vUCfQV2VEEsdKFZgG0e7QQHGwU3NfRx1i3SMPn5bSRGTQeuLwx6cS5avLr0RBXt0nYw9W91ZQwVS3zlvgC3VlbahsDQEX0O1rzKR8N+VxVFHXhzGs6XhVC1esTrXUF8fG8Md+NfdhNI3x8/U5vuPdXt1+eXFE9vOn3c/W9Rbw9Uf0hIIVB0w8G3XF89iVYzstx3+6nGV5FP/T86wuYlHQcZrmIbEaQuB+xU6lIY6zaB/dEgfVgPxFDeaft7jC7icz1vF3urq85aXFwgZMhANDt1EwyR4yXhU25Ifd52vweFhGdBDdIVUshB0gL7VvPQ9Gc15oes9btg/HtwYu0fkGcvCaTncJnhJtTd8JzYGR9wTuQD0PK0FUcukC3wddWpCe6etrEHwtwFB3rAxEdbekKUHOkMFLHbHSHtuCStJ8zQIJclHEFNEE+lBbRqnH3CYARtREGF8GlIkHheArZC2UhPQ9GFeVbBB99YCHkNVslzQk0ofsl831gQ5rWV9EKX1/YQR0NXEwPfLwTEQ3iEC4OaQZTKxKqISZE/zRlazpCDunEkhTDK12Ol8mNnK8d0m4Rq0MYHd0peQkDlPCt/0t7TNwC0ExG9jBRUs88SDWX1dYtQ2FFPJfnZHsFcgH8fplDpSEExFsa5xqkDMHNW6IRBiCAEXsn9djX2ZDNaD2VXD3l9r8eNb28GG9sFPQ7TTpCiOsq3O4XvdRMEkNJn0Rq1VCUX1vLsuoFOS4tKw1yikBqZrFTa1aGwVR9ipARdpbW8ZTan2YUEQgUln4VhLEBRj0HXFV7VGrYG2AgQTUPlqroEcati2JWQXqQUkzWVoY2cuIPcHKRjSEHUE+w0JP6Wohscwc31BARmwEEoZa8dGeXk+HW7qBwZWJqEeFUfHJlZyVKGVFfiftLQ8UD2BxomghnclTN4W+1UDdrUDEgpz3hN1honKIJsI7AwdVMu4lW5E9DE8YoDF5yWBVZR0gQ9fb3Tq2=pPHtvbNwz6u3UYK7cscFVEPoEl0XRG1CZWYgQmxYz9eMe01Oz9x37H+rSm7VwzSEpWSEGP3uoDZDM0hGUWqxtLH29j2wwocbRe81lEwTtWR9yfcuSglCQytwdrV5e9ghZjs4T6vWQFz2luGRtkcnRzTR78LRlHMQx8FREHMEKlWnmQyQVBp=wwxBwwsWFlLc4KKggayst51dxBTUxLUwTycsd1W7HVC4C2MKx1UNyFfuCzLfnlT=1E+=nlmB6TCQS2n2EaDBe=t2pgSrRxn2ybCQRy9o38dCpwU3DBg/QcMd83wSn0+sZA2dUk0wRytadcgKkpL8/1htREosB1bRDa6vaBDeo6TE9I+c+STdXMzo8EW+3cM18dVy4H1VgL3MKwWIwX0QiHOGBq18MJBtfbz85O2JYzVENOX21WO0EmHwbeWlEYIFErS+22FhpOTB6ApuArZNINgtfz8NBMF1hfrAWt62sGGFZ3obrGti8mgxEsGTEAYi4DwwIRQb3iAJDNW5tYCiwvPm1QJLWBIuNHaCFVU5AW8wR1UQ9DIQoJ1NgQWTUmphVNiVwZxW316ViH0T9HjicRJYgkFRaf8AV47QsSt1Thg+QBygc0oKcSwCkYzJK0r5BVlMRpLHVUDVlfL4PtYZ1CkMHcFN6BSbuBKUJAtXs9ajfFC9kB/0wz3Bz4tA3xTA06o1PdB7FcR2AQ51tQ9uZLvESsE49GFJdQsmWBCEBPXZN/tPZhHfZQaw1/QKeqiFC1xLhrtQdcf11CBgKJTmKxRV0s7JWqDfw5qt2Ne19eXUf63oV2JZuurcHVd3D72Xz439oMnpUQk93w/fnllz0Cu91f/RH2=+3nT1/Zn0F7hRRGFZCQcdeoMERlf7lXLSJEJBZJELsoJBawGCcSC2353FPdXDtsT04CWZRQYud1V6ObZ3tE4f1q51R39QxvXjlCCl8Uetd6dg8M6zr63XoIPlsb3RtbL3HWT0/VhP2Vf1aSz24R0OzMCtTq3dN+V39pld8XXtf33tiDvVwD9XxM+1t+Fzq3Z3ljRn3M1pBsJIZ9tZawZcXpcQapMPoXJ19fqZVFjDQUDJUYXkFaVVGMFIuMnEfJlxmEVWBVvJzFQdRkbzV9iIViQMIcevdgphRRCQz8cJbs/dM18S=6m1WOxfSUhy20fuq05r1gYlAw8bS6aF6ZXOiktG3HJ+qC064R/dyqB/tk/BFO3WBLQWlqK3qkBE4vpx+3sYzyoZ28KBn8V1ZOZi9BOlULdMSYe08PVh52J0Tc6pHBtPVEjWTlYLV3floSEsgUEXldU/YiVxHBPQD=2566F7YwY7dELdZFEj/ZRRdNtwI4TTapBhk3SUOA8HRMsqW2kJCc3eSZbiVksN28HCUQESXE5rwH13rBGmutUmQyw/WzaHElB5BYdV1c1moK29v525Mti8nWhD7hixBM8wMWaT9I1ru4tTreFR7HLETYD3d5QTaWlh07sRQoiDNs6+u7YBFhlmNNBZXF6qXxtflqmxHtd9tVy+K7p3oyO3gHWjdjWhJeRHFlJ2VlL1pIdbdmUFkqW9JAllesaEGEVEmEEIWsDKAluTXygKsbT5TmDi13UBlJrUSlNBtCQTkimxBBMiLdcumFNIiFziDasWjDBTWsGQL1hdzXEmWyLLISJtZdxSRDjtLTlfuy/aVQ4eQgumpkxQUYGjFuexo2BSEEX8J7UFua7J3CQWVjtkhpw6QD0EvLQVNK1grdUno3PC0NGyso9gF0q1ByrdQgFrXtRpGemFhE63p59xEqkD7dk1nX1tiphkJJyr0Tbv6qfxzS8scjcGXlfOKW9w4mjirTXCVCqWQLLg97nD9W6Dfwe4e76Jl1kt+H29vp6BFkPdt3EE7sKtQ1ZexoaBgIQslKCmI6deeoCVWnWELtWPpAVVVVQOP8cHU/if82ID1gKEmxsa1NNSylIqPpQLuDPWK0SLdjQNkt0MB33tEGc4/nDhR9ZoANRPrrNxO2WtZp0NxTgSB9udeSocRyPYD1EDZmbNMdS0KU8atxZykFhaul6pbaah0bazDUdiiDYgmQyGDgQ2YJh7EQ1QKtUFxbVba0saVaZiBbcg2sTJvOQGOkb0zVHHEZzl2wWgTXY/4WGtJlHTsGNKIBpwN6Ch8RU5+0UaAIdA9vU6QVdDvda14LX1pX+egyvTsZcN7=wdtthHZeE1MCZNhS32dg/ZCOw1VUutYAUBiBe7FMbGEcV90rIsHUWVk0QsAsv1wRSgbYGfo3MkTVUtht5yC401EMC9rfIVjnUFU+dTzKWImLGYTVDN2RTgWeBgcTNhFT4k15NEXg/ciEVcthKV9iJbV5eoM+15zyV9fyzAVrkIx9DK0AQR1osUAGEBWpRSNdiAMO61NPxUIg8OWFbwIqVKdonK0HH9gVlsXvp9xi7cMfd/d1luE3tReCV8Xz41XnCHoUV8ePz0M39mID/r2y8/Xtjx+v3qxcf3t2TnVHQQqTXp/SWhdf9o1XU63dr/F7bLsMPvdRw1tHNu7tWz1BKrRaw96TdhcQalP8btmwaYzdw7JaBywFQArzX3t8eRsPhQ8GCMUA8mWGYJQwnHwQD5z8HtlVpO6RaJleVEDWKkqGUQo89/Tmd+ESBrJ6nDG2RA93l9E0g61ogQFg3xHNiLYct8NC01zdRgdWBFBJFRV/Xl00T1o5ycqP0jWG6FaRsu7srVUcU1WBdzlDhYcEq4XxHgqQLtJXAymGsYQCZE2yhHUtQCU2M+Kj0gK0bAdVEA+7WQqxykbj2siISb1E/JUcIC5AIbS1bID0bFts8fR3TV1dGMzZJeQcGJYZGMMSIgTcecjO1EjasIKKUMPO0IvcgtOR4jt3Q4tUMqGVAZdUN5Bsz34gRrF7jl8RxsQB19wfxA8YwkD6QQEJbvhA8HJNcqG0JTcZH9gLF8wihbp1xxntbRCZ5GiFVRMc2UxsRFw1WSr83a0HSrF+Z/O0REaR/05men3TojzkH7V5eJWrb1DkNeid3nI89xL6U1/J6X9fb3NkN1a8xmtt0jIhdFSQsKQlvaaWHNSAlQxU9RUJApVR6eFN5NMlwzEseAdRCxtjwF7Ec1kbQU1AQdeCSpOB27abQirHL69R1Ow8GOn5QANLggPWFPSD0Du18fpwU6oOmHt7XDNNFeM5d=mgqFi+TMQVpWx5aB1VXDpTzmsWR17Rt6BQcCdDUDOW611tR01NiS1Z5D0hhcIdmVp5i8ycCt9qAiZoFPrC6zcdUlQOGcxWJ+r3kpKi1WtPtVrVEFLRtvc0UQIUdLCVadK3UfXHaxO4MLZjHKAF5sQ1VUFba2urbELFXXIGijrQcPG09vz1BWENY2BwW9zEKT0QUhsWA9kHia0sFMr5DQ9IVFFHKygVHu3u9jBxks36mrNnrXHkKNR8CNXrpgNWN1Pc923XiwWK918jUC3FLz9INYVjFlOSdRetTPtc9cwwWaqV8+uQICMbNNY+KWRBK63KAsUtMMLlEN6WVQXCts1H1cw0JjN5czrBzr9at2xajVzE5V6w5YE8tg4n2q1FuQtMcFcuYLv8b90Kt3djXgu11HcV9SzIEjlmWV9RDAUBQUReDirbwJBd25FZBlbcfcTvzf+wd7hMJFJwDVxx191VkyFK4y/G0EtRfc7tt=lsYWsR8fnlVEdZ2Zin952OYbxtBGBkMT5vI2QqItlvBEwaTcg4grdG6uCq2DkEDmGpqfS230xFZGLtgnrTeT1pzlb299bslVJ4lYtBBwcps9k6JScGqmOMSpn96K1UkAx5IAFImajEdVYFbDCS3J3gAMpQUcGQLE60gfHrpU8+PbkDJeByQKtShkKg9j1w6uF061AJWybRlQwqwX9BEnicSxSRxTajVccfrJFiBsu2AueVgrQxlc3D2rA5V0N4zS8C86TNl2oKnNb1q1uHTNLIhJTPHUkgeTklFxgkVKBuOzi1SoZiAMMC0NwirHA15E0eVDtBRIFzgNZd/YsKgZaHtYdAPUVA+czdYUqZuXooxgkVBS5zUfAq2EkK21oNYY0FjiPNDJX0SJK6YYlg1JzGTjJtBj8xOcoyLHUnNlOATtIj5vzVn8QWWue2VQUt2tFTLVrzPKZjE5vPQhLgEMBkNa=81tOF91hxvT5vV0+NUsMxr8UB4eVkRMn7ZI2NIOd8/REZx9733tefHl82jlQHT1IlfO8UgztRp13CV9Ru1sebVUu31uRFjbtkEbHtiEN0UfpN30FX30+X90dbS3f64I3xnjwvG0O7f7ZQ9nlMzSxggJE1sGEhJwZRscs1yWVhOX/dZytCw8EY+s/VwblvHFF6Q+wbwo4F2RnZs1EUntImsAnVroFdGAptUUkO2kmz7fGZTJi0YUBKnzhXJ4RzX4T9bXDkCzddrZSV+1xqollNaN1Mx7Zdd0h4LnNwoFDmmBEO3pycWGzdaSgYlr3ogXRgOE8l1hd9YkO4PPnRW1LuVD6B0EEt6CwnCcn7uc14cVPUqYaf2U5sdCoirTWbr1ERwQQVc1aSX6kNn5EPnttOlM+Qnxxw72dMZfn3pRGoMcwPJUgi4/ajuRtkUGbeIH1QrV5bdjbzYkUiJQ61WiHBSPJ1PdXfNXu1XtuWUcFRQQFEh4eilf6ywkd1t6ZBWd+M9JkM1KetYj/hVAiUssQ1uat8IMj39qsOUlSgNoAXFQFic5PVhba33jVLzgN5LlepR6E3B97X8YfNbVzzfsTwcLrhz1uUD/NGycbRkYNFE+WRmuJSoQQUiuJellbntDCAGMFwQBBeqtrhkjClKYyw7fzVVWiFSxpFbjBe/RAtFaw8PR1dhzEE9189DunJkUpR1EpUESn4QX8U9Te3MJ=w0a5Xu4ZWhdPqZKMInrgnCzpcfyH20IcDEB8389UQ1gX4jH0zJzTmoKIrEz9kRYR0DIQUg9DRMTcZNbRv1oIPcDNTTMPdtcU7BGjVlPLA4GjBuEPc65GtsBRsWIy24USgtJS4uzR+r1lLUCmgy82DxtZw6kAXAxxEgtZ7JLZQYZ7TrdWPbcVzd1URFFmWAEgFNa3XTy0DIVUOIlb2gbcN+VFkrFVNU0P9bkb2LwdlUFxUxpQQTCtoE5JcwxumYJY05LR6DfEFDKhEC26Taxs514nFZjpy4fNwc5rUe4T1EOCzHOEdbusYwd5Y+sRrVRUCAIVM+QS5BWBp2A1NRG1oHoaSXkxCAdUfQQVRX9hXtn3CtlfDKY/GKprk0Te2c6yclGQRiy39PGh1H9hPu3NOXFCpz3TQ1jxFjUR+PtsfHV0Eez64RBVQ3cP16rZjirU7tLQdvNfpDfQxIXvbQB/6zpBOQFnByti2MZ9HRCLjsCsKgjcnBXrUT1CN26K3h36bFlwN9SUE4PHcbVFYB+QBHLE0sQIhUWV2doRBR9AJ0eTM3Nho+C1sMYS5iCkJ6DGgcX1uBAeivUcjwQHVaImPCIV8eBi9V5g3R/yQfWrXQ/ZjN790wGT32s6z4MRRZDw9Hdm02xkaK06dTl8TdwB4gMYXA7pjRF2xl6pJt0FWsBWV+c20OdEkIWsmDwJJOQLL1Ur+33BBhwLczhXS+n7FIVINIZBJVqwMUPLwfHa0EncEpLVBZPEXcpAx03FCRBid21LlGQAtQru0EXVkTBIhRxVD2dmRisC3idecNw1vscdpHNtCR4cadgChVQYNQ5Q553Cw/Gw9fNhokqsYdsTnFbdRZT1C1FofvcED6I5/cetnn0q3rdf=leXlxu3dv2Pt91d/9ljWjXeTwuUU+wf1pb1QWt0+F0sqdC4XP3VU63tjePcZ93tv7m8+e3/tPO786t8/QN2HXlE+2AEXP3rK1VjQMMp0tVSZYuu350N9KsCNm1zQ280qVm2O42FFiTRTZ06+gY0LdhVvWEMJcMKBApmCe1rgaHYfkE6mKRhqzlwTOsC2FjUBNjbEyre3xpq2DfWt1Rwn/XWhYytzF9oBEWpjhCVEECn1vdRotKkTAXcdJQlwG3EKYQNOCQrOg0YKCALLw9dn6LUa1gE1xRS63Eb0zdaoNZLEcBe82n5Vrbu99UeUEZCnBXAauNI6bERpKQiVnLtClwqVxt8umApgC61aTdTO1thMRYKYg53GeI5DTH5E8rVDVg9iE6WREL43khWzukaCtwVVVbIqZgKOGrwM6IG4MET99TAZHMIgCHangyxrAwZvRSBsQNj1hbEziL3Z0kqHxp1lN0AZEQVHjg7ZTMEH8Y6V5TDhva5BRtUMNeATBokLciBFFKCFsRVG7zoNidvXS11H2hFCoYVt3OVOcN89i0E3ttXsnrflNV+FwSucJQegXGc5cIOkVE62E6M01mTkZJ0JV9RpoZW9wWLHC15+3kZAKxiD41MDhGQM99kwMtWFuNHUR6yz3LbqRD3xSCifIRKUkZKQBt1GYTRk4jmnKRl1rQRtrvY9k9S3pDX2VUuEbfVVw4k85ilGH0sGZV9gSBlSysvSDhQjU+rBcPq8ZYwOmzvPEVW5MIi0rNtt/ajx/eU1CL2Jvguku1jpK56dRAltHkSKF9sFRBqMH9RgrOw4uL3+4wNxXyrEUQrsVF2nzI8YCRMpHiF8N0dOYF1iAN/dVLWiBASWwkN0s8ZZsSxtbUIMJe12FeBWIEdVQ4cXm0N0v1vEct8TTQ1mV98g5FjGm9LIZhyKlSuNDt5QXc6TERf9djwqC19JjkeQxjPC959v18TF8iFxiEsxZ60GSwSnKQI4XIFfz1EqN0NCj8GEBepLbPd25FaC1MrmoW3Z0oKQauFrdJ0FIN3mi19iN8mZvOotz7L60TISfHZwMZiHu+gM+K/bdS9IJt86wdnP3dOVs6TsvYNEJ81vElNeDUGQ1Zj2QQOJDIW9jgtiGgleAQSR4P29klwX5FkMzkMdXhJM87BX8YxCZATo7MnUtRVCwJvwg58TVBzd1TeJfWc3iazNaoi3WuFzVrbuIWJNx8FUSM4gCxsDpO0b0AkgasbIdOxfPyQT2IDpgVYfWcNTAlqBcGzPzJSpuQNwwcT97QiBrrURQJULxElYFp4r4RQ04wIHYFXEYBRRtjcQ+sZkh1xSo2Ir7Sa14Ri0ILAkaW85J0dH4pHfs15f08GTCmDTz9UF0XfkVRR1Hr+qdO70dWf0prskeEapx6Jzkhuy4hzhft5FwEcGghzDtcOaXB/+0Nx1L3c3q47X0DWTyIRSncJAm=wwJNRArSEqUchVV6DEpaBUPWr1QUt6dxEed7YBoqxxoXP1HXGkCnO3FclLSIpAZ2itvYc3W9ZUpBMSUZMHwVxczUmB2QsEcFuUxA3q1gkHdgwqYGFxB/Vs9ahR9XCgSiYRRjU26US3UE1Qa3sOE25LRAUXpw3rQQowJ324c5BBSBkalsUwc5JmQ3NW0QHK8DG1dpRkDqgvXeILk3r1G30P1iJajUkZwTGlkRcFxAUK7tSXVIJ3te0dMwWUuiUI2dTJqNCk6gWUyBYjwQN8Tj0uJCJNEz0SRqdfwUIohMmRgEKBzRJSlLO3w0EwrfZXwHTQgeavLSXGgVcl6cUeUPkBVfPjRaUUgI4nZqTUZRTAm7e4PqwSVRlgUPev0DTH8+7eJqBS/H9Q34RP3GkHJblLk1LQXVV9A2FCQg5shYjVNl6RgaCUBKej9791KElv0Ba1LZVk3tpkri1HtE1k0YM3BAg30JQpbHVYVVikmQUNkM51oHYpY1d6r0cDnYR1AMehLhxCWBq0g/2sslt67ctgjBw0ARUuRsG0ir2gde7a6rW0DNPmttPjmwRhxrVQKUM9/Bzuj9EVdQ3nf30hEVUVnWGxIGGEbTdW10+oH5WfNYT2H8z91+A9sb2FXFVeaw/QDcJp8sWKQnTIQp+V4vGrBYJmgQHE96XMtQdeoaqdgWTAVB7ZXQKxV9RO86M+PYG4ex5fsXXftxtlNP6rVl6393iR4FGT2Q8QmsXpP1Bn9sYzb6cRv3=xE/Syn9N0JR0s9fTcPXfofBCeyysDYTdpC8aRsxE0m7V0NV3P0QSidPClT31HZPbbPnlvJaekY9kYTN9OwJDzRoJD2QTbgqmApKfR9U2UgtYS7eHVhg7f1ImORUQUNRMMl+AVXf1lfOuFP7pj2+oLxoLfw/kPrTMJC/XtmdOFt=IYmUEcd03CystqRRnV9V4iZbe0Xf9CaWQ6DQ0VUIFYt2/0g4RG0ET+1QKDOPXTt1EX3aqFNaLBiRtvAw5FA9DITgUy9+0HGFrVlVmMLaVl8jPFAMDJLNx0GUMv2sF8ZG1jC5SRJw0Npt0PeHVBKR/qDQtkPSwMOSvruBj8sWIFYSv1QFFIPCwXHn0EZkrzSDxsO/x/HTrhJSnGYLpwoaclYYWQeXMmwrT0LYh4TpBVYFxqwqGZw0ykKesu5Fggkux0KtT4aWWcZNU+4YQY1u2JQ4y53EF3x39xzlSq3/OL3xBF2UGUzVBMKwGjIMiHsL=/NVyX21UxWQ9Fcy1H1vwt1ea2Crp3dUVKERMwPX3wqnu0ND0goddY=hZXA3oXXkQ/UfV5LFIPba2mS1Q07zLQ9ZSi9EVaERbPzd39YLnNIH8VW8h6WYxw+2zdsVcSMg9TptOUxiUqd3hIFBDER2ptl15LxkSX6oNVFL1ERNlDDxPbx7VQtVHpxhpKbRXaOgxF4bqUVwwfNhMKZP0dMXAwtWfcHEUbW1gI4Nhq1itMW5FhlvvRf+tz0dx+7hosiVcwPfAdUcz196Vt3voxsk5b9ki0V9Bw9lVc8a0Fh7jEgERQBUbDgQ0GFZg9sVChbYTGh9PUx2sWfH7UOV9gC6wp99HtbOQTiOXADQ99I6aV7dffZQdu69hBtSkbuHlHn3XoCTXA8Ky3UReN079YMiNDGLESQz0wOIFcTxpAbURFs5uCVVGIMWUJBbOd9aBQHVDKQCNoEt1iLRID1FgXd87sDf1hW9o1PZKT8Gxsdlo99iUzP8ExUx5Dckb9+QFjUiF00f3lwKqbi69OBtDVZbae2DQVfVNvJlvt3GoGRhsRApTWiXWKBktZwy14MZKyd15642/QS1Q6ymbzY2TXCyd9hIW+1t0NKzljljM8dPdENvtQ=2VUx0cHxre2BqkZNO1OabkYdnxAM2N9BLUlXeoFFfz41n98NrXWsRIk21sBtVxkVZlFBCu6mAxK3Yj95LsWiMQRLQghTVlOKrFucaCtq2mykQacDrnRhHbEQCYqQUMPBxTzf3rY3dtRyd9VENMPy5+TmNfCQmZtQEPhwnyxUXsEN0x3y18MIVxGICMkGrdLhnJWmtAcJSW6xPBN8=wQ1cR56dPTfrXO7TlxKVsDjibnglcWXEM2YSD8dsd1Kpwyoe09RXC0BMNuWJV6/U6/QN81Ht55scHViAsLWIKxftyR561g/O2Mbcq9VVgggQoGTEBndgu1WadCW9N8GQRcNUPhQoF1wqt+QlcJe1BPi4YXG1IbXl8Am8xTQ/3a3FKKRp1TogqxwGXz48cvkbRuIDtUsFeFQ9Bm5k1xZeyTapEt6d1HHzloNCLTDkGSlkrECKQQgXxAKOjUkptsQFElEOxiuDp8Pd0P+xs70w5Z9NBl1xQVpDq4zqsrRlYRtufsvYFClZcd3Gh9wOV+IgbUPH0LaSU0sOa8FU3trICp3zq5maYKbcZ9mbk35i1H+19OmolNq1nxOIDDj9cYSjUTXvbf1I2N7Qm4JMTir1Fmez2mP2/uSgkkLdF/CgMcq1QYXlfGFu3pE98ROemkBIcBX6ZLCwO25Ui5DTn0vIHUTrVsKukFbcQt+sOUdDEB5VdBp1EQGCtKtSdkcVl+AlSsX1kz9efiVUXDncoPOkGIHtaUHnfniEGcbu2lUWfHFV8Rz/Y1kZIR/dYXzaT0gdF45A3kGVw8+ZKs54X8na06EE6tl4MgmXjlNOBl/VS9uM2DdDUmFg752t53S9PVmYZ1/C7WhJSUtZU20v=nr6C6QimQPOttsOT6BaTt1IMRgWbTAWc9HiUjB1Bt2T2It2PT07gCRtEUrHXVm6d1bNsF7fMMBWVkYUN9RD8ee6I2zpE0MMvex5y0QQTuGxkaWhU9MhpiNUA+VhxPt/dQMN9t8lCxsKU8fKk3YRbu0UF9iH7XI90YKgpf1lVS3URsQ9jfnlIqQ6BT+wUXsTdVVEMlAGFmPjaOFuFrtUBHYfsNIRA62nSYaK5fmjfCOm7BT+ug8hQZ8E6Sk8tCFQgGCnLE9IPT6wicW5xwY0ESDT8egJ4NhC5ZMTE0UR2zQ98xDs1E0BVF/0wfNziwz03Q3XNZe7YVZoh3jpbWgWFGAVDHq7crctY5JgoTBtVV56Dz7Wt8I5zihrRj0ExLVEnDj7bEmYVlv1HK0oP1qYTlWwSZuTwR81157Pa4bWt/dcMc+R1WG723SiGQdIQYDFAVgX3Skg8QJoEq7NbG7d2hGWVbD3GuVB9YAkCjUIUBlVRV0ERcDaBfz1IA9oGK4LZin5DsRMnUgfz/NK34/Q7VtHC99qWLYW6rPRuNQhV9ftx3v9/TRUuHu=+S2w4lYTgLClmuhQ1FVizCzW7JPrbIHvcD+FkYF1wQDX6MRwviF0496t3fRv2CGcORnRAxMB7a97sOQq1q/etxNB6nsbR3V6aXWOxAErH2MOAo8HphVEF731OreR1p0BB519PbD9FeWpG4nlj/f1z/WNB3t+KBsvckNkhy2qKdiS0mapF+Jgc+PGA3Ac7HabVDDCRKWDr0YgV01IA0QWUphp0H3ti+BCn1uTTr3=+IYFaRRtn6e3mSmnreT1QEKdgWqQDtDLzDfWPHTRFn9AtlCSekLEo5ckUTjcZ1XF3ppjssqVhrfXtH/acWgXlWFscu11/3EXZ1Rlb3dOwcYbauF1jUP0Up8LLQrpMEJXfpoPWl1x1H8XGUaF1EZXNlSkxT+mdpjxd3F9/ClNc7CTUifww4OVorsQX0H0+4J2Z4bVKDEhsP1A8R1TJFQ91REHEiEbPLBHaUtWgW8YayAjzQ0Ef64OcvdE9DZn8Eza7ZcurQVPTXBAE8G4TmuGSjWRjcY2Ug2Nv6PCpSuqxAFdT1fcxEXV99+FGVyoGAvAX3rTWEPMtfFQyBSGdb6TAOA31Y1m1u2YyljC/a2bxvLLalBXXZlP0WCoEjO18zH0F+V0QjmlB3VtuXGNnICM5R0pSYD9geE+4nDzXALLsq0w6TVhU1qmAiWVTr0JMIQtfxlRtE/EN+seUDU5tmVhmznUmq5gebLFC7Xhx1wXi3A4GLs6SGFHZmyxH815V/ENQRU3TlIT9bL3DZiGArYragBAuJN3CDG1jU19+ovGDdKlsVLZ0M5LFlq0sVG1moEFTDOsFJVBifGIWZvNDAERJ3R/Evi1wWxQNPWQj64SVxT30ZLbHbgFLt+mSnupw62NO0iSrE9tw8aPukIbFiAkHLtjrLyhse64UsPd7G5nWWBSxdlwHdUgFFdtYeAsNDgvP1VILPZdLne2AvrqR1Aqp72tYdQrq7TiDUJKT4UDAtlcVEKfS4DCQ0LaQ8+mGO71qkYVSoYwUEBUKTwUoOxo1p9VCLYP5X0xRgdItihEbww8RlbV2IdNNcYcscrKZobgV+TrVltdcD8dg1ZAqRMerIFjHSBQUhRZtANCqMYaQbLFUJ5yCuoW/bJG0+AgAxHUEyr3cXvz52Htx9Ei+rCQlq/QH/VMbcivHViIiAAM0xbbKigIl+WMZV6IEdMTd2xx0naPrguFc60IZR8FbQbRK1xFLm8RRk9qJd9EE1OcJgpTRcRPfB2k8buF80dqmhCtN3hfiEDsRF5Ullz9UQrCAB5NJCmVuZHN0cmVhbQplbmRvYmoKMjYgMCBvYmoKPDwvRmlsdGVyWy9GbGF0ZURlY29kZV0vTGVuZ3RoIDIyOTQ3Pj5zdHJlYW0KSCsF3LXbcRn/Bw9fCVkEe0dHSCOp9vftRBCaUloaik5uMdpcBNwYRsUXE+a7TtXqUITlbV59sdhNUHU6znnHOlY5xk9vTtra1CFSvpGOcNbc7U25ezsHRkY1o+a3taK3Uu63f90+eWM6HcPHp1f9kZ7oXz6m3yA9OxhZWUPL=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ue1ZRaoKCirXbYsPxaREDMti4KkRWj1Huy8HtEYIXoPJrZZ=wWgqUsDSWFhRPc9JCB+x1P6cexKPZU4k0zSBir1ohIgapW1LGBW3mPrWasd8TOEuItgrbW1kjNgauifhJDKt+JWE6Jeip143wUcsCRFhHiBrFxpDPBwXMZglbu7Li/LkoFDErZ6SYLa0H4Vx04jUqREJqDpDW9+0IewMZVXdDqBzs0aqh/wjC1FAgkca1rEXLtDaERjY8xFirZhQtQtHNyC1FSSHu329hP0dPWxw2lml5OxAwd1/ReXH9WEQb64zEYKW7Ed9P8rjadcfa=wxme2iSAbWVmLVB7h1GdhOwN9MQLTmUgebhZzkKCQ96XemC429AoL4jd4q4KhdnBEtVqW/Lpw+YIKtfWg8TNVf4imW4oJkp6rT4x4XBbTJkb1vUoKDuNCgpZlCYCzpSCwN2VrEBj0aTA4NdCwOt6TNMYw1hfkg8NFdDV7BZsJKDOrY2lUct1H116UcFIYDaCngtsJOQd79xAOH0dN7iH3aMtUa1saFhsTsFTkYt2QoegLfQReQZjBtbdZpyrr3CHnnt8ZXtUagEQIfBAWYHeD6fN5Q6BawJWGEN53EzBtoqiNcbsDFw/QwGUheR9T+oNsJ3ECcHuo61pZSnNCZ3vYckDO1VU9hxgJ2JGJVNRGvJ=1ETF7Z1QxrQrucgu7CV4y0X7iZrQMQXuLdQgQz1938gZREzurc0LkpVuScRQdlPTFnHWMOJx5dH6gUaUKYN6bHX3VD+kTNT87icMPS4NT5cF9dYhl9dNGbw4lq9kL0/PWVE1TFyJGx1CseIgVkFExDKmCQM5NG0a+iluT+Qg7W0HU0ztUQHqB86tPHB9j6VFPMrUdIiU+G3HU8nhcSiIntZ1VxEdhrdbdHkarNdaUuQOLc6MVcKKyolw0fJWFjY33L32glpjvE93PYX14hInP1vIE/rCvoYT5E2aGjU7cbbRAhVBh8cljescHdRke3T1uB64JkOtS0FeVAUbZwqDXgrcbbdwVuYK0/kE19xL2FhTW9aVwdca2pK+3hEU44Hmhv2j1VxFhxN0Whs90scw1Rc3NRJ4sQvxPp1h1USQRgfCq8ZXV1bzjEuNWiRXQY00taMmLbWagTexKY67c1z3Rs3IVuQOTZG1cdNaOAnpqujNbyVZ/ToiT0p4klxWw8KPWHnO0tHckepRAGkA87CFeaRtHR7e1V1sN3wrHaBzC6BzLd+2VwudVeX1ltW05sXrCeNVLTYndp17s9HRCwTgVUp2Uyd9lJPq4LRth7eYT14CcVNR9xtYGM9N6BXxiTnaONYIT1I9PMLoGNS1ve0mQGmmmQd/1hU/DFVu3xVL1klHFtZVQlXg3YQybBUw7YK9eY3p0EMd7CiE59AvCQisaJnVOcS930VCNb4gd+20tDKZxK+dpT5DWBK0Axq2EX5dHydlR6gWBhTtwUZZGV9jFVDUg2P0ZFTiYweQrVdbH+0RDDHtgc9=mTKi6DVgQu2sEWyBhY1Fa/FwE97spLhLHTpt4WBE1DN7wQ5KJhhG2k5OnsEHUBQVcsOlHc1AEF05Zlh+Ee0403DJ3WLLDHIqgMDI0MZEFgfFDrdX5QMJMJld5IDa6UmkUbCYG3DJQhaYwF21w9xfe1cwjNZVMsLC7UNzCH1N/yx7bA2MQ/Z6QUYT29exwvdEB0GB6YDSRV7Ls+AWQ7MxkRSFwzOfhNV4iX+RaaAwZ7umWzvB334zeX8DwXN+Wzo7XpIUxtYHuHWVgpX6c5DzZXENtkYQIPQxELLbF9LttcuXwC2HcmCliIBtQTdQIYkYRgz=3duT/e0pA4hJGS4upzSMsz5x5SbXrQlRCa/DNE8dUtQJWUfpXkK9kTamFbd1sEgUF1WCnU1iFxBHUHBbBHIqL6g+SBF6GzM9pwCd1IQLrfceSUmbe0Hx3rb/xfezmnkFs6B/tEU52/CC0e3JwrYFUKtg/0YFpg6WdAxCsFD0Vw/Rc6KwrCdEB3lFhsSna1CcibT0OqTpOdZc2Fot9iI03N7Sq1e0FrWsS4CkVuGsTC2D6QMe6VNB396Nx+IfU7Ye3B5I17XWwwv9skqniRdfrOUktFlekQpBarcdHcRW5C0CCelbR3FEftZwIPRT1aLRA0e1ERCXtIF6wnpQdfdVtQbrjcu6nadsTpYVtDH147FHcVVSr2ipRJantSd6Un8fHDkSw9lSVlt4wIWdRvHr0Tr+gdHkx6kd+feS09pDGBt2dbBJGCAHpdKz0ywR0U+YkFCtQmgpVpNyzNjUFoudLyTIBu8YZ3CI0wBeWUQzVBNcFUQXsf0g6QFRENMXi3UPdJ6ZFh1vfJQw4sVpK/GovSS4RTZHDvgw8MIhf/agiFNfHUp+wcdtBEH6thMia0TovFyBGqH7TApRnf2U0xCKKYVolWJnKluqCUBiK0bRnCWMMMwNkJ+UP6zMHiwykC1Fsf9Zn2J/D3nPQnNywJNq7UZnzOWExgXDcqW4zbUcMPM5fRm7qAOnEAUUdRCGpIsD/Hq62kc9cuRRG1RVVpXlp9P+cp7hoq/S9EObUYPXF+CFlCOQKxV91GN0S0SxtQAm1Jtt911BKG0WRutMMEMR2af31iVkW47cerrt0RRykDV2ADMasYHFRNMzNKN0/3fUqodBtiQMJRFVCPMX3ecI218LefQVW2FaGAN1HkEHeyJI5y9CFmntVMQgVkTTQ981cG0FaWUoTz8Q41leOFcuxzcOVtfiE4kbJiFs1J9wXddRhtwW1Z4qTXuysHRLUg7QUBcRdV1JcfVUIwaIqiIp/YRVQ6IE6d1TC1R/IVF0BwRLt93iV+s4czi1M1B9f1FuMakaxlVsDjdw6pKVtKC9bN0/nBREl4WV9/awyd0YrDQMSZhuRlRxV59VAlrJ7RlQFxrXlo01zuVmd1Sc3VrZytZE8c2+oDLPfpKXFQet3fPrc9aweJbUxFepv1CbiWKoV57e1UU88aSz1QBsJ2MQYuHZxE2B5TriytZfy/kzc5rxkyDvw5P3x5NzTU+72X0JtLcmTMHzj1I1iM7R9KXw+pzxsQRs5TqdIRGgUNgMaIHxkIz5NVFunF0Fi1Q4M3IISgUZC2mY/dCVk0FbQUBQ4S/XFN=z40ec30J6eWg+txgkH4rdVpt6BhKCDr4vZRWRCRkdEc2FIWQR+HYgj3w8ZMCHXl9Jt19e2MFHeQMWEk9297mDUlwX38oClNYrvcBNLctBsJIeQpCMRE8NxBCXxWAtbG7eIPgMMWQ/pRKczgVhjW2UAUkM7imSd1Wx1XpSs2EyhgPEFwUMxU0t+OLYKHV/NhxyfgaWI0U8kVxpDNvuRfAmsVPM13WyEP2U51EYBw0Md1sap/5VA/3V8bjft7w0ODiUmAFaAxXALVxoTxJD6fdg3EHEZaUoRV2JyEz76XWIkOQ16l1WTGvLWPrbSiWVbDIlksKkPrqmOHOUwRLWR/gW45SsHNSH3uBxuKnpI4iKDhVjz/ncRVCbyERtw987vY+RcLNRF2oQkdhfz8ZWwDC3F6BWN66wlGNXZfG4BLcOwG/8dk9ytU1lFBwN9AkIWErgXo/OHZHw1eR/rpEccA9Yhn/8wVl/FitRX9j8SHhk7gupDqI2ERWJboMs02hbfSwSammBNiAM/BNgDqh8t8Z11esiFiFY9hPH81E2QrAOC25nLF837d0bPzadykag0k3Uhe0MEO9dMctN5EZ90iLAVbMWQR34kQRvJT7HuyMKt1Fz7gnN7mW2wXnbE4B1/EQmFRNesEsUMGy1q4bsEBRm5RARkQgVVkMtNaCiO1IHoPHiNpORXsnW0UGxsOqZCQb1UqSAwcrtsOD6wKITkFU1FB2Ot+nFi7gvH29PH27rV7ATu9MDUn5lQ98fWS1p7ZO8l+q9clWkIfOpfftgPo/6zrbaslxRUMvutlwJgYJfKVefFbaI+lqCMbGjQyEFGgNAtAtje3u1q5AE9aQ0Tt0gRBFxMTq3kwfRRmc3/d0GRNbYY1VBgwQ3enPLZ/d6wjeQUVC13USsNxR7UBdeu/3BQbUqRVjUS15SXtWe9UfQ+r7llzCrbZ3lxQbpeiyQYx03fniMyet3x9CRn1RFqWw/z9liIMaZE7kAsd2F0U5P91U6o+G3nuKWA5JxALzBNIjpeAtsykFlbCwNhF23RiCkChN+KfnjuoX33X8d1fgGE9kGcS/CG29NXtZzE1jTgoKIPqBX53QV7fYOrwNJAkhpMKzcwr3u2UPCVBKQTcUPbwQX8edhh4Ccl5XmGJGWpgBkRnUT0QuQsJpUi2SLnRm7aGF/fW/TPz9j9dP3/304dNPPz8=3vZefmBhrqVR=8vH13/Z9OtPP9nzTm3337z4QN8P2PtE8/eUT/z4V9v93I8ntJTkXWpD5tnHHwhDW5KCUl93r2K3drwqQ7wZWOcriTrLWQRxyYVw9lGVQELW/rQXBuwcHnB5LKVhUhNhJjEjQVYGBx/H93M5KRAFkXF7IApCLXuunUFQ1Q/AY+TKRtUD40UBG0NVAfT/1MbznTjFf1q3SVm4Y+cdA30yq7UEli1grzO2IvmZd5Epi+K7xNsbd1pHd3CaLvZcJnO15Ls2kUTneNwV1vMQgEXtvR+JmDFgDh43vdeXCrNHNLbX5vKznrRDhoRxvd1w/uQZA2sviTYovB2w6ShyRdUbxruSxPfVxF3H8JCWI/Ks+QknFEbZ0EYXDf2=kkHUTBEWVhfkBcucoiHUCcZp0h/IPOJ5h2Kk5wSaEQFkDj1+StgGQ0+YBITKFW06sUPj8RDzcgJwZOJnRGRx19T0jzUjqNYdOpfaqk++2MZUB89Xq0mREVNfOkXn1Hpgg4XBGcEqQc18J/xA8atCJ6H0iYSA1ZX8jC/py92nIi+xQw4vcgJjDAtiiFy2tWNvdjpbi1RWigRlBVwWtX0eA0q1zlBa27NUFiL2VVWucaV1NEbwlgdi9etUUT7aAyxJEFF32xRGFIZWB0+urWCV3LzlIcnE0QnpKn0UFJqK8OQ+0FaWf3qALapyhvK21lipHUhf1OeIXVZLwhiKsSYbtxcc6YMUWSucwUN51sXNB1CEUVDsF89H3X389plgREHebcH+1EBlVaMkIT0LpB6ZLZqrDtOL0BkLF6d0vOfNjNddfRvdVkbHpD47MssAmcvC1xG/Gr2Wn0mDclT7zS8lRj8CVRXEp5HzU6gwdZ1G7KmvbAihebWVlQ0heEnkO+IoUV4V5B69YTl+3MhwOw8Qr3FVdFMHqSKmXxLUxsSa0etAdrL32WIaFwKOwUeURaq3kV9uv8EYZ0RJZ9M9UXYwVkOGYO2EC7H7iEMuGg2U1m0193bhthdpBTtG3FigfX2EprsBWW0b4T/TJGVoDLC0dHQJCiFqckE1Kk8IPcHcV62W1BiRhB0e=wJgCwK3DhPiW0HUP0a9ZxA60KhF1DJ1hpGUYO0JsblUprVTqLCDg29H/Dh3a0CbEG4NcN0FcW5krMLXMysNmDnOzX0OHcbWS71moK5w5IDwKu9YsQrCGXkKV7LKWlRTc5TL1j2Pkwx3P15M99ZwypSjwIq1dpcrSB8xtZVfdAtn3pPMFRprOdeIKtR3kJGlQGxKZi9gJHxEq5dCrCkGQ21RPNZQ8ME2tfrXcJBdvKtYvXdiwn2n7s13Qyd69V67fz4kWloXxRGQP87uLnH3txxsO1gYVwbbT8+XDcdyDUefQHGU5bOEaYgdiCEN6aTEWVfNR5rGwZQS6VVGzzamFc8Rh7GNZotOewtVgENlOrTWzBPZvwtfbBOqYFINnEKLjBfw83dztmUFAzIyjG2ydRcplfHssEC3t9w0QyU0ZR2CtNVlfUNVWRsmEn61lWIoJd8SiCY8zhdxTI4bQ1lZktoKHgFKkFNFAgXwUIGegNtM6meogXVwbBgAVTLwn51Id8eWxT4Ti=w9fB0LdFDb92pjJPqDrSkYQ/dGjW4Q1X0G0k95ggG1FWXEq9RqF6q1LdVCmF0vUVrKuc0NdYKBEGdrHwZoVdIbUqXpjDwkPNWcUFXF+QDuBSRYeME6WPbWFVqD9jESFpFAub1RpMVdx1QT0LtUUrfJ2XJSekl6xsMda1ahF7RgMMkhj3VlfN9ZIWIQ1aKh5UhcWK0Yp0TOByFV7ZBR/90QR1VUrCBE/2pnImHkGARl5RxEl39bdSD1Y9zrOKogYOk8+i0ywj0Oq25kRUTLRmzWhzP1EDNTsa29Qk3Oc9kXttwQqAnBHBkHX6kxC2mQV+PxIwPaygBAwVlM4FqK2Nwb04qPXca15B5LVSBzupCiohDJGnIqy6Q1JVIOR1eRe9YjFT7Ux6tbQYrn996QqpW1VcQiHzcwQtkDVDGAJqzmUEsBqn28M33UGs4TeFnzuGiIK8dfXT3WJVS4AxllxCnldjrgs9fSnwkYYkddBZUPclZbyA8FVE5dzMy3sM9j9ZkRFvxmagiJRtHxFzfRsD/1aa1jNKoFw/RgqD3nTDnuTQW7bQ0Rv0EVs5OU0AP34HrvYZFs0xMwtJgmf2YgKYF3Q4CQi1BCRwsEPcSlHK1VPDkF9OlNkrTkYKXNeexn8N1gHT5Oe7RqWncgm4LUV7g3pGVypVtVf+eBYwR6AwIuttzLxG2Pce7CGrnZmZQJRfAQUEmoOX7CQQDpGOod6AP3kQrCDQa7MjlDdvPalweU1iZmgxd09ZTVlrR3ErO6AXk+Js0QENlLgV5TJVVLYUSk0MvNXvCbLTGW9CIt8OcQZmRY3WhbXt6PSnuCmFzkr0wLpaDtUw0qFVMdFm1AWggEAYSni4a9bAuaG5F1U3R1Ffc53UCxz06SpjiDNja+sxtjien9ToLV8aR9ILG5Ex9CX7tWDTM5wt1gap09gIkKKsc60c5W15eFVmCk9YExvaBGo193kUcN9Al7LCXn07QMwxnag3YLs2LaQhG0UNV14ZiBcBJmiaTiEAMxUFUFtjNrHXAFxCPNTQ/YQDwS0EK7W21Q/u2IgNX62sPcyUQREZImxaySISkFeQwVV9XiRldTlvV/OWU2Q0Y3Ol55x79sHQ8UR0gBh6yUxDY2NXaGoMLiAo93llGhGwH3JW/HDJfZyYFE5DxkOekthTs4sRrcGB1IaNZE0R7cxCQXxgPelgItTUCDV7rhkyFsdBUTP3clAg7teUhqTiD6dcIq2MGAw2BIAd7NntyJHX3hrN1KMkFiFQJU9L09Qb2hFez9aRXoKJa9fyye4XEaN9MEhAnYME1owmZdzXKmNFCCuvWV1Sg/Zi3EgtANxoi3OG6XFVfAU1tdDVwsKOclBWW3ORxRlvOx6g6Q8NHhDbztGEQO3HxAL4oaCkZpQdgVRlb3X5b0zrBaXtoCrUhHsPV98F7Y7bWNfpssDOtskCoStA5QIGvJyQV1aUI+Qif90jawb2BPyspXkE4XlbkVHEi0+3TIFIMQXriFheyguZQUcUtg1/1VEcPO0FhaQenNEA0qxq7Aku+ruGwpYI8dSXUFCKLEG08gLtD1GmqqpVkMVvNParZhTS31IXCZiVU4VLdS/1kF1tgSxq53pcYX9aEEVDjnNCLGxT0bPt8y6wCqXsRO5BqJhgBG91EMUEB5CLr9lBWOydYz1EZCUTNKHjLYLbHKdQ1TXKb2z1DRxgbV1DWtkRziNtsaa1zg98CVNU734bgRdLA+LEdoFUaiTNVWsEW1o1jJiY1IQ85a9dMaRABVjYWgG5wNHbwVQDmWoMLd31YIncLZ7fbzS1hc9jhjPU80fLs/f3YWKITB9ucKd33wcC15nbCBhcHZP3T86VKleqFUUofdUHXaX0kwWepVAFPRAm=x4FVpcE0La90gbW7tUVURawcJbdRHVfZFyxwW+gWEsF2FSbViDF0TBluuR8Q+z97QJF7TUQv6Ue6W8NbjFkRi8E33BtclktxQLpg+h5mWL6taBxtNEA6pEZ8wTaV1tk9jpU2nGhmY=0UYP0HBOF9OC54/HkFKgwORVQtpHtQeSevuxOmqaRbJA53DZ5WwF7e7Vap/AJSOychQ0URoHLtVxD3UVEZqDmpVHJq0l6eSBXQSYvURIKV512c+ipt92cCxQfJWLpRdbcEEBMvt/PfHRz9xRjFWG7dh83E6KShOfZQcQILOlUMZSA6Pw6sV6uCwk/MeSVglhMkKSk1AjaCUHbqvHuNdVLBoPMFVjEctNE2WuWgCoFZ=38N1taPUKDxtSHVtIWgiLEVZVDUS0PaGmYbRh/rUMV1wFKFI6zp1w1/bHOkpA/VouQzJEmtUV64ORFcTSTTE1VIcfCF1ZBaQQllb=2MkC983Ab8NRy7x/MqFQe23UoQcnwYQYhGqaGQUMeMY3Sp983nSUcDEEGB9NCXmRHRTFeHuQFuzsSUBk9NDKwGXFRGiK2StN8TXnETV/HDWwwbZOGEeS2P36YLiSotwhB9gUCpk5CeMMHE3xbbz1EAPhM3LbXUghPQ5XQQpT3BzPgHHD8emJAlRNl5xHE0F6R1cgeDP4hYWR5F2DlQ7UL61XlEIniOOuMHSxTVE81hek09l8z1sMVcQLc8cFwbF9BhFjLtwJ2B6mLd1Zu4t+lE53WLHHyTdxNYCHB/Vp1OEJH81QmdO5vSWI2UZY1otpYLRs7Ngs+RK5lQQt8VXcEjJcVFBFbgDbgVJ0UFaVSrSxEVkpUcTt9iNd/zQ5JqWMe2AdXc84RAUCvgShFRtCw+eaNCo9NBQzSDkMcgxtVQVRQUBXFfc6aupKmjpG3B+QQdm186KARC8cGR/dtjgBzu5K53AkV+sVxl8tzQK7uepbxkHtzeYKklHZGZTRPO7Ax1PQrQQBIiZnLHoFA+kK3fV+Tb8m9KYwVbCU8p9KxnCgp8x3By4tsg/f1Ec29gTkaRt9+lbbt6QD8Yg2VE0OskLBNWl6M2IZfQ8WG0QTRZBDw/dVQhgDAgLGxKRFVXxkxdE0RIIge0deXVcQSgfiqY9mxiBPceNZ5JUtRV30kE3E9va0Yp5zTU+89tFZvLxJ8I319hSBwe1Bnsoq0QWAWzQgBvbuvdBZW73wp4tBHpQFcnuT0XPu3iIHctCdkfLcO6L20BgR01pVqDE9fnsWMioKhARirhcAIlaTckG/WZBGrRrWGmQwmxqoV8bTE9AByRRpwn8L68c7=waFmcgn0EOUesU8vDV+7sVDLPdaPDvHLuJR2ZGOPwWe299fpxBTLZ2nlPQOabKf6dXwiBlw36UM9mmxQD9wYr2wGJrTW4i9ot09YW9PaPc7xRsicHoabe1DfnIBqXvdoCg+a9RyMWSDKmDfg0l66pJQMYgWgWkdTsdIbCVN3agzu3hJddZKW8LYwTW1BPcm9VqtRuTKUFHTU6tk9vt39ba1A1V9efSshKDstzVRxwcWdNfXBlQLy9u/EY7LxPQz73BJCYu1qr3wRCJ8dpHFRexNpfaBLSAQ2TlByB4w1Qf6jHJAR8zOrWFTFaSgWyIhxZPB0OpY2htDYC6dRYC3hoTXa3e63bCm68E9HW/XBhwgrogaGsNB5EPJTCQOBJayMDpEc1DcwX0MRxw1WsWAtbQXp6TVzQC0H0FOQUMYd98gWQt0hULf1QBCz9Jw8E1bJyNB1gLcRtqTl+Eq6JmzkNXfd3yBUoeTfp2GxlzOQRIU19VmWWkaAxqZ2nkBHHVUBVcZC8NC198BRpaIPru52dVOiI/Te1Tigctz2e31BlHS6CT6eFncyUNQFudBNKdUTu05NRYUQVxB/CA2AVRHsarmkE9sd9nrHw4iIFvYCoPuUHUlU6YjEEJVKTIgT0lC9iY3RdNiRJzdF60VgbRn2VE+m5YplcQfZlZYe3UCTQ/fTQEaTUW9L3awpBHctjaWhLnYFtaV7aVlXloC8KnU1EQV2NCM1AVqFY3RY2dJngUSGxe1HuVFF6wI9VQ1VWQipE3CZZEYaM3aK6U5wlwFvN5/oIrQkKEtKuO53moMLq1g32UWe9r3TDsRthtwoVQgSw0EPVA9CmV+TmsGuH8nSQnRgtg4TEzPJgOHSdCVacyZGJxaIWhtEPw9xKwYh6bEtutitJkW3IhFKSuIrti1PSlgIQcEm3=33kAwiN/xe4wYwMuQLWhKBNwHI3qnxF0TUUr0ZSH3zH1lLd7FOVtVIJwV+hVIDEcFS43QEcTXw1OChmbltVO2BsJY3u27lzOp0ENgV37ckTAoi2W7F7g4jY5UzvZV0PaZgqwwJl03tD7eRJHbutqQ/ZXdo2grOJz1BQgZT16plUEzjkgCgdCBzi084XRpGkmU3ZXbB/npGRORxssVwTThlhY0lHYEnFLd82K3VoldQTBtkP+iAUE7F4COuJCncPt7LWn2B0QOMRcWhzNQbXK1/ZFiA1gcdx+KmYJBIpAViiBNW6HBC0ZwYCLYGQXBlt1/r4a0HSaYIO3dBC2RucNbWc9ri5KIbhvycOiH9HsfaZ2T66g2GDdeTT0n/G7NzXN6bOFdId7deTaNyy09wnf1E6rfMLI012ViMaQyg5W/XdUNpPXtaGTHdDkC1P9godiTaZlsbT1dGfxoJbbpcXoCuQdIxxoLS1REjcHFpa1MpZ28CfVl5xMrW4aZxY9BlpJGZcK0ebzphu0Pb9jLEUta1CeYW5jQREyW5NFXO0fWk9BhecucxWNOPTjfImY1JpB7Kn7iPWWgOWN/XkGwrYwomiWNxhFSmBEH2rRzQR7tHzW7idlRBlS2Bz3Fw51cFH0d7ZA/ai16VfRSMqbdGF8B+mKVeD9hS196KQwvNsEEFPY9W9h3G4hHHxfkORlBs1BK17X+1z3AIDINwDA8dj6n9Dd6YCK25XrkBHvHQcV0tEKa5UYMV+pkVgO5bF6czHbZx30FVhxXFFZFxp/RdLEQRDXV9eqknraQY5AjiBNQFsdEjF+ZC5oGVtv91nfj5wbQOISDxECJliU9dde35rC1gSUcQVp327dPo5U9l5KxbYV6ofmd9gsahUtyp0HXMOQmg3AkX0TyAmdzBDqRtRwrRU/Tx2RlYIF88cKIUNGVRlUQw9pvtU0IyWAxzQpSZXozMhbggKyQV9ZaRjGnXf+lhXOmZIYVnXIQtBaFB+U9lCU/pkEiKRTbT0ZbRgioH3D1Uz1lCnsbJqdHBD2K2FiCK00CxBX7FkrsdwbxJkULHOBFkB1gAythzWX0HmiEkOyhVC+tKGM2KlPLW8M81IDTTp1qxhVsKrk0IUFfEBA7iVRbE0qI2AXWs6T3XJAky13irDsBSNQJKhB5qPtUNgzrAiKr+lO2KAQi=nrYiEDNGFthLQ1BfFGpFFIIJRK20QToRA2kGu15d3qYkEQ1wYoHW7/D6L0RHGUXUWDClFFrmVaVRky5WRCCc2rMQZaAmsNYON9cCtt5qlp0EUW58KX7UkAmVVwe=8UE1j9gjd5EWiO1rWFka66D0gUQ0lRDutHfeIckcma28GG7EsP2B5V4i4DHWmpZVxVxrQ7HRwUKV5JwxDETk0tR1UuBN5kwXLnVamtXAgBfPRt52GQY6eAMRGaxDcTYV5WBgJIdONxcZQYWt0+TPYC1mnRTC0NkFUBQEZAbsTFy7Qi1W109qVTnyx+mAudlEJoNZ1YK1msxu1TrtFlUX6Rhp1YQxpB6yiAhZkpaR/ojB1l8wFBNo6CWB1uAp8Oq2LjZymKc5WxdZ5+UXtobydsRwdzqCaQAo+96UESQJpTCYxyyart97KJA7Ko3Q3teIzGxcUfrQ1kcgNbyxCrY111EoIzVjttgeWN9r1qnaFgtQygXUPrIEGq0lGet2uVUhMTxs8=xdIWRJzV7HC14GK1iF6tUtz2DZg5uGaKGQct2AhG3ioatlwVskBWNiwempFgw9TOJlxo1XItE7LJFd7RVelCcrEBVtuNBUHXpGcwdnJE/HybE+tYSzUChg91AuQJmS2+s7vfOKlkFUC+7qUNgyaZ4QQcE1joqGVhS4RYBBEQSsZgEdKipN8ONglEKRBNywd6dVhWC2JrBUFUYVV+WKpsHcRA2fE1OQ9s170fhpJWoEYm1BVlgYGI9xDfYcwRpIQVDxk3Ewknez14hapg32kgdhN2YHQHUiAKgDt/HQtayw0JycVVpfzmCnKlMRiotoNxTzGu9KlLVdNgFoxwbb=hgXt22zc3VC1WAIN7ekYM3dJeIcXDzr3RoR16mF0DOoE4NisWt9ri5EUdxxFKTrCp0JiGmN9Q+21FwJ6UVZmYNOUEDiB2rXUE1U5BfcCzxh4RuIXA98yAonvY2jQ9VEhdgUnUXsuA1Cp9GZUWAIKVtQexq1DAfBORseVRmuV6UO1AFQHEti9Cm9aEN9qcxiYK3INUQkd8bkUEXzYJJBVBAywL5ixwhSExvblUhKZBxy+2aO36xKreQ2/OG2HfsS1QZBUtO5WMHuEWIlrnUQRFaXGheQhiXh1k4gUNUzm1XC0GKI+xIERB77RllErUErZyqwcXU9SwtodLRpAyxEE6kDXQRP4rs5Rd4b2H0K5jt5BFbBEQWi1X0rXBiQ3XBqDLsiEHLGbC6WhJG8iMhQg0yrHDhtYCNkaZoMHBlYeHE5kGgO1GV807EEJD67IxKmZxF9YLZZagrHC17aQT9sENKskerF1CreGpTeJCSGlVpCAgemPuNHNCO0TTSla2B3BrH9pYLQP6CLHdktTz9ViBdcGodURm100fZEDopHQXWKZ0qNZF0kJSYSIDAaBEcHe5WsFvGq7kUW5ycQw+UH6rq7Eikmsi/iU34dZdZZLYCak3FiIgFODhVuLSg3RFacYkYtXZoFeQSdvdVyUiYJluFcsj0KBF0RYFzBiNNq5AccNMZXFHiAVsae0siTo2jtDti0PFVUNwNQ1LFCLKTJTzUDmzcE3EFTmEq2wrDhbQplNW3tRmENQJNk5AbRe6h1FcNcVxjDY2KAeYXrE0elslEiKa1+RFrUWs3UFAxKKzzUJBdIDu7kLurLjc7CqAaB6Z1pWVwWGhZEBo+FHQh0iXi4Bm9XRm2raSSwftittXxKRclJ1kOILv0CBjVXedSABOrLRJPSpqGiEQdKkjZ9tbDs676SsZPyQ/QqDSfpJsW9aVSUU66SwG4r+sN5/P1DZw8P3X0F/eL89Pb8+xnk+30RbuaFUd67090ntzfnVy+mO8fH909PX18+z49YQ3d6fcaSf9tTSuERMEwkirbnw5Ydey6A3iNHH9iz38QbxUAmsO6ikbDQ7J0FAlR4YE6H39hc3971Kc7d6enfz9g0xf2bkvTKQ18dz50SQVakZBticRVUWT4bQxMMBBeTQGDLYEbvxi3dNPc3tDmleTWeCwM9SID9klpCs0EfgpkkDRAxFkloEDJYuNVSllaTG6PUWE9GT4GQsCvR1y4C0wNERLVwWC5MmD1DL6mrFNYxtRMa8Pc6ZkAVtCQkUO6bV9yJh1WFXTWohGAglXqQcOOasMcLqX9ETkUFSUHxY7PWFZJmE3N/VvawUIRrFT3/SorilwXH2=qe6WJXV7fTXFfTFlXl8+X59dTbd+uHkm9fT9wCVj11/8ra193svVdjy8nt7e8HcurQ8udg9e3rtX2QV43EDRv008vr3F8n0FUbbCoc6RFgyl+FAkZB0N6NNwyBf0F93h3c0UNRKf9SXN+tmB/cnF+3tyenLHjy4OT9xevf2N3d/Xtxxn2R8fwZfdN9+rd519eT15e2/dd8OfHXi1Re48uW7trqdxNzfXb+4edd6oMK0zf6G33cMD19q3k/6F/KfRmWqZH0z9jGaYzRXo+6hQJVcNQFVFblkCw7J3xcPFP0t1ITjVXTd87t3uf9/Z3GbZbUSDyfM2fWM5F9+H38nDV/z7VFQyTrubHpxc3J2lMe13TXVxNQe1+X95XxEFQhx12N/QMIevcC2wQdj0ZRhglR4eneSV0EsPfZf2rYiBUWqguOkux6cGFVke7ZdtEQN2FPS3qOJrWEo+H3ez0DYxVgcKvdf+fZccMFl5f1lVuwdewMYwsiQkFfKOEanBo3hbwsCTcTTx4RTRJLxBF8NVrHdZA/RmuLtgvfMtd3o9f20ReRt8XAUC919+dtBD2FgaeZN2A923tD91onTwVUcEY/SvMaaDw+DMy4xpBHECFjEHwTfp1gXLVgwB8aykeYFY4WN8OiXBV/oLuO5xJ0z3XxpKjn6mRr8UHB3B3q3iaEAnpEVvK3lYuFZExRgUqSUKWUpl69Bk+FIvaTWK1kRnpGM3FXNN5T9bnILFgg9cxZmgUWI8GtgKGV9H5CuC3X=klyREspBz0Q0lrXg4iWxkPZhFgGBsH0MRbRmpsWVvqwEHTmlOilgYz+mI2WwClVWX1sEhsBmcY7VhXUSpYVoqQfp+LkoKeXEPVLbG8YBXsRAXAUdhqHpXF3ziDgsGtUoG1ANoiRxKx1FFVA7LZfiPbHl09M9ho2FlATZZwRiurKx8RVViDitkE9gPBn8Zo3kuF3cjZBpFyh2EDM8rBtm6WdUSXkcWIopuICeQfd5wdYVdES2DWCh+Q=npRURHQUvc9PnA19kNp3E7EGmRajL+hJEIkF06bRDuH19B5QzUQQK2lgOslxbIa90JLoOuNO0Q1GUQY20dJUl6C3I3zTNHOEecB3kCwb93UlftzBw03QxVgpzBQbsBthKA1FwXimtWF0jdKYQahFKBGxCNykJARAEREdDtiDVioEVwZbzNgG7jpOHQtZLRyiGfbcA5ROIbljFqF7+rX0HQV5RpAck4WDWRS3RcQBoqAUhvRS82D6U0DLfBf1EaCGMBcgqp2MwSjwIRthpqxXR9Ss7tuBzqsyyVgDMzKWmMCd7GVfMX1EQ0ESxemKYE0aJQI5nchZC10AQtwRtsBABf1BFnvuLHYdXxvfaSHXZsuoexgYZXwK1ghU/QmrC4it7JD2UAqpTzltKW89AS0dekgyCAKM1FaUdmyQUF0ndqYlUga1K8H7YHUZ0h7pEBJfikGlprnGgj5CY9Qhfrk+u8CZlhd2NiKB8/XxzNS0Ph4+D3xDbTYOf9WPXVdZMQhCmMRp7dnbbPl0v7RLkJWByaluPzdbwXrn30c5U39HwKnIfbWRwUQVgFEkDhdRAk8TzC3F2c30BUUFExdGNGA/r0UD+ii0w4xHRMcx0caZQedh1rxDk5KFvsXooXlNPh8q4UN2YXzhQgURUFVLxgYCUpHVsQd27IW8FTEUD3pyFQrbc6cJaF9ucULnfM1o9yhkGc53Peu/HIGNx1aQRU6uGBIX8rCH5oE2Vra3n6NknXtRFlEENbLFigzkpQMIFk6xAwEadTFYFqQOrdDTVjIHmoEBqQIWcbyAR2cNFdaxlRAA2JZcD0YR0dMUTcYMpAtReHkPaCCsCIVVeQMEfNCWX0D1oFdLCdagSk3YrUhJFYkVCkNy45ECpDYw4ZVtunHgMgPSE1Rw1osV862i/ztllWdd10DURSrEwBbUgKegOmGkQO3oMqaBLtf3BR1E0/ZTApFDOXByaKTOrcPZVgKD99FH/T31gw1fb380gSZlZ/aFRmMe0QZfJwhlDt7sWixQNuxHn0FjH1QHmMHqMhTNbnR0RPUJhyeRK3wjRBscQY09ZMxtaKaIUNY+sclEed3MXVTVBTFxiAMzCT42F0EQOoORXt1CwKrd+sMHeutDrC1ayBdNbauWtleASs/f3fbQxdEjsaz7bXMMYOEMFXBFdQ1qit6IRd2ysZFdZgwwg3FhY9tadxZ4SFh7lcMmMDWVv7gIfiHQsSBcGrr2QjKQ4GjxD5CZfQYuclwIF18R1mQFIhGClExy1T8L3I1lbEB95yoSFSpD5y7Yg7QZG8GRhLKxII31FMrrbORdcBELFJ2IGVCjrApQ4SmrO6tIK0K1PogkANRXadE1zN8nFuIXlBW2ocqBUgBtSr3jXZQ8b5O9QRjH3p5Zlf2LRcGpp1+702FR3ll/X1vGGYufc31gfT9jGj0KaURZjpmT0F3r6cn73eMmtjP0Nw9ZJll7eGgf3O+nsp1CLpcxteTiWNenfrd9eT3cXm0uTi8fLy9iV78c281b251CYM2gWl8Pd9cg97w9+ttdwzQMC/Y6wdVG62rfz9uf1/ddH5Fm2s/O300jL3Fz32P8U7vH8dgA/iQxNG=rcOTQ1+h1fG1cd+li/ecHAukNTwvy3clkDu/dXKKTh53HNZ3FcKjh7RIPBYN32tkbQ12938cLtv+kHevOQWBAXA+zjf91Hu0T3T5uBbdTp88+kH4UReo2G1Y93CdnWxl7Z9tUD3e33YXSxhuC0harjFb3N/fQUPdAV8vv1v0QfUXItPxGx1huCPXAwsN+maDKEbzRq4GqfLPevZXt9kVIYbC2uEY3RzfbXzE5VQYMTg3CIMYju2PLHUMIpE++vOQ4WiYhgCnxrxFTVz1DR7Dt9vNFJy5fdtgBFwdaGEgq9Q8SMebwVERobQ/ZmV9Z/x8V0tCxhsHkKFqBIRFwzfH5F8928KJjarRk+OQYz0WHMaRktsRNqzaAjB5MAzEvsXt1CVRfV5nCGjNRovndXVFDDBQEVTf8MhtmDgIBUymoZOCFa5HTUa9nuQUh8ElgBI62kGTiEGB90BSZ6aCc/KRsPYP1ue14SfVR/3+166jh5GttIy+In9e3Gz60yHXGCMIWbYcYE8WU9FmioiCckNMkdXh9DRQaeutkVY+peXQs9JLYsQ1aFVhnBwIpphtCp6Fp3W3Cgc3ECoQL0aENvRG7ufWdELm4ixeRB3ViLkrB3zJjcKFwYpL2iHBBAGDVHVW9pD0QuREYWTZgzJJrUMiT0ZYXmIWFRztQiD/6=0zacTEHaUFAJ4gK2AuYV5VktLZgJoD1WIkETi4mHdMEs/E3URkQYopuICeJG7aFkInoVGSpaUcgx0EFdMwS2wFKc9w9cTe5PZVsPgiBP7cIdVlfkgkZEVDdkRrpUNAVBMBLZBrZtgT7UIRltEwKHVlCS6DrjTtQCitHpaR0ZgK1CEewI2VBEQUNg3zBoXw7SVd5Myko8rHCjBSoAohT0Nx0EEt1dKChH=zkLSCLExNiBIIGVTUFO0cNYDZpHmIVf2FjKjZxAzcdamlYOsUwW7mYSHyDMUffk9fX0sOpnBMkBYVh2MDRKdV9ARGqoBEA+GqdabTtQIQwmeNseBZRwcZDAWHYKw0PRcYyJ0TVPWqyMgMXrX7UhdQVEMX5mJiW7EEaIXCib1pjRCoWtsbVSgecnEXDNbY3wXQta9uwQ7OJw8CsVg/arHnzmLX4TljRZybbdaGBUQbXVodMkVvwmqIO7tICgppD1CQ+3T0jWExFHEkYwigMFPNqH5k1tbMC1uPWtayl7Qe1qh5IbSd8Rwd5RiUKi1Vh4HKw0jZEAdt9Tb1t4g8Pfz16g+DfCl7UhlBsWdnJ+vTUcuQV4CJtif1zhWsd2MtTNRdzQ7fDo6jcYrAKIq0OSRVJzcRw4uwU+NtZ3EkLQ+d+nFkH9dH81+WkoKfRotHoXRLadawR5+RAgwcCfthAPzdvfKeD2mYLBVwSt8KGMY6R0cEL0dw8CZOc2HVI8clVKQzOSagfWXHzX7zNUHduxxCzpw37tIyxncdDAGV1nAg/K0g8dNdK6tPRlwJF3XQnRCDHPbYIE6K0HBBDauQ1RE04pWxUaTtZg4d11qB5sdCaEg7FCg0SYsdXWMduUgEJeGfBSgfHTFF3WFUCAIJUnt5DGkjrAeVHk9DhAczgtlOQ5YB3axmDAGptyICQdEVCV1iuORAqA1kPWdYyX56DCD0tQc0HBRloRrTSNRnVdA1HXU6wqMgW0ITUNCphepkEbTFkfZfctuxniCMJPMQ8QNMgaD6QVkDrsICckWGXB3aBlGCMHOGY3FxayuOn0HAfbJctXMx2nrsqMzIyErs88kdRLTziByNCkuDjXNeec6hh2PRb0xF3927ag5u3ttRYmXx4306tmwoOzksa3TXAVWxIXO+Efdadvg3FQHm1413LMOU0dPTJh2eRm33WlidVOGvftcaRtiyabikBls87YIJCY0zoR3dymM9auJg4WOmdcR8SgqwX9WvTUgRd/RFcTpnVzrdsK6kSegA4N+zSAIYP1E91gSjhQtgX295MVg8=gVHP30aZ1lBOOk1kHQXLFrfwYMOtRrDBFw87SKRNenOyzNCHoT31NRmTHaikHtUF5ydw4U05VkMGy8ha7GEEVAl1IQ1ICojBnJ91h87wf3q11bGXpMU7URikCDxVEWUGzncBVp3KTKI9zYaz15DsgDLHdwMerRCYAyegCQ5Ff1i1Zzri0dmCUFUusF/S0HLw8PK1o3flEDV2oFJGLdSsG82IHnH34T9RY/dj2U8VQf3Q63ccX6QUMT249GMf/Xv9GD0XWNNP/c63z8PTVgg/VI28z9/cfPTz8/PrzNw9eaek5N/xvf1fZxs8/Ta4kkaAcy31I90VEafPZL2JuREebE6Ux/JbvHt08vl59/QMDJz9/980DTwPdYXER06d3ljw6tw9j+st5WwF9IwO33/307q1lz0QzjjJSTu3tePH3zS97H7zgz2n+9ubQj0TVz9sf3t8ePcH7fUVw/fb/d734e3z98u0F8fXF7XXUy2s4ttYtTd=gkQV4hsdfNUQ027JNRgTksHR23ANbbgoyc7JDg+TCoK38esKFdHP1niDAGQHtxNGBNqG2ezw/dPX0OIaYtIQc0Rj03eVbW0hERpgYt/NzwQ3W=nPbFn1igRanPasJWsDUUh5BirtMhz3qN8oBEegVgPICItmFXsQIb1F1w90EmDi1zcgZW0iQj4I6Thq2duRlDyeEHCXIPyVrJOD7NO31uFYkRexJDfWB5qnkWXmurZhf=mg4RQEopmLb61pwUckbcsi6T1QMttLRUQXLFgN2dxNzsOoXC2G9dq23GgeWyXuT2NhqwcbxAGtUIjGjFF3WEGJg3zlM63VkOEoX3YNh96lqjszhaSx/6Vtwc1t+roj6GS0D3xkT0IMAYfm1IrV5AEnNTe4DgiwAUNvaqkaUOnieK1bdRM9I2d9EjFHY5NUbkTl52llyOv3tKgvalleqxusOUB0anXrxJCnGi1SQZGQFVd3FoIYlZNtRTU9sFLQ22FEeW8uW2dbZxhuZy6IdcFmVvSjNwWpaglk3T0Fb3pJcYX4ghv0+sNcwJsc6Lhc3DenuFikMEwLVs4t18JF2FtcGM4HERN2R7Mns8xoZTLz9tk1FTnMaHu0/MaYKcz4zVCDZkg2zWTu91U+kHToftkUIVhwYK6A1EUe24psEMdAaYzTw+7hJKcSODMKxvdPyFbd3tIDmzETx1eDBCxP3Bz36uGCxWO+vbwoErNzpYRPUznhFB1QL1lnUmRcExDifwxS1lIzXRm93aIptIHrEBE5zf/NZ81K0LXFrg6Y5Yrg+rAFK29vk4c+gNal3pTTMrddZaZLwHibthsQVlWNmZJg9zouNiFvCtgea1glt+hV93SsiFkEgqPuHatAYWEPNEvwyl1kcyovqxxuwRooY08gFED9+HcWw7D7ge0TSndHE16B5KnTVnfd25T0dC2dxGwNV2cZE9u8xrcTViuHFfeUk/5hYKFcNZaZCPWwdUbTa1iVC4JunzfXF8GzNMiM8ezYIUdfcSkMKR7Ttq0lEWS3XW0amHfd4d1Ft7ttXCpZChyx7dkX2uEramGEworGvdr35Fat3EIRvfH9g4lRCOWJwW1BlSZdqa4yBEe79DDcTQVhTVAg0ZBYzFxahmRxZzUxEgP63LFERaV6rVkIj3JdqZ98cvCzE2xAKCQi/VLHVFLrh/kQ8bdRsJ3bsw824cpCBzTXCx1q2u5gsyzSYPDsWe260rXQLCAsHpAs3rTiV8qCarTNgffQMEC/ZbBMRK1aIHxXF1sOHiXtk/A/c63EuFYXTNXwnaB1/YaR6LTlZW7HD36rq/xRF3MZQOIc93l/xEaGqs8V/dmWUgeUX24WZB6VWlrCNVUxYIFVaGQO0ZT0UxYSxlgflXtU11VWR/RVBWg0JoV11rCgUPyxkYblNKNF9FmczRk1YoxUVIks1LmHBBpldFHxipQhcDKLYPDpvagoiT+ctxlD1EkDwcaza4OM0plVnrZwWVfO3eZyAlrekNVmEbEnRwq+SIF29X13pyZmJRFktGC9IcLisJTy1LB502wAlgvE927Rv8QRx0rd5IqgcOvc9WmwGGe23Q1ePtc6bwQwQkRLe7XYmwYA1aQqlvsEY3f0C91fb0dhWFN3F0YBAkF8z0f9kgVcFwz6d1sOCGtgcEdH0g0IkCtSDVclhsWE5IcthcQF71yMxlxBJ20KW2zCiVj02H8CmIYFe+klFLJBsSmpPN0tI8xiYTGlJTo5dn8bWmyumS3MVyYXQItJD5tUw5ZkBNEl/Kwt5IWa2BNe0K211KDcF0Nes0YhoQRw4FBV49xuuWFhp2u27uNR8kvL2tGYOuoa6d+FsutttMnenZ1zVlxZplhTlwHHdfEetkEQbH8KYKWVjcWo5axhgUxkH1sDu+nhN4OsPSvHXgoOYQZMIqYxSvwd=1aU86YgYV2M7PCNv4WN5G2lbIBkM8IFkzhfQ9Adlk6ekEZCOtCNCq4/d9dgNukK8O0sKYTNkKxACoIllcXkVe31DzmMKmkGILFIIeMZUliQwYsKtbMxUZeVMbVTz3lpXLX5soHUaUTnR2RN6kMVhtpJ1UPXM1rOTlVa2zzETW3tTq90O7R60iLf91plp+e0RsPtC6KX0RQytS4IVEdL0D2SlN8IRlQQRL4jdRsUVc1h0xEncOlR7ENcQN2d9/RFilEYMcFbd0x6TsdSw5wSHBUcn=1fXj0n=mMkR8QWLdmRFk0+QfME5830I129tfT1jcQ8MsTQ2LUdpStxGrnR1F8q3lEWWY2Cl0TkGPdQdlSG85oEvOKFQNVsDAk5yUEuBAlNrcQLJQYhIgtBWA4tiB181N5FDc=yag1i42ccF+8wVg0+64mN0Cpw5et3VTGeJwiF+S0hJDI3qA+MiNgrWEQKueoXB+TAUrM0drWQiOyUVbUzPV+xFptRBUQNQJHLrq5tenFYV4Fx85rNHU2NRgF1W5WzhFgoEn0CRDO/Hc5tM1Ife2IldMZX5zU7b3t9jHfrMm9x8w+ractRSSNHBScR2nJUa0JigQ9BPyQcCEaa9wqV89MFXp2RCClrXsUSDBhkopyBSW7zSGzEkCikQsyI2ETFRgJtRt2mYTmhzAQckpm8DHmkEVVZQwDpUM9QNNVkWalg/V/N6faChtY0M6fXEu69ZAjXLZg+WMLyQgHPxwWiaecwTycbOnqxMgsHZbh2yUM6CTNZsFedxIpy1Xxsqzl+te60HVDJww7z9IIBXiWX6C25mEJBAV5+G2QiLjUVYY2jz90LWPwXaDhA+d2bUqw2ue29z570IWbgeS34h3MRQsZCm92PSAkdnQsCBBIysBbgtgCTmsELUD9BcGD2Kna0Mc1gNk1FdlrX53CjfJIMyyUKomKjfYDJU9yEOU7fdf2za51FZkX2Nmu01kNPhkG=x1RC0JMD3OVBJ30d5UV5ORrF+4lAff0CfQMpA+lyIE0GCAMC1kCQu324ig9Rgi30lK3mF2kyiC8GUWFkN0dFMnwfT9YelvXFZRVpk4cJr/HXCaSNsYV9DfoKLyZ313kq32VjARZmU8t2Lx/czoOuW7dTN2EEFiHpE=w1BZ2DfaLEJv19D19h+qYcdV9jdNQQ/0uREBys+ycYBWRE2T6NW9hNAETPA+wZNoizdRDZxcE64EeEw9s13OkcEDUB944W8OTjDHZghfBo1GoNKA0osL0gpB7keEwmakpBR6QxSKYua1QzZxF5RVkPOsIiPdRPMHN7GsIERUNuKs0p+lg5wV8WG0YTkEMXEa0NZJ2GBTFQkEtwKPHlvHpyTjq79FQEBArdsQxEoN0RwFxKW4QF01Vt086SFhoahMbtvOwcbqF0NAz1eaCVPc11N0ALP3ZsYgG6TTO1RTwxEMIxQD6HJ8EwPYB3kbAjDlEzbUEy15gcbT2mNaQySssce2CQgOQUFV8XKWMbRm0fHRsPBvd3TdKl9eYATrn/b50VaIEODQBQizNAbTXEXNNaJoKCAGP1tUcRDsd6/Q9xya0D0Nk1vQCwoJEVV2DhBRFxhKUhOMEUN0sYmQ1VkORTVbChmtz12J1B7OxugCyFbxox4SU+QwPnrCIguw491HAo9HSA113lfVnYtd1oPLuMRXSlRoV8EIbtHRvfGMDPrg7Nhc3cdS+D7eu3H9tIIN8HcbiEmAQ4vCmgsv/HwMR7FJ2QgoEspZsFVPCBW=t3W7z5eHbU01DNVy2U93+3k7mt9FymKGwO8DW+sQcPYQWEK10gFXQqmx0d8HzlJO8RF9AllQ6SkqbDBTw4GJCIJQNEglBQF4EEkbpscHG2lgQ1sENIPiuVtWPTNtKVIwfxsHfDaNiA8rh7KF8CUIRotHcmmQXEIyXLpIkgGoBODuAiklZRFUZ830FZx5SUmM0IfOlfbUjmurThMtT9ejxeHlQ1xUwWBJdzRB9th2IWgMCh4aTgwItkB/aYBzvHQSg9WX85dCImVFZRi1VEwNiyMw3wq4Cw4kCDH9EQS4VU5iMshfcEnMOEYWTdUHGgriTT1hBF42QIGN5GX99kaBqthTmgKCltMkCVaAt5juuATMMNRo7DX107WE9OydtRk9C2MYVQxaIMvWrsdBt9oawgTviN2ITJBtaz2wWDAEdmkBQV7YC15JmMG1vqg96xOmcPg2YEBlZPWFyBgoXNYEtrFMiNair26pqsqT+0FjNIuwgRqOkIJoFkFoxEQNjW0dQAV1hN7F+TCpPTFHM1lkOyBeFEQQG5Theikb37EhaRhXzW+gk9kM2ErBaVAqRysfXyl8JVlkBSZqCXfiUs2kLD8UO6ZYU3FpB+0dEpLHpk0OIfZVN27L4QVUDP3IVkQbRrWypdzk5BhR9jBdNVcSt19lVtkdwW1YQbHbSdXC38LDXdsL6525rO3EIe/05Vjdkq+3kX1kZcthNYP0FCW2hXetgV7FCDWQKQAdb2FfV83HGV57kOep22I/Nu3zqC0DIn6RddpfHV6DQOxPsJS3QOsXWX0f0XzpkFOspM7U5m4vUfTCE5/xw0YxEiTQdESBKERBRAzfxxPdgVk/RffJQPbkFgXJ0k9sdkq38vXtEX2ACw2NkX2z7ELf6Cg1bqc5OGY9gZz1tM8XLuxIRPHGdwK1j51lC9ykzwPCgQdCX9hDek8GOkhsU7UesqVE3N9s+H8OXceszQk7XsJZdep/tlxVfhu3kQA1SmZ1gkfT19WesVQ2bT0oUE6HtJQRfI2Nb4mNuS0k+OQUpzcfYFxB9rHoBG8PJk1eWKikt3RfNQsrW5J1ia2MRIWVCsQ1UQIgfYyycdogVVcqwS1ga1GV5KGhUwk01IC7imFWBsUAu4sV9eaDg/bTFjB1sO6npB1cTTlgcV07YGJNPYith8aW4zLlERTWVHoCzEuQW2YAQ1d8dkxkL1GBdYRFZA2SBoOsqQ1ob61gbWW0x7pO2FxNUcIVnWMlNeqRF5HX7UI1JzTyoSKcNeJhFa4qaTMJXFyApSRTqtJlcNfE2uCttUBncY0/bNB1QagfWgtsNelCqtgFynWVW/bXsLmPoRbV/Z86d7qfTKsDNxk3td3LB7dxrdxOxm1rDT6CBGDyoTA1l+KQ41f2sFJ0N8zAXLvrPTp3F9xH0kbHTpR4pjdXW0+HduEDn=ogjgR45Tw9E29R13hQdrb3W91rA9gUQXdRpl01cqUJiGBc7XkpPXgYGlyU0VBL8lgOvMSee4qS2UYPXX2EOFzfRl92zkWy/PdR+c3TItwRR+R8Wwf3XFsuDpXtmhYXtbUXqrAzHd+grUVgC2Pb1HhKgY5kgMUu2aJh6GWTiIh4qtH9+Gz9frfbiXWEXUV4uRkvTpxXWsH0PWw8XRWNNW25p1cdiUyAP3dEfHBFcZqTtfXx21N9yWid1Rf=xB/G3aqXl59kCFzktR1v80P3k1fwyxdiVkiWR5Es/rXqrU81eGNdDMbQ95PXV+Yx5qIG7Vt06yQcPONd7JBkP+qZJb0IDfodfs1wRWCxq67bLV9DQ+s5mK9br2H9MFNdJekCA2VV5lTtwdBZfRZ6JpNbs1dxhs16lVDK24ZRlPOPO3XUg6cCGnDXJtR1G61+CsRLkN+DhgKBOkHXa7teW9ZIBpJ1rnZuJlgVXfnUR22QB12QSYQNIqWrpoUNHSTAMO7RMGmQLM+GAfOLbpbJl5Csj1COo4lyQcDTvd93/L5AtYqxBcwPCCEasLsPZ3EQka7W/diGlRLkYa84HOCixO0dUfzOdV2DN3XnJOAH9FRHS8YaHC7wQ4HzgZLDmQZwNxpHzO9cdD15ttuU0jqVlEONbLXa9uaVsvW9bRclI1yBmosKUsV3fHNMuFJ2sWVx9K0QUMPHUJrjQve0QgB6ceYjFbSgpKpUZED3CHVQT9TDi09=xmpV/LRUlRNHXtVWd+DxxWTwef1tgZK4oKk8ewgQCUHTT1guFZLFtZOxttXDrfuV9W6xg1kRBWFZM3sKNR8oQ1DTKnEQVY9SUZ9E87BVi67EF+mot0wR20u6kHtvdleXqrTxN8x0fnLc9h3HVt8we19jdNQQwx+XU49MQ5eq06anvpQDqwcnXdqywZ5ENaAgVuel4UYT/NCXyupErXcGLCPkYQr64rFe6xhmeVVOQkZwqI2llkehHuYE1z8SLQ1h3LD1R1N07ec96+5DIwwsa/O7b1/NHwR0Z3o/QZXUx8FNTz9O03FxWURlXxtFWZ4W25yWt5ZtitVVddwxA7uoKMcKZwf887jcxcpX9k1K0cOLXFfeWNf=nNrczxfWFta7t+6QUHTwrrkH17T1kjY911TGOnt0LrDtZS1RspKARW1sZWNh53ZAk5HICsQqQwfe/tUEkQgdVe40ETXoasX4FMXCmZKcHgTsFxCnRtAu0RqaUzpQwTUiEC3TAo4lvaBLHSxIxNhrbScduCCgTutwCMcwxQQmplSIQEZCRAgHlRXStSEtBTiBLVFIXvnTnQS0GNvNItsGR1QQ1E2y/QdEHNC5gKK0kmCYECQmZxfFjnn5wdZMQIOXYFDN0kMaS6E25GBnd4E1kG1iIzNLMwsLIQMQwsVYEndwVVY3MTEeBi1AECDCCw3LdVCmVuZHN0cmVhbQplbmRvYmoKMjcgMCBvYmoKPDwvRmlsdGVyWy9GbGF0ZURlY29kZV0vTGVuZ3RoIDQ1MDA+PnN0cmVhbQpIRtXH6Shb9A2OBR7sqEk1foDt5x16KXlrVx2cipVU/NAEEVYqFFBcxv8/XRzc9gYQaDSLHVCUd+z7XqvXW2EPDOs8D1lITn15A/PdCUwwJ1T9I9l824g83rbcW/a0wzXiWMPMVI6Rb=voYwcH0zBPfqxwKhf8YFofI1+YHwzT0RSz79aFrnXhdvf0SxCFLzXFyJ0fkITDL/csOpzkHVjUHW61l9RFniA2IZsQ2IF2k1Ua6odkS7wTfgWsPxNxG1lJwT0Ic9wN6twaYM2gjSuRNXQSxMKIH8Npwa19j9MgpyKmAUQhkMezsYaxUk8x2nf6BYF8l6OR8yMYFysv4vqxTTZ8vka2AuwjALnkDVBpcT1ERqzjOMh6IknnmZzKw4X598iLicFf3rrYuTWdanSMV8Cjw2rXFUccdRytVQRmMrEwYVHnJRrEaDnFRcHyT0XrZANV7zwkDVsZbVYb36nebYyPyVJXEYqRitBo899kHC3xc/Kd7d0xBBxk70RvZTZYVh8XiqUliPCEHRxrNP2JPQN3V6tOKicHKkbbRlBTN+97hVGTmDLXHLSyNPHV8ZLtj8MkXYFvGGxkyWYLjW37m1b+z0R35uJqt4E9RfR3Sl51E9YUNR62983UFKe0Tri93m3se0JRM4xO5e2lsIW3p55CdLpG/o6cLwQ86fzXzu6DTDiywtm2B0Ya2K2T3cPdNUVEUCznrXYeUg5Cy7ZD1liS1ISG1EIkWzW9DECI1TicG1iid6OSpTRli9BQQfdAxczlw1rlyx3H81t8f2NTkXsOXYI+dIoOkiD1iFCF6AQ1HJX0WYbdPN8Ea904dALasC96Aj9XRyg6QgdccR15tLGUet0IY2+oVtsaOviahH9VQkL1e4E37ZXou0lZM3eztQBrVSkXlHIxNtEwhhhLDnccCGzURSMD5GNaDlojA1G4wEft15CtQ9HsbRaU1QmCnhHA7ZSADkNYPQNhMN0T6y3CMAeeQwG6mKFfXF+NQTSTr3Ns1ct7XkM8ntjuu63EdR2sVgMaK0xY/TkJM1F5oC7wVYaCbZRO7HRu5Qtx/LeQOE0cCH2Qy7ci6YTe52CQ9jUikIzS370hg2SITU6IkQvIP1IxUMi0HaQHfN8MCxsBZwNffAr8XB/HSkHGtY1Tx55tbEUeVz2IihJ1V5EnUHK3FRQ2BSF6ucCc8eFRVHYWUeCWWpAxiBSSEfUIm2gtudjrKgYnDJHfau67hlg2JAAUyQC8GaAFMlCBwM+bVWBaN8EY2U1ZiEEAFYhRJuKmrX5DUlZLFnFEIu2Pfwd+W4RFkghtPrHZTXDn8K33zTKV+SUcFt2kma0l25tZ8RxXYjrOFqrCRpkRmHCQ5JmEYxa1fw85RjPtJ1Y/Nlh2qwO5A+pQm5ttM2cWhAdN6xixYDcF2iE8Ds6SWcjdLXuSJDpIjLoiRC8g/akCyJM+gVZVtUHw2rMunQ9QEWF9Yq5hXfPkFcbSLHZSaXxUK1lmW9KXtQjemZCvcCQ5/eD0XXSR8kdCZxkgVmFHMdBC2RqYYUSBVdg1Qak90gQUF7eIYIBdjdRDiGKhXA9ZlUE3UTVQj1iQQKeoiaQUK2XTmFaGGAUwu9YN8cFJ9hbmEWCPMGE6vd5FYOWEDPBOpJl07m1h6W1ryWdeBlxXVVO33WKgIzlGYsPpzEmbY0JFN9zsUNMEOWUOzd6A29DRSG3NVpLji2QxuDpnVlViVDTB2ILtjNBH8fHdacUGSRFoD3aFCF6AQ1HHX0X4UigrFZX0R9IyOwB1sK60gpXN1tlBmGtY1zx55VEGUzpxmgK9/USJZZz5SF1GIHojkgp3wvMfXk9FFwlfkQjsE5gkURIZtgtBGmECtBzIEC1thY1oQctsEMUCuHHMQxioN2QOaZVsd9X0lArdTV1sFxC7LHdAntVUhvuX4BRiEbX0TXviUUYZoEwbzyx2s1txGrOM4zHoiSedipLdtN8prVlEcd1Ba8DaK0iMwZgmrPydhJiozWxT9PRcbzbV6f1YRxq0zmQP1QUcltBtbwYzvEPmhaV1YFsnODmNnSXnUgj9rDs6DA541o3R4heBPtDUmGPYJRt5gT0gbVUT4F6qyMUHTlc=18HySN7NNCcteBKl8VithZ2VvSmDUI3qgQr3AkOf3g9GV0kfJHQmcZIGZgUsnHlJdMbMRlS19YxyEFGUGD8dAWp0FetKgrtu3Ssqd9izLYj0DkNYHXEmNPdEdkwgJhnhitrcOFXcVtnI1FEc7dTTPdbS1vms7I33rElzH1pFYCYzChNWf07CTFgtqj6ey42Wk/W+xDkbzuetNdHJ33tEXGgaViFRomRztaXXLX0QV9TAcInS0KUL0AxF5Ohwtwqg8KCY9XFGRmAPOBvWlNV5xkIRUcx17CueUkMq2UEQPbF0Em39RKllnlIXYgeiOU6CnfC8x9eT0UXCV8HRiOwTmCVIEhkCYEQQ2RjLM1ogLmwvdgF23ZtDJ5MTpobQzUUYHfNVexE+S8dhasVidqjrVXlDHFDCIG0HQFGIRsOehNae2K4RRhmgTBvPLHazWs6as4zjYeiJJ52Kmte23wmtWfHnXtrQNorSIwKeCas/J2EmKhtbXE9FxvNfXqI/ViIHGoTOZA/VBRyW0G1tBjO8Q+aD5XJgVCyQwOYXMoLk86G8YdacUGSRFHhTw0FoB9ZOFeezsN9sgeyDasC96Aj9XRyg6QgdccR15tLGUet0IAW+oVtsaOviahH9VQkL1e4E37ZXou0lZM3eztQBrVSkXlHIzuGJRFxPX1BHHIQUYYMWx0LdanVUV60qCu27dKyp32F5sQNoYQ4gRB2xz4JzT0R3SIMkCYN35Y7Sa3c1lVHOiSDYpHNv00xvW0s+89rOiQNfBNdxtFYRmMlaw9QwwENlLV9jlkZtpPfH5sfA6783lrbW0GM7xD5oWldmBULJA5hd20MUF9RFfU2AMSMYWQ0RYheIPpRSNGuDwpJj0g/EZOYA9AG9c6U1XnQhFRzHXsK55QyrQUa=9sXUVkiViXLrDNfyl6RA9MHmO+FvD3vneL/NIUwdApMG294NDND1wwIAhtgZWYZRhAXhe7IDtOuzgGTkYHbQ4BxlVQM+alVpaN8EY001Ym871HVex2gOKGstoPOIUEQdgfdCQY9MdwiDUJAmDd+WO1mtXNZVRznkg9PU/V9wbVQHg0+QdwwLJVkXRRVa1eXrRSiBRUNMQE4FR81lrG6hON1QxXUTl7HQfzzX0DmwdHp17XTXrWWWpS92Ihh1MBVdhS9g+w80zliY227f0h1dOVxLOT3JuUMWQyB2FwG0Pra1NfQ1TeNN6blIKEXZHSPncFN+dDXBJMtmVpCETpdFC3AgxjCy5aAacQQIcAGgF2MDKQoLcwQ7YNcuWifxkZdsHST1gOdUamXLU1o0U9YyAlOd9hqpwXMtekk6W7FTLktHiANCRz4fU1xe2RfcQduzkcAxoIwTdtYEFVmIt1tQGs7f0Knxd7X1AnwUQHsdjDfHeSPHeEDPFLL10LddlbOf0pSWBcZYFKnVwbO3b1t+6VpnUndFkdzAVWGlGESsZNM4V1VbtV/ZIVFDPdCt60Fje2L6Nra1E+jct6yasEDEH2jHiDkSsPRkEAy6KTIORVlkKULdCjFaO1sswrg8KscDXsEIHABxdi=ykKC3MEO2DXLz1nn8YTnakk9DlHd2s6T1NaNxFPWMgITnfYaactlzKXpIluxUy5LR0gCkU+HlMS0yJhwRY4iQ0Y2EQrHfb2QBZnsYTVtjYO40PuNlVng87f0bKlGSFnBFsNGfYh1gDiEZF4gwREZX0TRdHQ4ziO1fArUe7e2tN6aUMVRaoNFsHx2Z1bc6Kx1V1vUHXhIdgdTgJmFsfYztkc1mWXD0H1IdHWk/y2/dyTly3Ogf1g2c3BDa2tTH/oUrSsqhCxBxnxFCtD0Zap580cGEj3Q5Qt0qMVo/yzEaEs0FLiD0wns8RWFhWAH9m9yzTT1vdWBs9qUcxx/parVitwlkwahnDCAl5ztsVRDufy5GD6l8K3cYZekIYWB2yfcDalCSwcEc6B9RoiDgldWntaEBOs3R4DgjBN215gQVQYi3W1Aazt9HqdhsccCMG6wRzrMGCx13mwIxoJIDhC/bFvQvNCQvcSx3mk3uBew8Wt3L6UkURgCmbrVgsb9+2/Ue1z2cwUPye5gKrFHiJU1H+nca9eQGu70NeSPtZz18Nz1HznoO9A9wRm57aG1tUN6wTdRNWtRDNHdaRAtFedQJBlo2U2QUCA4WWBQtwIM=w6nXB5UBssxbfKwWBC1U9R5PUViYI1gBu3bhPcv0U1Yv1i5PVEaT5TK1cHbUMDLxkZAwjJw5bF9xktDQyrfWVyWTpCEpgtP1YZRlsBkChkFpwL39z22+sfVUEXhDDAjBN+0QwamMHzEq61qEOdv6W5ZA1VHXsS85Gm7ODVhrxH0Kfzv2Agl9UH8bxE9kN7dxHEeqTproWK7Ja9b0kRa7bQQVuOjg2dy3LXzUrULipG7EQ9s7mAqsNUEIFVHfaVurKtPatmQQ1IVlQ01QUNeA/0CphbH1pbvsQpxGmZd0kFiMHVDtG8GoPOlqqTzRQZgyJMTQi1K0g=rkCySJMQVZSklVAkAvcdTFBcHCHdUrl14jL9V5tccehRzXUN72ViJjT2X4xlb7BVQbrZRY9pUitCUCNEgW4j33lHps4eiN9iMvd3kgxH08M1VaEHzTHhmYy2V5eQVVHeL8LT1bqYCkBtVfWQm6TkgAQRHqD8DTLdkRvdxHEeqTproWK7q9b0kRa7bQQVuOjg2a923LXxEr0LupO7HQ9s7mAqsNXsIFVHfaVurK3BaCVmQQ1I1nc03cUK4W8MPV6+xCnac53SQXIwd0O0b2gVVZmC4ZTNDRmEI50ECHUrDAWc9sITpBCR0g3ysEgQtVREeT1FYmCNYAbt24T3L9FNWL9YmTxlRnUFRdesQml6iBCcz8CVgXh+dS9JEYt2KnXN9EARmXw/DI6OmRjgfYDpi5At6c/0gOcPY3RkDgjBN+1agQXTYh3W1AZzt9HwQa=hAEHNqDB8DOu30CUcCCX1Qfwo0gXohXw=zxSy9dAXdLXDn9KUlgXGWBS0J1cGwWW9bfqlbZ+FJ3YhZHcwFVhpYhEqXzTOFdVpLfdSFQj917f14jR1U/b+QeraiKcRp1DdJBYi1Q7SwcBklXE0y1bKcMKBSB0wQIdStUMCZxwlCIQE+UiC4IRAL0QUY5h2waxdikw/ZVFibfOkH1A3z5UK1sHbUJjLxkZAyjJw5bF9xNrhL1EbKoGIAiFDQz638Sd0bNsIliz0FStMfIVPdQR5S1cbctH/Rsyq4hU1lZrg/0Kki29LCENDi94ck9AUYICeIH0MKZW5kc3RyZWFtCmVuZG9iago2IDAgb2JqCls1IDAgUl0KZW5kb2JqCjI4IDAgb2JqCjw8L0NyZWF0aW9uRGF0ZShEOjIwMDkxMTEzMDAxNzIwLTA2JzAwJykvQ3JlYXRvcihBZG9iZSBJbGx1c3RyYXRvciBDUzQpL01vZERhdGUoRDoyMDA5MTExMzAwMTcyMC0wNicwMCcpL1Byb2R1Y2VyKEFkb2JlIFBERiBsaWJyYXJ5IDkuMDApL1RpdGxlKGJsYW5rLXBhZ2UpPj4KZW5kb2JqCnhyZWYKMCAyOQowMDAwMDAwMDAwIDY1NTM1IGYKMDAwMDAwMDAxNiAwMDAwMCBuCjAwMDAwMDAxNDQgMDAwMDAgbgowMDAwMDU4ODQ1IDAwMDAwIG4KMDAwMDAwMDAwMCAwMDAwMCBmCjAwMDAwNjAwMzMgMDAwMDAgbgowMDAwMTk3OTcyIDAwMDAwIG4KMDAwMDA1ODg5NiAwMDAwMCBuCjAwMDAwNTkxOTUgMDAwMDAgbgowMDAwMDYwMjE5IDAwMDAwIG4KMDAwMDA1OTI5MCAwMDAwMCBuCjAwMDAwNTk0NzIgMDAwMDAgbgowMDAwMDU5NTIwIDAwMDAwIG4KMDAwMDA2MDEwMyAwMDAwMCBuCjAwMDAwNjAxMzQgMDAwMDAgbgowMDAwMDYwMjkyIDAwMDAwIG4KMDAwMDA2MDY3OCAwMDAwMCBuCjAwMDAwNjE2NjMgMDAwMDAgbgowMDAwMDYxNzczIDAwMDAwIG4KMDAwMDA3NjgyMSAwMDAwMCBuCjAwMDAwODkyMTYgMDAwMDAgbgowMDAwMTAyOTkzIDAwMDAwIG4KMDAwMDEyMDI3OCAwMDAwMCBuCjAwMDAxMzY2NDUgMDAwMDAgbgowMDAwMTQwNDM2IDAwMDAwIG4KMDAwMDE1MDA4OSAwMDAwMCBuCjAwMDAxNzAzODAgMDAwMDAgbgowMDAwMTkzNDAwIDAwMDAwIG4KMDAwMDE5Nzk5NSAwMDAwMCBuCnRyYWlsZXIKPDwvU2l6ZSAyOS9Sb290IDEgMCBSL0luZm8gMjggMCBSL0lEWzwzRkVGQ0UxRTAwRTY0M0YyOTMwQTk2MzNFMzFBRjZEQT48NTlGMzZBM0RDQ0RENEVGNUJERUQ2Mjk2OTE4QjgxQzc+XT4+CnN0YXJ0eHJlZgoxOTgxNjkKJSVFT0YK";

    /**
     * Check if carrier has shipping label option available
     *
     * @return boolean
     */
    public function isShippingLabelsAvailable()
    {
        return true;
    }

    /**
     * Check if carrier has shipping tracking option available
     *
     * @return boolean
     */
    public function isTrackingAvailable()
    {
        return true;
    }

    /**
     * Collect rates for this shipping method based on information in $request
     *
     * @param Mage_Shipping_Model_Rate_Request $data
     * @return Mage_Shipping_Model_Rate_Result
     */
    public function collectRates(Mage_Shipping_Model_Rate_Request $request)
    {
        $this->_rates = $request;
        // skip if not enabled
        if (!Mage::getStoreConfig('carriers/' . $this->_code . '/active')) {
            return false;
        }
        
        /**
         * here we are retrieving shipping rates from external service
         * or using internal logic to calculate the rate from $request
         * you can see an example in Mage_Usa_Model_Shipping_Carrier_Ups::setRequest()
         */
        // containing all the shipping rates of this method
        $result = Mage::getModel('shipping/rate_result');

        // $response is an array that we have
        $response = explode(',', Mage::getStoreConfig('carriers/' . $this->_code . '/allowed_methods'));
        $methods = Mage::getModel('globkurier/method');

        $freeBoxes = 0;
        if ($request->getAllItems()) {
            foreach ($request->getAllItems() as $item) {

                if ($item->getProduct()->isVirtual() || $item->getParentItem()) {
                    continue;
                }

                if ($item->getHasChildren() && $item->isShipSeparately()) {
                    foreach ($item->getChildren() as $child) {
                        if ($child->getFreeShipping() && !$child->getProduct()->isVirtual()) {
                            $freeBoxes += $item->getQty() * $child->getQty();
                        }
                    }
                } elseif ($item->getFreeShipping()) {
                    $freeBoxes += $item->getQty();
                }
            }
        }
		
		$cartItems = Mage::getSingleton('checkout/session')->getQuote()->getAllItems();
		$cartProductId = 0;
		$methodIdArray = array();
		if(count($cartItems)==1) {
			foreach($cartItems as $item) {
				$cartProductId = $item->getProductId();
			}
			$methodCollection = Mage::getModel('globkurier/method')->getCollection();
			foreach($methodCollection as $method) {
				$methodProduct = $method->getProducts();
				$methodProductId = explode(',',$methodProduct);
				foreach($methodProductId as $id) {
					if($cartProductId==$id) {
						$methodIdArray[] = $method->getId();
					}
				}
			}
		}

        foreach ($response as $rMethod) {
            if(empty($rMethod)) continue;
            // create new instance of method rate
            $method = Mage::getModel('shipping/rate_result_method');
            $methods->load($rMethod);
			
			if(count($methodIdArray)) {
				if(!in_array($methods->getId(),$methodIdArray)) continue;
			}
			
            if (!$methods->getActive()) continue;

            if ($request->getPackageWeight() > $methods->getMaxWeight() && $methods->getMaxWeight() != 0) continue;

            if (!in_array($request->getDestCountryId(), $methods->getCountries())) continue;

            // record carrier information
            $method->setCarrier($this->_code);
            $method->setCarrierTitle(Mage::getStoreConfig('carriers/' . $this->_code . '/title'));

            // record method information
            $method->setMethod($rMethod);
            $method->setMethodTitle($methods->getName());

            //logo
            if ($methods->getLogo(false)) {
                $method->setLogo($methods->getLogo());
            }

            // koszty dla sprzedawcy
            $cost = Mage::helper('globkurier')->getConfig('pricetype') == Websoft_Globkurier_Model_Pricetype::MANUAL ?
                Mage::helper('globkurier')->getConfig('price')
                : $methods->getPrice();
            if ($cost === false) {
                continue;
            }
            $method->setCost($cost);

            // koszty dla kupujacego
            $method->setPrice($this->getFinalPriceWithHandlingFee($method->getCost()));
            if($request->getFreeShipping() || $request->getPackageQty() == $freeBoxes){
                $method->setPrice(0);
                $method->setCost(0);
            }
            // add this rate to the result
            $result->append($method);
        }

        return $result;
    }

    /**
     * This method is used when viewing / listing Shipping Methods with Codes programmatically
     */
    public function getAllowedMethods()
    {
        $avaiableMethods = explode(',', Mage::getStoreConfig('carriers/' . $this->_code . '/allowed_methods'));
        $methodModel = Mage::getModel('globkurier/method');
        $result = array();

        foreach ($avaiableMethods as $method) {
            if (!$methodModel->getActive()) continue;
            $result[$method] = $methodModel->getLabel($method);
        }
        return $result;
    }

    /**
     * Do request to shipment
     *
     * @param Mage_Shipping_Model_Shipment_Request $request
     * @return array
     */
    public function requestToShipment(Mage_Shipping_Model_Shipment_Request $request)
    {
        $this->_validateRequest($request);

        $webapiHelper = Mage::getModel('globkurier/webapi');
        /* @var $webapiHelper Websoft_Globkurier_Model_Webapi */

        $packages = $request->getPackages();
        if (!is_array($packages) || !$packages) {
            Mage::throwException(Mage::helper('globkurier')->__('No packages for request'));
        }
        if ($request->getStoreId() != null) {
            $this->setStore($request->getStoreId());
        }

        $data = array();

        try {
            $method = Mage::getModel('globkurier/method')->load($request->getShippingMethod());
            if (strpos($method->getMethod(), "globbox") !== FALSE) {
                $gbApi = Mage::getModel('globkurier/globboxApi');
                $gbResponse = $gbApi->saveOrder($request);
                $nrgb = $gbResponse['number_order'];
            } else {
                foreach ($packages as $packageId => $package) {
                    $request->setPackageId($packageId);
                    $request->setPackagingType(isset($package['params']['container']) ? $package['params']['container'] : null);
                    $request->setPackageWeight(isset($package['params']['weight']) ? $package['params']['weight'] : null);
                    $request->setPackageParams(new Varien_Object($package['params']));
                    $request->setPackageItems($package['items']);
                    $this->_validatePackage($package);
                }
                $nrgk = $webapiHelper->sendPackage($request);
            }
        } catch (Exception $e) {
            Mage::throwException($e->getMessage());
            Mage::logException($e);
            return false;
        }
        try {
            if (isset($nrgk)) {
                $label = $webapiHelper->getLabel($nrgk);
            } else {
                $nrgk = "gb_" .$nrgb;
                $label = $gbApi->getPdf($nrgb);
                $label = base64_decode($label['etykieta']);
            }
        } catch (Exception $e) {
            $msg = $e->getMessage();
            Mage::getSingleton('adminhtml/session')->addError($msg);
            if (strpos($msg, 'Brak listu') !== FALSE || strpos($msg, 'no letter with the specified number') !== FALSE) {
                Mage::getSingleton('adminhtml/session')->addError(Mage::helper('globkurier')->getConfig('no_label_message'));
            }
        }
        $data[] = array(
            'tracking_number' => $nrgk,
            'label_content' => base64_decode(self::$dummyLabel)
        );
        $request->setMasterTrackingId($nrgk);
        if (isset($label) && $label) {
            $data[0]['label_content'] = $label;
        }
//        $data[0]['label_content'] = $webapiHelper->getLabel($orderResults[]);
        $order_id = $request->getOrderShipment()->getOrderId();
        $ordersModel = Mage::getModel('globkurier/orders');
        $ordersModel->setCreateDate(now())
            ->setOrderId($order_id)
            ->setApiNumber($nrgk);

        try {
            $ordersModel->save();
        } catch (Exception $e) {
            Mage::throwException(Mage::helper('globkurier')->__('Wystąpił błąd: ' . $e->getMessage()));
        }

        $track = Mage::getModel('sales/order_shipment_track')
            ->setNumber($nrgk)
            ->setCarrierCode($this->_code)
            ->setTitle('Globkurier');
        $request->getOrderShipment()->addTrack($track);

        $response = new Varien_Object(array(
            'info' => $data
        ));
        return $response;
    }

    public function _validateRequest($request)
    {
        $packages = $request->getPackages();

        foreach ($packages as $packageId => $package) {
            if ($package['params']['weight_units'] != 'KILOGRAM') {
                Mage::throwException(Mage::helper('globkurier')->__('Wagę należy podać w kilogramach'));
            }
            if ($package['params']['dimension_units'] != 'CENTIMETER') {
                Mage::throwException(Mage::helper('globkurier')->__('Rozmiar należy podać w centymetrach'));
            }
        }
    }

    public function _validatePackage($package)
    {
        if ($package['params']['weight'] == 0 || $package['params']['height'] == 0 || $package['params']['length'] == 0) {
            Mage::throwException(Mage::helper('globkurier')->__("Wymiary paczki są wymagane."));
        }
    }

    public function getTrackingInfo($nrgk)
    {
        $oResult = new Varien_Object();
        try {
            $msg = "";
            if (strpos($nrgk, "gb_")) {
                $nrgb = explode("_",$nrgk);
                $response = Mage::getModel('globkurier/globboxApi')->getTracking($nrgb[1]);
                $tracking = array();
                switch($response['status']){
                    case 'INVERIFI':
                        $msg = "Przetwarzane";
                        break;
                    case 'NEW':
                        $msg = "Złożono zamówienie";
                        break;
                    case 'INPICKUP':
                        $msg = "Pobranie paczki od nadawcy";
                        break;
                    case 'INTRANSIT':
                        $msg = "W trasie";
                        break;
                    case 'DELIVERED':
                        $msg = "Dostarczono";
                        break;
                    case 'CANCELED':
                        $msg = "Anulowano";
                        break;
                    case 'RETURNED':
                        $msg = "Zwrócono";
                        break;
                }
            } else {
                $tracking = Mage::getModel('globkurier/webapi')->getTracking($nrgk);
            }

            $oResult->setTracking($nrgk);
            $oResult->setCarrierTitle(Mage::getStoreConfig('carriers/' . $this->_code . '/title'));

            if (!$tracking) {
                $tracking = array();
                $msg = "Nie znaleziono paczki w systemie.";
            }
            foreach ($tracking as $msge) {
                $msg .= $msge->date . " " . $msge->time . " : " . $msge->location . " - " . $msge->status . " <br/>";
            }
        } catch (Exception $e) {
            $msg = $e->getMessage();
        }
        $oResult->setTrackSummary($msg);

        return $oResult;
    }
}
