<?php

class Websoft_Globkurier_Helper_Errors extends Mage_Core_Helper_Abstract {

    protected $_errors = array(
        'BOK_WS_DATE_BEFORE_NOW' => 'Data odbioru została ustawiona na wcześniejszą niż aktualna',
        'UNKNOWN_ERROR' => 'Wystąpił nieznany błąd',
        'DB_ERROR' => 'Wystąpil błąd podczas wykonywania operacji na bazie danych',
        'INCORRECT_DATA' => 'Niepoprawne dane',
        'NOT_PROCESSED' => 'Nieprzeprocesowane dane',
        'DUPLICATED_PACKAGE_SEARCH_KEY' => 'Podany klucz przesyłki nie jest unikatowy',
        'DUPLICATED_PARCEL_SEARCH_KEY' => 'Podany klucz paczki nie jest unikatowy',
        'DISALLOWED_FID' => 'Podano niedozwolony numer FID',
        'NOT_FOUND' => 'Nieznaleziono obiektu',
        'NOT_PROCESSED' => 'Obiekt nieprzetworzony',
        'INCORRECT_PKGS_FOR_SESSION_TYPE' => 'Wybrano przesyłki, które nie są zgodne z typem sesji',
        'INCORRECT_PICKUP_ADDRESS_FID' => 'Numer FID (PickupAddress/FID) jest niedozwolony lub niepoprawny',
        'INCORRECT_PICKUP_ADDRESS_NAME' => 'Nazwa (PickupAddress/Name) jest niepoprawna (niezgodna z protokołem)',
        'INCORRECT_PICKUP_ADDRESS_COMPANY' => 'Nazwa firmy (PickupAddress/Company) jest niepoprawna (niezgodna z protokołem)',
        'INCORRECT_PICKUP_ADDRESS_ADDRESS' => 'Adres (PickupAddress/Address) jest niepoprawny (niezgodny z protokołem)',
        'INCORRECT_PICKUP_ADDRESS_CITY' => 'Miasto (PickupAddress/City) jest niepoprawne (niezgodne z protokołem)',
        'INCORRECT_PICKUP_ADDRESS_COUNTRY' => 'Kod kraju (PickupAddress/Country) jest niepoprawny (niezgodny z protokołem)',
        'INCORRECT_PICKUP_ADDRESS_POSTAL_CODE' => 'Kod pocztowy (PickupAddress/PostalCode) jest niepoprawny (niezgodny z protokołem)',
        'INCORRECT_PICKUP_ADDRESS_EMAIL' => 'Adres email (PickupAddress/Email) jest niepoprawny (niezgodny z protokołem)',
        'INCORRECT_PICKUP_ADDRESS_PHONE' => 'Numer telefonu (PickupAddress/Phone) jest niepoprawny (niezgodny z protokołem)',
        'ACCESS_DENIED_FOR_FID' => 'Wybrano przesyłki, dla których numer FID jest niedozwolony dla użytkownika',
        'BOK_WS_ERROR' => 'Błąd webserwisu aplikacji BOK/Dispatch',
        'BOK_WS_UNKNOWN_ERROR' => 'Nieznany błąd webserwisu aplikacji BOK/Dispatch',
        'BOK_WS_NO_PRIVILEGES' => 'Brak uprawnień w aplikacji BOK/Dispatch',
        'INCORRECT_STATUS' => 'Niepoprawny status',
        'EMPTY_DATA' => 'Nie wypełnione dane',
        'BOK_WS_TRY_AGAIN_LATER' => 'Błąd webserwisu BOK/Dispatch. Spróbuj ponownie później',
        'VALIDATION_ERROR' => 'Błąd walidacji',
        'ORDER_CANCEL_DENIED' => 'Operacja anulowania zlecenia nie może być wykonana (zlecenie na status nie pozwalający na anulowanie)',
        'BOK_WS_EMPTY_VALUE' => 'Brak wymaganej wartości',
        'BOK_WS_INCORRECT_VALUE' => 'Niepoprawna wartość',
        'BOK_WS_INCORRECT_FORMAT' => 'Niepoprawny format',
        'BOK_WS_INCORRECT_SET_OF_PARAMS' => 'Niepoprawny zestaw parametrów',
        'BOK_WS_INCORRECT_PICKUP_TIME' => 'Niepoprawny czas odbioru przesyłki',
        'BOK_WS_INCORRECT_GABARITS' => 'Niepoprawne gabaryty paczki',
        'BOK_WS_VALUE_GREATER_THAN' => 'Wartość pierwszego pola większa niż wartość drugiego pola',
        'BOK_WS_VALUE_LOWER_THAN' => 'Wartość pierwszego pola mniejsza niż wartość drugiego pola',
        'BOK_WS_DATES_NOT_WITHIN_THE_SAME_DAY' => 'Daty nie z tego samego dnia',
        'BOK_WS_VALUE_BLOCKED' => 'Wartość zablokowana',
        'BOK_WS_BUSINESS_RULES_BLOCKED' => 'Blokada z powodu reguły biznesowej',
        'BOK_WS_VALUE_NOT_A_NUMBER' => 'Wartość nie jest liczbą',
        'BOK_WS_VALUE_NOT_A_POSTAL_CODE' => 'Niepoprawny kod pocztowy',
        'BOK_WS_VALUE_NOT_AN_HOUR' => 'Wartość nie jest poprawną godziną',
        'BOK_WS_VALUE_NOT_A_MINUTE' => 'Wartość nie jest poprawną minutą',
        'BOK_WS_VALUE_NOT_A_DATE' => 'Wartość nie jest poprawną datą',
        'BOK_WS_NOT_ALLOWED_SEND_TO_DISPATCHER' => 'Niedozwolona wysyłka do dyspozytora',
        'BOK_WS_NOT_ALLOWED_SEND_TO_COORDINATOR' => 'Niedozwolona wysyłka do kordynatora',
        'BOK_WS_VALUE_NOT_IN_FORMAT_HH_MM' => 'Wartość nie jest w formacie HH:MM',
        'BOK_WS_INCATION_ERROR' => 'Błąd wywołania webserwisu BOK/Dispatch',
        'BOK_WS_INCORRECT_STATUS_CHANGE' => 'Niedozwolona zmiana statusu',
        'BOK_WS_NONEXISTENT_USER' => 'Niepoprawny użytkownik',
        'BOK_WS_UNKNOWN_ERROR' => 'Nieznany błąd'
    );
    
    public function parseStatusInfo($response) {
        $errorDetails = $response->errorDetails;
        $msg = null;
        
        $errors = is_array($errorDetails) ? $errorDetails : array($errorDetails);
        foreach($errors as $error){
            $msg .= isset($this->_errors[$error->code]) ? $this->_errors[$error->code] : $error->code;
            $desc = isset($error->description) ? $error->description : '';
            $msg .= " (" . $error->fields .  $desc . ")\n";            
        }

        return $msg;
    }    

    public function parseSoapError($soapFault) {
        $msg = isset($this->_errors[$soapFault->faultcode]) ? $this->_errors[$soapFault->faultcode] : $soapFault->faultcode;
        $msg .= ' (' . $soapFault->getMessage() . ')';

        return $msg;
    }

    public function showError($msg) {
        echo ('<div id="messages"><ul class="messages"><li class="error-msg"><ul><li><span>' . $msg . '</span></li></ul></li></ul></div>');
    }

    public function getConfig($value) {
        return Mage::getStoreConfig(self::XML_PATH_BASE . $value);
    }

}