<?php

class Websoft_Globkurier_Block_Adminhtml_Sales_Popup_Form extends Mage_Adminhtml_Block_Widget_Form {

    public function __construct()
    {
        parent::__construct();
        $this->setDestElementId('popup_form');
        $this->setId('websoft_globkurier_popup_form');
        $this->setTitle($this->__('Metody wysyłki'));
    }
    /**
     *
     * @return Mage_Sales_Model_Order_Shipment
     */
    public function getShipment()
    {
        return Mage::registry('current_shipment');
    }

    protected function _prepareForm()
    {
        $id = $this->getRequest()->getParam('order_id');
        $services = Mage::getModel('globkurier/services');
        $serviceCode =  str_replace("globkurier_", "", $this->getShipment()->getOrder()->getShippingMethod());
        $dateOptions = Mage::getModel('globkurier/webapi')->getShipmentDatesOptions();

        $form = new Varien_Data_Form(array(
            'id'        => 'popup_form',
            'action'    => '',
            'method'    => ''
        ));

        $fieldset = $form->addFieldset('base_fieldset', array(
            'legend'    => Mage::helper('checkout')->__(''),
            'class'     => 'fieldset',
        ));

        $fieldset->addField('services', 'select', array(
        'name'  => 'services',
        'label'     => Mage::helper('globkurier')->__('Produkt'),
        'values'    => $services->toOptionsForCode($serviceCode),
        'required'  => true
        ));

        $fieldset->addField('dates', 'select', array(
        'name'  => 'dates',
        'label'     => Mage::helper('globkurier')->__('Wybierz datę nadania'),
        'values'    => $dateOptions['dates'],
        'required'  => true
        ));

        $fieldset->addField('time_from', 'select', array(
        'name'  => 'time_from',
        'label'     => Mage::helper('globkurier')->__('Początkowa godzina odbioru'),
        'values'    => $dateOptions['time_from'],
        'required'  => true
        ));

        $fieldset->addField('time_to', 'select', array(
        'name'  => 'time_to',
        'label'     => Mage::helper('globkurier')->__('Końcowa godzina odbioru'),
        'values'    => $dateOptions['time_to'],
        'required'  => true
        ));

        $fieldset->addField('content', 'text', array(
        'name'  => 'content',
        'label'     => Mage::helper('globkurier')->__('Zawartość'),
        'required'  => true
        ));

        $fieldset->addField('insurance_value', 'text', array(
        'name'  => 'insurance_value',
        'label'     => Mage::helper('globkurier')->__('Wartość ubezpieczenia'),
        'after_element_html' => '<small>Wypełnić tylko w przypadku gdy paczka ma być ubezpieczona.</small>',
        'required'  => false
        ));


        $fieldset->addField('pickuppay_value', 'text', array(
        'name'  => 'pickuppay_value',
        'label'     => Mage::helper('globkurier')->__('Wartość pobrania'),
        'after_element_html' => '<small>Wypełnić tylko w przypadku gdy paczka ma być wysłana za pobraniem.</small>',
        'required'  => false
        ));

        $fieldset->addField('id', 'hidden', array(
            'name' => 'id',
        ));
        $model = Mage::getModel('globkurier/method')->load($serviceCode);
        $form->setValues($model->getData());
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
}
