<?php

class Websoft_Globkurier_Block_Adminhtml_Methods_Grid extends Mage_Adminhtml_Block_Widget_Grid {
    protected function _prepareCollection() {
        $this->setDefaultSort('id');
        $this->setDefaultDir('desc');
        $collection = $this->loadCollection();
        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    protected function loadCollection() {
        /* @var $collection Mage_Core_Model_Mysql4_Collection_Abstract*/
        $collection = Mage::getModel('globkurier/method')
            ->getCollection()
            ->addFilter('active',1);

        return $collection;
    }

    protected function _prepareColumns() {
        $this->addColumn('id', array(
            'header' => Mage::helper('globkurier')->__('Id'),
            'align' => 'right',
            'index' => 'id',
            'width' => 100
        ));

        $this->addColumn('nazwa', array(
            'header' => Mage::helper('globkurier')->__('Nazwa metody'),
            'align' => 'left',
            'index' => 'name',
            'filter' => false,
            'search' => false,
        ));

//        $this->addColumn('logo', array(
//            'header' => Mage::helper('globkurier')->__('Logo'),
//            'align' => 'center',
//            'index' => 'logo',
//            'filter' => false,
//            'search' => false,
//            'renderer' => 'Websoft_Globkurier_Block_Adminhtml_Renderer_Logo'
//        ));
        $this->addColumn('extras', array(
            'header' => Mage::helper('globkurier')->__('Opcje dodatkowe'),
            'align' => 'left',
            'index' => 'extra',
            'filter' => false,
            'search' => false,
            'renderer' => 'Websoft_Globkurier_Block_Adminhtml_Renderer_Extra'
        ));
        $this->addColumn('countries', array(
            'header' => Mage::helper('globkurier')->__('Kraje docelowe'),
            'align' => 'left',
            'index' => 'extra',
            'filter' => false,
            'search' => false,
            'renderer' => 'Websoft_Globkurier_Block_Adminhtml_Renderer_Countries'
        ));

        $this->addColumn('waga', array(
            'header' => Mage::helper('globkurier')->__('Waga'),
            'align' => 'left',
            'index' => 'max_weight',
            'filter' => false,
            'search' => false,
            'width' => 100
        ));

        $this->addColumn('cena', array(
            'header' => Mage::helper('globkurier')->__('Cena'),
            'align' => 'left',
            'index' => 'price',
            'filter' => false,
            'search' => false,
            'width' => 100
        ));

        $this->addColumn('action', array(
            'width' => '100',
            'type' => 'action',
            'getter' => 'getId',
            'actions' => array(
                array(
                    'caption' => Mage::helper('globkurier')->__('Usuń'),
                    'url' => array('base' => '*/*/remove'),
                    'field' => 'id',
                )
            ),
            'filter' => false,
            'sortable' => false,
            'index' => 'stores',
            'is_system' => true,
        ));

       return parent::_prepareColumns();
    }

   public function getRowUrl($row)
    {
        return $this->getUrl('*/*/editMethod', array('id'=>$row->getId()));
    }

}
