<?php
class Websoft_Globkurier_Block_Adminhtml_Methods_Edit_Tabs extends Mage_Adminhtml_Block_Widget_Tabs {

	public function __construct() {
		parent::__construct();
		$this->setId('methods_tabs');
		$this->setDestElementId('edit_form');
		$this->setTitle(Mage::helper('globkurier')->__('Metody wysyłki'));
	}

	protected function _beforeToHtml() {
		$this->addTab('form_section', array(
			'label'     => Mage::helper('globkurier')->__('Ustawienia'),
			'title'     => Mage::helper('globkurier')->__('Ustawienia'),
			'content'   => $this->getLayout()->createBlock('globkurier/adminhtml_methods_edit_tab_form')->toHtml(),
		));
		$this->addTab('products_section', array(
			'label'     => Mage::helper('globkurier')->__('Produkty'),
			'title'     => Mage::helper('globkurier')->__('Produkty'),
			'url'       => $this->getUrl('*/*/products', array('_current' => true)),
			'class'     => 'ajax',
		));
		return parent::_beforeToHtml();
	}
	
}