<?php
class Websoft_Globkurier_Block_Adminhtml_Methods_Edit_Tab_Products extends Mage_Adminhtml_Block_Widget_Grid {
	
	public function __construct() {
		parent::__construct();
		$this->setId('productsGrid');
		$this->setDefaultSort('entity_id');
		$this->setDefaultDir('ASC');
		$this->setTitle(Mage::helper('globkurier')->__('Produkty'));
		$this->setUseAjax(true);
		if($this->getRequest()->getParam('id')) {
			$this->setDefaultFilter(array('product_ids' => 1));
		}
	}
	
	protected function _addColumnFilterToCollection($column) {
		if($column->getId() == 'product_ids') {
			$productIds = $this->_getSelectedProducts();
			if(empty($productIds)) {
				$productIds = 0;
			}
			if($column->getFilter()->getValue()) {
				$this->getCollection()->addFieldToFilter('entity_id', array('in' => $productIds));
			} else {
				if($productIds) {
					$this->getCollection()->addFieldToFilter('entity_id', array('nin' => $productIds));
				}
			}
		} else {
			parent::_addColumnFilterToCollection($column);
		}
		return $this;
	}
	
	protected function _prepareCollection() {
		$productModel = Mage::getModel('catalog/product');
		$collection = $productModel->getCollection()->addAttributeToSelect('*');
		$this->setCollection($collection);
		return parent::_prepareCollection();
	}
	
	protected function _prepareColumns() {
		
		$this->addColumn('product_ids', array(
			'header_css_class'  => 'a-center',
			'type'              => 'checkbox',
			'name'              => 'product_ids',
			'values'            => $this->_getSelectedProducts(),
			'align'             => 'center',
			'index'             => 'entity_id',
			'field_name'        => 'product_ids[]',
		));
		
		$this->addColumn('product_entity_id', array(
			'header'    => Mage::helper('globkurier')->__('ID'),
			'sortable'  => true,
			'width'     => 60,
			'index'     => 'entity_id'
		));

		$this->addColumn('product_name', array(
			'header'    => Mage::helper('globkurier')->__('Name'),
			'index'     => 'name'
		));

		$this->addColumn('product_type', array(
			'header'    => Mage::helper('globkurier')->__('Type'),
			'width'     => 100,
			'index'     => 'type_id',
			'type'      => 'options',
			'options'   => Mage::getSingleton('catalog/product_type')->getOptionArray(),
		));
		
		$this->addColumn('product_status', array(
			'header'    => Mage::helper('globkurier')->__('Status'),
			'width'     => 90,
			'index'     => 'status',
			'type'      => 'options',
			'options'   => Mage::getSingleton('catalog/product_status')->getOptionArray(),
		));

		$this->addColumn('product_visibility', array(
			'header'    => Mage::helper('globkurier')->__('Visibility'),
			'width'     => 90,
			'index'     => 'visibility',
			'type'      => 'options',
			'options'   => Mage::getSingleton('catalog/product_visibility')->getOptionArray(),
		));

		$this->addColumn('product_sku', array(
			'header'    => Mage::helper('globkurier')->__('SKU'),
			'width'     => 80,
			'index'     => 'sku'
		));

		$this->addColumn('product_price', array(
			'header'        => Mage::helper('globkurier')->__('Price'),
			'type'          => 'currency',
			'currency_code' => (string) Mage::getStoreConfig(Mage_Directory_Model_Currency::XML_PATH_CURRENCY_BASE),
			'index'         => 'price'
		));

		return parent::_prepareColumns();
		
	}
	
	public function getRowUrl($row) {
		return;
	}
	
	public function getGridUrl() {
		return $this->getUrl('*/*/products', array('_current'=>true));
	}
	
	protected function _getMethod() {
        $id = $this->getRequest()->getParam('id');
		$method = Mage::getModel('globkurier/method')->load($id);
		return $method;
    }
	
	protected function _getSelectedProducts() {
		$products = $this->_getMethod()->getProducts();
		$products = explode(',',$products);
		return $products;
	}
	
}