<?php

class Websoft_Globkurier_Block_Adminhtml_Methods_Edit_Tab_Form extends Mage_Adminhtml_Block_Widget_Form
{


    protected function _prepareForm()
    {
        $id = $this->getRequest()->getParam('id');

        $form = new Varien_Data_Form(array(
            'id' => 'edit_form',
            'action' => $this->getUrl('*/*/save', array('id' => $this->getRequest()->getParam('id'))),
            'method' => 'post',
            'enctype' => 'multipart/form-data'
        ));

        $fieldset = $form->addFieldset('base_fieldset', array(
            'legend' => Mage::helper('checkout')->__(''),
            'class' => 'fieldset',
        ));

        if ($id) {
            $fieldset->addField('id', 'hidden', array(
                'name' => 'id',
            ));

            $model = Mage::getModel('globkurier/method')->load($id);
        }

        $fieldset->addField('name', 'text', array(
            'name' => 'name',
            'label' => Mage::helper('globkurier')->__('Nazwa usługi'),
            'required' => true
        ));

        $fieldset->addField('max_weight', 'text', array(
            'name' => 'max_weight',
            'label' => Mage::helper('globkurier')->__('Maksymalna waga'),
            'required' => false
        ));

        $fieldset->addField('price', 'text', array(
            'name' => 'price',
            'label' => Mage::helper('globkurier')->__('Koszt dla klienta'),
            'required' => true
        ));

        $fieldset->addField('method', 'select', array(
            'name' => 'method',
            'label' => Mage::helper('globkurier')->__('Metoda'),
            'onchange' => 'getExtras(this.value)',
            'values' => Mage::getModel('globkurier/methods')->toOptionArray(),
            //'after_emement_html' => '<span id="method_description"></span>',
            //'note' => 'Lista dostępnych metod dostępna <a target="_blank" href="https://www.globkurier.pl/tabela-uslug.pdf">tutaj</a>.',
            'required' => true
        ));

        $fieldset->addField('extra', 'multiselect', array(
            'label' => Mage::helper('globkurier')->__('Dodatki do przesyłki'),
            'name' => 'extra',
            'note' => Mage::helper('globkurier')->__('Dostępne dla wybranej metody'),
            'after_element_html' => $this->getInlineJavascript(),
            'values' => isset($model) ? Mage::getBlockSingleton('globkurier/adminhtml_extras')->setCode($model->getMethod())->getExtrasOptions()
                    : array(
                        array(
                            'value' => false,
                            'label' => 'Wybierz metodę'
                        )
                    )
        ));

        $fieldset->addField('countries', 'multiselect', array(
            'name'  => 'countries',
            'label'     => Mage::helper('globkurier')->__('Aktywny dla krajów'),
            'values' => Mage::getResourceModel('directory/country_collection')->loadData()->toOptionArray(false),
            'required'  => true
        ));

//        $fieldset->addField('logo', 'hidden', array(
//            'name'  => 'logo',
//            'label'     => Mage::helper('globkurier')->__('Logo metody')
//        ));


        if (isset($model)) {
            $form->setValues($model->getData());
        }
        //$form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }

    public function getInlineJavascript()
    {
        $url = Mage::helper("adminhtml")->getUrl('globkurier/adminhtml_methods/extras');
        $script = "
        <script>
        var loadUrl = '$url';
        function getExtras(value){
            new Ajax.Request(loadUrl+'code/'+value+'/', {
                        method: 'get',
                        onComplete: function(transport) {
                            $('extra').update(transport.responseText);
                        }
});

}
        </script>
        ";
        return $script;
    }
}