<?php

class Websoft_Globkurier_Block_Adminhtml_Extras extends Mage_Core_Block_Abstract {

    protected $code;

    public function _toHtml() {
        $output = "";
        foreach($this->getExtras() as $key => $value){
            $output .= "<option value=\"$key\">".$value."</option>";
        }
        if(empty($output)){
            $output .= "<option>Opcje nie są dostępne.</option>";
        }
        else{
            $output = "<option></option>".$output;
        }

        return $output;
    }

    public function setCode($code){
        $this->code = $code;

        return $this;
    }

    public function getExtrasOptions(){
        $output = array();
        foreach($this->getExtras() as $key => $value){
            $output [] = array('label' => $value, 'value'=> $key);
        }
        return $output;
    }

    public function getExtras(){
        $webapi = Mage::getModel('globkurier/webapi');
        $extras = $webapi->getExtras($this->code);
        $result = array();
        if(!is_array($extras)) $extras = array();

        foreach($extras as $extra){
            $result[$extra->symbol] = $extra->nazwa.($extra->kategoria == "COD" ? '(Wymaga ubezpieczenia) ' : '').' - '.$extra->cena.'zł';
        }

        $code = explode("_",$this->code);
        if($code[0] == 'globbox' && in_array((int)$code[1],array(1,2,3))){
            $result['globbox_cod'] = "Pobranie (Wymaga ubezpieczenia)";
            $result['globbox_insurance'] = "Ubezpieczenie";
        }

        return $result;
    }
}