<?php

class Websoft_Globkurier_Block_Adminhtml_Consign_Grid extends Mage_Adminhtml_Block_Widget_Grid {
    protected function _prepareCollection() {
        $this->setDefaultSort('create_date');
        $this->setDefaultDir('desc');            
        $collection = $this->loadCollection();
        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    protected function loadCollection() {
        return Mage::getModel('globkurier/orders')->getCollection();
    }

    protected function _prepareColumns() {
        $this->addColumn('create_date', array(
            'header' => Mage::helper('globkurier')->__('Data nadania'),
            'align' => 'right',
            'index' => 'create_date',
            'type' => 'date',
        ));
        $this->addColumn('order_id', array(
            'header' => Mage::helper('globkurier')->__('Numer zamówienia'),
            'align' => 'right',
            'renderer' => 'globkurier/adminhtml_consign_render_order',
            'filter' => false,
            'search' => false,
        ));

        $this->addColumn('gk_id', array(
            'header' => Mage::helper('globkurier')->__('Numer zamówienia globkurier'),
            'align' => 'right',
            'index' => 'api_number',
            'filter' => false,
            'search' => false,
        ));
        $this->addColumn('customer_firstname', array(
            'header' => Mage::helper('globkurier')->__('Imię'),
            'align' => 'right',
            'renderer' => 'globkurier/adminhtml_consign_render_firstname',
            'filter' => false,
            'search' => false,
        ));
        $this->addColumn('customer_lastname', array(
            'header' => Mage::helper('globkurier')->__('Nazwisko'),
            'align' => 'right',
            'renderer' => 'globkurier/adminhtml_consign_render_lastname',
            'filter' => false,
            'search' => false,
        ));
        $this->addColumn('action',
                array(
                        'width'     => '100',
                        'type'      => 'action',
                        'getter'    => 'getId',
                        'actions'   => array(
                                array(
                                        'caption'   => Mage::helper('globkurier')->__('Pobierz etykietę'),
                                        'url'       => array('base'=> '*/*/printLabel'),
                                        'field'     => 'id',
                                )
                        ),
                        'filter'    => false,
                        'sortable'  => false,
                        'is_system' => true,
        ));     
        
        return parent::_prepareColumns();
    }
}