<?php

class appGlobKurierFrontendComponents extends sfComponents
{
    public function executeDeliveryOnBasketList()
    {
        $config = stConfig::getInstance('appGlobKurierBackend');

        if ($this->delivery->getId() == $config->get('glob_box_delivery_id'))
        {
            $this->type = 'glob_box';

            $this->mapConfig = array(
                'api_key' => GlobKurierApi::GOOGLE_MAP_KEY,
                'lat' =>  GlobKurierApi::GOOGLE_MAP_LAT,
                'lng' =>  GlobKurierApi::GOOGLE_MAP_LNG,
                'zoom' =>  GlobKurierApi::GOOGLE_MAP_ZOOM
            );
        }
        elseif ($this->delivery->getId() == $config->get('in_post_delivery_id'))
        {
            $this->type = 'in_post';
            $this->terminals = GlobKurierPlugin::getTerminals();
        }
        else
        {
            return sfView::NONE;
        }

        $this->smarty = new stSmarty('appGlobKurierFrontend');
    }

    public function executeBasketForm()
    {
        $this->smarty = new stSmarty('appGlobKurierFrontend');
    }
}
