<?php

class appGlobKurierFrontendActions extends stActions
{
    public function executeAjaxGetPoints()
    {
        if(!$this->getRequest()->isXmlHttpRequest())
        {
            return sfView::NONE;
        }

        $location = stXssSafe::cleanHtml($this->getRequestParameter('location'), 'UTF-8');

        $config = stConfig::getInstance('appGlobKurierBackend');

        $data = array(
            'LOGIN' => $config->get('login'),
            'PASSWORD' => $config->get('password'),
            'APIKEY' => $config->get('apikey'),
            'LOCATION' => $location
        );

        $result = GlobKurierApi::call(GlobKurierApi::URL_GET_POINTS, $data);

        if ($result['status'] == 1)
        {
            $responseContent = json_encode($result['points']);
        }
        else
        {
            $this->getResponse()->setStatusCode('404');

            $responseContent = $result['error']['message'];
        }

        return $this->renderText($responseContent);
    }
}
