<?php if (isset($evaluation['errors'])) : ?>
    <div class="error">
        <?php echo implode('<br />', $evaluation['errors']) ?>
    </div>
<?php else : ?>
    <h3><?php echo __('Wybierz kuriera') ?></h6>
    <?php foreach ($evaluation['products'] as $product) : ?>
        <div class="evaluation-product">
            <label for="glob_kurier_order_base_service_<?php echo $product['symbol'] ?>">
                <span class="image"><img src="<?php echo $product['courier_img'] ?>" alt="<?php echo $product['courier'] ?>" /></span>
                <span class="input"><input type="radio" id="glob_kurier_order_base_service_<?php echo $product['symbol'] ?>" name="glob_kurier_order[base_service]" value="<?php echo $product['symbol'].'||'.$product['courier'] ?>"></span>
                <span class="price"><?php echo $product['product_price'].' '.__('zł').'*' ?></span>
                <div class="st_clear_all"></div>
                <span class="description"><?php echo $product['product'] ?></span>
            </label>
        </div>
    <?php endforeach ?>
    <div class="st_clear_all"></div>
    	<?php echo '* '.__('Cena netto, nie zawiera podatku VAT oraz opłaty paliwowej.') ?>
    <div class="st_clear_all"></div>
    <div id="addons"></div>
    <script type="text/javascript">
        jQuery(function($)
        {
            var getAddonsUrl = '<?php echo st_url_for('globKurier/ajaxGetOrderAddons') ?>';

            $('.evaluation-product input[type="radio"]').click(function()
            {
                globKurierPreloader.show();

                var service = this;

                $('#addons').load(getAddonsUrl, {'symbol' : service.value.split('||')[0]}, function()
                {
                    globKurierPreloader.hide();
                });
            });
        });
    </script>
<?php endif; ?>
