<?php


abstract class BaseOrderHasGlobKurierOrder extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $st_order_id;


	
	protected $app_glob_kurier_order_id;

	
	protected $aOrder;

	
	protected $aGlobKurierOrder;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getStOrderId()
    {

            return $this->st_order_id;
    }

    
    public function getAppGlobKurierOrderId()
    {

            return $this->app_glob_kurier_order_id;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = OrderHasGlobKurierOrderPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = OrderHasGlobKurierOrderPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = OrderHasGlobKurierOrderPeer::ID;
        }

	} 
	
	public function setStOrderId($v)
	{

        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->st_order_id !== $v) {
          $this->st_order_id = $v;
          $this->modifiedColumns[] = OrderHasGlobKurierOrderPeer::ST_ORDER_ID;
        }

		if ($this->aOrder !== null && $this->aOrder->getId() !== $v) {
			$this->aOrder = null;
		}

	} 
	
	public function setAppGlobKurierOrderId($v)
	{

        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->app_glob_kurier_order_id !== $v) {
          $this->app_glob_kurier_order_id = $v;
          $this->modifiedColumns[] = OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID;
        }

		if ($this->aGlobKurierOrder !== null && $this->aGlobKurierOrder->getId() !== $v) {
			$this->aGlobKurierOrder = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      if ($this->getDispatcher()->getListeners('OrderHasGlobKurierOrder.preHydrate')) {
          $event = $this->getDispatcher()->notify(new sfEvent($this, 'OrderHasGlobKurierOrder.preHydrate', array('resultset' => $rs, 'startcol' => $startcol)));
          $startcol = $event['startcol'];
      }

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->st_order_id = $rs->getInt($startcol + 3);

      $this->app_glob_kurier_order_id = $rs->getInt($startcol + 4);

      $this->resetModified();

      $this->setNew(false);
      if ($this->getDispatcher()->getListeners('OrderHasGlobKurierOrder.postHydrate')) {
          $event = $this->getDispatcher()->notify(new sfEvent($this, 'OrderHasGlobKurierOrder.postHydrate', array('resultset' => $rs, 'startcol' => $startcol + 5)));
          return $event['startcol'];
      }

            return $startcol + 5; 
    } catch (Exception $e) {
      throw new PropelException("Error populating OrderHasGlobKurierOrder object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseOrderHasGlobKurierOrder:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderHasGlobKurierOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			OrderHasGlobKurierOrderPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseOrderHasGlobKurierOrder:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
    if (!$this->alreadyInSave) {
        if ($this->getDispatcher()->getListeners('OrderHasGlobKurierOrder.preSave')) {
            $this->getDispatcher()->notify(new sfEvent($this, 'OrderHasGlobKurierOrder.preSave', array('con' => $con)));
    	  }
    }

    if (!$this->alreadyInSave) {
      foreach (sfMixer::getCallables('BaseOrderHasGlobKurierOrder:save:pre') as $callable)
      {
        $affectedRows = call_user_func($callable, $this, $con);
        if (is_int($affectedRows))
        {
          return $affectedRows;
        }
      }
    }


    if ($this->isNew() && !$this->isColumnModified(OrderHasGlobKurierOrderPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(OrderHasGlobKurierOrderPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(OrderHasGlobKurierOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
  if (!$this->alreadyInSave) {
        if ($this->getDispatcher()->getListeners('OrderHasGlobKurierOrder.postSave')) {
            $this->getDispatcher()->notify(new sfEvent($this, 'OrderHasGlobKurierOrder.postSave', array('con' => $con)));
        }
  }

    if (!$this->alreadyInSave) {
      foreach (sfMixer::getCallables('BaseOrderHasGlobKurierOrder:save:post') as $callable)
      {
        call_user_func($callable, $this, $con, $affectedRows);
      }
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aOrder !== null) {
				if ($this->aOrder->isModified()) {
					$affectedRows += $this->aOrder->save($con);
				}
				$this->setOrder($this->aOrder);
			}

			if ($this->aGlobKurierOrder !== null) {
				if ($this->aGlobKurierOrder->isModified()) {
					$affectedRows += $this->aGlobKurierOrder->save($con);
				}
				$this->setGlobKurierOrder($this->aGlobKurierOrder);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = OrderHasGlobKurierOrderPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += OrderHasGlobKurierOrderPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aOrder !== null) {
				if (!$this->aOrder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrder->getValidationFailures());
				}
			}

			if ($this->aGlobKurierOrder !== null) {
				if (!$this->aGlobKurierOrder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aGlobKurierOrder->getValidationFailures());
				}
			}


			if (($retval = OrderHasGlobKurierOrderPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderHasGlobKurierOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getStOrderId();
				break;
			case 4:
				return $this->getAppGlobKurierOrderId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderHasGlobKurierOrderPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getStOrderId(),
			$keys[4] => $this->getAppGlobKurierOrderId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = OrderHasGlobKurierOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setStOrderId($value);
				break;
			case 4:
				$this->setAppGlobKurierOrderId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = OrderHasGlobKurierOrderPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setStOrderId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setAppGlobKurierOrderId($arr[$keys[4]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(OrderHasGlobKurierOrderPeer::DATABASE_NAME);

		if ($this->isColumnModified(OrderHasGlobKurierOrderPeer::CREATED_AT)) $criteria->add(OrderHasGlobKurierOrderPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(OrderHasGlobKurierOrderPeer::UPDATED_AT)) $criteria->add(OrderHasGlobKurierOrderPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(OrderHasGlobKurierOrderPeer::ID)) $criteria->add(OrderHasGlobKurierOrderPeer::ID, $this->id);
		if ($this->isColumnModified(OrderHasGlobKurierOrderPeer::ST_ORDER_ID)) $criteria->add(OrderHasGlobKurierOrderPeer::ST_ORDER_ID, $this->st_order_id);
		if ($this->isColumnModified(OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID)) $criteria->add(OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID, $this->app_glob_kurier_order_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(OrderHasGlobKurierOrderPeer::DATABASE_NAME);

		$criteria->add(OrderHasGlobKurierOrderPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setStOrderId($this->st_order_id);

		$copyObj->setAppGlobKurierOrderId($this->app_glob_kurier_order_id);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new OrderHasGlobKurierOrderPeer();
		}
		return self::$peer;
	}

	
	public function setOrder($v)
	{


		if ($v === null) {
			$this->setStOrderId(NULL);
		} else {
			$this->setStOrderId($v->getId());
		}


		$this->aOrder = $v;
	}


	
	public function getOrder($con = null)
	{
		if ($this->aOrder === null && ($this->st_order_id !== null)) {
						$this->aOrder = OrderPeer::retrieveByPK($this->st_order_id, $con);

			
		}
		return $this->aOrder;
	}

	
	public function setGlobKurierOrder($v)
	{


		if ($v === null) {
			$this->setAppGlobKurierOrderId(NULL);
		} else {
			$this->setAppGlobKurierOrderId($v->getId());
		}


		$this->aGlobKurierOrder = $v;
	}


	
	public function getGlobKurierOrder($con = null)
	{
		if ($this->aGlobKurierOrder === null && ($this->app_glob_kurier_order_id !== null)) {
						$this->aGlobKurierOrder = GlobKurierOrderPeer::retrieveByPK($this->app_glob_kurier_order_id, $con);

			
		}
		return $this->aGlobKurierOrder;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'OrderHasGlobKurierOrder.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseOrderHasGlobKurierOrder:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseOrderHasGlobKurierOrder::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 