<?php


abstract class BaseGlobKurierOrder extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $nrgk;


	
	protected $sent_date;


	
	protected $base_service;


	
	protected $courier;


	
	protected $additional_services;


	
	protected $cod_amount;


	
	protected $cod_account;


	
	protected $insurance_amount;


	
	protected $declared_value;


	
	protected $payment_type;


	
	protected $content;


	
	protected $length;


	
	protected $width;


	
	protected $height;


	
	protected $weight;


	
	protected $number_of_parcels;


	
	protected $comments;


	
	protected $sender_name;


	
	protected $sender_street;


	
	protected $sender_house_number;


	
	protected $sender_apartment_number;


	
	protected $sender_postal_code;


	
	protected $sender_city;


	
	protected $sender_country;


	
	protected $sender_contact_person;


	
	protected $sender_phone;


	
	protected $sender_email;


	
	protected $sender_terminal;


	
	protected $receiver_name;


	
	protected $receiver_street;


	
	protected $receiver_house_number;


	
	protected $receiver_apartment_number;


	
	protected $receiver_postal_code;


	
	protected $receiver_city;


	
	protected $receiver_country;


	
	protected $receiver_contact_person;


	
	protected $receiver_phone;


	
	protected $receiver_email;


	
	protected $receiver_glob_box;


	
	protected $receiver_terminal;


	
	protected $custom_lp;

	
	protected $collOrderHasGlobKurierOrders;

	
	protected $lastOrderHasGlobKurierOrderCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getNrgk()
    {

            return $this->nrgk;
    }

	
	public function getSentDate($format = 'Y-m-d H:i:s')
	{

		if ($this->sent_date === null || $this->sent_date === '') {
			return null;
		} elseif (!is_int($this->sent_date)) {
						$ts = strtotime($this->sent_date);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [sent_date] as date/time value: " . var_export($this->sent_date, true));
			}
		} else {
			$ts = $this->sent_date;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getBaseService()
    {

            return $this->base_service;
    }

    
    public function getCourier()
    {

            return $this->courier;
    }

    
    public function getAdditionalServices()
    {

            return $this->additional_services;
    }

    
    public function getCodAmount()
    {

            return null !== $this->cod_amount ? (string)$this->cod_amount : null;
    }

    
    public function getCodAccount()
    {

            return $this->cod_account;
    }

    
    public function getInsuranceAmount()
    {

            return null !== $this->insurance_amount ? (string)$this->insurance_amount : null;
    }

    
    public function getDeclaredValue()
    {

            return null !== $this->declared_value ? (string)$this->declared_value : null;
    }

    
    public function getPaymentType()
    {

            return $this->payment_type;
    }

    
    public function getContent()
    {

            return $this->content;
    }

    
    public function getLength()
    {

            return null !== $this->length ? (string)$this->length : null;
    }

    
    public function getWidth()
    {

            return null !== $this->width ? (string)$this->width : null;
    }

    
    public function getHeight()
    {

            return null !== $this->height ? (string)$this->height : null;
    }

    
    public function getWeight()
    {

            return null !== $this->weight ? (string)$this->weight : null;
    }

    
    public function getNumberOfParcels()
    {

            return $this->number_of_parcels;
    }

    
    public function getComments()
    {

            return $this->comments;
    }

    
    public function getSenderName()
    {

            return $this->sender_name;
    }

    
    public function getSenderStreet()
    {

            return $this->sender_street;
    }

    
    public function getSenderHouseNumber()
    {

            return $this->sender_house_number;
    }

    
    public function getSenderApartmentNumber()
    {

            return $this->sender_apartment_number;
    }

    
    public function getSenderPostalCode()
    {

            return $this->sender_postal_code;
    }

    
    public function getSenderCity()
    {

            return $this->sender_city;
    }

    
    public function getSenderCountry()
    {

            return $this->sender_country;
    }

    
    public function getSenderContactPerson()
    {

            return $this->sender_contact_person;
    }

    
    public function getSenderPhone()
    {

            return $this->sender_phone;
    }

    
    public function getSenderEmail()
    {

            return $this->sender_email;
    }

    
    public function getSenderTerminal()
    {

            return $this->sender_terminal;
    }

    
    public function getReceiverName()
    {

            return $this->receiver_name;
    }

    
    public function getReceiverStreet()
    {

            return $this->receiver_street;
    }

    
    public function getReceiverHouseNumber()
    {

            return $this->receiver_house_number;
    }

    
    public function getReceiverApartmentNumber()
    {

            return $this->receiver_apartment_number;
    }

    
    public function getReceiverPostalCode()
    {

            return $this->receiver_postal_code;
    }

    
    public function getReceiverCity()
    {

            return $this->receiver_city;
    }

    
    public function getReceiverCountry()
    {

            return $this->receiver_country;
    }

    
    public function getReceiverContactPerson()
    {

            return $this->receiver_contact_person;
    }

    
    public function getReceiverPhone()
    {

            return $this->receiver_phone;
    }

    
    public function getReceiverEmail()
    {

            return $this->receiver_email;
    }

    
    public function getReceiverGlobBox()
    {

            return $this->receiver_glob_box;
    }

    
    public function getReceiverTerminal()
    {

            return $this->receiver_terminal;
    }

    
    public function getCustomLp()
    {

            return $this->custom_lp;
    }

	
	public function setId($v)
	{

        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::ID;
        }

	} 
	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = GlobKurierOrderPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = GlobKurierOrderPeer::UPDATED_AT;
		}

	} 
	
	public function setNrgk($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->nrgk !== $v) {
          $this->nrgk = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::NRGK;
        }

	} 
	
	public function setSentDate($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [sent_date] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->sent_date !== $ts) {
			$this->sent_date = $ts;
			$this->modifiedColumns[] = GlobKurierOrderPeer::SENT_DATE;
		}

	} 
	
	public function setBaseService($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->base_service !== $v) {
          $this->base_service = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::BASE_SERVICE;
        }

	} 
	
	public function setCourier($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->courier !== $v) {
          $this->courier = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::COURIER;
        }

	} 
	
	public function setAdditionalServices($v)
	{

        if ($this->additional_services !== $v) {
          $this->additional_services = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::ADDITIONAL_SERVICES;
        }

	} 
	
	public function setCodAmount($v)
	{

        if ($v !== null && !is_float($v) && is_numeric($v)) {
          $v = (float) $v;
        }

        if ($this->cod_amount !== $v) {
          $this->cod_amount = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::COD_AMOUNT;
        }

	} 
	
	public function setCodAccount($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->cod_account !== $v) {
          $this->cod_account = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::COD_ACCOUNT;
        }

	} 
	
	public function setInsuranceAmount($v)
	{

        if ($v !== null && !is_float($v) && is_numeric($v)) {
          $v = (float) $v;
        }

        if ($this->insurance_amount !== $v) {
          $this->insurance_amount = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::INSURANCE_AMOUNT;
        }

	} 
	
	public function setDeclaredValue($v)
	{

        if ($v !== null && !is_float($v) && is_numeric($v)) {
          $v = (float) $v;
        }

        if ($this->declared_value !== $v) {
          $this->declared_value = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::DECLARED_VALUE;
        }

	} 
	
	public function setPaymentType($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->payment_type !== $v) {
          $this->payment_type = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::PAYMENT_TYPE;
        }

	} 
	
	public function setContent($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->content !== $v) {
          $this->content = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::CONTENT;
        }

	} 
	
	public function setLength($v)
	{

        if ($v !== null && !is_float($v) && is_numeric($v)) {
          $v = (float) $v;
        }

        if ($this->length !== $v) {
          $this->length = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::LENGTH;
        }

	} 
	
	public function setWidth($v)
	{

        if ($v !== null && !is_float($v) && is_numeric($v)) {
          $v = (float) $v;
        }

        if ($this->width !== $v) {
          $this->width = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::WIDTH;
        }

	} 
	
	public function setHeight($v)
	{

        if ($v !== null && !is_float($v) && is_numeric($v)) {
          $v = (float) $v;
        }

        if ($this->height !== $v) {
          $this->height = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::HEIGHT;
        }

	} 
	
	public function setWeight($v)
	{

        if ($v !== null && !is_float($v) && is_numeric($v)) {
          $v = (float) $v;
        }

        if ($this->weight !== $v) {
          $this->weight = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::WEIGHT;
        }

	} 
	
	public function setNumberOfParcels($v)
	{

        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->number_of_parcels !== $v) {
          $this->number_of_parcels = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::NUMBER_OF_PARCELS;
        }

	} 
	
	public function setComments($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->comments !== $v) {
          $this->comments = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::COMMENTS;
        }

	} 
	
	public function setSenderName($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_name !== $v) {
          $this->sender_name = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_NAME;
        }

	} 
	
	public function setSenderStreet($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_street !== $v) {
          $this->sender_street = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_STREET;
        }

	} 
	
	public function setSenderHouseNumber($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_house_number !== $v) {
          $this->sender_house_number = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_HOUSE_NUMBER;
        }

	} 
	
	public function setSenderApartmentNumber($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_apartment_number !== $v) {
          $this->sender_apartment_number = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_APARTMENT_NUMBER;
        }

	} 
	
	public function setSenderPostalCode($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_postal_code !== $v) {
          $this->sender_postal_code = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_POSTAL_CODE;
        }

	} 
	
	public function setSenderCity($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_city !== $v) {
          $this->sender_city = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_CITY;
        }

	} 
	
	public function setSenderCountry($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_country !== $v) {
          $this->sender_country = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_COUNTRY;
        }

	} 
	
	public function setSenderContactPerson($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_contact_person !== $v) {
          $this->sender_contact_person = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_CONTACT_PERSON;
        }

	} 
	
	public function setSenderPhone($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_phone !== $v) {
          $this->sender_phone = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_PHONE;
        }

	} 
	
	public function setSenderEmail($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_email !== $v) {
          $this->sender_email = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_EMAIL;
        }

	} 
	
	public function setSenderTerminal($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->sender_terminal !== $v) {
          $this->sender_terminal = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::SENDER_TERMINAL;
        }

	} 
	
	public function setReceiverName($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_name !== $v) {
          $this->receiver_name = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_NAME;
        }

	} 
	
	public function setReceiverStreet($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_street !== $v) {
          $this->receiver_street = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_STREET;
        }

	} 
	
	public function setReceiverHouseNumber($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_house_number !== $v) {
          $this->receiver_house_number = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_HOUSE_NUMBER;
        }

	} 
	
	public function setReceiverApartmentNumber($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_apartment_number !== $v) {
          $this->receiver_apartment_number = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_APARTMENT_NUMBER;
        }

	} 
	
	public function setReceiverPostalCode($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_postal_code !== $v) {
          $this->receiver_postal_code = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_POSTAL_CODE;
        }

	} 
	
	public function setReceiverCity($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_city !== $v) {
          $this->receiver_city = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_CITY;
        }

	} 
	
	public function setReceiverCountry($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_country !== $v) {
          $this->receiver_country = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_COUNTRY;
        }

	} 
	
	public function setReceiverContactPerson($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_contact_person !== $v) {
          $this->receiver_contact_person = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_CONTACT_PERSON;
        }

	} 
	
	public function setReceiverPhone($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_phone !== $v) {
          $this->receiver_phone = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_PHONE;
        }

	} 
	
	public function setReceiverEmail($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_email !== $v) {
          $this->receiver_email = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_EMAIL;
        }

	} 
	
	public function setReceiverGlobBox($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_glob_box !== $v) {
          $this->receiver_glob_box = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_GLOB_BOX;
        }

	} 
	
	public function setReceiverTerminal($v)
	{

        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->receiver_terminal !== $v) {
          $this->receiver_terminal = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::RECEIVER_TERMINAL;
        }

	} 
	
	public function setCustomLp($v)
	{

        if ($this->custom_lp !== $v) {
          $this->custom_lp = $v;
          $this->modifiedColumns[] = GlobKurierOrderPeer::CUSTOM_LP;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      if ($this->getDispatcher()->getListeners('GlobKurierOrder.preHydrate')) {
          $event = $this->getDispatcher()->notify(new sfEvent($this, 'GlobKurierOrder.preHydrate', array('resultset' => $rs, 'startcol' => $startcol)));
          $startcol = $event['startcol'];
      }

      $this->id = $rs->getInt($startcol + 0);

      $this->created_at = $rs->getTimestamp($startcol + 1, null);

      $this->updated_at = $rs->getTimestamp($startcol + 2, null);

      $this->nrgk = $rs->getString($startcol + 3);

      $this->sent_date = $rs->getTimestamp($startcol + 4, null);

      $this->base_service = $rs->getString($startcol + 5);

      $this->courier = $rs->getString($startcol + 6);

      $this->additional_services = $rs->getString($startcol + 7) ? unserialize($rs->getString($startcol + 7)) : null;

      $this->cod_amount = $rs->getString($startcol + 8);
      if (null !== $this->cod_amount && $this->cod_amount == intval($this->cod_amount))
      {
        $this->cod_amount = (string)intval($this->cod_amount);
      }

      $this->cod_account = $rs->getString($startcol + 9);

      $this->insurance_amount = $rs->getString($startcol + 10);
      if (null !== $this->insurance_amount && $this->insurance_amount == intval($this->insurance_amount))
      {
        $this->insurance_amount = (string)intval($this->insurance_amount);
      }

      $this->declared_value = $rs->getString($startcol + 11);
      if (null !== $this->declared_value && $this->declared_value == intval($this->declared_value))
      {
        $this->declared_value = (string)intval($this->declared_value);
      }

      $this->payment_type = $rs->getString($startcol + 12);

      $this->content = $rs->getString($startcol + 13);

      $this->length = $rs->getString($startcol + 14);
      if (null !== $this->length && $this->length == intval($this->length))
      {
        $this->length = (string)intval($this->length);
      }

      $this->width = $rs->getString($startcol + 15);
      if (null !== $this->width && $this->width == intval($this->width))
      {
        $this->width = (string)intval($this->width);
      }

      $this->height = $rs->getString($startcol + 16);
      if (null !== $this->height && $this->height == intval($this->height))
      {
        $this->height = (string)intval($this->height);
      }

      $this->weight = $rs->getString($startcol + 17);
      if (null !== $this->weight && $this->weight == intval($this->weight))
      {
        $this->weight = (string)intval($this->weight);
      }

      $this->number_of_parcels = $rs->getInt($startcol + 18);

      $this->comments = $rs->getString($startcol + 19);

      $this->sender_name = $rs->getString($startcol + 20);

      $this->sender_street = $rs->getString($startcol + 21);

      $this->sender_house_number = $rs->getString($startcol + 22);

      $this->sender_apartment_number = $rs->getString($startcol + 23);

      $this->sender_postal_code = $rs->getString($startcol + 24);

      $this->sender_city = $rs->getString($startcol + 25);

      $this->sender_country = $rs->getString($startcol + 26);

      $this->sender_contact_person = $rs->getString($startcol + 27);

      $this->sender_phone = $rs->getString($startcol + 28);

      $this->sender_email = $rs->getString($startcol + 29);

      $this->sender_terminal = $rs->getString($startcol + 30);

      $this->receiver_name = $rs->getString($startcol + 31);

      $this->receiver_street = $rs->getString($startcol + 32);

      $this->receiver_house_number = $rs->getString($startcol + 33);

      $this->receiver_apartment_number = $rs->getString($startcol + 34);

      $this->receiver_postal_code = $rs->getString($startcol + 35);

      $this->receiver_city = $rs->getString($startcol + 36);

      $this->receiver_country = $rs->getString($startcol + 37);

      $this->receiver_contact_person = $rs->getString($startcol + 38);

      $this->receiver_phone = $rs->getString($startcol + 39);

      $this->receiver_email = $rs->getString($startcol + 40);

      $this->receiver_glob_box = $rs->getString($startcol + 41);

      $this->receiver_terminal = $rs->getString($startcol + 42);

      $this->custom_lp = $rs->getString($startcol + 43) ? unserialize($rs->getString($startcol + 43)) : null;

      $this->resetModified();

      $this->setNew(false);
      if ($this->getDispatcher()->getListeners('GlobKurierOrder.postHydrate')) {
          $event = $this->getDispatcher()->notify(new sfEvent($this, 'GlobKurierOrder.postHydrate', array('resultset' => $rs, 'startcol' => $startcol + 44)));
          return $event['startcol'];
      }

            return $startcol + 44; 
    } catch (Exception $e) {
      throw new PropelException("Error populating GlobKurierOrder object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseGlobKurierOrder:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(GlobKurierOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			GlobKurierOrderPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseGlobKurierOrder:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
    if (!$this->alreadyInSave) {
        if ($this->getDispatcher()->getListeners('GlobKurierOrder.preSave')) {
            $this->getDispatcher()->notify(new sfEvent($this, 'GlobKurierOrder.preSave', array('con' => $con)));
    	  }
    }

    if (!$this->alreadyInSave) {
      foreach (sfMixer::getCallables('BaseGlobKurierOrder:save:pre') as $callable)
      {
        $affectedRows = call_user_func($callable, $this, $con);
        if (is_int($affectedRows))
        {
          return $affectedRows;
        }
      }
    }


    if ($this->isNew() && !$this->isColumnModified(GlobKurierOrderPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(GlobKurierOrderPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(GlobKurierOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
  if (!$this->alreadyInSave) {
        if ($this->getDispatcher()->getListeners('GlobKurierOrder.postSave')) {
            $this->getDispatcher()->notify(new sfEvent($this, 'GlobKurierOrder.postSave', array('con' => $con)));
        }
  }

    if (!$this->alreadyInSave) {
      foreach (sfMixer::getCallables('BaseGlobKurierOrder:save:post') as $callable)
      {
        call_user_func($callable, $this, $con, $affectedRows);
      }
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
              $o_additional_services = $this->additional_services;
              if (null !== $this->additional_services && $this->isColumnModified(GlobKurierOrderPeer::ADDITIONAL_SERVICES)) {
                  $this->additional_services = serialize($this->additional_services);
              }

              $o_custom_lp = $this->custom_lp;
              if (null !== $this->custom_lp && $this->isColumnModified(GlobKurierOrderPeer::CUSTOM_LP)) {
                  $this->custom_lp = serialize($this->custom_lp);
              }

				if ($this->isNew()) {
					$pk = GlobKurierOrderPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += GlobKurierOrderPeer::doUpdate($this, $con);
				}
				$this->resetModified();
             $this->additional_services = $o_additional_services;

             $this->custom_lp = $o_custom_lp;
 			}

			if ($this->collOrderHasGlobKurierOrders !== null) {
				foreach($this->collOrderHasGlobKurierOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = GlobKurierOrderPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collOrderHasGlobKurierOrders !== null) {
					foreach($this->collOrderHasGlobKurierOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = GlobKurierOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getCreatedAt();
				break;
			case 2:
				return $this->getUpdatedAt();
				break;
			case 3:
				return $this->getNrgk();
				break;
			case 4:
				return $this->getSentDate();
				break;
			case 5:
				return $this->getBaseService();
				break;
			case 6:
				return $this->getCourier();
				break;
			case 7:
				return $this->getAdditionalServices();
				break;
			case 8:
				return $this->getCodAmount();
				break;
			case 9:
				return $this->getCodAccount();
				break;
			case 10:
				return $this->getInsuranceAmount();
				break;
			case 11:
				return $this->getDeclaredValue();
				break;
			case 12:
				return $this->getPaymentType();
				break;
			case 13:
				return $this->getContent();
				break;
			case 14:
				return $this->getLength();
				break;
			case 15:
				return $this->getWidth();
				break;
			case 16:
				return $this->getHeight();
				break;
			case 17:
				return $this->getWeight();
				break;
			case 18:
				return $this->getNumberOfParcels();
				break;
			case 19:
				return $this->getComments();
				break;
			case 20:
				return $this->getSenderName();
				break;
			case 21:
				return $this->getSenderStreet();
				break;
			case 22:
				return $this->getSenderHouseNumber();
				break;
			case 23:
				return $this->getSenderApartmentNumber();
				break;
			case 24:
				return $this->getSenderPostalCode();
				break;
			case 25:
				return $this->getSenderCity();
				break;
			case 26:
				return $this->getSenderCountry();
				break;
			case 27:
				return $this->getSenderContactPerson();
				break;
			case 28:
				return $this->getSenderPhone();
				break;
			case 29:
				return $this->getSenderEmail();
				break;
			case 30:
				return $this->getSenderTerminal();
				break;
			case 31:
				return $this->getReceiverName();
				break;
			case 32:
				return $this->getReceiverStreet();
				break;
			case 33:
				return $this->getReceiverHouseNumber();
				break;
			case 34:
				return $this->getReceiverApartmentNumber();
				break;
			case 35:
				return $this->getReceiverPostalCode();
				break;
			case 36:
				return $this->getReceiverCity();
				break;
			case 37:
				return $this->getReceiverCountry();
				break;
			case 38:
				return $this->getReceiverContactPerson();
				break;
			case 39:
				return $this->getReceiverPhone();
				break;
			case 40:
				return $this->getReceiverEmail();
				break;
			case 41:
				return $this->getReceiverGlobBox();
				break;
			case 42:
				return $this->getReceiverTerminal();
				break;
			case 43:
				return $this->getCustomLp();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = GlobKurierOrderPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getCreatedAt(),
			$keys[2] => $this->getUpdatedAt(),
			$keys[3] => $this->getNrgk(),
			$keys[4] => $this->getSentDate(),
			$keys[5] => $this->getBaseService(),
			$keys[6] => $this->getCourier(),
			$keys[7] => $this->getAdditionalServices(),
			$keys[8] => $this->getCodAmount(),
			$keys[9] => $this->getCodAccount(),
			$keys[10] => $this->getInsuranceAmount(),
			$keys[11] => $this->getDeclaredValue(),
			$keys[12] => $this->getPaymentType(),
			$keys[13] => $this->getContent(),
			$keys[14] => $this->getLength(),
			$keys[15] => $this->getWidth(),
			$keys[16] => $this->getHeight(),
			$keys[17] => $this->getWeight(),
			$keys[18] => $this->getNumberOfParcels(),
			$keys[19] => $this->getComments(),
			$keys[20] => $this->getSenderName(),
			$keys[21] => $this->getSenderStreet(),
			$keys[22] => $this->getSenderHouseNumber(),
			$keys[23] => $this->getSenderApartmentNumber(),
			$keys[24] => $this->getSenderPostalCode(),
			$keys[25] => $this->getSenderCity(),
			$keys[26] => $this->getSenderCountry(),
			$keys[27] => $this->getSenderContactPerson(),
			$keys[28] => $this->getSenderPhone(),
			$keys[29] => $this->getSenderEmail(),
			$keys[30] => $this->getSenderTerminal(),
			$keys[31] => $this->getReceiverName(),
			$keys[32] => $this->getReceiverStreet(),
			$keys[33] => $this->getReceiverHouseNumber(),
			$keys[34] => $this->getReceiverApartmentNumber(),
			$keys[35] => $this->getReceiverPostalCode(),
			$keys[36] => $this->getReceiverCity(),
			$keys[37] => $this->getReceiverCountry(),
			$keys[38] => $this->getReceiverContactPerson(),
			$keys[39] => $this->getReceiverPhone(),
			$keys[40] => $this->getReceiverEmail(),
			$keys[41] => $this->getReceiverGlobBox(),
			$keys[42] => $this->getReceiverTerminal(),
			$keys[43] => $this->getCustomLp(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = GlobKurierOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setCreatedAt($value);
				break;
			case 2:
				$this->setUpdatedAt($value);
				break;
			case 3:
				$this->setNrgk($value);
				break;
			case 4:
				$this->setSentDate($value);
				break;
			case 5:
				$this->setBaseService($value);
				break;
			case 6:
				$this->setCourier($value);
				break;
			case 7:
				$this->setAdditionalServices($value);
				break;
			case 8:
				$this->setCodAmount($value);
				break;
			case 9:
				$this->setCodAccount($value);
				break;
			case 10:
				$this->setInsuranceAmount($value);
				break;
			case 11:
				$this->setDeclaredValue($value);
				break;
			case 12:
				$this->setPaymentType($value);
				break;
			case 13:
				$this->setContent($value);
				break;
			case 14:
				$this->setLength($value);
				break;
			case 15:
				$this->setWidth($value);
				break;
			case 16:
				$this->setHeight($value);
				break;
			case 17:
				$this->setWeight($value);
				break;
			case 18:
				$this->setNumberOfParcels($value);
				break;
			case 19:
				$this->setComments($value);
				break;
			case 20:
				$this->setSenderName($value);
				break;
			case 21:
				$this->setSenderStreet($value);
				break;
			case 22:
				$this->setSenderHouseNumber($value);
				break;
			case 23:
				$this->setSenderApartmentNumber($value);
				break;
			case 24:
				$this->setSenderPostalCode($value);
				break;
			case 25:
				$this->setSenderCity($value);
				break;
			case 26:
				$this->setSenderCountry($value);
				break;
			case 27:
				$this->setSenderContactPerson($value);
				break;
			case 28:
				$this->setSenderPhone($value);
				break;
			case 29:
				$this->setSenderEmail($value);
				break;
			case 30:
				$this->setSenderTerminal($value);
				break;
			case 31:
				$this->setReceiverName($value);
				break;
			case 32:
				$this->setReceiverStreet($value);
				break;
			case 33:
				$this->setReceiverHouseNumber($value);
				break;
			case 34:
				$this->setReceiverApartmentNumber($value);
				break;
			case 35:
				$this->setReceiverPostalCode($value);
				break;
			case 36:
				$this->setReceiverCity($value);
				break;
			case 37:
				$this->setReceiverCountry($value);
				break;
			case 38:
				$this->setReceiverContactPerson($value);
				break;
			case 39:
				$this->setReceiverPhone($value);
				break;
			case 40:
				$this->setReceiverEmail($value);
				break;
			case 41:
				$this->setReceiverGlobBox($value);
				break;
			case 42:
				$this->setReceiverTerminal($value);
				break;
			case 43:
				$this->setCustomLp($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = GlobKurierOrderPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setCreatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setUpdatedAt($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setNrgk($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSentDate($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setBaseService($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setCourier($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setAdditionalServices($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setCodAmount($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setCodAccount($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setInsuranceAmount($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setDeclaredValue($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setPaymentType($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setContent($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setLength($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setWidth($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setHeight($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setWeight($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setNumberOfParcels($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setComments($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setSenderName($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setSenderStreet($arr[$keys[21]]);
		if (array_key_exists($keys[22], $arr)) $this->setSenderHouseNumber($arr[$keys[22]]);
		if (array_key_exists($keys[23], $arr)) $this->setSenderApartmentNumber($arr[$keys[23]]);
		if (array_key_exists($keys[24], $arr)) $this->setSenderPostalCode($arr[$keys[24]]);
		if (array_key_exists($keys[25], $arr)) $this->setSenderCity($arr[$keys[25]]);
		if (array_key_exists($keys[26], $arr)) $this->setSenderCountry($arr[$keys[26]]);
		if (array_key_exists($keys[27], $arr)) $this->setSenderContactPerson($arr[$keys[27]]);
		if (array_key_exists($keys[28], $arr)) $this->setSenderPhone($arr[$keys[28]]);
		if (array_key_exists($keys[29], $arr)) $this->setSenderEmail($arr[$keys[29]]);
		if (array_key_exists($keys[30], $arr)) $this->setSenderTerminal($arr[$keys[30]]);
		if (array_key_exists($keys[31], $arr)) $this->setReceiverName($arr[$keys[31]]);
		if (array_key_exists($keys[32], $arr)) $this->setReceiverStreet($arr[$keys[32]]);
		if (array_key_exists($keys[33], $arr)) $this->setReceiverHouseNumber($arr[$keys[33]]);
		if (array_key_exists($keys[34], $arr)) $this->setReceiverApartmentNumber($arr[$keys[34]]);
		if (array_key_exists($keys[35], $arr)) $this->setReceiverPostalCode($arr[$keys[35]]);
		if (array_key_exists($keys[36], $arr)) $this->setReceiverCity($arr[$keys[36]]);
		if (array_key_exists($keys[37], $arr)) $this->setReceiverCountry($arr[$keys[37]]);
		if (array_key_exists($keys[38], $arr)) $this->setReceiverContactPerson($arr[$keys[38]]);
		if (array_key_exists($keys[39], $arr)) $this->setReceiverPhone($arr[$keys[39]]);
		if (array_key_exists($keys[40], $arr)) $this->setReceiverEmail($arr[$keys[40]]);
		if (array_key_exists($keys[41], $arr)) $this->setReceiverGlobBox($arr[$keys[41]]);
		if (array_key_exists($keys[42], $arr)) $this->setReceiverTerminal($arr[$keys[42]]);
		if (array_key_exists($keys[43], $arr)) $this->setCustomLp($arr[$keys[43]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(GlobKurierOrderPeer::DATABASE_NAME);

		if ($this->isColumnModified(GlobKurierOrderPeer::ID)) $criteria->add(GlobKurierOrderPeer::ID, $this->id);
		if ($this->isColumnModified(GlobKurierOrderPeer::CREATED_AT)) $criteria->add(GlobKurierOrderPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(GlobKurierOrderPeer::UPDATED_AT)) $criteria->add(GlobKurierOrderPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(GlobKurierOrderPeer::NRGK)) $criteria->add(GlobKurierOrderPeer::NRGK, $this->nrgk);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENT_DATE)) $criteria->add(GlobKurierOrderPeer::SENT_DATE, $this->sent_date);
		if ($this->isColumnModified(GlobKurierOrderPeer::BASE_SERVICE)) $criteria->add(GlobKurierOrderPeer::BASE_SERVICE, $this->base_service);
		if ($this->isColumnModified(GlobKurierOrderPeer::COURIER)) $criteria->add(GlobKurierOrderPeer::COURIER, $this->courier);
		if ($this->isColumnModified(GlobKurierOrderPeer::ADDITIONAL_SERVICES)) $criteria->add(GlobKurierOrderPeer::ADDITIONAL_SERVICES, $this->additional_services);
		if ($this->isColumnModified(GlobKurierOrderPeer::COD_AMOUNT)) $criteria->add(GlobKurierOrderPeer::COD_AMOUNT, $this->cod_amount);
		if ($this->isColumnModified(GlobKurierOrderPeer::COD_ACCOUNT)) $criteria->add(GlobKurierOrderPeer::COD_ACCOUNT, $this->cod_account);
		if ($this->isColumnModified(GlobKurierOrderPeer::INSURANCE_AMOUNT)) $criteria->add(GlobKurierOrderPeer::INSURANCE_AMOUNT, $this->insurance_amount);
		if ($this->isColumnModified(GlobKurierOrderPeer::DECLARED_VALUE)) $criteria->add(GlobKurierOrderPeer::DECLARED_VALUE, $this->declared_value);
		if ($this->isColumnModified(GlobKurierOrderPeer::PAYMENT_TYPE)) $criteria->add(GlobKurierOrderPeer::PAYMENT_TYPE, $this->payment_type);
		if ($this->isColumnModified(GlobKurierOrderPeer::CONTENT)) $criteria->add(GlobKurierOrderPeer::CONTENT, $this->content);
		if ($this->isColumnModified(GlobKurierOrderPeer::LENGTH)) $criteria->add(GlobKurierOrderPeer::LENGTH, $this->length);
		if ($this->isColumnModified(GlobKurierOrderPeer::WIDTH)) $criteria->add(GlobKurierOrderPeer::WIDTH, $this->width);
		if ($this->isColumnModified(GlobKurierOrderPeer::HEIGHT)) $criteria->add(GlobKurierOrderPeer::HEIGHT, $this->height);
		if ($this->isColumnModified(GlobKurierOrderPeer::WEIGHT)) $criteria->add(GlobKurierOrderPeer::WEIGHT, $this->weight);
		if ($this->isColumnModified(GlobKurierOrderPeer::NUMBER_OF_PARCELS)) $criteria->add(GlobKurierOrderPeer::NUMBER_OF_PARCELS, $this->number_of_parcels);
		if ($this->isColumnModified(GlobKurierOrderPeer::COMMENTS)) $criteria->add(GlobKurierOrderPeer::COMMENTS, $this->comments);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_NAME)) $criteria->add(GlobKurierOrderPeer::SENDER_NAME, $this->sender_name);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_STREET)) $criteria->add(GlobKurierOrderPeer::SENDER_STREET, $this->sender_street);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_HOUSE_NUMBER)) $criteria->add(GlobKurierOrderPeer::SENDER_HOUSE_NUMBER, $this->sender_house_number);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_APARTMENT_NUMBER)) $criteria->add(GlobKurierOrderPeer::SENDER_APARTMENT_NUMBER, $this->sender_apartment_number);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_POSTAL_CODE)) $criteria->add(GlobKurierOrderPeer::SENDER_POSTAL_CODE, $this->sender_postal_code);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_CITY)) $criteria->add(GlobKurierOrderPeer::SENDER_CITY, $this->sender_city);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_COUNTRY)) $criteria->add(GlobKurierOrderPeer::SENDER_COUNTRY, $this->sender_country);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_CONTACT_PERSON)) $criteria->add(GlobKurierOrderPeer::SENDER_CONTACT_PERSON, $this->sender_contact_person);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_PHONE)) $criteria->add(GlobKurierOrderPeer::SENDER_PHONE, $this->sender_phone);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_EMAIL)) $criteria->add(GlobKurierOrderPeer::SENDER_EMAIL, $this->sender_email);
		if ($this->isColumnModified(GlobKurierOrderPeer::SENDER_TERMINAL)) $criteria->add(GlobKurierOrderPeer::SENDER_TERMINAL, $this->sender_terminal);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_NAME)) $criteria->add(GlobKurierOrderPeer::RECEIVER_NAME, $this->receiver_name);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_STREET)) $criteria->add(GlobKurierOrderPeer::RECEIVER_STREET, $this->receiver_street);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_HOUSE_NUMBER)) $criteria->add(GlobKurierOrderPeer::RECEIVER_HOUSE_NUMBER, $this->receiver_house_number);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_APARTMENT_NUMBER)) $criteria->add(GlobKurierOrderPeer::RECEIVER_APARTMENT_NUMBER, $this->receiver_apartment_number);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_POSTAL_CODE)) $criteria->add(GlobKurierOrderPeer::RECEIVER_POSTAL_CODE, $this->receiver_postal_code);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_CITY)) $criteria->add(GlobKurierOrderPeer::RECEIVER_CITY, $this->receiver_city);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_COUNTRY)) $criteria->add(GlobKurierOrderPeer::RECEIVER_COUNTRY, $this->receiver_country);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_CONTACT_PERSON)) $criteria->add(GlobKurierOrderPeer::RECEIVER_CONTACT_PERSON, $this->receiver_contact_person);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_PHONE)) $criteria->add(GlobKurierOrderPeer::RECEIVER_PHONE, $this->receiver_phone);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_EMAIL)) $criteria->add(GlobKurierOrderPeer::RECEIVER_EMAIL, $this->receiver_email);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_GLOB_BOX)) $criteria->add(GlobKurierOrderPeer::RECEIVER_GLOB_BOX, $this->receiver_glob_box);
		if ($this->isColumnModified(GlobKurierOrderPeer::RECEIVER_TERMINAL)) $criteria->add(GlobKurierOrderPeer::RECEIVER_TERMINAL, $this->receiver_terminal);
		if ($this->isColumnModified(GlobKurierOrderPeer::CUSTOM_LP)) $criteria->add(GlobKurierOrderPeer::CUSTOM_LP, $this->custom_lp);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(GlobKurierOrderPeer::DATABASE_NAME);

		$criteria->add(GlobKurierOrderPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setNrgk($this->nrgk);

		$copyObj->setSentDate($this->sent_date);

		$copyObj->setBaseService($this->base_service);

		$copyObj->setCourier($this->courier);

		$copyObj->setAdditionalServices($this->additional_services);

		$copyObj->setCodAmount($this->cod_amount);

		$copyObj->setCodAccount($this->cod_account);

		$copyObj->setInsuranceAmount($this->insurance_amount);

		$copyObj->setDeclaredValue($this->declared_value);

		$copyObj->setPaymentType($this->payment_type);

		$copyObj->setContent($this->content);

		$copyObj->setLength($this->length);

		$copyObj->setWidth($this->width);

		$copyObj->setHeight($this->height);

		$copyObj->setWeight($this->weight);

		$copyObj->setNumberOfParcels($this->number_of_parcels);

		$copyObj->setComments($this->comments);

		$copyObj->setSenderName($this->sender_name);

		$copyObj->setSenderStreet($this->sender_street);

		$copyObj->setSenderHouseNumber($this->sender_house_number);

		$copyObj->setSenderApartmentNumber($this->sender_apartment_number);

		$copyObj->setSenderPostalCode($this->sender_postal_code);

		$copyObj->setSenderCity($this->sender_city);

		$copyObj->setSenderCountry($this->sender_country);

		$copyObj->setSenderContactPerson($this->sender_contact_person);

		$copyObj->setSenderPhone($this->sender_phone);

		$copyObj->setSenderEmail($this->sender_email);

		$copyObj->setSenderTerminal($this->sender_terminal);

		$copyObj->setReceiverName($this->receiver_name);

		$copyObj->setReceiverStreet($this->receiver_street);

		$copyObj->setReceiverHouseNumber($this->receiver_house_number);

		$copyObj->setReceiverApartmentNumber($this->receiver_apartment_number);

		$copyObj->setReceiverPostalCode($this->receiver_postal_code);

		$copyObj->setReceiverCity($this->receiver_city);

		$copyObj->setReceiverCountry($this->receiver_country);

		$copyObj->setReceiverContactPerson($this->receiver_contact_person);

		$copyObj->setReceiverPhone($this->receiver_phone);

		$copyObj->setReceiverEmail($this->receiver_email);

		$copyObj->setReceiverGlobBox($this->receiver_glob_box);

		$copyObj->setReceiverTerminal($this->receiver_terminal);

		$copyObj->setCustomLp($this->custom_lp);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getOrderHasGlobKurierOrders() as $relObj) {
				$copyObj->addOrderHasGlobKurierOrder($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new GlobKurierOrderPeer();
		}
		return self::$peer;
	}

	
	public function initOrderHasGlobKurierOrders()
	{
		if ($this->collOrderHasGlobKurierOrders === null) {
			$this->collOrderHasGlobKurierOrders = array();
		}
	}

	
	public function getOrderHasGlobKurierOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderHasGlobKurierOrders === null) {
			if ($this->isNew()) {
			   $this->collOrderHasGlobKurierOrders = array();
			} else {

				$criteria->add(OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID, $this->getId());

				OrderHasGlobKurierOrderPeer::addSelectColumns($criteria);
				$this->collOrderHasGlobKurierOrders = OrderHasGlobKurierOrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID, $this->getId());

				OrderHasGlobKurierOrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderHasGlobKurierOrderCriteria) || !$this->lastOrderHasGlobKurierOrderCriteria->equals($criteria)) {
					$this->collOrderHasGlobKurierOrders = OrderHasGlobKurierOrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderHasGlobKurierOrderCriteria = $criteria;
		return $this->collOrderHasGlobKurierOrders;
	}

	
	public function countOrderHasGlobKurierOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID, $this->getId());

		return OrderHasGlobKurierOrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderHasGlobKurierOrder(OrderHasGlobKurierOrder $l)
	{
		$this->collOrderHasGlobKurierOrders[] = $l;
		$l->setGlobKurierOrder($this);
	}


	
	public function getOrderHasGlobKurierOrdersJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderHasGlobKurierOrders === null) {
			if ($this->isNew()) {
				$this->collOrderHasGlobKurierOrders = array();
			} else {

				$criteria->add(OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID, $this->getId());

				$this->collOrderHasGlobKurierOrders = OrderHasGlobKurierOrderPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderHasGlobKurierOrderPeer::APP_GLOB_KURIER_ORDER_ID, $this->getId());

			if (!isset($this->lastOrderHasGlobKurierOrderCriteria) || !$this->lastOrderHasGlobKurierOrderCriteria->equals($criteria)) {
				$this->collOrderHasGlobKurierOrders = OrderHasGlobKurierOrderPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastOrderHasGlobKurierOrderCriteria = $criteria;

		return $this->collOrderHasGlobKurierOrders;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'GlobKurierOrder.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseGlobKurierOrder:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseGlobKurierOrder::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 