<?php

/**
 * Subclass for representing a row from the 'app_glob_kurier_order' table.
 *
 * @package plugins.appGlobKurierPlugin.lib.model
 */
class GlobKurierOrder extends BaseGlobKurierOrder
{
    /**
     * Sets orders.
     *
     * @param string $v list of orders' ids
     */
    public function setOrderHasGlobKurierOrders($v)
    {
        $ordersIds = explode('-', $v);

        if ($ordersIds)
        {
            foreach ($ordersIds as $orderId)
            {
                $ohg = new OrderHasGlobKurierOrder();

                $ohg->setStOrderId($orderId);

                $this->addOrderHasGlobKurierOrder($ohg);
            }
        }
    }

    /**
     * Populates GlobKurierOrder with order related data.
     *
     * @param array $orders array of Orders
     */
    public function populateFromOrders(array $orders)
    {
        $firstOrder = reset($orders);
        $config = stConfig::getInstance('appGlobKurierBackend');

        // Receiver data.

        $delivery = $firstOrder->getOrderUserDataDelivery();
        $billing = $firstOrder->getOrderUserDataBilling();

        $name = $delivery->getCompany() ? $delivery->getCompany() : $billing->getCompany();
        $name = $name ? $name : $delivery->getFullName() ? $delivery->getFullName() : $billing->getFullName();

        $this->setReceiverName($name);
        $this->setReceiverStreet($delivery->getStreet() ? $delivery->getStreet() : $billing->getStreet());
        $this->setReceiverHouseNumber($delivery->getHouse() ? $delivery->getHouse() : $billing->getHouse());
        $this->setReceiverApartmentNumber($delivery->getFlat() ? $delivery->getFlat() : $billing->getFlat());
        $this->setReceiverPostalCode($delivery->getCode() ? $delivery->getCode() : $billing->getCode());
        $this->setReceiverCity($delivery->getTown() ? $delivery->getTown() : $billing->getTown());
        $this->setReceiverCountry($delivery->getCountry() ? $delivery->getCountry()->getIsoA2() : $billing->getCountry()->getIsoA2());
        $this->setReceiverContactPerson($delivery->getFullName() ? $delivery->getFullName() : $billing->getFullName());
        $this->setReceiverPhone($delivery->getPhone() ? $delivery->getPhone() : $billing->getPhone());
        $this->setReceiverEmail($firstOrder->getOptClientEmail());

        if ($firstOrder->getGlobBox())
        {
            $this->setReceiverGlobBox($firstOrder->getGlobBox());
        }

        if ($firstOrder->getInPostTerminal())
        {
            $this->setSenderTerminal($config->get('sender_terminal'));
            $this->setReceiverTerminal($firstOrder->getInPostTerminal());
        }

        // Package data.

        $unpaid = 0.0;
        $value = 0.0;
        $weight = 0.0;
        $defaultWeight = $config->get('default_weight');
        $comments = array();

        foreach ($orders as $order)
        {
            $unpaid += $order->getUnpaidAmount();
            $value += $order->getTotalAmountWithDelivery(true);
            $comments[] = $order->getDescription();

            if ($defaultWeight == '')
            {
                foreach ($order->getOrderProducts() as $orderProduct)
                {
                    $product = $orderProduct->getProduct();

                    if ($product)
                    {
                        $weight += $orderProduct->getQuantity() * $product->getWeight();
                    }
                }
            }
        }

        if ($defaultWeight != '')
        {
            $weight = $defaultWeight;
        }

        $this->setDeclaredValue($value);
        $this->setWeight($weight);
        $this->setNumberOfParcels(1);

        if ($config->get('set_comments_from_order'))
        {
            $this->setComments(implode(', ', $comments));
        }
    }
}
