<?php

abstract class GlobKurierPlugin
{
    const IN_POST_BASE_SERVICE = 'PKB';
    const PACZKA_W_RUCHU_BASE_SERVICE = 'RUCH20';

    public static $error;

    public static function getTerminals()
    {
        $config = stConfig::getInstance('appGlobKurierBackend');

        $data = array(
            'LOGIN' => $config->get('login'),
            'PASSWORD' => $config->get('password'),
            'APIKEY' => $config->get('apikey'),
            'PRODUCT' => GlobKurierPlugin::IN_POST_BASE_SERVICE
        );

        $result = GlobKurierApi::call(GlobKurierApi::URL_GET_TERMINALS, $data);

        if ($result['status'] == 1)
        {
            foreach ($result['list'] as $i => $t)
            {
                $result['list'][$i]['name'] = $t['departmentId'].' - '.$t['postalCode'].' '.$t['town'].' '.$t['address'];
            }

            return $result['list'];
        }
        else
        {
            GlobKurierPlugin::$error = $result['error']['message'];

            return false;
        }
    }
	
	public static function getCountries()
	{
		$data="";
		$result = GlobKurierApi::call(GlobKurierApi::URL_GET_COUNTRIES, $data);
		if ($result['status'] == 1)
        {
        	foreach($result['list'] as $i =>$t)
			{
				$countries[$i]['name']= strtoupper($result['list'][$i]['country']);
				$countries[$i]['code']= strtoupper($result['list'][$i]['isoCode']);
			}    
			return $countries;
		}
		else
		{
			GlobKurierPlugin::$error = $result['error']['message'];

            return false;
		}
	}

    public static function getGlobBoxPoints($location)
    {
        $config = stConfig::getInstance('appGlobKurierBackend');

        $data = array(
            'LOGIN' => $config->get('login'),
            'PASSWORD' => $config->get('password'),
            'APIKEY' => $config->get('apikey'),
            'LOCATION' => $location
        );

        $result = GlobKurierApi::call(GlobKurierApi::URL_GET_POINTS, $data);

        if ($result['status'] == 1)
        {
            return $result['points'];
        }
        else
        {
            GlobKurierPlugin::$error = $result['error']['message'];

            return false;
        }
    }
}
